/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.debugger;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.Serializable;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.mozilla.javascript.tools.debugger.Main;

class Menubar
extends JMenuBar
implements ActionListener {
    Main db;
    JMenu windowMenu;
    JCheckBoxMenuItem breakOnExceptions;

    JMenu getDebugMenu() {
        return this.getMenu(2);
    }

    Menubar(Main main) {
        JMenuItem jMenuItem;
        Serializable serializable;
        this.db = main;
        String[] stringArray = new String[]{"Open...", "Run...", "", "Exit"};
        String[] stringArray2 = new String[]{"Open", "Load", "", "Exit"};
        char[] cArray = new char[]{'0', 'N', '\u0000', 'X'};
        int[] nArray = new int[]{79, 78, 0, 81};
        String[] stringArray3 = new String[]{"Cut", "Copy", "Paste", "Go to function..."};
        char[] cArray2 = new char[]{'T', 'C', 'P', 'F'};
        String[] stringArray4 = new String[]{"Break", "Go", "Step Into", "Step Over", "Step Out"};
        char[] cArray3 = new char[]{'B', 'G', 'I', 'O', 'T'};
        String[] stringArray5 = new String[]{"Metal", "Windows", "Motif"};
        char[] cArray4 = new char[]{'M', 'W', 'F'};
        int[] nArray2 = new int[]{19, 116, 122, 118, 119, 0, 0};
        JMenu jMenu = new JMenu("File");
        jMenu.setMnemonic('F');
        JMenu jMenu2 = new JMenu("Edit");
        jMenu2.setMnemonic('E');
        JMenu jMenu3 = new JMenu("Platform");
        jMenu3.setMnemonic('P');
        JMenu jMenu4 = new JMenu("Debug");
        jMenu4.setMnemonic('D');
        this.windowMenu = new JMenu("Window");
        this.windowMenu.setMnemonic('W');
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].length() == 0) {
                jMenu.addSeparator();
            } else {
                JMenuItem jMenuItem2 = new JMenuItem(stringArray[n], cArray[n]);
                jMenuItem2.setActionCommand(stringArray2[n]);
                jMenuItem2.addActionListener(this);
                jMenu.add(jMenuItem2);
                if (nArray[n] != 0) {
                    serializable = KeyStroke.getKeyStroke(nArray[n], 2);
                    jMenuItem2.setAccelerator((KeyStroke)serializable);
                }
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < stringArray3.length) {
            serializable = new JMenuItem(stringArray3[n2], cArray2[n2]);
            serializable.addActionListener(this);
            jMenu2.add((JMenuItem)serializable);
            ++n2;
        }
        int n3 = 0;
        while (n3 < stringArray5.length) {
            JMenuItem jMenuItem3 = new JMenuItem(stringArray5[n3], cArray4[n3]);
            jMenuItem3.addActionListener(this);
            jMenu3.add(jMenuItem3);
            ++n3;
        }
        int n4 = 0;
        while (n4 < stringArray4.length) {
            jMenuItem = new JMenuItem(stringArray4[n4], cArray3[n4]);
            jMenuItem.addActionListener(this);
            if (nArray2[n4] != 0) {
                KeyStroke keyStroke = KeyStroke.getKeyStroke(nArray2[n4], 0);
                jMenuItem.setAccelerator(keyStroke);
            }
            if (n4 != 0) {
                jMenuItem.setEnabled(false);
            }
            jMenu4.add(jMenuItem);
            ++n4;
        }
        this.breakOnExceptions = new JCheckBoxMenuItem("Break on Exceptions");
        this.breakOnExceptions.setMnemonic('X');
        this.breakOnExceptions.addActionListener(this);
        this.breakOnExceptions.setSelected(false);
        jMenu4.add(this.breakOnExceptions);
        this.add(jMenu);
        this.add(jMenu2);
        this.add(jMenu4);
        jMenuItem = new JMenuItem("Cascade", 65);
        this.windowMenu.add(jMenuItem);
        jMenuItem.addActionListener(this);
        jMenuItem = new JMenuItem("Tile", 84);
        this.windowMenu.add(jMenuItem);
        jMenuItem.addActionListener(this);
        this.windowMenu.addSeparator();
        jMenuItem = new JMenuItem("Console", 67);
        this.windowMenu.add(jMenuItem);
        jMenuItem.addActionListener(this);
        this.add(this.windowMenu);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        String string2 = null;
        if (string.equals("Metal")) {
            string2 = "javax.swing.plaf.metal.MetalLookAndFeel";
        } else if (string.equals("Windows")) {
            string2 = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
        } else if (string.equals("Motif")) {
            string2 = "com.sun.java.swing.plaf.motif.MotifLookAndFeel";
        } else if (string.equals("Break on Exceptions")) {
            this.db.setBreakOnExceptions(this.breakOnExceptions.isSelected());
        } else {
            this.db.actionPerformed(actionEvent);
            return;
        }
        try {
            UIManager.setLookAndFeel(string2);
            SwingUtilities.updateComponentTreeUI(this.db);
            SwingUtilities.updateComponentTreeUI(this.db.dlg);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addFile(String string) {
        JMenuItem jMenuItem;
        int n = this.windowMenu.getItemCount();
        if (n == 4) {
            this.windowMenu.addSeparator();
            ++n;
        }
        JMenuItem jMenuItem2 = this.windowMenu.getItem(n - 1);
        boolean bl = false;
        int n2 = 5;
        if (jMenuItem2 != null && jMenuItem2.getText().equals("More Windows...")) {
            bl = true;
            ++n2;
        }
        if (!bl && n - 4 == 5) {
            JMenuItem jMenuItem3 = new JMenuItem("More Windows...", 77);
            this.windowMenu.add(jMenuItem3);
            jMenuItem3.setActionCommand("More Windows...");
            jMenuItem3.addActionListener(this);
            return;
        }
        if (n - 4 <= n2) {
            if (bl) {
                --n;
                this.windowMenu.remove(jMenuItem2);
            }
            File file = new File(string);
            jMenuItem = new JMenuItem((char)(48 + (n - 4)) + " " + file.getName(), 48 + (n - 4));
            this.windowMenu.add(jMenuItem);
            if (bl) {
                this.windowMenu.add(jMenuItem2);
            }
        } else {
            return;
        }
        jMenuItem.setActionCommand(string);
        jMenuItem.addActionListener(this);
    }
}

