/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.mozilla.javascript.ClassDefinitionException;
import org.mozilla.javascript.FunctionObject;
import org.mozilla.javascript.PropertyException;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.WrappedException;

public final class LazilyLoadedCtor {
    private static Method getter;
    private static Method setter;
    private String ctorName;
    private String className;
    private boolean sealed;
    private boolean isReplaced;

    public LazilyLoadedCtor(ScriptableObject scriptableObject, String string, String string2, boolean bl) {
        this.className = string2;
        this.ctorName = string;
        this.sealed = bl;
        if (getter == null) {
            Method[] methodArray = FunctionObject.getMethodList(this.getClass());
            getter = FunctionObject.findMethods(methodArray, "getProperty")[0];
            setter = FunctionObject.findMethods(methodArray, "setProperty")[0];
        }
        try {
            scriptableObject.defineProperty(string, this, getter, setter, 2);
        }
        catch (PropertyException propertyException) {
            throw WrappedException.wrapException(propertyException);
        }
    }

    public Object getProperty(ScriptableObject scriptableObject) {
        ScriptableObject scriptableObject2 = scriptableObject;
        synchronized (scriptableObject2) {
            if (!this.isReplaced) {
                boolean bl = false;
                Class<?> clazz = null;
                try {
                    clazz = Class.forName(this.className);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    bl = true;
                }
                catch (SecurityException securityException) {
                    bl = true;
                }
                if (clazz != null) {
                    try {
                        ScriptableObject.defineClass(scriptableObject, clazz, this.sealed);
                        this.isReplaced = true;
                    }
                    catch (InstantiationException instantiationException) {
                        throw WrappedException.wrapException(instantiationException);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        throw WrappedException.wrapException(illegalAccessException);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        throw WrappedException.wrapException(invocationTargetException);
                    }
                    catch (ClassDefinitionException classDefinitionException) {
                        throw WrappedException.wrapException(classDefinitionException);
                    }
                    catch (PropertyException propertyException) {
                        throw WrappedException.wrapException(propertyException);
                    }
                    catch (SecurityException securityException) {
                        bl = true;
                    }
                }
                if (bl) {
                    scriptableObject.delete(this.ctorName);
                    Object object = Scriptable.NOT_FOUND;
                    return object;
                }
            }
        }
        return scriptableObject.get(this.ctorName, (Scriptable)scriptableObject);
    }

    public Object setProperty(ScriptableObject scriptableObject, Object object) {
        ScriptableObject scriptableObject2 = scriptableObject;
        synchronized (scriptableObject2) {
            this.isReplaced = true;
            Object object2 = object;
            return object2;
        }
    }
}

