/* datamodel.c generated by valac 0.14.2, the Vala compiler
 * generated from datamodel.vala, do not modify */

/* datamodel.vala
 *
 * Copyright © 2011 Collabora Ltd.
 *             By Seif Lotfy <seif@lotfy.com>
 *             By Siegfried-Angel Gevatter Pujals <siegfried@gevatter.com>
 * Copyright © 2011 Manish Sinha <manishsinha@ubuntu.com>
 * Copyright © 2012 Canonical Ltd.
 *             By Siegfried-A. Gevatter <siegfried.gevatter@collabora.co.uk>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>


#define ZEITGEIST_TYPE_TIME_RANGE (zeitgeist_time_range_get_type ())
#define ZEITGEIST_TIME_RANGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_TIME_RANGE, ZeitgeistTimeRange))
#define ZEITGEIST_TIME_RANGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_TYPE_TIME_RANGE, ZeitgeistTimeRangeClass))
#define ZEITGEIST_IS_TIME_RANGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_TIME_RANGE))
#define ZEITGEIST_IS_TIME_RANGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_TYPE_TIME_RANGE))
#define ZEITGEIST_TIME_RANGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_TYPE_TIME_RANGE, ZeitgeistTimeRangeClass))

typedef struct _ZeitgeistTimeRange ZeitgeistTimeRange;
typedef struct _ZeitgeistTimeRangeClass ZeitgeistTimeRangeClass;
typedef struct _ZeitgeistTimeRangePrivate ZeitgeistTimeRangePrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define ZEITGEIST_TYPE_RESULT_TYPE (zeitgeist_result_type_get_type ())

#define ZEITGEIST_TYPE_RELEVANT_RESULT_TYPE (zeitgeist_relevant_result_type_get_type ())

#define ZEITGEIST_TYPE_STORAGE_STATE (zeitgeist_storage_state_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))

#define ZEITGEIST_TYPE_EVENT (zeitgeist_event_get_type ())
#define ZEITGEIST_EVENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_EVENT, ZeitgeistEvent))
#define ZEITGEIST_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_TYPE_EVENT, ZeitgeistEventClass))
#define ZEITGEIST_IS_EVENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_EVENT))
#define ZEITGEIST_IS_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_TYPE_EVENT))
#define ZEITGEIST_EVENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_TYPE_EVENT, ZeitgeistEventClass))

typedef struct _ZeitgeistEvent ZeitgeistEvent;
typedef struct _ZeitgeistEventClass ZeitgeistEventClass;
typedef struct _ZeitgeistEventPrivate ZeitgeistEventPrivate;

#define ZEITGEIST_TYPE_SUBJECT (zeitgeist_subject_get_type ())
#define ZEITGEIST_SUBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_SUBJECT, ZeitgeistSubject))
#define ZEITGEIST_SUBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_TYPE_SUBJECT, ZeitgeistSubjectClass))
#define ZEITGEIST_IS_SUBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_SUBJECT))
#define ZEITGEIST_IS_SUBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_TYPE_SUBJECT))
#define ZEITGEIST_SUBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_TYPE_SUBJECT, ZeitgeistSubjectClass))

typedef struct _ZeitgeistSubject ZeitgeistSubject;
typedef struct _ZeitgeistSubjectClass ZeitgeistSubjectClass;
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
#define _g_byte_array_unref0(var) ((var == NULL) ? NULL : (var = (g_byte_array_unref (var), NULL)))
#define _g_variant_iter_free0(var) ((var == NULL) ? NULL : (var = (g_variant_iter_free (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_variant_type_free0(var) ((var == NULL) ? NULL : (var = (g_variant_type_free (var), NULL)))
#define _g_variant_builder_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_builder_unref (var), NULL)))
#define _g_string_chunk_free0(var) ((var == NULL) ? NULL : (var = (g_string_chunk_free (var), NULL)))
typedef struct _ZeitgeistSubjectPrivate ZeitgeistSubjectPrivate;

typedef enum  {
	ZEITGEIST_ENGINE_ERROR_BACKUP_FAILED,
	ZEITGEIST_ENGINE_ERROR_DATABASE_BUSY,
	ZEITGEIST_ENGINE_ERROR_DATABASE_CANTOPEN,
	ZEITGEIST_ENGINE_ERROR_DATABASE_CORRUPT,
	ZEITGEIST_ENGINE_ERROR_DATABASE_ERROR,
	ZEITGEIST_ENGINE_ERROR_DATABASE_RETIRE_FAILED,
	ZEITGEIST_ENGINE_ERROR_EXISTING_INSTANCE,
	ZEITGEIST_ENGINE_ERROR_INVALID_ARGUMENT,
	ZEITGEIST_ENGINE_ERROR_INVALID_KEY,
	ZEITGEIST_ENGINE_ERROR_INVALID_SIGNATURE,
	ZEITGEIST_ENGINE_ERROR_TOO_MANY_RESULTS
} ZeitgeistEngineError;
#define ZEITGEIST_ENGINE_ERROR zeitgeist_engine_error_quark ()
struct _ZeitgeistTimeRange {
	GObject parent_instance;
	ZeitgeistTimeRangePrivate * priv;
};

struct _ZeitgeistTimeRangeClass {
	GObjectClass parent_class;
};

struct _ZeitgeistTimeRangePrivate {
	gint64 _start;
	gint64 _end;
};

typedef enum  {
	ZEITGEIST_RESULT_TYPE_MOST_RECENT_EVENTS = 0,
	ZEITGEIST_RESULT_TYPE_LEAST_RECENT_EVENTS = 1,
	ZEITGEIST_RESULT_TYPE_MOST_RECENT_SUBJECTS = 2,
	ZEITGEIST_RESULT_TYPE_LEAST_RECENT_SUBJECTS = 3,
	ZEITGEIST_RESULT_TYPE_MOST_POPULAR_SUBJECTS = 4,
	ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_SUBJECTS = 5,
	ZEITGEIST_RESULT_TYPE_MOST_POPULAR_ACTOR = 6,
	ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_ACTOR = 7,
	ZEITGEIST_RESULT_TYPE_MOST_RECENT_ACTOR = 8,
	ZEITGEIST_RESULT_TYPE_LEAST_RECENT_ACTOR = 9,
	ZEITGEIST_RESULT_TYPE_MOST_RECENT_ORIGIN = 10,
	ZEITGEIST_RESULT_TYPE_LEAST_RECENT_ORIGIN = 11,
	ZEITGEIST_RESULT_TYPE_MOST_POPULAR_ORIGIN = 12,
	ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_ORIGIN = 13,
	ZEITGEIST_RESULT_TYPE_OLDEST_ACTOR = 14,
	ZEITGEIST_RESULT_TYPE_MOST_RECENT_SUBJECT_INTERPRETATION = 15,
	ZEITGEIST_RESULT_TYPE_LEAST_RECENT_SUBJECT_INTERPRETATION = 16,
	ZEITGEIST_RESULT_TYPE_MOST_POPULAR_SUBJECT_INTERPRETATION = 17,
	ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_SUBJECT_INTERPRETATION = 18,
	ZEITGEIST_RESULT_TYPE_MOST_RECENT_MIMETYPE = 19,
	ZEITGEIST_RESULT_TYPE_LEAST_RECENT_MIMETYPE = 20,
	ZEITGEIST_RESULT_TYPE_MOST_POPULAR_MIMETYPE = 21,
	ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_MIMETYPE = 22,
	ZEITGEIST_RESULT_TYPE_MOST_RECENT_CURRENT_URI = 23,
	ZEITGEIST_RESULT_TYPE_LEAST_RECENT_CURRENT_URI = 24,
	ZEITGEIST_RESULT_TYPE_MOST_POPULAR_CURRENT_URI = 25,
	ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_CURRENT_URI = 26,
	ZEITGEIST_RESULT_TYPE_MOST_RECENT_EVENT_ORIGIN = 27,
	ZEITGEIST_RESULT_TYPE_LEAST_RECENT_EVENT_ORIGIN = 28,
	ZEITGEIST_RESULT_TYPE_MOST_POPULAR_EVENT_ORIGIN = 29,
	ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_EVENT_ORIGIN = 30
} ZeitgeistResultType;

typedef enum  {
	ZEITGEIST_RELEVANT_RESULT_TYPE_RECENT = 0,
	ZEITGEIST_RELEVANT_RESULT_TYPE_RELATED = 1
} ZeitgeistRelevantResultType;

typedef enum  {
	ZEITGEIST_STORAGE_STATE_NOT_AVAILABLE = 0,
	ZEITGEIST_STORAGE_STATE_AVAILABLE = 1,
	ZEITGEIST_STORAGE_STATE_ANY = 2
} ZeitgeistStorageState;

struct _ZeitgeistEvent {
	GObject parent_instance;
	ZeitgeistEventPrivate * priv;
};

struct _ZeitgeistEventClass {
	GObjectClass parent_class;
};

struct _ZeitgeistEventPrivate {
	guint32 _id;
	gint64 _timestamp;
	gchar* _origin;
	const gchar* _actor;
	const gchar* _interpretation;
	const gchar* _manifestation;
	GPtrArray* _subjects;
	GByteArray* _payload;
};

struct _ZeitgeistSubject {
	GObject parent_instance;
	ZeitgeistSubjectPrivate * priv;
};

struct _ZeitgeistSubjectClass {
	GObjectClass parent_class;
};

struct _ZeitgeistSubjectPrivate {
	gchar* _uri;
	gchar* _origin;
	gchar* _text;
	gchar* _storage;
	gchar* _current_uri;
	const gchar* _mimetype;
	const gchar* _interpretation;
	const gchar* _manifestation;
};


static gpointer zeitgeist_time_range_parent_class = NULL;
static gpointer zeitgeist_event_parent_class = NULL;
static GStringChunk* zeitgeist_event_url_store;
static GStringChunk* zeitgeist_event_url_store = NULL;
static gpointer zeitgeist_subject_parent_class = NULL;
static GStringChunk* zeitgeist_subject_url_store;
static GStringChunk* zeitgeist_subject_url_store = NULL;

GQuark zeitgeist_engine_error_quark (void);
void zeitgeist_assert_sig (gboolean condition, const gchar* error_message, GError** error);
gint64 zeitgeist_timestamp_now (void);
gint64 zeitgeist_timestamp_from_timeval (GTimeVal* tv);
GType zeitgeist_time_range_get_type (void) G_GNUC_CONST;
#define ZEITGEIST_TIME_RANGE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), ZEITGEIST_TYPE_TIME_RANGE, ZeitgeistTimeRangePrivate))
enum  {
	ZEITGEIST_TIME_RANGE_DUMMY_PROPERTY,
	ZEITGEIST_TIME_RANGE_START,
	ZEITGEIST_TIME_RANGE_END
};
ZeitgeistTimeRange* zeitgeist_time_range_new (gint64 start_msec, gint64 end_msec);
ZeitgeistTimeRange* zeitgeist_time_range_construct (GType object_type, gint64 start_msec, gint64 end_msec);
static void zeitgeist_time_range_set_start (ZeitgeistTimeRange* self, gint64 value);
static void zeitgeist_time_range_set_end (ZeitgeistTimeRange* self, gint64 value);
ZeitgeistTimeRange* zeitgeist_time_range_new_anytime (void);
ZeitgeistTimeRange* zeitgeist_time_range_construct_anytime (GType object_type);
ZeitgeistTimeRange* zeitgeist_time_range_new_to_now (void);
ZeitgeistTimeRange* zeitgeist_time_range_construct_to_now (GType object_type);
ZeitgeistTimeRange* zeitgeist_time_range_new_from_now (void);
ZeitgeistTimeRange* zeitgeist_time_range_construct_from_now (GType object_type);
ZeitgeistTimeRange* zeitgeist_time_range_new_from_variant (GVariant* variant, GError** error);
ZeitgeistTimeRange* zeitgeist_time_range_construct_from_variant (GType object_type, GVariant* variant, GError** error);
GVariant* zeitgeist_time_range_to_variant (ZeitgeistTimeRange* self);
gint64 zeitgeist_time_range_get_start (ZeitgeistTimeRange* self);
gint64 zeitgeist_time_range_get_end (ZeitgeistTimeRange* self);
ZeitgeistTimeRange* zeitgeist_time_range_intersect (ZeitgeistTimeRange* self, ZeitgeistTimeRange* time_range);
static void zeitgeist_time_range_finalize (GObject* obj);
static void _vala_zeitgeist_time_range_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_zeitgeist_time_range_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType zeitgeist_result_type_get_type (void) G_GNUC_CONST;
gboolean zeitgeist_result_type_is_sort_order_asc (ZeitgeistResultType result_type);
GType zeitgeist_relevant_result_type_get_type (void) G_GNUC_CONST;
GType zeitgeist_storage_state_get_type (void) G_GNUC_CONST;
gboolean zeitgeist_check_field_match (const gchar* property, const gchar* template_property, gboolean is_symbol, gboolean can_wildcard);
gboolean zeitgeist_utils_parse_negation (gchar** val);
gboolean zeitgeist_utils_is_empty_string (const gchar* s);
GList* zeitgeist_symbol_get_all_parents (const gchar* symbol_uri);
gboolean zeitgeist_utils_parse_wildcard (gchar** val);
GType zeitgeist_event_get_type (void) G_GNUC_CONST;
GType zeitgeist_subject_get_type (void) G_GNUC_CONST;
#define ZEITGEIST_EVENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), ZEITGEIST_TYPE_EVENT, ZeitgeistEventPrivate))
enum  {
	ZEITGEIST_EVENT_DUMMY_PROPERTY,
	ZEITGEIST_EVENT_ID,
	ZEITGEIST_EVENT_TIMESTAMP,
	ZEITGEIST_EVENT_ORIGIN,
	ZEITGEIST_EVENT_ACTOR,
	ZEITGEIST_EVENT_INTERPRETATION,
	ZEITGEIST_EVENT_MANIFESTATION,
	ZEITGEIST_EVENT_SUBJECTS,
	ZEITGEIST_EVENT_PAYLOAD
};
gint zeitgeist_event_num_subjects (ZeitgeistEvent* self);
GPtrArray* zeitgeist_event_get_subjects (ZeitgeistEvent* self);
void zeitgeist_event_add_subject (ZeitgeistEvent* self, ZeitgeistSubject* subject);
void zeitgeist_event_take_subject (ZeitgeistEvent* self, ZeitgeistSubject* subject);
ZeitgeistEvent* zeitgeist_event_new_full (const gchar* interpretation, const gchar* manifestation, const gchar* actor, const gchar* origin, ...);
ZeitgeistEvent* zeitgeist_event_construct_full (GType object_type, const gchar* interpretation, const gchar* manifestation, const gchar* actor, const gchar* origin, ...);
void zeitgeist_event_set_interpretation (ZeitgeistEvent* self, const gchar* value);
void zeitgeist_event_set_manifestation (ZeitgeistEvent* self, const gchar* value);
void zeitgeist_event_set_actor (ZeitgeistEvent* self, const gchar* value);
void zeitgeist_event_set_origin (ZeitgeistEvent* self, const gchar* value);
ZeitgeistEvent* zeitgeist_event_new_from_variant (GVariant* event_variant, GError** error);
ZeitgeistEvent* zeitgeist_event_construct_from_variant (GType object_type, GVariant* event_variant, GError** error);
#define ZEITGEIST_UTILS_SIG_EVENT "asaasay"
void zeitgeist_event_set_id (ZeitgeistEvent* self, guint32 value);
void zeitgeist_event_set_timestamp (ZeitgeistEvent* self, gint64 value);
ZeitgeistSubject* zeitgeist_subject_new_from_variant (GVariant* subject_variant, GError** error);
ZeitgeistSubject* zeitgeist_subject_construct_from_variant (GType object_type, GVariant* subject_variant, GError** error);
void zeitgeist_event_set_payload (ZeitgeistEvent* self, GByteArray* value);
GByteArray* zeitgeist_event_get_payload (ZeitgeistEvent* self);
GVariant* zeitgeist_event_to_variant (ZeitgeistEvent* self);
guint32 zeitgeist_event_get_id (ZeitgeistEvent* self);
gint64 zeitgeist_event_get_timestamp (ZeitgeistEvent* self);
const gchar* zeitgeist_event_get_interpretation (ZeitgeistEvent* self);
const gchar* zeitgeist_event_get_manifestation (ZeitgeistEvent* self);
const gchar* zeitgeist_event_get_actor (ZeitgeistEvent* self);
const gchar* zeitgeist_event_get_origin (ZeitgeistEvent* self);
GVariant* zeitgeist_subject_to_variant (ZeitgeistSubject* self);
static GVariant* zeitgeist_event_optimize_variant_allocation (ZeitgeistEvent* self, GVariant* event_variant);
void zeitgeist_event_debug_print (ZeitgeistEvent* self);
const gchar* zeitgeist_subject_get_uri (ZeitgeistSubject* self);
const gchar* zeitgeist_subject_get_interpretation (ZeitgeistSubject* self);
const gchar* zeitgeist_subject_get_manifestation (ZeitgeistSubject* self);
const gchar* zeitgeist_subject_get_mimetype (ZeitgeistSubject* self);
const gchar* zeitgeist_subject_get_origin (ZeitgeistSubject* self);
const gchar* zeitgeist_subject_get_text (ZeitgeistSubject* self);
const gchar* zeitgeist_subject_get_current_uri (ZeitgeistSubject* self);
const gchar* zeitgeist_subject_get_storage (ZeitgeistSubject* self);
gboolean zeitgeist_event_matches_template (ZeitgeistEvent* self, ZeitgeistEvent* template_event);
gboolean zeitgeist_subject_matches_template (ZeitgeistSubject* self, ZeitgeistSubject* template_subject);
ZeitgeistEvent* zeitgeist_event_new (void);
ZeitgeistEvent* zeitgeist_event_construct (GType object_type);
void zeitgeist_event_set_subjects (ZeitgeistEvent* self, GPtrArray* value);
static GObject * zeitgeist_event_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _g_object_unref0_ (gpointer var);
static void zeitgeist_event_finalize (GObject* obj);
static void _vala_zeitgeist_event_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_zeitgeist_event_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GPtrArray* zeitgeist_events_from_variant (GVariant* vevents, GError** error);
GVariant* zeitgeist_events_to_variant (GPtrArray* events);
GVariant* zeitgeist_events_get_null_event_variant (void);
GVariant* zeitgeist_events_to_variant_with_limit (GPtrArray* events, gsize limit, GError** error);
#define ZEITGEIST_SUBJECT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), ZEITGEIST_TYPE_SUBJECT, ZeitgeistSubjectPrivate))
enum  {
	ZEITGEIST_SUBJECT_DUMMY_PROPERTY,
	ZEITGEIST_SUBJECT_URI,
	ZEITGEIST_SUBJECT_ORIGIN,
	ZEITGEIST_SUBJECT_TEXT,
	ZEITGEIST_SUBJECT_STORAGE,
	ZEITGEIST_SUBJECT_CURRENT_URI,
	ZEITGEIST_SUBJECT_MIMETYPE,
	ZEITGEIST_SUBJECT_INTERPRETATION,
	ZEITGEIST_SUBJECT_MANIFESTATION
};
ZeitgeistSubject* zeitgeist_subject_new_full (const gchar* uri, const gchar* interpretation, const gchar* manifestation, const gchar* mimetype, const gchar* origin, const gchar* text, const gchar* storage, const gchar* current_uri);
ZeitgeistSubject* zeitgeist_subject_construct_full (GType object_type, const gchar* uri, const gchar* interpretation, const gchar* manifestation, const gchar* mimetype, const gchar* origin, const gchar* text, const gchar* storage, const gchar* current_uri);
void zeitgeist_subject_set_interpretation (ZeitgeistSubject* self, const gchar* value);
void zeitgeist_subject_set_manifestation (ZeitgeistSubject* self, const gchar* value);
void zeitgeist_subject_set_mimetype (ZeitgeistSubject* self, const gchar* value);
void zeitgeist_subject_set_origin (ZeitgeistSubject* self, const gchar* value);
void zeitgeist_subject_set_text (ZeitgeistSubject* self, const gchar* value);
void zeitgeist_subject_set_storage (ZeitgeistSubject* self, const gchar* value);
void zeitgeist_subject_set_current_uri (ZeitgeistSubject* self, const gchar* value);
void zeitgeist_subject_set_uri (ZeitgeistSubject* self, const gchar* value);
ZeitgeistSubject* zeitgeist_subject_new (void);
ZeitgeistSubject* zeitgeist_subject_construct (GType object_type);
static void zeitgeist_subject_finalize (GObject* obj);
static void _vala_zeitgeist_subject_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_zeitgeist_subject_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


void zeitgeist_assert_sig (gboolean condition, const gchar* error_message, GError** error) {
	gboolean _tmp0_;
	gboolean _tmp1_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (error_message != NULL);
	_tmp0_ = condition;
	_tmp1_ = G_UNLIKELY (!_tmp0_);
	if (_tmp1_) {
		const gchar* _tmp2_;
		GError* _tmp3_;
		_tmp2_ = error_message;
		_tmp3_ = g_error_new_literal (ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_INVALID_SIGNATURE, _tmp2_);
		_inner_error_ = _tmp3_;
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


gint64 zeitgeist_timestamp_now (void) {
	gint64 result = 0LL;
	GTimeVal _tmp0_ = {0};
	gint64 _tmp1_ = 0LL;
	g_get_current_time (&_tmp0_);
	_tmp1_ = zeitgeist_timestamp_from_timeval (&_tmp0_);
	result = _tmp1_;
	return result;
}


gint64 zeitgeist_timestamp_from_timeval (GTimeVal* tv) {
	gint64 result = 0LL;
	gint64 _result_ = 0LL;
	GTimeVal _tmp0_;
	glong _tmp1_;
	gint64 _tmp2_;
	GTimeVal _tmp3_;
	glong _tmp4_;
	g_return_val_if_fail (tv != NULL, 0LL);
	_tmp0_ = *tv;
	_tmp1_ = _tmp0_.tv_sec;
	_result_ = ((gint64) _tmp1_) * 1000;
	_tmp2_ = _result_;
	_tmp3_ = *tv;
	_tmp4_ = _tmp3_.tv_usec;
	_result_ = _tmp2_ + (((gint64) _tmp4_) / 1000);
	result = _result_;
	return result;
}


ZeitgeistTimeRange* zeitgeist_time_range_construct (GType object_type, gint64 start_msec, gint64 end_msec) {
	ZeitgeistTimeRange * self = NULL;
	gint64 _tmp0_;
	gint64 _tmp1_;
	self = (ZeitgeistTimeRange*) g_object_new (object_type, NULL);
	_tmp0_ = start_msec;
	zeitgeist_time_range_set_start (self, _tmp0_);
	_tmp1_ = end_msec;
	zeitgeist_time_range_set_end (self, _tmp1_);
	return self;
}


ZeitgeistTimeRange* zeitgeist_time_range_new (gint64 start_msec, gint64 end_msec) {
	return zeitgeist_time_range_construct (ZEITGEIST_TYPE_TIME_RANGE, start_msec, end_msec);
}


ZeitgeistTimeRange* zeitgeist_time_range_construct_anytime (GType object_type) {
	ZeitgeistTimeRange * self = NULL;
	gint64 _tmp0_;
	_tmp0_ = G_MAXINT64;
	self = (ZeitgeistTimeRange*) zeitgeist_time_range_construct (object_type, (gint64) 0, _tmp0_);
	return self;
}


ZeitgeistTimeRange* zeitgeist_time_range_new_anytime (void) {
	return zeitgeist_time_range_construct_anytime (ZEITGEIST_TYPE_TIME_RANGE);
}


ZeitgeistTimeRange* zeitgeist_time_range_construct_to_now (GType object_type) {
	ZeitgeistTimeRange * self = NULL;
	gint64 _tmp0_ = 0LL;
	_tmp0_ = zeitgeist_timestamp_now ();
	self = (ZeitgeistTimeRange*) zeitgeist_time_range_construct (object_type, (gint64) 0, _tmp0_);
	return self;
}


ZeitgeistTimeRange* zeitgeist_time_range_new_to_now (void) {
	return zeitgeist_time_range_construct_to_now (ZEITGEIST_TYPE_TIME_RANGE);
}


ZeitgeistTimeRange* zeitgeist_time_range_construct_from_now (GType object_type) {
	ZeitgeistTimeRange * self = NULL;
	gint64 _tmp0_ = 0LL;
	gint64 _tmp1_;
	_tmp0_ = zeitgeist_timestamp_now ();
	_tmp1_ = G_MAXINT64;
	self = (ZeitgeistTimeRange*) zeitgeist_time_range_construct (object_type, _tmp0_, _tmp1_);
	return self;
}


ZeitgeistTimeRange* zeitgeist_time_range_new_from_now (void) {
	return zeitgeist_time_range_construct_from_now (ZEITGEIST_TYPE_TIME_RANGE);
}


ZeitgeistTimeRange* zeitgeist_time_range_construct_from_variant (GType object_type, GVariant* variant, GError** error) {
	ZeitgeistTimeRange * self = NULL;
	GVariant* _tmp0_;
	const gchar* _tmp1_ = NULL;
	gint64 start_msec;
	gint64 end_msec;
	GVariant* _tmp2_;
	gint64 _tmp3_;
	gint64 _tmp4_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (variant != NULL, NULL);
	_tmp0_ = variant;
	_tmp1_ = g_variant_get_type_string (_tmp0_);
	zeitgeist_assert_sig (g_strcmp0 (_tmp1_, "(xx)") == 0, "Invalid D-Bus signature.", &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	start_msec = (gint64) 0;
	end_msec = (gint64) 0;
	_tmp2_ = variant;
	g_variant_get (_tmp2_, "(xx)", &start_msec, &end_msec, NULL);
	_tmp3_ = start_msec;
	_tmp4_ = end_msec;
	self = (ZeitgeistTimeRange*) zeitgeist_time_range_construct (object_type, _tmp3_, _tmp4_);
	return self;
}


ZeitgeistTimeRange* zeitgeist_time_range_new_from_variant (GVariant* variant, GError** error) {
	return zeitgeist_time_range_construct_from_variant (ZEITGEIST_TYPE_TIME_RANGE, variant, error);
}


GVariant* zeitgeist_time_range_to_variant (ZeitgeistTimeRange* self) {
	GVariant* result = NULL;
	gint64 _tmp0_;
	gint64 _tmp1_;
	GVariant* _tmp2_;
	GVariant* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_start;
	_tmp1_ = self->priv->_end;
	_tmp2_ = g_variant_new ("(xx)", _tmp0_, _tmp1_, NULL);
	_tmp3_ = g_variant_ref_sink (_tmp2_);
	result = _tmp3_;
	return result;
}


ZeitgeistTimeRange* zeitgeist_time_range_intersect (ZeitgeistTimeRange* self, ZeitgeistTimeRange* time_range) {
	ZeitgeistTimeRange* result = NULL;
	ZeitgeistTimeRange* _tmp0_;
	ZeitgeistTimeRange* _result_;
	gint64 _tmp1_;
	ZeitgeistTimeRange* _tmp2_;
	gint64 _tmp3_;
	gint64 _tmp15_;
	ZeitgeistTimeRange* _tmp16_;
	gint64 _tmp17_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (time_range != NULL, NULL);
	_tmp0_ = zeitgeist_time_range_new ((gint64) 0, (gint64) 0);
	_result_ = _tmp0_;
	_tmp1_ = self->priv->_start;
	_tmp2_ = time_range;
	_tmp3_ = _tmp2_->priv->_start;
	if (_tmp1_ < _tmp3_) {
		gint64 _tmp4_;
		ZeitgeistTimeRange* _tmp5_;
		gint64 _tmp6_;
		_tmp4_ = self->priv->_end;
		_tmp5_ = time_range;
		_tmp6_ = _tmp5_->priv->_start;
		if (_tmp4_ < _tmp6_) {
			result = NULL;
			_g_object_unref0 (_result_);
			return result;
		} else {
			ZeitgeistTimeRange* _tmp7_;
			ZeitgeistTimeRange* _tmp8_;
			gint64 _tmp9_;
			_tmp7_ = _result_;
			_tmp8_ = time_range;
			_tmp9_ = _tmp8_->priv->_start;
			zeitgeist_time_range_set_start (_tmp7_, _tmp9_);
		}
	} else {
		gint64 _tmp10_;
		ZeitgeistTimeRange* _tmp11_;
		gint64 _tmp12_;
		_tmp10_ = self->priv->_start;
		_tmp11_ = time_range;
		_tmp12_ = _tmp11_->priv->_end;
		if (_tmp10_ > _tmp12_) {
			result = NULL;
			_g_object_unref0 (_result_);
			return result;
		} else {
			ZeitgeistTimeRange* _tmp13_;
			gint64 _tmp14_;
			_tmp13_ = _result_;
			_tmp14_ = self->priv->_start;
			zeitgeist_time_range_set_start (_tmp13_, _tmp14_);
		}
	}
	_tmp15_ = self->priv->_end;
	_tmp16_ = time_range;
	_tmp17_ = _tmp16_->priv->_end;
	if (_tmp15_ < _tmp17_) {
		gint64 _tmp18_;
		ZeitgeistTimeRange* _tmp19_;
		gint64 _tmp20_;
		_tmp18_ = self->priv->_end;
		_tmp19_ = time_range;
		_tmp20_ = _tmp19_->priv->_start;
		if (_tmp18_ < _tmp20_) {
			result = NULL;
			_g_object_unref0 (_result_);
			return result;
		} else {
			ZeitgeistTimeRange* _tmp21_;
			gint64 _tmp22_;
			_tmp21_ = _result_;
			_tmp22_ = self->priv->_end;
			zeitgeist_time_range_set_end (_tmp21_, _tmp22_);
		}
	} else {
		gint64 _tmp23_;
		ZeitgeistTimeRange* _tmp24_;
		gint64 _tmp25_;
		_tmp23_ = self->priv->_start;
		_tmp24_ = time_range;
		_tmp25_ = _tmp24_->priv->_end;
		if (_tmp23_ > _tmp25_) {
			result = NULL;
			_g_object_unref0 (_result_);
			return result;
		} else {
			ZeitgeistTimeRange* _tmp26_;
			ZeitgeistTimeRange* _tmp27_;
			gint64 _tmp28_;
			_tmp26_ = _result_;
			_tmp27_ = time_range;
			_tmp28_ = _tmp27_->priv->_end;
			zeitgeist_time_range_set_end (_tmp26_, _tmp28_);
		}
	}
	result = _result_;
	return result;
}


gint64 zeitgeist_time_range_get_start (ZeitgeistTimeRange* self) {
	gint64 result;
	gint64 _tmp0_;
	g_return_val_if_fail (self != NULL, 0LL);
	_tmp0_ = self->priv->_start;
	result = _tmp0_;
	return result;
}


static void zeitgeist_time_range_set_start (ZeitgeistTimeRange* self, gint64 value) {
	gint64 _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_start = _tmp0_;
	g_object_notify ((GObject *) self, "start");
}


gint64 zeitgeist_time_range_get_end (ZeitgeistTimeRange* self) {
	gint64 result;
	gint64 _tmp0_;
	g_return_val_if_fail (self != NULL, 0LL);
	_tmp0_ = self->priv->_end;
	result = _tmp0_;
	return result;
}


static void zeitgeist_time_range_set_end (ZeitgeistTimeRange* self, gint64 value) {
	gint64 _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_end = _tmp0_;
	g_object_notify ((GObject *) self, "end");
}


static void zeitgeist_time_range_class_init (ZeitgeistTimeRangeClass * klass) {
	zeitgeist_time_range_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ZeitgeistTimeRangePrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_zeitgeist_time_range_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_zeitgeist_time_range_set_property;
	G_OBJECT_CLASS (klass)->finalize = zeitgeist_time_range_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZEITGEIST_TIME_RANGE_START, g_param_spec_int64 ("start", "start", "start", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZEITGEIST_TIME_RANGE_END, g_param_spec_int64 ("end", "end", "end", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void zeitgeist_time_range_instance_init (ZeitgeistTimeRange * self) {
	self->priv = ZEITGEIST_TIME_RANGE_GET_PRIVATE (self);
}


static void zeitgeist_time_range_finalize (GObject* obj) {
	ZeitgeistTimeRange * self;
	self = ZEITGEIST_TIME_RANGE (obj);
	G_OBJECT_CLASS (zeitgeist_time_range_parent_class)->finalize (obj);
}


GType zeitgeist_time_range_get_type (void) {
	static volatile gsize zeitgeist_time_range_type_id__volatile = 0;
	if (g_once_init_enter (&zeitgeist_time_range_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ZeitgeistTimeRangeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) zeitgeist_time_range_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ZeitgeistTimeRange), 0, (GInstanceInitFunc) zeitgeist_time_range_instance_init, NULL };
		GType zeitgeist_time_range_type_id;
		zeitgeist_time_range_type_id = g_type_register_static (G_TYPE_OBJECT, "ZeitgeistTimeRange", &g_define_type_info, 0);
		g_once_init_leave (&zeitgeist_time_range_type_id__volatile, zeitgeist_time_range_type_id);
	}
	return zeitgeist_time_range_type_id__volatile;
}


static void _vala_zeitgeist_time_range_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ZeitgeistTimeRange * self;
	self = ZEITGEIST_TIME_RANGE (object);
	switch (property_id) {
		case ZEITGEIST_TIME_RANGE_START:
		g_value_set_int64 (value, zeitgeist_time_range_get_start (self));
		break;
		case ZEITGEIST_TIME_RANGE_END:
		g_value_set_int64 (value, zeitgeist_time_range_get_end (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_zeitgeist_time_range_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ZeitgeistTimeRange * self;
	self = ZEITGEIST_TIME_RANGE (object);
	switch (property_id) {
		case ZEITGEIST_TIME_RANGE_START:
		zeitgeist_time_range_set_start (self, g_value_get_int64 (value));
		break;
		case ZEITGEIST_TIME_RANGE_END:
		zeitgeist_time_range_set_end (self, g_value_get_int64 (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


gboolean zeitgeist_result_type_is_sort_order_asc (ZeitgeistResultType result_type) {
	gboolean result = FALSE;
	ZeitgeistResultType _tmp0_;
	_tmp0_ = result_type;
	switch (_tmp0_) {
		case ZEITGEIST_RESULT_TYPE_LEAST_RECENT_EVENTS:
		case ZEITGEIST_RESULT_TYPE_LEAST_RECENT_EVENT_ORIGIN:
		case ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_EVENT_ORIGIN:
		case ZEITGEIST_RESULT_TYPE_LEAST_RECENT_SUBJECTS:
		case ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_SUBJECTS:
		case ZEITGEIST_RESULT_TYPE_LEAST_RECENT_CURRENT_URI:
		case ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_CURRENT_URI:
		case ZEITGEIST_RESULT_TYPE_LEAST_RECENT_ACTOR:
		case ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_ACTOR:
		case ZEITGEIST_RESULT_TYPE_OLDEST_ACTOR:
		case ZEITGEIST_RESULT_TYPE_LEAST_RECENT_ORIGIN:
		case ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_ORIGIN:
		case ZEITGEIST_RESULT_TYPE_LEAST_RECENT_SUBJECT_INTERPRETATION:
		case ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_SUBJECT_INTERPRETATION:
		case ZEITGEIST_RESULT_TYPE_LEAST_RECENT_MIMETYPE:
		case ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_MIMETYPE:
		{
			result = TRUE;
			return result;
		}
		case ZEITGEIST_RESULT_TYPE_MOST_RECENT_EVENTS:
		case ZEITGEIST_RESULT_TYPE_MOST_RECENT_EVENT_ORIGIN:
		case ZEITGEIST_RESULT_TYPE_MOST_POPULAR_EVENT_ORIGIN:
		case ZEITGEIST_RESULT_TYPE_MOST_RECENT_SUBJECTS:
		case ZEITGEIST_RESULT_TYPE_MOST_POPULAR_SUBJECTS:
		case ZEITGEIST_RESULT_TYPE_MOST_RECENT_CURRENT_URI:
		case ZEITGEIST_RESULT_TYPE_MOST_POPULAR_CURRENT_URI:
		case ZEITGEIST_RESULT_TYPE_MOST_RECENT_ACTOR:
		case ZEITGEIST_RESULT_TYPE_MOST_POPULAR_ACTOR:
		case ZEITGEIST_RESULT_TYPE_MOST_RECENT_ORIGIN:
		case ZEITGEIST_RESULT_TYPE_MOST_POPULAR_ORIGIN:
		case ZEITGEIST_RESULT_TYPE_MOST_RECENT_SUBJECT_INTERPRETATION:
		case ZEITGEIST_RESULT_TYPE_MOST_POPULAR_SUBJECT_INTERPRETATION:
		case ZEITGEIST_RESULT_TYPE_MOST_RECENT_MIMETYPE:
		case ZEITGEIST_RESULT_TYPE_MOST_POPULAR_MIMETYPE:
		{
			result = FALSE;
			return result;
		}
		default:
		{
			ZeitgeistResultType _tmp1_;
			_tmp1_ = result_type;
			g_warning ("datamodel.vala:283: Unrecognized ResultType: %u", (guint) _tmp1_);
			result = TRUE;
			return result;
		}
	}
}


GType zeitgeist_result_type_get_type (void) {
	static volatile gsize zeitgeist_result_type_type_id__volatile = 0;
	if (g_once_init_enter (&zeitgeist_result_type_type_id__volatile)) {
		static const GEnumValue values[] = {{ZEITGEIST_RESULT_TYPE_MOST_RECENT_EVENTS, "ZEITGEIST_RESULT_TYPE_MOST_RECENT_EVENTS", "most-recent-events"}, {ZEITGEIST_RESULT_TYPE_LEAST_RECENT_EVENTS, "ZEITGEIST_RESULT_TYPE_LEAST_RECENT_EVENTS", "least-recent-events"}, {ZEITGEIST_RESULT_TYPE_MOST_RECENT_SUBJECTS, "ZEITGEIST_RESULT_TYPE_MOST_RECENT_SUBJECTS", "most-recent-subjects"}, {ZEITGEIST_RESULT_TYPE_LEAST_RECENT_SUBJECTS, "ZEITGEIST_RESULT_TYPE_LEAST_RECENT_SUBJECTS", "least-recent-subjects"}, {ZEITGEIST_RESULT_TYPE_MOST_POPULAR_SUBJECTS, "ZEITGEIST_RESULT_TYPE_MOST_POPULAR_SUBJECTS", "most-popular-subjects"}, {ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_SUBJECTS, "ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_SUBJECTS", "least-popular-subjects"}, {ZEITGEIST_RESULT_TYPE_MOST_POPULAR_ACTOR, "ZEITGEIST_RESULT_TYPE_MOST_POPULAR_ACTOR", "most-popular-actor"}, {ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_ACTOR, "ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_ACTOR", "least-popular-actor"}, {ZEITGEIST_RESULT_TYPE_MOST_RECENT_ACTOR, "ZEITGEIST_RESULT_TYPE_MOST_RECENT_ACTOR", "most-recent-actor"}, {ZEITGEIST_RESULT_TYPE_LEAST_RECENT_ACTOR, "ZEITGEIST_RESULT_TYPE_LEAST_RECENT_ACTOR", "least-recent-actor"}, {ZEITGEIST_RESULT_TYPE_MOST_RECENT_ORIGIN, "ZEITGEIST_RESULT_TYPE_MOST_RECENT_ORIGIN", "most-recent-origin"}, {ZEITGEIST_RESULT_TYPE_LEAST_RECENT_ORIGIN, "ZEITGEIST_RESULT_TYPE_LEAST_RECENT_ORIGIN", "least-recent-origin"}, {ZEITGEIST_RESULT_TYPE_MOST_POPULAR_ORIGIN, "ZEITGEIST_RESULT_TYPE_MOST_POPULAR_ORIGIN", "most-popular-origin"}, {ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_ORIGIN, "ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_ORIGIN", "least-popular-origin"}, {ZEITGEIST_RESULT_TYPE_OLDEST_ACTOR, "ZEITGEIST_RESULT_TYPE_OLDEST_ACTOR", "oldest-actor"}, {ZEITGEIST_RESULT_TYPE_MOST_RECENT_SUBJECT_INTERPRETATION, "ZEITGEIST_RESULT_TYPE_MOST_RECENT_SUBJECT_INTERPRETATION", "most-recent-subject-interpretation"}, {ZEITGEIST_RESULT_TYPE_LEAST_RECENT_SUBJECT_INTERPRETATION, "ZEITGEIST_RESULT_TYPE_LEAST_RECENT_SUBJECT_INTERPRETATION", "least-recent-subject-interpretation"}, {ZEITGEIST_RESULT_TYPE_MOST_POPULAR_SUBJECT_INTERPRETATION, "ZEITGEIST_RESULT_TYPE_MOST_POPULAR_SUBJECT_INTERPRETATION", "most-popular-subject-interpretation"}, {ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_SUBJECT_INTERPRETATION, "ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_SUBJECT_INTERPRETATION", "least-popular-subject-interpretation"}, {ZEITGEIST_RESULT_TYPE_MOST_RECENT_MIMETYPE, "ZEITGEIST_RESULT_TYPE_MOST_RECENT_MIMETYPE", "most-recent-mimetype"}, {ZEITGEIST_RESULT_TYPE_LEAST_RECENT_MIMETYPE, "ZEITGEIST_RESULT_TYPE_LEAST_RECENT_MIMETYPE", "least-recent-mimetype"}, {ZEITGEIST_RESULT_TYPE_MOST_POPULAR_MIMETYPE, "ZEITGEIST_RESULT_TYPE_MOST_POPULAR_MIMETYPE", "most-popular-mimetype"}, {ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_MIMETYPE, "ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_MIMETYPE", "least-popular-mimetype"}, {ZEITGEIST_RESULT_TYPE_MOST_RECENT_CURRENT_URI, "ZEITGEIST_RESULT_TYPE_MOST_RECENT_CURRENT_URI", "most-recent-current-uri"}, {ZEITGEIST_RESULT_TYPE_LEAST_RECENT_CURRENT_URI, "ZEITGEIST_RESULT_TYPE_LEAST_RECENT_CURRENT_URI", "least-recent-current-uri"}, {ZEITGEIST_RESULT_TYPE_MOST_POPULAR_CURRENT_URI, "ZEITGEIST_RESULT_TYPE_MOST_POPULAR_CURRENT_URI", "most-popular-current-uri"}, {ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_CURRENT_URI, "ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_CURRENT_URI", "least-popular-current-uri"}, {ZEITGEIST_RESULT_TYPE_MOST_RECENT_EVENT_ORIGIN, "ZEITGEIST_RESULT_TYPE_MOST_RECENT_EVENT_ORIGIN", "most-recent-event-origin"}, {ZEITGEIST_RESULT_TYPE_LEAST_RECENT_EVENT_ORIGIN, "ZEITGEIST_RESULT_TYPE_LEAST_RECENT_EVENT_ORIGIN", "least-recent-event-origin"}, {ZEITGEIST_RESULT_TYPE_MOST_POPULAR_EVENT_ORIGIN, "ZEITGEIST_RESULT_TYPE_MOST_POPULAR_EVENT_ORIGIN", "most-popular-event-origin"}, {ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_EVENT_ORIGIN, "ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_EVENT_ORIGIN", "least-popular-event-origin"}, {0, NULL, NULL}};
		GType zeitgeist_result_type_type_id;
		zeitgeist_result_type_type_id = g_enum_register_static ("ZeitgeistResultType", values);
		g_once_init_leave (&zeitgeist_result_type_type_id__volatile, zeitgeist_result_type_type_id);
	}
	return zeitgeist_result_type_type_id__volatile;
}


GType zeitgeist_relevant_result_type_get_type (void) {
	static volatile gsize zeitgeist_relevant_result_type_type_id__volatile = 0;
	if (g_once_init_enter (&zeitgeist_relevant_result_type_type_id__volatile)) {
		static const GEnumValue values[] = {{ZEITGEIST_RELEVANT_RESULT_TYPE_RECENT, "ZEITGEIST_RELEVANT_RESULT_TYPE_RECENT", "recent"}, {ZEITGEIST_RELEVANT_RESULT_TYPE_RELATED, "ZEITGEIST_RELEVANT_RESULT_TYPE_RELATED", "related"}, {0, NULL, NULL}};
		GType zeitgeist_relevant_result_type_type_id;
		zeitgeist_relevant_result_type_type_id = g_enum_register_static ("ZeitgeistRelevantResultType", values);
		g_once_init_leave (&zeitgeist_relevant_result_type_type_id__volatile, zeitgeist_relevant_result_type_type_id);
	}
	return zeitgeist_relevant_result_type_type_id__volatile;
}


/**
     * Enumeration class defining the possible values for the storage
     * state of an event subject.
     *
     * The StorageState enumeration can be used to control whether or
     * not matched events must have their subjects available to the user.
     * Fx. not including deleted files, files on unplugged USB drives,
     * files available only when a network is available etc.
     */
GType zeitgeist_storage_state_get_type (void) {
	static volatile gsize zeitgeist_storage_state_type_id__volatile = 0;
	if (g_once_init_enter (&zeitgeist_storage_state_type_id__volatile)) {
		static const GEnumValue values[] = {{ZEITGEIST_STORAGE_STATE_NOT_AVAILABLE, "ZEITGEIST_STORAGE_STATE_NOT_AVAILABLE", "not-available"}, {ZEITGEIST_STORAGE_STATE_AVAILABLE, "ZEITGEIST_STORAGE_STATE_AVAILABLE", "available"}, {ZEITGEIST_STORAGE_STATE_ANY, "ZEITGEIST_STORAGE_STATE_ANY", "any"}, {0, NULL, NULL}};
		GType zeitgeist_storage_state_type_id;
		zeitgeist_storage_state_type_id = g_enum_register_static ("ZeitgeistStorageState", values);
		g_once_init_leave (&zeitgeist_storage_state_type_id__volatile, zeitgeist_storage_state_type_id);
	}
	return zeitgeist_storage_state_type_id__volatile;
}


gboolean zeitgeist_check_field_match (const gchar* property, const gchar* template_property, gboolean is_symbol, gboolean can_wildcard) {
	gboolean result = FALSE;
	gboolean matches;
	gboolean is_negated;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* parsed;
	const gchar* _tmp2_;
	const gchar* _tmp4_;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp30_ = FALSE;
	gboolean _tmp31_;
	gboolean _tmp34_;
	matches = FALSE;
	is_negated = FALSE;
	_tmp0_ = template_property;
	_tmp1_ = g_strdup (_tmp0_);
	parsed = _tmp1_;
	_tmp2_ = parsed;
	if (_tmp2_ != NULL) {
		gboolean _tmp3_ = FALSE;
		_tmp3_ = zeitgeist_utils_parse_negation (&parsed);
		is_negated = _tmp3_;
	}
	_tmp4_ = parsed;
	_tmp5_ = zeitgeist_utils_is_empty_string (_tmp4_);
	if (_tmp5_) {
		result = TRUE;
		_g_free0 (parsed);
		return result;
	} else {
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		_tmp6_ = parsed;
		_tmp7_ = property;
		if (g_strcmp0 (_tmp6_, _tmp7_) == 0) {
			matches = TRUE;
		} else {
			gboolean _tmp8_ = FALSE;
			gboolean _tmp9_ = FALSE;
			gboolean _tmp10_;
			gboolean _tmp12_;
			gboolean _tmp19_;
			_tmp10_ = is_symbol;
			if (_tmp10_) {
				const gchar* _tmp11_;
				_tmp11_ = property;
				_tmp9_ = _tmp11_ != NULL;
			} else {
				_tmp9_ = FALSE;
			}
			_tmp12_ = _tmp9_;
			if (_tmp12_) {
				const gchar* _tmp13_;
				GList* _tmp14_ = NULL;
				GList* _tmp15_;
				const gchar* _tmp16_;
				GCompareFunc _tmp17_;
				GList* _tmp18_ = NULL;
				_tmp13_ = property;
				_tmp14_ = zeitgeist_symbol_get_all_parents (_tmp13_);
				_tmp15_ = _tmp14_;
				_tmp16_ = parsed;
				_tmp17_ = g_strcmp0;
				_tmp18_ = g_list_find_custom (_tmp15_, _tmp16_, _tmp17_);
				_tmp8_ = _tmp18_ != NULL;
				_g_list_free0 (_tmp15_);
			} else {
				_tmp8_ = FALSE;
			}
			_tmp19_ = _tmp8_;
			if (_tmp19_) {
				matches = TRUE;
			} else {
				gboolean _tmp20_ = FALSE;
				gboolean _tmp21_;
				gboolean _tmp23_;
				_tmp21_ = can_wildcard;
				if (_tmp21_) {
					gboolean _tmp22_ = FALSE;
					_tmp22_ = zeitgeist_utils_parse_wildcard (&parsed);
					_tmp20_ = _tmp22_;
				} else {
					_tmp20_ = FALSE;
				}
				_tmp23_ = _tmp20_;
				if (_tmp23_) {
					gboolean _tmp24_ = FALSE;
					const gchar* _tmp25_;
					gboolean _tmp29_;
					_tmp25_ = property;
					if (_tmp25_ != NULL) {
						const gchar* _tmp26_;
						const gchar* _tmp27_;
						gboolean _tmp28_ = FALSE;
						_tmp26_ = property;
						_tmp27_ = parsed;
						_tmp28_ = g_str_has_prefix (_tmp26_, _tmp27_);
						_tmp24_ = _tmp28_;
					} else {
						_tmp24_ = FALSE;
					}
					_tmp29_ = _tmp24_;
					if (_tmp29_) {
						matches = TRUE;
					}
				}
			}
		}
	}
	_tmp31_ = is_negated;
	if (_tmp31_) {
		gboolean _tmp32_;
		_tmp32_ = matches;
		_tmp30_ = !_tmp32_;
	} else {
		gboolean _tmp33_;
		_tmp33_ = matches;
		_tmp30_ = _tmp33_;
	}
	_tmp34_ = _tmp30_;
	result = _tmp34_;
	_g_free0 (parsed);
	return result;
}


static gint g_ptr_array_get_length (GPtrArray* self) {
	gint result;
	guint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->len;
	result = (gint) _tmp0_;
	return result;
}


static void g_ptr_array_set_length (GPtrArray* self, gint value) {
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	g_ptr_array_set_size (self, _tmp0_);
}


gint zeitgeist_event_num_subjects (ZeitgeistEvent* self) {
	gint result = 0;
	GPtrArray* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_subjects;
	_tmp1_ = g_ptr_array_get_length (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void zeitgeist_event_add_subject (ZeitgeistEvent* self, ZeitgeistSubject* subject) {
	GPtrArray* _tmp0_;
	ZeitgeistSubject* _tmp1_;
	ZeitgeistSubject* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (subject != NULL);
	_tmp0_ = self->priv->_subjects;
	_tmp1_ = subject;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	g_ptr_array_add (_tmp0_, _tmp2_);
}


void zeitgeist_event_take_subject (ZeitgeistEvent* self, ZeitgeistSubject* subject) {
	GPtrArray* _tmp0_;
	ZeitgeistSubject* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (subject != NULL);
	_tmp0_ = self->priv->_subjects;
	_tmp1_ = subject;
	subject = NULL;
	g_ptr_array_add (_tmp0_, _tmp1_);
	_g_object_unref0 (subject);
}


ZeitgeistEvent* zeitgeist_event_construct_full (GType object_type, const gchar* interpretation, const gchar* manifestation, const gchar* actor, const gchar* origin, ...) {
	ZeitgeistEvent * self = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	self = (ZeitgeistEvent*) g_object_new (object_type, NULL);
	_tmp0_ = interpretation;
	zeitgeist_event_set_interpretation (self, _tmp0_);
	_tmp1_ = manifestation;
	zeitgeist_event_set_manifestation (self, _tmp1_);
	_tmp2_ = actor;
	zeitgeist_event_set_actor (self, _tmp2_);
	_tmp3_ = origin;
	zeitgeist_event_set_origin (self, _tmp3_);
	return self;
}


ZeitgeistEvent* zeitgeist_event_new_full (const gchar* interpretation, const gchar* manifestation, const gchar* actor, const gchar* origin, ...) {
	return zeitgeist_event_construct_full (ZEITGEIST_TYPE_EVENT, interpretation, manifestation, actor, origin);
}


static guint64 uint64_parse (const gchar* str) {
	guint64 result = 0ULL;
	const gchar* _tmp0_;
	guint64 _tmp1_ = 0ULL;
	g_return_val_if_fail (str != NULL, 0ULL);
	_tmp0_ = str;
	_tmp1_ = g_ascii_strtoull (_tmp0_, NULL, (guint) 0);
	result = _tmp1_;
	return result;
}


static gint64 int64_parse (const gchar* str) {
	gint64 result = 0LL;
	const gchar* _tmp0_;
	gint64 _tmp1_ = 0LL;
	g_return_val_if_fail (str != NULL, 0LL);
	_tmp0_ = str;
	_tmp1_ = g_ascii_strtoll (_tmp0_, NULL, (guint) 0);
	result = _tmp1_;
	return result;
}


ZeitgeistEvent* zeitgeist_event_construct_from_variant (GType object_type, GVariant* event_variant, GError** error) {
	ZeitgeistEvent * self = NULL;
	GVariant* _tmp0_;
	const gchar* _tmp1_ = NULL;
	GVariant* _tmp2_;
	GVariantIter* _tmp3_ = NULL;
	GVariantIter* iter;
	GVariantIter* _tmp4_;
	gsize _tmp5_ = 0UL;
	GVariantIter* _tmp6_;
	GVariant* _tmp7_ = NULL;
	GVariant* _tmp8_;
	GVariantIter* _tmp9_ = NULL;
	GVariantIter* _tmp10_;
	GVariantIter* event_array;
	GVariantIter* _tmp11_;
	GVariant* _tmp12_ = NULL;
	GVariant* _tmp13_;
	GVariantIter* _tmp14_ = NULL;
	GVariantIter* _tmp15_;
	GVariantIter* subjects_array;
	GVariantIter* _tmp16_;
	GVariant* _tmp17_ = NULL;
	GVariant* payload_variant;
	GVariantIter* _tmp18_;
	gsize _tmp19_ = 0UL;
	gsize event_props;
	gsize _tmp20_;
	GVariantIter* _tmp21_;
	GVariant* _tmp22_ = NULL;
	GVariant* _tmp23_;
	const gchar* _tmp24_ = NULL;
	guint64 _tmp25_ = 0ULL;
	GVariantIter* _tmp26_;
	GVariant* _tmp27_ = NULL;
	GVariant* _tmp28_;
	const gchar* _tmp29_ = NULL;
	gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* str_timestamp;
	const gchar* _tmp32_;
	GVariantIter* _tmp36_;
	GVariant* _tmp37_ = NULL;
	GVariant* _tmp38_;
	const gchar* _tmp39_ = NULL;
	GVariantIter* _tmp40_;
	GVariant* _tmp41_ = NULL;
	GVariant* _tmp42_;
	const gchar* _tmp43_ = NULL;
	GVariantIter* _tmp44_;
	GVariant* _tmp45_ = NULL;
	GVariant* _tmp46_;
	const gchar* _tmp47_ = NULL;
	gsize _tmp48_;
	GVariant* _tmp65_;
	gsize _tmp66_ = 0UL;
	guint payload_length;
	guint _tmp67_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (event_variant != NULL, NULL);
	self = (ZeitgeistEvent*) g_object_new (object_type, NULL);
	_tmp0_ = event_variant;
	_tmp1_ = g_variant_get_type_string (_tmp0_);
	zeitgeist_assert_sig (g_strcmp0 (_tmp1_, "(" ZEITGEIST_UTILS_SIG_EVENT ")") == 0, "Invalid D-Bus signature.", &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp2_ = event_variant;
	_tmp3_ = g_variant_iter_new (_tmp2_);
	iter = _tmp3_;
	_tmp4_ = iter;
	_tmp5_ = g_variant_iter_n_children (_tmp4_);
	zeitgeist_assert_sig (_tmp5_ >= ((gsize) 3), "Incomplete event struct.", &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_variant_iter_free0 (iter);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_variant_iter_free0 (iter);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp6_ = iter;
	_tmp7_ = g_variant_iter_next_value (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_variant_iter_new (_tmp8_);
	_tmp10_ = _tmp9_;
	_g_variant_unref0 (_tmp8_);
	event_array = _tmp10_;
	_tmp11_ = iter;
	_tmp12_ = g_variant_iter_next_value (_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = g_variant_iter_new (_tmp13_);
	_tmp15_ = _tmp14_;
	_g_variant_unref0 (_tmp13_);
	subjects_array = _tmp15_;
	_tmp16_ = iter;
	_tmp17_ = g_variant_iter_next_value (_tmp16_);
	payload_variant = _tmp17_;
	_tmp18_ = event_array;
	_tmp19_ = g_variant_iter_n_children (_tmp18_);
	event_props = _tmp19_;
	_tmp20_ = event_props;
	zeitgeist_assert_sig (_tmp20_ >= ((gsize) 5), "Missing event information.", &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_variant_unref0 (payload_variant);
			_g_variant_iter_free0 (subjects_array);
			_g_variant_iter_free0 (event_array);
			_g_variant_iter_free0 (iter);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_variant_unref0 (payload_variant);
			_g_variant_iter_free0 (subjects_array);
			_g_variant_iter_free0 (event_array);
			_g_variant_iter_free0 (iter);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp21_ = event_array;
	_tmp22_ = g_variant_iter_next_value (_tmp21_);
	_tmp23_ = _tmp22_;
	_tmp24_ = g_variant_get_string (_tmp23_, NULL);
	_tmp25_ = uint64_parse (_tmp24_);
	zeitgeist_event_set_id (self, (guint32) _tmp25_);
	_g_variant_unref0 (_tmp23_);
	_tmp26_ = event_array;
	_tmp27_ = g_variant_iter_next_value (_tmp26_);
	_tmp28_ = _tmp27_;
	_tmp29_ = g_variant_get_string (_tmp28_, NULL);
	_tmp30_ = g_strdup (_tmp29_);
	_tmp31_ = _tmp30_;
	_g_variant_unref0 (_tmp28_);
	str_timestamp = _tmp31_;
	_tmp32_ = str_timestamp;
	if (g_strcmp0 (_tmp32_, "") == 0) {
		gint64 _tmp33_ = 0LL;
		_tmp33_ = zeitgeist_timestamp_now ();
		zeitgeist_event_set_timestamp (self, _tmp33_);
	} else {
		const gchar* _tmp34_;
		gint64 _tmp35_ = 0LL;
		_tmp34_ = str_timestamp;
		_tmp35_ = int64_parse (_tmp34_);
		zeitgeist_event_set_timestamp (self, _tmp35_);
	}
	_tmp36_ = event_array;
	_tmp37_ = g_variant_iter_next_value (_tmp36_);
	_tmp38_ = _tmp37_;
	_tmp39_ = g_variant_get_string (_tmp38_, NULL);
	zeitgeist_event_set_interpretation (self, _tmp39_);
	_g_variant_unref0 (_tmp38_);
	_tmp40_ = event_array;
	_tmp41_ = g_variant_iter_next_value (_tmp40_);
	_tmp42_ = _tmp41_;
	_tmp43_ = g_variant_get_string (_tmp42_, NULL);
	zeitgeist_event_set_manifestation (self, _tmp43_);
	_g_variant_unref0 (_tmp42_);
	_tmp44_ = event_array;
	_tmp45_ = g_variant_iter_next_value (_tmp44_);
	_tmp46_ = _tmp45_;
	_tmp47_ = g_variant_get_string (_tmp46_, NULL);
	zeitgeist_event_set_actor (self, _tmp47_);
	_g_variant_unref0 (_tmp46_);
	_tmp48_ = event_props;
	if (_tmp48_ >= ((gsize) 6)) {
		GVariantIter* _tmp49_;
		GVariant* _tmp50_ = NULL;
		GVariant* _tmp51_;
		const gchar* _tmp52_ = NULL;
		_tmp49_ = event_array;
		_tmp50_ = g_variant_iter_next_value (_tmp49_);
		_tmp51_ = _tmp50_;
		_tmp52_ = g_variant_get_string (_tmp51_, NULL);
		zeitgeist_event_set_origin (self, _tmp52_);
		_g_variant_unref0 (_tmp51_);
	} else {
		zeitgeist_event_set_origin (self, "");
	}
	{
		gint i;
		i = 0;
		{
			gboolean _tmp53_;
			_tmp53_ = TRUE;
			while (TRUE) {
				gboolean _tmp54_;
				gint _tmp56_;
				GVariantIter* _tmp57_;
				gsize _tmp58_ = 0UL;
				GVariantIter* _tmp59_;
				GVariant* _tmp60_ = NULL;
				GVariant* subject_variant;
				GVariant* _tmp61_;
				ZeitgeistSubject* _tmp62_;
				ZeitgeistSubject* _tmp63_;
				GPtrArray* _tmp64_;
				_tmp54_ = _tmp53_;
				if (!_tmp54_) {
					gint _tmp55_;
					_tmp55_ = i;
					i = _tmp55_ + 1;
				}
				_tmp53_ = FALSE;
				_tmp56_ = i;
				_tmp57_ = subjects_array;
				_tmp58_ = g_variant_iter_n_children (_tmp57_);
				if (!(((gsize) _tmp56_) < _tmp58_)) {
					break;
				}
				_tmp59_ = subjects_array;
				_tmp60_ = g_variant_iter_next_value (_tmp59_);
				subject_variant = _tmp60_;
				_tmp61_ = subject_variant;
				_tmp62_ = zeitgeist_subject_new_from_variant (_tmp61_, &_inner_error_);
				_tmp63_ = _tmp62_;
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
						g_propagate_error (error, _inner_error_);
						_g_variant_unref0 (subject_variant);
						_g_free0 (str_timestamp);
						_g_variant_unref0 (payload_variant);
						_g_variant_iter_free0 (subjects_array);
						_g_variant_iter_free0 (event_array);
						_g_variant_iter_free0 (iter);
						_g_object_unref0 (self);
						return NULL;
					} else {
						_g_variant_unref0 (subject_variant);
						_g_free0 (str_timestamp);
						_g_variant_unref0 (payload_variant);
						_g_variant_iter_free0 (subjects_array);
						_g_variant_iter_free0 (event_array);
						_g_variant_iter_free0 (iter);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				_tmp64_ = self->priv->_subjects;
				g_ptr_array_add (_tmp64_, _tmp63_);
				_g_variant_unref0 (subject_variant);
			}
		}
	}
	_tmp65_ = payload_variant;
	_tmp66_ = g_variant_n_children (_tmp65_);
	payload_length = (guint) _tmp66_;
	_tmp67_ = payload_length;
	if (_tmp67_ > ((guint) 0)) {
		guint _tmp68_;
		guint _tmp69_;
		GByteArray* _tmp70_;
		GByteArray* _tmp71_;
		GVariant* _tmp72_;
		void* _tmp73_ = NULL;
		guint8* data;
		gint data_length1;
		gint _data_size_;
		guint _tmp74_;
		gint _tmp75_;
		GByteArray* _tmp76_;
		guint8* _tmp77_;
		gint _tmp77__length1;
		_tmp68_ = payload_length;
		g_debug ("datamodel.vala:461: there was payload with length: %u", _tmp68_);
		_tmp69_ = payload_length;
		_tmp70_ = g_byte_array_sized_new (_tmp69_);
		_tmp71_ = _tmp70_;
		zeitgeist_event_set_payload (self, _tmp71_);
		_g_byte_array_unref0 (_tmp71_);
		_tmp72_ = payload_variant;
		_tmp73_ = g_variant_get_data (_tmp72_);
		data = (guint8*) _tmp73_;
		data_length1 = -1;
		_data_size_ = data_length1;
		_tmp74_ = payload_length;
		data_length1 = (gint) _tmp74_;
		_tmp75_ = data_length1;
		_tmp76_ = self->priv->_payload;
		_tmp77_ = data;
		_tmp77__length1 = data_length1;
		g_byte_array_append (_tmp76_, _tmp77_, _tmp77__length1);
	}
	_g_free0 (str_timestamp);
	_g_variant_unref0 (payload_variant);
	_g_variant_iter_free0 (subjects_array);
	_g_variant_iter_free0 (event_array);
	_g_variant_iter_free0 (iter);
	return self;
}


ZeitgeistEvent* zeitgeist_event_new_from_variant (GVariant* event_variant, GError** error) {
	return zeitgeist_event_construct_from_variant (ZEITGEIST_TYPE_EVENT, event_variant, error);
}


static gpointer _g_byte_array_ref0 (gpointer self) {
	return self ? g_byte_array_ref (self) : NULL;
}


GVariant* zeitgeist_event_to_variant (ZeitgeistEvent* self) {
	GVariant* result = NULL;
	GVariantType* _tmp0_;
	GVariantType* _tmp1_;
	GVariantBuilder* _tmp2_;
	GVariantBuilder* _tmp3_;
	GVariantBuilder* vb;
	GVariantBuilder* _tmp4_;
	GVariantType* _tmp5_;
	GVariantType* _tmp6_;
	gchar* _tmp7_ = NULL;
	guint32 _tmp8_;
	GVariantBuilder* _tmp12_;
	const gchar* _tmp13_;
	GVariantBuilder* _tmp14_;
	gint64 _tmp15_;
	gchar* _tmp16_ = NULL;
	gchar* _tmp17_;
	const gchar* _tmp18_ = NULL;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	GVariantBuilder* _tmp23_;
	const gchar* _tmp24_;
	const gchar* _tmp25_ = NULL;
	const gchar* _tmp26_;
	const gchar* _tmp27_;
	GVariantBuilder* _tmp30_;
	const gchar* _tmp31_;
	const gchar* _tmp32_ = NULL;
	const gchar* _tmp33_;
	const gchar* _tmp34_;
	GVariantBuilder* _tmp37_;
	const gchar* _tmp38_;
	const gchar* _tmp39_ = NULL;
	const gchar* _tmp40_;
	GVariantBuilder* _tmp42_;
	const gchar* _tmp43_;
	GVariantBuilder* _tmp44_;
	GVariantBuilder* _tmp45_;
	GVariantType* _tmp46_;
	GVariantType* _tmp47_;
	GVariantBuilder* _tmp61_;
	GByteArray* _tmp62_;
	GVariantBuilder* _tmp78_;
	GVariant* _tmp79_ = NULL;
	GVariant* _tmp80_;
	GVariant* _tmp81_ = NULL;
	GVariant* _tmp82_;
	GVariant* event_variant;
	GVariant* _tmp83_ = NULL;
	GVariant* ret;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_variant_type_new ("(" ZEITGEIST_UTILS_SIG_EVENT ")");
	_tmp1_ = _tmp0_;
	_tmp2_ = g_variant_builder_new (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_variant_type_free0 (_tmp1_);
	vb = _tmp3_;
	_tmp4_ = vb;
	_tmp5_ = g_variant_type_new ("as");
	_tmp6_ = _tmp5_;
	g_variant_builder_open (_tmp4_, _tmp6_);
	_g_variant_type_free0 (_tmp6_);
	_tmp8_ = self->priv->_id;
	if (_tmp8_ == ((guint32) 0)) {
		gchar* _tmp9_;
		_tmp9_ = g_strdup ("");
		_g_free0 (_tmp7_);
		_tmp7_ = _tmp9_;
	} else {
		guint32 _tmp10_;
		gchar* _tmp11_ = NULL;
		_tmp10_ = self->priv->_id;
		_tmp11_ = g_strdup_printf ("%u", _tmp10_);
		_g_free0 (_tmp7_);
		_tmp7_ = _tmp11_;
	}
	_tmp12_ = vb;
	_tmp13_ = _tmp7_;
	g_variant_builder_add (_tmp12_, "s", _tmp13_, NULL);
	_tmp14_ = vb;
	_tmp15_ = self->priv->_timestamp;
	_tmp16_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp15_);
	_tmp17_ = _tmp16_;
	g_variant_builder_add (_tmp14_, "s", _tmp17_, NULL);
	_g_free0 (_tmp17_);
	_tmp19_ = zeitgeist_event_get_interpretation (self);
	_tmp20_ = _tmp19_;
	if (_tmp20_ != NULL) {
		const gchar* _tmp21_;
		const gchar* _tmp22_;
		_tmp21_ = zeitgeist_event_get_interpretation (self);
		_tmp22_ = _tmp21_;
		_tmp18_ = _tmp22_;
	} else {
		_tmp18_ = "";
	}
	_tmp23_ = vb;
	_tmp24_ = _tmp18_;
	g_variant_builder_add (_tmp23_, "s", _tmp24_, NULL);
	_tmp26_ = zeitgeist_event_get_manifestation (self);
	_tmp27_ = _tmp26_;
	if (_tmp27_ != NULL) {
		const gchar* _tmp28_;
		const gchar* _tmp29_;
		_tmp28_ = zeitgeist_event_get_manifestation (self);
		_tmp29_ = _tmp28_;
		_tmp25_ = _tmp29_;
	} else {
		_tmp25_ = "";
	}
	_tmp30_ = vb;
	_tmp31_ = _tmp25_;
	g_variant_builder_add (_tmp30_, "s", _tmp31_, NULL);
	_tmp33_ = zeitgeist_event_get_actor (self);
	_tmp34_ = _tmp33_;
	if (_tmp34_ != NULL) {
		const gchar* _tmp35_;
		const gchar* _tmp36_;
		_tmp35_ = zeitgeist_event_get_actor (self);
		_tmp36_ = _tmp35_;
		_tmp32_ = _tmp36_;
	} else {
		_tmp32_ = "";
	}
	_tmp37_ = vb;
	_tmp38_ = _tmp32_;
	g_variant_builder_add (_tmp37_, "s", _tmp38_, NULL);
	_tmp40_ = self->priv->_origin;
	if (_tmp40_ != NULL) {
		const gchar* _tmp41_;
		_tmp41_ = self->priv->_origin;
		_tmp39_ = _tmp41_;
	} else {
		_tmp39_ = "";
	}
	_tmp42_ = vb;
	_tmp43_ = _tmp39_;
	g_variant_builder_add (_tmp42_, "s", _tmp43_, NULL);
	_tmp44_ = vb;
	g_variant_builder_close (_tmp44_);
	_tmp45_ = vb;
	_tmp46_ = g_variant_type_new ("aas");
	_tmp47_ = _tmp46_;
	g_variant_builder_open (_tmp45_, _tmp47_);
	_g_variant_type_free0 (_tmp47_);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp48_;
			_tmp48_ = TRUE;
			while (TRUE) {
				gboolean _tmp49_;
				gint _tmp51_;
				GPtrArray* _tmp52_;
				gint _tmp53_;
				gint _tmp54_;
				GVariantBuilder* _tmp55_;
				GPtrArray* _tmp56_;
				gint _tmp57_;
				gconstpointer _tmp58_ = NULL;
				GVariant* _tmp59_ = NULL;
				GVariant* _tmp60_;
				_tmp49_ = _tmp48_;
				if (!_tmp49_) {
					gint _tmp50_;
					_tmp50_ = i;
					i = _tmp50_ + 1;
				}
				_tmp48_ = FALSE;
				_tmp51_ = i;
				_tmp52_ = self->priv->_subjects;
				_tmp53_ = g_ptr_array_get_length (_tmp52_);
				_tmp54_ = _tmp53_;
				if (!(_tmp51_ < _tmp54_)) {
					break;
				}
				_tmp55_ = vb;
				_tmp56_ = self->priv->_subjects;
				_tmp57_ = i;
				_tmp58_ = g_ptr_array_index (_tmp56_, (guint) _tmp57_);
				_tmp59_ = zeitgeist_subject_to_variant ((ZeitgeistSubject*) _tmp58_);
				_tmp60_ = _tmp59_;
				g_variant_builder_add_value (_tmp55_, _tmp60_);
				_g_variant_unref0 (_tmp60_);
			}
		}
	}
	_tmp61_ = vb;
	g_variant_builder_close (_tmp61_);
	_tmp62_ = self->priv->_payload;
	if (_tmp62_ != NULL) {
		GVariantType* _tmp63_;
		GVariantType* _tmp64_;
		GByteArray* _tmp65_;
		guint8* _tmp66_;
		gint _tmp66__length1;
		GByteArray* _tmp67_;
		GByteArray* _tmp68_;
		GVariant* _tmp69_ = NULL;
		GVariant* _tmp70_;
		GVariant* _tmp71_;
		GVariant* payload_variant;
		GVariantBuilder* _tmp72_;
		GVariant* _tmp73_;
		_tmp63_ = g_variant_type_new ("ay");
		_tmp64_ = _tmp63_;
		_tmp65_ = self->priv->_payload;
		_tmp66_ = _tmp65_->data;
		_tmp66__length1 = (gint) _tmp65_->len;
		_tmp67_ = self->priv->_payload;
		_tmp68_ = _g_byte_array_ref0 (_tmp67_);
		_tmp69_ = g_variant_new_from_data (_tmp64_, _tmp66_, _tmp66__length1, FALSE, g_byte_array_unref, _tmp68_);
		_tmp70_ = g_variant_ref_sink (_tmp69_);
		_tmp71_ = _tmp70_;
		_g_variant_type_free0 (_tmp64_);
		payload_variant = _tmp71_;
		_tmp72_ = vb;
		_tmp73_ = payload_variant;
		g_variant_builder_add_value (_tmp72_, _tmp73_);
		_g_variant_unref0 (payload_variant);
	} else {
		GVariantBuilder* _tmp74_;
		GVariantType* _tmp75_;
		GVariantType* _tmp76_;
		GVariantBuilder* _tmp77_;
		_tmp74_ = vb;
		_tmp75_ = g_variant_type_new ("ay");
		_tmp76_ = _tmp75_;
		g_variant_builder_open (_tmp74_, _tmp76_);
		_g_variant_type_free0 (_tmp76_);
		_tmp77_ = vb;
		g_variant_builder_close (_tmp77_);
	}
	_tmp78_ = vb;
	_tmp79_ = g_variant_builder_end (_tmp78_);
	_tmp80_ = g_variant_ref_sink (_tmp79_);
	_tmp81_ = g_variant_get_normal_form (_tmp80_);
	_tmp82_ = _tmp81_;
	_g_variant_unref0 (_tmp80_);
	event_variant = _tmp82_;
	_tmp83_ = zeitgeist_event_optimize_variant_allocation (self, event_variant);
	ret = _tmp83_;
	result = ret;
	_g_variant_unref0 (event_variant);
	_g_free0 (_tmp7_);
	_g_variant_builder_unref0 (vb);
	return result;
}


static GVariant* zeitgeist_event_optimize_variant_allocation (ZeitgeistEvent* self, GVariant* event_variant) {
	GVariant* result = NULL;
	GVariant* _tmp0_;
	gsize _tmp1_ = 0UL;
	guchar* _tmp2_ = NULL;
	guchar* data;
	gint data_length1;
	gint _data_size_;
	GVariant* _tmp3_;
	guchar* _tmp4_;
	gint _tmp4__length1;
	guchar* _tmp5_;
	gint _tmp5__length1;
	guchar* data_copy;
	gint data_copy_length1;
	gint _data_copy_size_;
	GVariantType* _tmp6_;
	GVariantType* _tmp7_;
	guchar* _tmp8_;
	gint _tmp8__length1;
	GVariant* _tmp9_ = NULL;
	GVariant* _tmp10_;
	GVariant* _tmp11_;
	GVariant* ret;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (event_variant != NULL, NULL);
	_tmp0_ = event_variant;
	_tmp1_ = g_variant_get_size (_tmp0_);
	_tmp2_ = g_new0 (guchar, _tmp1_);
	data = _tmp2_;
	data_length1 = _tmp1_;
	_data_size_ = data_length1;
	_tmp3_ = event_variant;
	_tmp4_ = data;
	_tmp4__length1 = data_length1;
	g_variant_store (_tmp3_, _tmp4_);
	_tmp5_ = data;
	_tmp5__length1 = data_length1;
	data_copy = _tmp5_;
	data_copy_length1 = _tmp5__length1;
	_data_copy_size_ = data_copy_length1;
	_tmp6_ = g_variant_type_new ("(" ZEITGEIST_UTILS_SIG_EVENT ")");
	_tmp7_ = _tmp6_;
	_tmp8_ = data;
	_tmp8__length1 = data_length1;
	data = NULL;
	_tmp9_ = g_variant_new_from_data (_tmp7_, data_copy, data_copy_length1, TRUE, g_free, _tmp8_);
	_tmp10_ = g_variant_ref_sink (_tmp9_);
	_tmp11_ = _tmp10_;
	_g_variant_type_free0 (_tmp7_);
	ret = _tmp11_;
	result = ret;
	data = (g_free (data), NULL);
	return result;
}


void zeitgeist_event_debug_print (ZeitgeistEvent* self) {
	FILE* _tmp0_;
	guint32 _tmp1_;
	gint64 _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	GPtrArray* _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	g_return_if_fail (self != NULL);
	_tmp0_ = stdout;
	_tmp1_ = self->priv->_id;
	_tmp2_ = self->priv->_timestamp;
	_tmp3_ = zeitgeist_event_get_actor (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = zeitgeist_event_get_interpretation (self);
	_tmp6_ = _tmp5_;
	_tmp7_ = zeitgeist_event_get_manifestation (self);
	_tmp8_ = _tmp7_;
	_tmp9_ = self->priv->_origin;
	_tmp10_ = self->priv->_subjects;
	_tmp11_ = g_ptr_array_get_length (_tmp10_);
	_tmp12_ = _tmp11_;
	fprintf (_tmp0_, "id: %d\t" "timestamp: %" G_GINT64_FORMAT "\n" "actor: %s\n" "interpretation: %s\n" "manifestation: %s\n" "origin: %s\n" "num subjects: %d\n", _tmp1_, _tmp2_, _tmp4_, _tmp6_, _tmp8_, _tmp9_, _tmp12_);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp13_;
			_tmp13_ = TRUE;
			while (TRUE) {
				gboolean _tmp14_;
				gint _tmp16_;
				GPtrArray* _tmp17_;
				gint _tmp18_;
				gint _tmp19_;
				GPtrArray* _tmp20_;
				gint _tmp21_;
				gconstpointer _tmp22_ = NULL;
				ZeitgeistSubject* _tmp23_;
				ZeitgeistSubject* s;
				FILE* _tmp24_;
				gint _tmp25_;
				ZeitgeistSubject* _tmp26_;
				const gchar* _tmp27_;
				const gchar* _tmp28_;
				ZeitgeistSubject* _tmp29_;
				const gchar* _tmp30_;
				const gchar* _tmp31_;
				ZeitgeistSubject* _tmp32_;
				const gchar* _tmp33_;
				const gchar* _tmp34_;
				ZeitgeistSubject* _tmp35_;
				const gchar* _tmp36_;
				const gchar* _tmp37_;
				ZeitgeistSubject* _tmp38_;
				const gchar* _tmp39_;
				const gchar* _tmp40_;
				ZeitgeistSubject* _tmp41_;
				const gchar* _tmp42_;
				const gchar* _tmp43_;
				ZeitgeistSubject* _tmp44_;
				const gchar* _tmp45_;
				const gchar* _tmp46_;
				ZeitgeistSubject* _tmp47_;
				const gchar* _tmp48_;
				const gchar* _tmp49_;
				_tmp14_ = _tmp13_;
				if (!_tmp14_) {
					gint _tmp15_;
					_tmp15_ = i;
					i = _tmp15_ + 1;
				}
				_tmp13_ = FALSE;
				_tmp16_ = i;
				_tmp17_ = self->priv->_subjects;
				_tmp18_ = g_ptr_array_get_length (_tmp17_);
				_tmp19_ = _tmp18_;
				if (!(_tmp16_ < _tmp19_)) {
					break;
				}
				_tmp20_ = self->priv->_subjects;
				_tmp21_ = i;
				_tmp22_ = g_ptr_array_index (_tmp20_, (guint) _tmp21_);
				_tmp23_ = _g_object_ref0 ((ZeitgeistSubject*) _tmp22_);
				s = _tmp23_;
				_tmp24_ = stdout;
				_tmp25_ = i;
				_tmp26_ = s;
				_tmp27_ = zeitgeist_subject_get_uri (_tmp26_);
				_tmp28_ = _tmp27_;
				_tmp29_ = s;
				_tmp30_ = zeitgeist_subject_get_interpretation (_tmp29_);
				_tmp31_ = _tmp30_;
				_tmp32_ = s;
				_tmp33_ = zeitgeist_subject_get_manifestation (_tmp32_);
				_tmp34_ = _tmp33_;
				_tmp35_ = s;
				_tmp36_ = zeitgeist_subject_get_mimetype (_tmp35_);
				_tmp37_ = _tmp36_;
				_tmp38_ = s;
				_tmp39_ = zeitgeist_subject_get_origin (_tmp38_);
				_tmp40_ = _tmp39_;
				_tmp41_ = s;
				_tmp42_ = zeitgeist_subject_get_text (_tmp41_);
				_tmp43_ = _tmp42_;
				_tmp44_ = s;
				_tmp45_ = zeitgeist_subject_get_current_uri (_tmp44_);
				_tmp46_ = _tmp45_;
				_tmp47_ = s;
				_tmp48_ = zeitgeist_subject_get_storage (_tmp47_);
				_tmp49_ = _tmp48_;
				fprintf (_tmp24_, "  Subject #%d:\n" "    uri: %s\n" "    interpretation: %s\n" "    manifestation: %s\n" "    mimetype: %s\n" "    origin: %s\n" "    text: %s\n" "    current_uri: %s\n" "    storage: %s\n", _tmp25_, _tmp28_, _tmp31_, _tmp34_, _tmp37_, _tmp40_, _tmp43_, _tmp46_, _tmp49_);
				_g_object_unref0 (s);
			}
		}
	}
}


gboolean zeitgeist_event_matches_template (ZeitgeistEvent* self, ZeitgeistEvent* template_event) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	ZeitgeistEvent* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gboolean _tmp5_ = FALSE;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	ZeitgeistEvent* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	gboolean _tmp11_ = FALSE;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	ZeitgeistEvent* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	gboolean _tmp17_ = FALSE;
	const gchar* _tmp18_;
	ZeitgeistEvent* _tmp19_;
	const gchar* _tmp20_;
	gboolean _tmp21_ = FALSE;
	ZeitgeistEvent* _tmp22_;
	GPtrArray* _tmp23_;
	gint _tmp24_;
	gint _tmp25_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (template_event != NULL, FALSE);
	_tmp0_ = zeitgeist_event_get_interpretation (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = template_event;
	_tmp3_ = zeitgeist_event_get_interpretation (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = zeitgeist_check_field_match (_tmp1_, _tmp4_, TRUE, FALSE);
	if (!_tmp5_) {
		result = FALSE;
		return result;
	}
	_tmp6_ = zeitgeist_event_get_manifestation (self);
	_tmp7_ = _tmp6_;
	_tmp8_ = template_event;
	_tmp9_ = zeitgeist_event_get_manifestation (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = zeitgeist_check_field_match (_tmp7_, _tmp10_, TRUE, FALSE);
	if (!_tmp11_) {
		result = FALSE;
		return result;
	}
	_tmp12_ = zeitgeist_event_get_actor (self);
	_tmp13_ = _tmp12_;
	_tmp14_ = template_event;
	_tmp15_ = zeitgeist_event_get_actor (_tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = zeitgeist_check_field_match (_tmp13_, _tmp16_, FALSE, TRUE);
	if (!_tmp17_) {
		result = FALSE;
		return result;
	}
	_tmp18_ = self->priv->_origin;
	_tmp19_ = template_event;
	_tmp20_ = _tmp19_->priv->_origin;
	_tmp21_ = zeitgeist_check_field_match (_tmp18_, _tmp20_, FALSE, TRUE);
	if (!_tmp21_) {
		result = FALSE;
		return result;
	}
	_tmp22_ = template_event;
	_tmp23_ = _tmp22_->priv->_subjects;
	_tmp24_ = g_ptr_array_get_length (_tmp23_);
	_tmp25_ = _tmp24_;
	if (_tmp25_ == 0) {
		result = TRUE;
		return result;
	}
	{
		gint i;
		i = 0;
		{
			gboolean _tmp26_;
			_tmp26_ = TRUE;
			while (TRUE) {
				gboolean _tmp27_;
				gint _tmp29_;
				GPtrArray* _tmp30_;
				gint _tmp31_;
				gint _tmp32_;
				_tmp27_ = _tmp26_;
				if (!_tmp27_) {
					gint _tmp28_;
					_tmp28_ = i;
					i = _tmp28_ + 1;
				}
				_tmp26_ = FALSE;
				_tmp29_ = i;
				_tmp30_ = self->priv->_subjects;
				_tmp31_ = g_ptr_array_get_length (_tmp30_);
				_tmp32_ = _tmp31_;
				if (!(_tmp29_ < _tmp32_)) {
					break;
				}
				{
					gint j;
					j = 0;
					{
						gboolean _tmp33_;
						_tmp33_ = TRUE;
						while (TRUE) {
							gboolean _tmp34_;
							gint _tmp36_;
							ZeitgeistEvent* _tmp37_;
							GPtrArray* _tmp38_;
							gint _tmp39_;
							gint _tmp40_;
							GPtrArray* _tmp41_;
							gint _tmp42_;
							gconstpointer _tmp43_ = NULL;
							ZeitgeistEvent* _tmp44_;
							GPtrArray* _tmp45_;
							gint _tmp46_;
							gconstpointer _tmp47_ = NULL;
							gboolean _tmp48_ = FALSE;
							_tmp34_ = _tmp33_;
							if (!_tmp34_) {
								gint _tmp35_;
								_tmp35_ = j;
								j = _tmp35_ + 1;
							}
							_tmp33_ = FALSE;
							_tmp36_ = j;
							_tmp37_ = template_event;
							_tmp38_ = _tmp37_->priv->_subjects;
							_tmp39_ = g_ptr_array_get_length (_tmp38_);
							_tmp40_ = _tmp39_;
							if (!(_tmp36_ < _tmp40_)) {
								break;
							}
							_tmp41_ = self->priv->_subjects;
							_tmp42_ = i;
							_tmp43_ = g_ptr_array_index (_tmp41_, (guint) _tmp42_);
							_tmp44_ = template_event;
							_tmp45_ = _tmp44_->priv->_subjects;
							_tmp46_ = j;
							_tmp47_ = g_ptr_array_index (_tmp45_, (guint) _tmp46_);
							_tmp48_ = zeitgeist_subject_matches_template ((ZeitgeistSubject*) _tmp43_, (ZeitgeistSubject*) _tmp47_);
							if (_tmp48_) {
								result = TRUE;
								return result;
							}
						}
					}
				}
			}
		}
	}
	result = FALSE;
	return result;
}


ZeitgeistEvent* zeitgeist_event_construct (GType object_type) {
	ZeitgeistEvent * self = NULL;
	self = (ZeitgeistEvent*) g_object_new (object_type, NULL);
	return self;
}


ZeitgeistEvent* zeitgeist_event_new (void) {
	return zeitgeist_event_construct (ZEITGEIST_TYPE_EVENT);
}


guint32 zeitgeist_event_get_id (ZeitgeistEvent* self) {
	guint32 result;
	guint32 _tmp0_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->_id;
	result = _tmp0_;
	return result;
}


void zeitgeist_event_set_id (ZeitgeistEvent* self, guint32 value) {
	guint32 _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_id = _tmp0_;
	g_object_notify ((GObject *) self, "id");
}


gint64 zeitgeist_event_get_timestamp (ZeitgeistEvent* self) {
	gint64 result;
	gint64 _tmp0_;
	g_return_val_if_fail (self != NULL, 0LL);
	_tmp0_ = self->priv->_timestamp;
	result = _tmp0_;
	return result;
}


void zeitgeist_event_set_timestamp (ZeitgeistEvent* self, gint64 value) {
	gint64 _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_timestamp = _tmp0_;
	g_object_notify ((GObject *) self, "timestamp");
}


const gchar* zeitgeist_event_get_origin (ZeitgeistEvent* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_origin;
	result = _tmp0_;
	return result;
}


void zeitgeist_event_set_origin (ZeitgeistEvent* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_origin);
	self->priv->_origin = _tmp1_;
	g_object_notify ((GObject *) self, "origin");
}


const gchar* zeitgeist_event_get_actor (ZeitgeistEvent* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_actor;
	result = _tmp0_;
	return result;
}


void zeitgeist_event_set_actor (ZeitgeistEvent* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_;
	const gchar* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp1_ = value;
	if (_tmp1_ != NULL) {
		GStringChunk* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_ = NULL;
		_tmp2_ = zeitgeist_event_url_store;
		_tmp3_ = value;
		_tmp4_ = g_string_chunk_insert_const (_tmp2_, _tmp3_);
		_tmp0_ = _tmp4_;
	} else {
		_tmp0_ = NULL;
	}
	_tmp5_ = _tmp0_;
	self->priv->_actor = _tmp5_;
	g_object_notify ((GObject *) self, "actor");
}


const gchar* zeitgeist_event_get_interpretation (ZeitgeistEvent* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_interpretation;
	result = _tmp0_;
	return result;
}


void zeitgeist_event_set_interpretation (ZeitgeistEvent* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_;
	const gchar* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp1_ = value;
	if (_tmp1_ != NULL) {
		GStringChunk* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_ = NULL;
		_tmp2_ = zeitgeist_event_url_store;
		_tmp3_ = value;
		_tmp4_ = g_string_chunk_insert_const (_tmp2_, _tmp3_);
		_tmp0_ = _tmp4_;
	} else {
		_tmp0_ = NULL;
	}
	_tmp5_ = _tmp0_;
	self->priv->_interpretation = _tmp5_;
	g_object_notify ((GObject *) self, "interpretation");
}


const gchar* zeitgeist_event_get_manifestation (ZeitgeistEvent* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_manifestation;
	result = _tmp0_;
	return result;
}


void zeitgeist_event_set_manifestation (ZeitgeistEvent* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_;
	const gchar* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp1_ = value;
	if (_tmp1_ != NULL) {
		GStringChunk* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_ = NULL;
		_tmp2_ = zeitgeist_event_url_store;
		_tmp3_ = value;
		_tmp4_ = g_string_chunk_insert_const (_tmp2_, _tmp3_);
		_tmp0_ = _tmp4_;
	} else {
		_tmp0_ = NULL;
	}
	_tmp5_ = _tmp0_;
	self->priv->_manifestation = _tmp5_;
	g_object_notify ((GObject *) self, "manifestation");
}


GPtrArray* zeitgeist_event_get_subjects (ZeitgeistEvent* self) {
	GPtrArray* result;
	GPtrArray* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_subjects;
	result = _tmp0_;
	return result;
}


static gpointer _g_ptr_array_ref0 (gpointer self) {
	return self ? g_ptr_array_ref (self) : NULL;
}


void zeitgeist_event_set_subjects (ZeitgeistEvent* self, GPtrArray* value) {
	GPtrArray* _tmp0_;
	GPtrArray* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_ptr_array_ref0 (_tmp0_);
	_g_ptr_array_unref0 (self->priv->_subjects);
	self->priv->_subjects = _tmp1_;
	g_object_notify ((GObject *) self, "subjects");
}


GByteArray* zeitgeist_event_get_payload (ZeitgeistEvent* self) {
	GByteArray* result;
	GByteArray* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_payload;
	result = _tmp0_;
	return result;
}


void zeitgeist_event_set_payload (ZeitgeistEvent* self, GByteArray* value) {
	GByteArray* _tmp0_;
	GByteArray* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_byte_array_ref0 (_tmp0_);
	_g_byte_array_unref0 (self->priv->_payload);
	self->priv->_payload = _tmp1_;
	g_object_notify ((GObject *) self, "payload");
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static GObject * zeitgeist_event_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	ZeitgeistEvent * self;
	GPtrArray* _tmp0_;
	GPtrArray* _tmp1_;
	parent_class = G_OBJECT_CLASS (zeitgeist_event_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = ZEITGEIST_EVENT (obj);
	_tmp0_ = g_ptr_array_new_with_free_func (_g_object_unref0_);
	_tmp1_ = _tmp0_;
	zeitgeist_event_set_subjects (self, _tmp1_);
	_g_ptr_array_unref0 (_tmp1_);
	return obj;
}


static void zeitgeist_event_class_init (ZeitgeistEventClass * klass) {
	GStringChunk* _tmp0_;
	zeitgeist_event_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ZeitgeistEventPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_zeitgeist_event_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_zeitgeist_event_set_property;
	G_OBJECT_CLASS (klass)->constructor = zeitgeist_event_constructor;
	G_OBJECT_CLASS (klass)->finalize = zeitgeist_event_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZEITGEIST_EVENT_ID, g_param_spec_uint ("id", "id", "id", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZEITGEIST_EVENT_TIMESTAMP, g_param_spec_int64 ("timestamp", "timestamp", "timestamp", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZEITGEIST_EVENT_ORIGIN, g_param_spec_string ("origin", "origin", "origin", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZEITGEIST_EVENT_ACTOR, g_param_spec_string ("actor", "actor", "actor", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZEITGEIST_EVENT_INTERPRETATION, g_param_spec_string ("interpretation", "interpretation", "interpretation", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZEITGEIST_EVENT_MANIFESTATION, g_param_spec_string ("manifestation", "manifestation", "manifestation", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZEITGEIST_EVENT_SUBJECTS, g_param_spec_boxed ("subjects", "subjects", "subjects", G_TYPE_PTR_ARRAY, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZEITGEIST_EVENT_PAYLOAD, g_param_spec_boxed ("payload", "payload", "payload", G_TYPE_BYTE_ARRAY, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	_tmp0_ = g_string_chunk_new ((gsize) 4096);
	_g_string_chunk_free0 (zeitgeist_event_url_store);
	zeitgeist_event_url_store = _tmp0_;
}


static void zeitgeist_event_instance_init (ZeitgeistEvent * self) {
	self->priv = ZEITGEIST_EVENT_GET_PRIVATE (self);
}


static void zeitgeist_event_finalize (GObject* obj) {
	ZeitgeistEvent * self;
	self = ZEITGEIST_EVENT (obj);
	_g_free0 (self->priv->_origin);
	_g_ptr_array_unref0 (self->priv->_subjects);
	_g_byte_array_unref0 (self->priv->_payload);
	G_OBJECT_CLASS (zeitgeist_event_parent_class)->finalize (obj);
}


GType zeitgeist_event_get_type (void) {
	static volatile gsize zeitgeist_event_type_id__volatile = 0;
	if (g_once_init_enter (&zeitgeist_event_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ZeitgeistEventClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) zeitgeist_event_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ZeitgeistEvent), 0, (GInstanceInitFunc) zeitgeist_event_instance_init, NULL };
		GType zeitgeist_event_type_id;
		zeitgeist_event_type_id = g_type_register_static (G_TYPE_OBJECT, "ZeitgeistEvent", &g_define_type_info, 0);
		g_once_init_leave (&zeitgeist_event_type_id__volatile, zeitgeist_event_type_id);
	}
	return zeitgeist_event_type_id__volatile;
}


static void _vala_zeitgeist_event_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ZeitgeistEvent * self;
	self = ZEITGEIST_EVENT (object);
	switch (property_id) {
		case ZEITGEIST_EVENT_ID:
		g_value_set_uint (value, zeitgeist_event_get_id (self));
		break;
		case ZEITGEIST_EVENT_TIMESTAMP:
		g_value_set_int64 (value, zeitgeist_event_get_timestamp (self));
		break;
		case ZEITGEIST_EVENT_ORIGIN:
		g_value_set_string (value, zeitgeist_event_get_origin (self));
		break;
		case ZEITGEIST_EVENT_ACTOR:
		g_value_set_string (value, zeitgeist_event_get_actor (self));
		break;
		case ZEITGEIST_EVENT_INTERPRETATION:
		g_value_set_string (value, zeitgeist_event_get_interpretation (self));
		break;
		case ZEITGEIST_EVENT_MANIFESTATION:
		g_value_set_string (value, zeitgeist_event_get_manifestation (self));
		break;
		case ZEITGEIST_EVENT_SUBJECTS:
		g_value_set_boxed (value, zeitgeist_event_get_subjects (self));
		break;
		case ZEITGEIST_EVENT_PAYLOAD:
		g_value_set_boxed (value, zeitgeist_event_get_payload (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_zeitgeist_event_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ZeitgeistEvent * self;
	self = ZEITGEIST_EVENT (object);
	switch (property_id) {
		case ZEITGEIST_EVENT_ID:
		zeitgeist_event_set_id (self, g_value_get_uint (value));
		break;
		case ZEITGEIST_EVENT_TIMESTAMP:
		zeitgeist_event_set_timestamp (self, g_value_get_int64 (value));
		break;
		case ZEITGEIST_EVENT_ORIGIN:
		zeitgeist_event_set_origin (self, g_value_get_string (value));
		break;
		case ZEITGEIST_EVENT_ACTOR:
		zeitgeist_event_set_actor (self, g_value_get_string (value));
		break;
		case ZEITGEIST_EVENT_INTERPRETATION:
		zeitgeist_event_set_interpretation (self, g_value_get_string (value));
		break;
		case ZEITGEIST_EVENT_MANIFESTATION:
		zeitgeist_event_set_manifestation (self, g_value_get_string (value));
		break;
		case ZEITGEIST_EVENT_SUBJECTS:
		zeitgeist_event_set_subjects (self, g_value_get_boxed (value));
		break;
		case ZEITGEIST_EVENT_PAYLOAD:
		zeitgeist_event_set_payload (self, g_value_get_boxed (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


GPtrArray* zeitgeist_events_from_variant (GVariant* vevents, GError** error) {
	GPtrArray* result = NULL;
	GPtrArray* _tmp0_;
	GPtrArray* events;
	GVariant* _tmp1_;
	const gchar* _tmp2_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (vevents != NULL, NULL);
	_tmp0_ = g_ptr_array_new_with_free_func (_g_object_unref0_);
	events = _tmp0_;
	_tmp1_ = vevents;
	_tmp2_ = g_variant_get_type_string (_tmp1_);
	g_assert (g_strcmp0 (_tmp2_, "a(" ZEITGEIST_UTILS_SIG_EVENT ")") == 0);
	{
		GVariant* _tmp3_;
		GVariantIter* _tmp4_ = NULL;
		GVariantIter* _event_it;
		GVariant* event = NULL;
		_tmp3_ = vevents;
		_tmp4_ = g_variant_iter_new (_tmp3_);
		_event_it = _tmp4_;
		while (TRUE) {
			GVariantIter* _tmp5_;
			GVariant* _tmp6_ = NULL;
			GVariant* _tmp7_;
			GVariant* _tmp8_;
			ZeitgeistEvent* _tmp9_;
			ZeitgeistEvent* _tmp10_;
			GPtrArray* _tmp11_;
			_tmp5_ = _event_it;
			_tmp6_ = g_variant_iter_next_value (_tmp5_);
			_g_variant_unref0 (event);
			event = _tmp6_;
			_tmp7_ = event;
			if (!(_tmp7_ != NULL)) {
				break;
			}
			_tmp8_ = event;
			_tmp9_ = zeitgeist_event_new_from_variant (_tmp8_, &_inner_error_);
			_tmp10_ = _tmp9_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_variant_unref0 (event);
					_g_variant_iter_free0 (_event_it);
					_g_ptr_array_unref0 (events);
					return NULL;
				} else {
					_g_variant_unref0 (event);
					_g_variant_iter_free0 (_event_it);
					_g_ptr_array_unref0 (events);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			_tmp11_ = events;
			g_ptr_array_add (_tmp11_, _tmp10_);
		}
		_g_variant_unref0 (event);
		_g_variant_iter_free0 (_event_it);
	}
	result = events;
	return result;
}


GVariant* zeitgeist_events_to_variant (GPtrArray* events) {
	GVariant* result = NULL;
	GVariantType* _tmp0_;
	GVariantType* _tmp1_;
	GVariantBuilder* _tmp2_;
	GVariantBuilder* _tmp3_;
	GVariantBuilder* vb;
	GVariantBuilder* _tmp23_;
	GVariant* _tmp24_ = NULL;
	GVariant* _tmp25_;
	g_return_val_if_fail (events != NULL, NULL);
	_tmp0_ = g_variant_type_new ("a(" ZEITGEIST_UTILS_SIG_EVENT ")");
	_tmp1_ = _tmp0_;
	_tmp2_ = g_variant_builder_new (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_variant_type_free0 (_tmp1_);
	vb = _tmp3_;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp4_;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp5_;
				gint _tmp7_;
				GPtrArray* _tmp8_;
				gint _tmp9_;
				gint _tmp10_;
				GPtrArray* _tmp11_;
				gint _tmp12_;
				gconstpointer _tmp13_ = NULL;
				_tmp5_ = _tmp4_;
				if (!_tmp5_) {
					gint _tmp6_;
					_tmp6_ = i;
					i = _tmp6_ + 1;
				}
				_tmp4_ = FALSE;
				_tmp7_ = i;
				_tmp8_ = events;
				_tmp9_ = g_ptr_array_get_length (_tmp8_);
				_tmp10_ = _tmp9_;
				if (!(_tmp7_ < _tmp10_)) {
					break;
				}
				_tmp11_ = events;
				_tmp12_ = i;
				_tmp13_ = g_ptr_array_index (_tmp11_, (guint) _tmp12_);
				if (((ZeitgeistEvent*) _tmp13_) != NULL) {
					GVariantBuilder* _tmp14_;
					GPtrArray* _tmp15_;
					gint _tmp16_;
					gconstpointer _tmp17_ = NULL;
					GVariant* _tmp18_ = NULL;
					GVariant* _tmp19_;
					_tmp14_ = vb;
					_tmp15_ = events;
					_tmp16_ = i;
					_tmp17_ = g_ptr_array_index (_tmp15_, (guint) _tmp16_);
					_tmp18_ = zeitgeist_event_to_variant ((ZeitgeistEvent*) _tmp17_);
					_tmp19_ = _tmp18_;
					g_variant_builder_add_value (_tmp14_, _tmp19_);
					_g_variant_unref0 (_tmp19_);
				} else {
					GVariantBuilder* _tmp20_;
					GVariant* _tmp21_ = NULL;
					GVariant* _tmp22_;
					_tmp20_ = vb;
					_tmp21_ = zeitgeist_events_get_null_event_variant ();
					_tmp22_ = _tmp21_;
					g_variant_builder_add_value (_tmp20_, _tmp22_);
					_g_variant_unref0 (_tmp22_);
				}
			}
		}
	}
	_tmp23_ = vb;
	_tmp24_ = g_variant_builder_end (_tmp23_);
	_tmp25_ = g_variant_ref_sink (_tmp24_);
	result = _tmp25_;
	_g_variant_builder_unref0 (vb);
	return result;
}


GVariant* zeitgeist_events_to_variant_with_limit (GPtrArray* events, gsize limit, GError** error) {
	GVariant* result = NULL;
	GVariantType* _tmp0_;
	GVariantType* _tmp1_;
	GVariantBuilder* _tmp2_;
	GVariantBuilder* _tmp3_;
	GVariantBuilder* vb;
	gsize variant_size;
	GVariantBuilder* _tmp35_;
	GVariant* _tmp36_ = NULL;
	GVariant* _tmp37_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (events != NULL, NULL);
	_tmp0_ = g_variant_type_new ("a(" ZEITGEIST_UTILS_SIG_EVENT ")");
	_tmp1_ = _tmp0_;
	_tmp2_ = g_variant_builder_new (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_variant_type_free0 (_tmp1_);
	vb = _tmp3_;
	variant_size = (gsize) 0;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp4_;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp5_;
				gint _tmp7_;
				GPtrArray* _tmp8_;
				gint _tmp9_;
				gint _tmp10_;
				GVariant* event_variant = NULL;
				GPtrArray* _tmp11_;
				gint _tmp12_;
				gconstpointer _tmp13_ = NULL;
				gsize _tmp19_;
				GVariant* _tmp20_;
				gsize _tmp21_ = 0UL;
				gsize _tmp22_;
				gsize _tmp23_;
				GVariantBuilder* _tmp33_;
				GVariant* _tmp34_;
				_tmp5_ = _tmp4_;
				if (!_tmp5_) {
					gint _tmp6_;
					_tmp6_ = i;
					i = _tmp6_ + 1;
				}
				_tmp4_ = FALSE;
				_tmp7_ = i;
				_tmp8_ = events;
				_tmp9_ = g_ptr_array_get_length (_tmp8_);
				_tmp10_ = _tmp9_;
				if (!(_tmp7_ < _tmp10_)) {
					break;
				}
				_tmp11_ = events;
				_tmp12_ = i;
				_tmp13_ = g_ptr_array_index (_tmp11_, (guint) _tmp12_);
				if (((ZeitgeistEvent*) _tmp13_) != NULL) {
					GPtrArray* _tmp14_;
					gint _tmp15_;
					gconstpointer _tmp16_ = NULL;
					GVariant* _tmp17_ = NULL;
					_tmp14_ = events;
					_tmp15_ = i;
					_tmp16_ = g_ptr_array_index (_tmp14_, (guint) _tmp15_);
					_tmp17_ = zeitgeist_event_to_variant ((ZeitgeistEvent*) _tmp16_);
					_g_variant_unref0 (event_variant);
					event_variant = _tmp17_;
				} else {
					GVariant* _tmp18_ = NULL;
					_tmp18_ = zeitgeist_events_get_null_event_variant ();
					_g_variant_unref0 (event_variant);
					event_variant = _tmp18_;
				}
				_tmp19_ = variant_size;
				_tmp20_ = event_variant;
				_tmp21_ = g_variant_get_size (_tmp20_);
				variant_size = _tmp19_ + _tmp21_;
				_tmp22_ = variant_size;
				_tmp23_ = limit;
				if (_tmp22_ > _tmp23_) {
					gsize _tmp24_;
					gint _tmp25_;
					gsize avg_event_size;
					gsize _tmp26_;
					gsize _tmp27_;
					gsize _tmp28_;
					gchar* _tmp29_ = NULL;
					gchar* error_message;
					const gchar* _tmp30_;
					const gchar* _tmp31_;
					GError* _tmp32_;
					_tmp24_ = variant_size;
					_tmp25_ = i;
					avg_event_size = _tmp24_ / (_tmp25_ + 1);
					_tmp26_ = limit;
					_tmp27_ = limit;
					_tmp28_ = avg_event_size;
					_tmp29_ = g_strdup_printf ("Query exceeded size limit of % " G_GSIZE_FORMAT "MiB (roughly ~%d events).", (_tmp26_ / 1024) / 1024, _tmp27_ / _tmp28_);
					error_message = _tmp29_;
					_tmp30_ = error_message;
					g_warning ("datamodel.vala:654: %s", _tmp30_);
					_tmp31_ = error_message;
					_tmp32_ = g_error_new_literal (ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_TOO_MANY_RESULTS, _tmp31_);
					_inner_error_ = _tmp32_;
					if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
						g_propagate_error (error, _inner_error_);
						_g_free0 (error_message);
						_g_variant_unref0 (event_variant);
						_g_variant_builder_unref0 (vb);
						return NULL;
					} else {
						_g_free0 (error_message);
						_g_variant_unref0 (event_variant);
						_g_variant_builder_unref0 (vb);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
					_g_free0 (error_message);
				}
				_tmp33_ = vb;
				_tmp34_ = event_variant;
				g_variant_builder_add_value (_tmp33_, _tmp34_);
				_g_variant_unref0 (event_variant);
			}
		}
	}
	_tmp35_ = vb;
	_tmp36_ = g_variant_builder_end (_tmp35_);
	_tmp37_ = g_variant_ref_sink (_tmp36_);
	result = _tmp37_;
	_g_variant_builder_unref0 (vb);
	return result;
}


GVariant* zeitgeist_events_get_null_event_variant (void) {
	GVariant* result = NULL;
	GVariantType* _tmp0_;
	GVariantType* _tmp1_;
	GVariantBuilder* _tmp2_;
	GVariantBuilder* _tmp3_;
	GVariantBuilder* vb;
	GVariantType* _tmp4_;
	GVariantType* _tmp5_;
	GVariantType* _tmp6_;
	GVariantType* _tmp7_;
	GVariantType* _tmp8_;
	GVariantType* _tmp9_;
	GVariant* _tmp10_ = NULL;
	GVariant* _tmp11_;
	_tmp0_ = g_variant_type_new ("(" ZEITGEIST_UTILS_SIG_EVENT ")");
	_tmp1_ = _tmp0_;
	_tmp2_ = g_variant_builder_new (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_variant_type_free0 (_tmp1_);
	vb = _tmp3_;
	_tmp4_ = g_variant_type_new ("as");
	_tmp5_ = _tmp4_;
	g_variant_builder_open (vb, _tmp5_);
	_g_variant_type_free0 (_tmp5_);
	g_variant_builder_close (vb);
	_tmp6_ = g_variant_type_new ("aas");
	_tmp7_ = _tmp6_;
	g_variant_builder_open (vb, _tmp7_);
	_g_variant_type_free0 (_tmp7_);
	g_variant_builder_close (vb);
	_tmp8_ = g_variant_type_new ("ay");
	_tmp9_ = _tmp8_;
	g_variant_builder_open (vb, _tmp9_);
	_g_variant_type_free0 (_tmp9_);
	g_variant_builder_close (vb);
	_tmp10_ = g_variant_builder_end (vb);
	_tmp11_ = g_variant_ref_sink (_tmp10_);
	result = _tmp11_;
	_g_variant_builder_unref0 (vb);
	return result;
}


ZeitgeistSubject* zeitgeist_subject_construct_full (GType object_type, const gchar* uri, const gchar* interpretation, const gchar* manifestation, const gchar* mimetype, const gchar* origin, const gchar* text, const gchar* storage, const gchar* current_uri) {
	ZeitgeistSubject * self = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	self = (ZeitgeistSubject*) g_object_new (object_type, NULL);
	_tmp0_ = interpretation;
	zeitgeist_subject_set_interpretation (self, _tmp0_);
	_tmp1_ = manifestation;
	zeitgeist_subject_set_manifestation (self, _tmp1_);
	_tmp2_ = mimetype;
	zeitgeist_subject_set_mimetype (self, _tmp2_);
	_tmp3_ = origin;
	zeitgeist_subject_set_origin (self, _tmp3_);
	_tmp4_ = text;
	zeitgeist_subject_set_text (self, _tmp4_);
	_tmp5_ = storage;
	zeitgeist_subject_set_storage (self, _tmp5_);
	_tmp6_ = current_uri;
	zeitgeist_subject_set_current_uri (self, _tmp6_);
	return self;
}


ZeitgeistSubject* zeitgeist_subject_new_full (const gchar* uri, const gchar* interpretation, const gchar* manifestation, const gchar* mimetype, const gchar* origin, const gchar* text, const gchar* storage, const gchar* current_uri) {
	return zeitgeist_subject_construct_full (ZEITGEIST_TYPE_SUBJECT, uri, interpretation, manifestation, mimetype, origin, text, storage, current_uri);
}


ZeitgeistSubject* zeitgeist_subject_construct_from_variant (GType object_type, GVariant* subject_variant, GError** error) {
	ZeitgeistSubject * self = NULL;
	GVariant* _tmp0_;
	GVariantIter* _tmp1_ = NULL;
	GVariantIter* iter;
	gsize _tmp2_ = 0UL;
	gsize subject_props;
	GVariant* _tmp3_ = NULL;
	GVariant* _tmp4_;
	const gchar* _tmp5_ = NULL;
	GVariant* _tmp6_ = NULL;
	GVariant* _tmp7_;
	const gchar* _tmp8_ = NULL;
	GVariant* _tmp9_ = NULL;
	GVariant* _tmp10_;
	const gchar* _tmp11_ = NULL;
	GVariant* _tmp12_ = NULL;
	GVariant* _tmp13_;
	const gchar* _tmp14_ = NULL;
	GVariant* _tmp15_ = NULL;
	GVariant* _tmp16_;
	const gchar* _tmp17_ = NULL;
	GVariant* _tmp18_ = NULL;
	GVariant* _tmp19_;
	const gchar* _tmp20_ = NULL;
	GVariant* _tmp21_ = NULL;
	GVariant* _tmp22_;
	const gchar* _tmp23_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (subject_variant != NULL, NULL);
	self = (ZeitgeistSubject*) g_object_new (object_type, NULL);
	_tmp0_ = subject_variant;
	_tmp1_ = g_variant_iter_new (_tmp0_);
	iter = _tmp1_;
	_tmp2_ = g_variant_iter_n_children (iter);
	subject_props = _tmp2_;
	zeitgeist_assert_sig (subject_props >= ((gsize) 7), "Missing subject information", &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_variant_iter_free0 (iter);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_variant_iter_free0 (iter);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp3_ = g_variant_iter_next_value (iter);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_variant_get_string (_tmp4_, NULL);
	zeitgeist_subject_set_uri (self, _tmp5_);
	_g_variant_unref0 (_tmp4_);
	_tmp6_ = g_variant_iter_next_value (iter);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_variant_get_string (_tmp7_, NULL);
	zeitgeist_subject_set_interpretation (self, _tmp8_);
	_g_variant_unref0 (_tmp7_);
	_tmp9_ = g_variant_iter_next_value (iter);
	_tmp10_ = _tmp9_;
	_tmp11_ = g_variant_get_string (_tmp10_, NULL);
	zeitgeist_subject_set_manifestation (self, _tmp11_);
	_g_variant_unref0 (_tmp10_);
	_tmp12_ = g_variant_iter_next_value (iter);
	_tmp13_ = _tmp12_;
	_tmp14_ = g_variant_get_string (_tmp13_, NULL);
	zeitgeist_subject_set_origin (self, _tmp14_);
	_g_variant_unref0 (_tmp13_);
	_tmp15_ = g_variant_iter_next_value (iter);
	_tmp16_ = _tmp15_;
	_tmp17_ = g_variant_get_string (_tmp16_, NULL);
	zeitgeist_subject_set_mimetype (self, _tmp17_);
	_g_variant_unref0 (_tmp16_);
	_tmp18_ = g_variant_iter_next_value (iter);
	_tmp19_ = _tmp18_;
	_tmp20_ = g_variant_get_string (_tmp19_, NULL);
	zeitgeist_subject_set_text (self, _tmp20_);
	_g_variant_unref0 (_tmp19_);
	_tmp21_ = g_variant_iter_next_value (iter);
	_tmp22_ = _tmp21_;
	_tmp23_ = g_variant_get_string (_tmp22_, NULL);
	zeitgeist_subject_set_storage (self, _tmp23_);
	_g_variant_unref0 (_tmp22_);
	if (subject_props >= ((gsize) 8)) {
		GVariant* _tmp24_ = NULL;
		GVariant* _tmp25_;
		const gchar* _tmp26_ = NULL;
		_tmp24_ = g_variant_iter_next_value (iter);
		_tmp25_ = _tmp24_;
		_tmp26_ = g_variant_get_string (_tmp25_, NULL);
		zeitgeist_subject_set_current_uri (self, _tmp26_);
		_g_variant_unref0 (_tmp25_);
	} else {
		zeitgeist_subject_set_current_uri (self, "");
	}
	_g_variant_iter_free0 (iter);
	return self;
}


ZeitgeistSubject* zeitgeist_subject_new_from_variant (GVariant* subject_variant, GError** error) {
	return zeitgeist_subject_construct_from_variant (ZEITGEIST_TYPE_SUBJECT, subject_variant, error);
}


GVariant* zeitgeist_subject_to_variant (ZeitgeistSubject* self) {
	GVariant* result = NULL;
	gchar* ptr_arr[8] = {0};
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	const gchar* _tmp12_ = NULL;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	const gchar* _tmp17_;
	gchar* _tmp18_;
	const gchar* _tmp19_ = NULL;
	const gchar* _tmp20_;
	const gchar* _tmp22_;
	gchar* _tmp23_;
	const gchar* _tmp24_ = NULL;
	const gchar* _tmp25_;
	const gchar* _tmp26_;
	const gchar* _tmp29_;
	gchar* _tmp30_;
	const gchar* _tmp31_ = NULL;
	const gchar* _tmp32_;
	const gchar* _tmp34_;
	gchar* _tmp35_;
	const gchar* _tmp36_ = NULL;
	const gchar* _tmp37_;
	const gchar* _tmp39_;
	gchar* _tmp40_;
	const gchar* _tmp41_ = NULL;
	const gchar* _tmp42_;
	const gchar* _tmp44_;
	gchar* _tmp45_;
	GVariant* _tmp46_;
	GVariant* _tmp47_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = self->priv->_uri;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_;
		_tmp2_ = self->priv->_uri;
		_tmp0_ = _tmp2_;
	} else {
		_tmp0_ = "";
	}
	_tmp3_ = _tmp0_;
	ptr_arr[0] = _tmp3_;
	_tmp4_ = ptr_arr[0];
	_tmp6_ = zeitgeist_subject_get_interpretation (self);
	_tmp7_ = _tmp6_;
	if (_tmp7_ != NULL) {
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		_tmp8_ = zeitgeist_subject_get_interpretation (self);
		_tmp9_ = _tmp8_;
		_tmp5_ = _tmp9_;
	} else {
		_tmp5_ = "";
	}
	_tmp10_ = _tmp5_;
	ptr_arr[1] = _tmp10_;
	_tmp11_ = ptr_arr[1];
	_tmp13_ = zeitgeist_subject_get_manifestation (self);
	_tmp14_ = _tmp13_;
	if (_tmp14_ != NULL) {
		const gchar* _tmp15_;
		const gchar* _tmp16_;
		_tmp15_ = zeitgeist_subject_get_manifestation (self);
		_tmp16_ = _tmp15_;
		_tmp12_ = _tmp16_;
	} else {
		_tmp12_ = "";
	}
	_tmp17_ = _tmp12_;
	ptr_arr[2] = _tmp17_;
	_tmp18_ = ptr_arr[2];
	_tmp20_ = self->priv->_origin;
	if (_tmp20_ != NULL) {
		const gchar* _tmp21_;
		_tmp21_ = self->priv->_origin;
		_tmp19_ = _tmp21_;
	} else {
		_tmp19_ = "";
	}
	_tmp22_ = _tmp19_;
	ptr_arr[3] = _tmp22_;
	_tmp23_ = ptr_arr[3];
	_tmp25_ = zeitgeist_subject_get_mimetype (self);
	_tmp26_ = _tmp25_;
	if (_tmp26_ != NULL) {
		const gchar* _tmp27_;
		const gchar* _tmp28_;
		_tmp27_ = zeitgeist_subject_get_mimetype (self);
		_tmp28_ = _tmp27_;
		_tmp24_ = _tmp28_;
	} else {
		_tmp24_ = "";
	}
	_tmp29_ = _tmp24_;
	ptr_arr[4] = _tmp29_;
	_tmp30_ = ptr_arr[4];
	_tmp32_ = self->priv->_text;
	if (_tmp32_ != NULL) {
		const gchar* _tmp33_;
		_tmp33_ = self->priv->_text;
		_tmp31_ = _tmp33_;
	} else {
		_tmp31_ = "";
	}
	_tmp34_ = _tmp31_;
	ptr_arr[5] = _tmp34_;
	_tmp35_ = ptr_arr[5];
	_tmp37_ = self->priv->_storage;
	if (_tmp37_ != NULL) {
		const gchar* _tmp38_;
		_tmp38_ = self->priv->_storage;
		_tmp36_ = _tmp38_;
	} else {
		_tmp36_ = "";
	}
	_tmp39_ = _tmp36_;
	ptr_arr[6] = _tmp39_;
	_tmp40_ = ptr_arr[6];
	_tmp42_ = self->priv->_current_uri;
	if (_tmp42_ != NULL) {
		const gchar* _tmp43_;
		_tmp43_ = self->priv->_current_uri;
		_tmp41_ = _tmp43_;
	} else {
		_tmp41_ = "";
	}
	_tmp44_ = _tmp41_;
	ptr_arr[7] = _tmp44_;
	_tmp45_ = ptr_arr[7];
	_tmp46_ = g_variant_new_strv ((gchar**) ptr_arr, 8);
	_tmp47_ = g_variant_ref_sink (_tmp46_);
	result = _tmp47_;
	return result;
}


gboolean zeitgeist_subject_matches_template (ZeitgeistSubject* self, ZeitgeistSubject* template_subject) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	ZeitgeistSubject* _tmp1_;
	const gchar* _tmp2_;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp4_;
	ZeitgeistSubject* _tmp5_;
	const gchar* _tmp6_;
	gboolean _tmp7_ = FALSE;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	ZeitgeistSubject* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	gboolean _tmp13_ = FALSE;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	ZeitgeistSubject* _tmp16_;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	gboolean _tmp19_ = FALSE;
	const gchar* _tmp20_;
	ZeitgeistSubject* _tmp21_;
	const gchar* _tmp22_;
	gboolean _tmp23_ = FALSE;
	const gchar* _tmp24_;
	const gchar* _tmp25_;
	ZeitgeistSubject* _tmp26_;
	const gchar* _tmp27_;
	const gchar* _tmp28_;
	gboolean _tmp29_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (template_subject != NULL, FALSE);
	_tmp0_ = self->priv->_uri;
	_tmp1_ = template_subject;
	_tmp2_ = _tmp1_->priv->_uri;
	_tmp3_ = zeitgeist_check_field_match (_tmp0_, _tmp2_, FALSE, TRUE);
	if (!_tmp3_) {
		result = FALSE;
		return result;
	}
	_tmp4_ = self->priv->_current_uri;
	_tmp5_ = template_subject;
	_tmp6_ = _tmp5_->priv->_current_uri;
	_tmp7_ = zeitgeist_check_field_match (_tmp4_, _tmp6_, FALSE, TRUE);
	if (!_tmp7_) {
		result = FALSE;
		return result;
	}
	_tmp8_ = zeitgeist_subject_get_interpretation (self);
	_tmp9_ = _tmp8_;
	_tmp10_ = template_subject;
	_tmp11_ = zeitgeist_subject_get_interpretation (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = zeitgeist_check_field_match (_tmp9_, _tmp12_, TRUE, FALSE);
	if (!_tmp13_) {
		result = FALSE;
		return result;
	}
	_tmp14_ = zeitgeist_subject_get_manifestation (self);
	_tmp15_ = _tmp14_;
	_tmp16_ = template_subject;
	_tmp17_ = zeitgeist_subject_get_manifestation (_tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = zeitgeist_check_field_match (_tmp15_, _tmp18_, TRUE, FALSE);
	if (!_tmp19_) {
		result = FALSE;
		return result;
	}
	_tmp20_ = self->priv->_origin;
	_tmp21_ = template_subject;
	_tmp22_ = _tmp21_->priv->_origin;
	_tmp23_ = zeitgeist_check_field_match (_tmp20_, _tmp22_, FALSE, TRUE);
	if (!_tmp23_) {
		result = FALSE;
		return result;
	}
	_tmp24_ = zeitgeist_subject_get_mimetype (self);
	_tmp25_ = _tmp24_;
	_tmp26_ = template_subject;
	_tmp27_ = zeitgeist_subject_get_mimetype (_tmp26_);
	_tmp28_ = _tmp27_;
	_tmp29_ = zeitgeist_check_field_match (_tmp25_, _tmp28_, FALSE, TRUE);
	if (!_tmp29_) {
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}


ZeitgeistSubject* zeitgeist_subject_construct (GType object_type) {
	ZeitgeistSubject * self = NULL;
	self = (ZeitgeistSubject*) g_object_new (object_type, NULL);
	return self;
}


ZeitgeistSubject* zeitgeist_subject_new (void) {
	return zeitgeist_subject_construct (ZEITGEIST_TYPE_SUBJECT);
}


const gchar* zeitgeist_subject_get_uri (ZeitgeistSubject* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_uri;
	result = _tmp0_;
	return result;
}


void zeitgeist_subject_set_uri (ZeitgeistSubject* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_uri);
	self->priv->_uri = _tmp1_;
	g_object_notify ((GObject *) self, "uri");
}


const gchar* zeitgeist_subject_get_origin (ZeitgeistSubject* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_origin;
	result = _tmp0_;
	return result;
}


void zeitgeist_subject_set_origin (ZeitgeistSubject* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_origin);
	self->priv->_origin = _tmp1_;
	g_object_notify ((GObject *) self, "origin");
}


const gchar* zeitgeist_subject_get_text (ZeitgeistSubject* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_text;
	result = _tmp0_;
	return result;
}


void zeitgeist_subject_set_text (ZeitgeistSubject* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_text);
	self->priv->_text = _tmp1_;
	g_object_notify ((GObject *) self, "text");
}


const gchar* zeitgeist_subject_get_storage (ZeitgeistSubject* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_storage;
	result = _tmp0_;
	return result;
}


void zeitgeist_subject_set_storage (ZeitgeistSubject* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_storage);
	self->priv->_storage = _tmp1_;
	g_object_notify ((GObject *) self, "storage");
}


const gchar* zeitgeist_subject_get_current_uri (ZeitgeistSubject* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_current_uri;
	result = _tmp0_;
	return result;
}


void zeitgeist_subject_set_current_uri (ZeitgeistSubject* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_current_uri);
	self->priv->_current_uri = _tmp1_;
	g_object_notify ((GObject *) self, "current-uri");
}


const gchar* zeitgeist_subject_get_mimetype (ZeitgeistSubject* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_mimetype;
	result = _tmp0_;
	return result;
}


void zeitgeist_subject_set_mimetype (ZeitgeistSubject* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_;
	const gchar* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp1_ = value;
	if (_tmp1_ != NULL) {
		GStringChunk* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_ = NULL;
		_tmp2_ = zeitgeist_subject_url_store;
		_tmp3_ = value;
		_tmp4_ = g_string_chunk_insert_const (_tmp2_, _tmp3_);
		_tmp0_ = _tmp4_;
	} else {
		_tmp0_ = NULL;
	}
	_tmp5_ = _tmp0_;
	self->priv->_mimetype = _tmp5_;
	g_object_notify ((GObject *) self, "mimetype");
}


const gchar* zeitgeist_subject_get_interpretation (ZeitgeistSubject* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_interpretation;
	result = _tmp0_;
	return result;
}


void zeitgeist_subject_set_interpretation (ZeitgeistSubject* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_;
	const gchar* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp1_ = value;
	if (_tmp1_ != NULL) {
		GStringChunk* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_ = NULL;
		_tmp2_ = zeitgeist_subject_url_store;
		_tmp3_ = value;
		_tmp4_ = g_string_chunk_insert_const (_tmp2_, _tmp3_);
		_tmp0_ = _tmp4_;
	} else {
		_tmp0_ = NULL;
	}
	_tmp5_ = _tmp0_;
	self->priv->_interpretation = _tmp5_;
	g_object_notify ((GObject *) self, "interpretation");
}


const gchar* zeitgeist_subject_get_manifestation (ZeitgeistSubject* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_manifestation;
	result = _tmp0_;
	return result;
}


void zeitgeist_subject_set_manifestation (ZeitgeistSubject* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_;
	const gchar* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp1_ = value;
	if (_tmp1_ != NULL) {
		GStringChunk* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_ = NULL;
		_tmp2_ = zeitgeist_subject_url_store;
		_tmp3_ = value;
		_tmp4_ = g_string_chunk_insert_const (_tmp2_, _tmp3_);
		_tmp0_ = _tmp4_;
	} else {
		_tmp0_ = NULL;
	}
	_tmp5_ = _tmp0_;
	self->priv->_manifestation = _tmp5_;
	g_object_notify ((GObject *) self, "manifestation");
}


static void zeitgeist_subject_class_init (ZeitgeistSubjectClass * klass) {
	GStringChunk* _tmp0_;
	zeitgeist_subject_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ZeitgeistSubjectPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_zeitgeist_subject_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_zeitgeist_subject_set_property;
	G_OBJECT_CLASS (klass)->finalize = zeitgeist_subject_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZEITGEIST_SUBJECT_URI, g_param_spec_string ("uri", "uri", "uri", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZEITGEIST_SUBJECT_ORIGIN, g_param_spec_string ("origin", "origin", "origin", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZEITGEIST_SUBJECT_TEXT, g_param_spec_string ("text", "text", "text", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZEITGEIST_SUBJECT_STORAGE, g_param_spec_string ("storage", "storage", "storage", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZEITGEIST_SUBJECT_CURRENT_URI, g_param_spec_string ("current-uri", "current-uri", "current-uri", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZEITGEIST_SUBJECT_MIMETYPE, g_param_spec_string ("mimetype", "mimetype", "mimetype", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZEITGEIST_SUBJECT_INTERPRETATION, g_param_spec_string ("interpretation", "interpretation", "interpretation", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZEITGEIST_SUBJECT_MANIFESTATION, g_param_spec_string ("manifestation", "manifestation", "manifestation", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	_tmp0_ = g_string_chunk_new ((gsize) 4096);
	_g_string_chunk_free0 (zeitgeist_subject_url_store);
	zeitgeist_subject_url_store = _tmp0_;
}


static void zeitgeist_subject_instance_init (ZeitgeistSubject * self) {
	self->priv = ZEITGEIST_SUBJECT_GET_PRIVATE (self);
}


static void zeitgeist_subject_finalize (GObject* obj) {
	ZeitgeistSubject * self;
	self = ZEITGEIST_SUBJECT (obj);
	_g_free0 (self->priv->_uri);
	_g_free0 (self->priv->_origin);
	_g_free0 (self->priv->_text);
	_g_free0 (self->priv->_storage);
	_g_free0 (self->priv->_current_uri);
	G_OBJECT_CLASS (zeitgeist_subject_parent_class)->finalize (obj);
}


GType zeitgeist_subject_get_type (void) {
	static volatile gsize zeitgeist_subject_type_id__volatile = 0;
	if (g_once_init_enter (&zeitgeist_subject_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ZeitgeistSubjectClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) zeitgeist_subject_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ZeitgeistSubject), 0, (GInstanceInitFunc) zeitgeist_subject_instance_init, NULL };
		GType zeitgeist_subject_type_id;
		zeitgeist_subject_type_id = g_type_register_static (G_TYPE_OBJECT, "ZeitgeistSubject", &g_define_type_info, 0);
		g_once_init_leave (&zeitgeist_subject_type_id__volatile, zeitgeist_subject_type_id);
	}
	return zeitgeist_subject_type_id__volatile;
}


static void _vala_zeitgeist_subject_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ZeitgeistSubject * self;
	self = ZEITGEIST_SUBJECT (object);
	switch (property_id) {
		case ZEITGEIST_SUBJECT_URI:
		g_value_set_string (value, zeitgeist_subject_get_uri (self));
		break;
		case ZEITGEIST_SUBJECT_ORIGIN:
		g_value_set_string (value, zeitgeist_subject_get_origin (self));
		break;
		case ZEITGEIST_SUBJECT_TEXT:
		g_value_set_string (value, zeitgeist_subject_get_text (self));
		break;
		case ZEITGEIST_SUBJECT_STORAGE:
		g_value_set_string (value, zeitgeist_subject_get_storage (self));
		break;
		case ZEITGEIST_SUBJECT_CURRENT_URI:
		g_value_set_string (value, zeitgeist_subject_get_current_uri (self));
		break;
		case ZEITGEIST_SUBJECT_MIMETYPE:
		g_value_set_string (value, zeitgeist_subject_get_mimetype (self));
		break;
		case ZEITGEIST_SUBJECT_INTERPRETATION:
		g_value_set_string (value, zeitgeist_subject_get_interpretation (self));
		break;
		case ZEITGEIST_SUBJECT_MANIFESTATION:
		g_value_set_string (value, zeitgeist_subject_get_manifestation (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_zeitgeist_subject_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ZeitgeistSubject * self;
	self = ZEITGEIST_SUBJECT (object);
	switch (property_id) {
		case ZEITGEIST_SUBJECT_URI:
		zeitgeist_subject_set_uri (self, g_value_get_string (value));
		break;
		case ZEITGEIST_SUBJECT_ORIGIN:
		zeitgeist_subject_set_origin (self, g_value_get_string (value));
		break;
		case ZEITGEIST_SUBJECT_TEXT:
		zeitgeist_subject_set_text (self, g_value_get_string (value));
		break;
		case ZEITGEIST_SUBJECT_STORAGE:
		zeitgeist_subject_set_storage (self, g_value_get_string (value));
		break;
		case ZEITGEIST_SUBJECT_CURRENT_URI:
		zeitgeist_subject_set_current_uri (self, g_value_get_string (value));
		break;
		case ZEITGEIST_SUBJECT_MIMETYPE:
		zeitgeist_subject_set_mimetype (self, g_value_get_string (value));
		break;
		case ZEITGEIST_SUBJECT_INTERPRETATION:
		zeitgeist_subject_set_interpretation (self, g_value_get_string (value));
		break;
		case ZEITGEIST_SUBJECT_MANIFESTATION:
		zeitgeist_subject_set_manifestation (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



