/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Mozilla SMIL module.
 *
 * The Initial Developer of the Original Code is Brian Birtles.
 * Portions created by the Initial Developer are Copyright (C) 2005
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Brian Birtles <birtles@gmail.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either of the GNU General Public License Version 2 or later (the "GPL"),
 * or the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#include "nsSMILTimeValueSpec.h"
#include "nsSMILTimeValue.h"
#include "nsSMILTimedElement.h"
#include "nsSMILInstanceTime.h"
#include "nsSMILParserUtils.h"
#include "nsString.h"
#include "nsAutoPtr.h"

//----------------------------------------------------------------------
// Implementation

already_AddRefed<nsSMILTimeValueSpec>
NS_NewSMILTimeValueSpec(nsSMILTimedElement* aOwner,
                        PRBool aIsBegin,
                        const nsAString& aStringSpec)
{
  nsSMILTimeValueSpec* result = new nsSMILTimeValueSpec(aOwner, aIsBegin);
  NS_ENSURE_TRUE(result, nsnull);

  NS_ADDREF(result); // Need to addref as SetSpec calls getWeakReference
  nsresult rv = result->SetSpec(aStringSpec);
  if (NS_FAILED(rv)) {
    NS_RELEASE(result);
    return nsnull;
  }
  return result;
}

nsSMILTimeValueSpec::nsSMILTimeValueSpec(nsSMILTimedElement* aOwner,
                                         PRBool aIsBegin)
  : mOwner(aOwner),
    mIsBegin(aIsBegin),
    mOffset() // initalises to zero
{
}

//----------------------------------------------------------------------
// nsISupports

NS_IMPL_ISUPPORTS1(nsSMILTimeValueSpec,
                   nsISupports)

//----------------------------------------------------------------------
// nsSMILTimeValueSpec

nsresult
nsSMILTimeValueSpec::SetSpec(const nsAString& aStringSpec)
{
  // XXX Need to parse other specifiers, not just offset type
  nsSMILTimeValue clockTime;
  nsresult rv = nsSMILParserUtils::ParseClockValue(aStringSpec, &clockTime,
                              nsSMILParserUtils::kClockValueAllowSign
                              | nsSMILParserUtils::kClockValueAllowIndefinite);

  if (NS_FAILED(rv) || (!clockTime.IsResolved() && !clockTime.IsIndefinite()))
    return NS_ERROR_FAILURE;
  
  if (clockTime.IsResolved())
    mOffset = clockTime.GetMillis();
  
  if (mOwner) {
    nsSMILInstanceTime instance(clockTime, this);
    mOwner->AddInstanceTime(instance, mIsBegin);
  }

  return rv;
}
