#
#      Copyright (C) 2005-2008 Team XBMC
#      http://www.xbmc.org
#
#  This Program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2, or (at your option)
#  any later version.
#
#  This Program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with XBMC; see the file COPYING.  If not, write to
#  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
#  http://www.gnu.org/copyleft/gpl.html
#

#Display weather forecast on your xbox


########ENTER YOUR ZIP CODE###########
zipcode = '94025'         


import sys, urllib, string, urlparse, re, xbmc, xbmcgui

#will parse out text between given tag
def parsexml( line, tag ):
   result= re.search('<' + tag + '>.*' + tag + '>', line, re.DOTALL)
   try:
       if result.group(0):
           mod = string.replace(result.group(0), '<' + tag + '>','')
           mod = string.replace(mod, '</' + tag + '>', '')
           mod = string.lstrip(mod)
           return mod
   except:
       return


url = 'http://www.rssweather.com/rss.php?config=&forecast=zandh&zipcode=' + zipcode + '&alt=rss20a'
data = urllib.urlopen(url)
currentline= data.read()
itemdivide= string.split(currentline, '<item>')
place= parsexml(itemdivide[0], 'title')

i=1
items= len(itemdivide)
dayforecast=[]
forecast=[]

while i < items:
   check=parsexml(itemdivide[i], 'category')
   if check=="Current Conditions":
       time=parsexml(itemdivide[i], 'pubDate')
       ctemp=parsexml(itemdivide[i], 'description')
   if check=="Weather Forecast":
       forecast.append(parsexml(itemdivide[i],'description'))
       dayforecast.append(parsexml(itemdivide[i], 'title'))
   i=i+1
   
# now we have all the parts we need so display to the user

dialog= xbmcgui.Dialog()
dayforecast.insert(0, 'exit')
dayforecast.insert(0, 'Current Temperature: ' + ctemp)
dayforecast.insert(0, 'Information From: ' + time)
selected= dialog.select(place, dayforecast)
if selected < 3:
   print 'quitting..'
else:
   dialog.ok(dayforecast[selected],forecast[selected-3])
