# -*- Mode: Python; tab-width: 4 -*-

import http_server

class query_channel (http_server.http_channel):
	def handle_incoming_client_data (self, data):
		print 'icd:', repr (data)

	def process_query_request (self, path, path_parts):
		self.push (
			self.response (200) + \
			self.generated_content_header (path)
			)

	def process_post_variable (self, var):
		parts = string.split (var, '=')
		if len(parts) != 2:
			print "malformed POST variable, ignoring:", repr(var)
		else:
			self.post_variable_list.append (parts)
		
	# this simply accumulates the header data
	# as it comes in.

	def done_receiving_post_data (self):
		self.push_with_producer (
			form_description_producer (
				self,
				self.post_variable_list,
				'a title'
				)
			)

	def handle_special_paths (self, path, path_parts):
		if path_parts[0] == 'query':
			self.process_query_request (path, path_parts)
			return 1
		else:
			return 0
			
from mstatus import html_lines_producer

class form_description_producer (html_lines_producer):
	def __init__ (self, channel, var_list, title):
		self.channel = channel
		lines =  [
			'<h1>Form Fields</h1>',
			'<pre>'
			]
		for [k,v] in var_list:
			lines.append ('%s : %s' % (repr(k),repr(v)))
		lines.append ('</pre>')
		html_lines_producer.__init__ (self, channel, lines, 'Form Fields')
			
		
