#!/usr/local/bin/python
# -*- Mode: Python; tab-width: 4 -*-

# convert a 'mime.types' file from NCSA/Apache

import sys
import string

def convert_entry (table, line):
    if line[0] in ['#','\r','\n']:
	return
    else:
	parts = string.split (line)
	if len(parts) == 1:
	    # no file extensions
	    return
	else:
	    type = parts[0]
	    for ext in parts[1:]:
		if table.has_key (ext):
		    sys.stderr.write ('Warning: overriding %s = %s\n' % (ext, table[key]))
		table[ext] = type

if __name__ == '__main__':
    if len(sys.argv) < 2:
	print 'Usage: %s mime_type_file [...]' % sys.argv[0]
	sys.exit (0)
    else:
	table = {}
	for file in sys.argv[1:]:
	    fd = open (file, 'r')
	    while 1:
		line = fd.readline()
		if not line:
		    break
		else:
		    convert_entry (table, line)
	print '# -*- Python -*-'
	print '# Converted by %s from:' % sys.argv[0]
	for file in sys.argv[1:]:
	    print '# %s' % file
	print '#'
	print 'content_type_map = \\'
	print '  {'
	pairs = table.items()
	pairs.sort()
	for key, value in pairs:
	    print "  %10s:  '%s'," % (repr(key), value)
	print '  }'
