#
#      Copyright (C) 2005-2008 Team XBMC
#      http://www.xbmc.org
#
#  This Program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2, or (at your option)
#  any later version.
#
#  This Program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with XBMC; see the file COPYING.  If not, write to
#  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
#  http://www.gnu.org/copyleft/gpl.html
#

import xbmcgui
import os

KEY_BUTTON_BACK = 275
KEY_KEYBOARD_ESC = 61467

__title__ = "Window XML Example"

"""
    Notes)
        The xml included in the defualt skin shouldn't rely on includes and defaults
        Maybe a uniform name would be good like Script_WindowXMLExample,Script_AMT_Main.xml)
"""

"""
    xbmcgui.WindowXML()
    xbmcgui.WindowXML().onInit(self)
    xbmcgui.WindowXML().onAction(self,action)
    xbmcgui.WindowXML().onClick(self,controlID)  Replacement for onControl
    xbmcgui.WindowXML().onFocus(self,controlID)

    xbmcgui.WindowXMLDialog()
    xbmcgui.WindowXMLDialog().onInit(self)
    xbmcgui.WindowXMLDialog().onAction(self,action)
    xbmcgui.WindowXMLDialog().onClick(self,controlID)  Replacement for onControl
    xbmcgui.WindowXMLDialog().onFocus(self,controlID)
"""

scriptPath = os.getcwd().replace(';','')

class WindowXMLExample(xbmcgui.WindowXML):
    def __init__(self,strXMLname, strFallbackPath,strDefaultName,bforeFallback=0):
        self.url = "http://xboxmediacenter.com"

    def onInit(self):
        """
            This function has been implemented and works
            The Idea for this function is to be used to get inital data and populate lists
        """
        print "onInit(): Window Initalized"
        for x in range(0,10):
            self.addItem(xbmcgui.ListItem(("Hello %i" % x),("World %i" % x), "defaultVideo.png", "defaultVideoBig.png"))
            self.addItem(xbmcgui.ListItem(("Test %i"  % x),("Hey %i"   % x), "defaultVideo.png", "defaultVideoBig.png"))
        # now update the list
        self.button = self.getControl(99) # Example of getting a control based on ID
        self.button.setLabel('Add to List', 'font14', '0xFFFFFFFF', '0xFFFF3300', '0xFF000000')  # changing the control after its on screen

    def onAction(self, action):
        """"
            onAction in WindowXML works same as on a Window or WindowDialog its for keypress/controller buttons etc
            This function has been implemented and works
        """
        buttonCode =  action.getButtonCode()
        actionID   =  action.getId()
        print "onAction(): actionID=%i buttonCode=%i" % (actionID,buttonCode)
        if (buttonCode == KEY_BUTTON_BACK or buttonCode == KEY_KEYBOARD_ESC or buttonCode == 61467):
            self.close()

    def onClick(self, controlID):
        """
            onClick(self, controlID) is the replacement for onControl. It gives an interger.
            This function has been implemented and works
        """
        print "onclick(): control %i" % controlID
        if (controlID == 7):
            #xbmcgui.Dialog().ok(__title__ + ": About","Example Script coded by Donno :D","WindowXML Class coded by Donno","With help from Spiff and jmarshall :)")
            dialog = WindowXMLDialogExample("DialogOK.xml",os.path.join(scriptPath,'DefaultSkin'))
            dialog.setHeading(__title__ + ": About")
            dialog.setLines("Example Script coded by Donno :D","WindowXML Class coded by Donno","With help from Spiff and jmarshall :)")
            dialog.doModal()
            del dialog

        elif (controlID == 13):
            self.clearList()
        elif (controlID == 99):
            for x in range(0,10):
                self.addItem(xbmcgui.ListItem(("Hello %i" % x),("World %i" % x), "defaultVideo.png", "defaultVideoBig.png"))
                self.addItem(xbmcgui.ListItem(("Test %i"  % x),("Hey %i"   % x), "defaultVideo.png", "defaultVideoBig.png"))
        elif (50 <= controlID <= 59):
            print "CurrentListPosition: %i" % self.getCurrentListPosition()
            selItem = self.getListItem(self.getCurrentListPosition())
            print "Selected List Item: Label: %s  Label 2 %s" % (selItem.getLabel(),selItem.getLabel2())
            print "List Item 2: Label: %s   Label 2: %s" % (self.getListItem(2).getLabel(),self.getListItem(2).getLabel2())
            
    def onFocus(self, controlID):
        """"
            onFocus(self, int controlID)
            This function has been implemented and works
        """
        print "onFocus(): control %i" % controlID
        if (controlID == 5):
            print 'The control with id="5" just got focus'

class WindowXMLDialogExample(xbmcgui.WindowXMLDialog):
    def __init__(self,strXMLname, strFallbackPath):
        self.url = "http://xboxmediacenter.com"
        self.heading = ""
        self.line1 = ""
        self.line2 = ""
        self.line3 = ""

    def onInit(self):
        """
            This function has been implemented and works
            The Idea for this function is to be used to put the inital data 
        """
        print "onInit(): Window Initalized"
        self._setLines()

    def onAction(self, action):
        """"
            This function has been implemented and works
        """
        buttonCode =  action.getButtonCode()
        actionID   =  action.getId()
        print "onAction(): actionID=%i buttonCode=%i" % (actionID,buttonCode)
        if (buttonCode == KEY_BUTTON_BACK or buttonCode == KEY_KEYBOARD_ESC or buttonCode == 61467):
            self.close()

    def onClick(self, controlID):
        """
            onClick(self, controlID) is the replacement for onControl. It gives an interger.
            This function has been implemented and works
        """
        print "onclick(): control %i" % controlID
        if (controlID == 10):
            self.close()

    def onFocus(self, controlID):
        """"
            onFocus(self, int controlID)
            This function has been implemented and works
        """
        print "onFocus(): control %i" % controlID

    def _setLines(self):
        self.getControl(1).setLabel(self.heading)
        self.getControl(2).setLabel(self.line1)
        self.getControl(3).setLabel(self.line2)
        self.getControl(4).setLabel(self.line3)

    def setHeading(self, heading):
        self.heading = heading

    def setLines(self, line1,line2, line3):
        self.line1 = line1
        self.line2 = line2
        self.line3 = line3

if __name__ == '__main__':
    w = WindowXMLExample("Script_WindowXMLExample.xml",scriptPath,"DefaultSkin")
    w.doModal()
    del w
    
