/************************************************************************
 *
 *  BatchConverter.java
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *  Copyright: 2002-2007 by Henrik Just
 *
 *  All Rights Reserved.
 * 
 *  Version 0.5 (2007-04-10)
 *
 */
 
package writer2latex.api;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;

/** <p>This is an extended interface for a converter, which offers conversion of
 *  OpenDocument or OOo 1.x docs into a specific format.
 *  It extends the <code>Converter</code> interface with a method to perform
 *  batch conversion of a directory.</p>
 *  <p>Instances of this interface are created using the
 *  <code>ConverterFactory</code></p>
 *  <p>Note: This interface is not yet in use</p>
 */
public interface BatchConverter extends Converter {
    
    /** <p>Perform batch conversion of an entire directory</p>
     *  @param sourceDir the directory to read from
     *  @param targetDir the directory to write to
     *  @param bRecurse if set to true, subdirectories are converted as well
     *  @param bContinueOnError if set to true, the conversion will continue
     *  even if one of the conversions raise an error
     *  @param messages a <code>PrintStream</code> to write status messages
     *  about the conversion to. If this parameter is null, status messages will
     *  be supressed.
     *  @throws IOException if any of the directories does not exist or (if the
     *  parameter <code>bContinueOnError</code> is false) some I/O
     *  error occurs during the conversion.
     */
    public void BatchConvert(File sourceDir, File targetDir, boolean bRecurse,
        boolean bContinueOnError, PrintStream messages) throws IOException;

}

