/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.xhtml;

import java.util.Enumeration;
import writer2latex.office.OfficeReader;
import writer2latex.office.StyleWithProperties;
import writer2latex.util.CSVList;
import writer2latex.util.Config;
import writer2latex.xhtml.Converter;
import writer2latex.xhtml.StyleConverterHelper;
import writer2latex.xhtml.StyleInfo;

public abstract class StyleWithPropertiesConverterHelper
extends StyleConverterHelper {
    public StyleWithPropertiesConverterHelper(OfficeReader ofr, Config config, Converter converter, int nType) {
        super(ofr, config, converter, nType);
    }

    public void applyStyle(String sStyleName, StyleInfo info) {
        StyleWithProperties style = (StyleWithProperties)this.getStyles().getStyle(sStyleName);
        info.sTagName = this.getDefaultTagName(style);
        if (style != null) {
            StyleConverterHelper.applyLang(style, info);
            StyleConverterHelper.applyDirection(style, info);
            if (style.isAutomatic()) {
                this.applyStyle(style.getParentName(), info);
                if (this.bConvertHard) {
                    this.applyProperties(style, info.props, false);
                }
            } else {
                String sDisplayName = style.getDisplayName();
                if (this.styleMap.contains(sDisplayName)) {
                    info.sTagName = this.styleMap.getElement(sDisplayName);
                    if (!"(none)".equals(this.styleMap.getCss(sDisplayName))) {
                        info.sClass = this.styleMap.getCss(sDisplayName);
                    }
                } else {
                    info.sClass = this.getClassNamePrefix() + this.styleNames.getExportName(sDisplayName);
                }
            }
        }
    }

    public String getStyleDeclarations(String sIndent) {
        if (this.bConvertStyles) {
            StringBuffer buf = new StringBuffer();
            Enumeration names = this.styleNames.keys();
            while (names.hasMoreElements()) {
                String sDisplayName = (String)names.nextElement();
                StyleWithProperties style = (StyleWithProperties)this.getStyles().getStyleByDisplayName(sDisplayName);
                if (style.isAutomatic()) continue;
                CSVList props = new CSVList(";");
                this.applyProperties(style, props, true);
                buf.append(sIndent);
                buf.append(this.getDefaultTagName(null));
                buf.append(".");
                buf.append(this.getClassNamePrefix());
                buf.append(this.styleNames.getExportName(sDisplayName));
                buf.append(" {");
                buf.append(props.toString());
                buf.append("}\n");
            }
            return buf.toString();
        }
        return "";
    }

    public String getClassNamePrefix() {
        return "";
    }

    public abstract String getDefaultTagName(StyleWithProperties var1);

    public abstract void applyProperties(StyleWithProperties var1, CSVList var2, boolean var3);
}

