/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.xhtml;

import java.util.Enumeration;
import writer2latex.office.ListStyle;
import writer2latex.office.OfficeReader;
import writer2latex.office.OfficeStyleFamily;
import writer2latex.util.CSVList;
import writer2latex.util.Config;
import writer2latex.xhtml.Converter;
import writer2latex.xhtml.StyleConverterHelper;
import writer2latex.xhtml.StyleInfo;

public class ListStyleConverter
extends StyleConverterHelper {
    public ListStyleConverter(OfficeReader ofr, Config config, Converter converter, int nType) {
        super(ofr, config, converter, nType);
        this.styleMap = config.getXListStyleMap();
        this.bConvertStyles = config.xhtmlFormatting() == 4 || config.xhtmlFormatting() == 7;
        this.bConvertHard = config.xhtmlFormatting() == 4 || config.xhtmlFormatting() == 6;
    }

    public void applyStyle(int nLevel, String sStyleName, StyleInfo info) {
        ListStyle style = this.ofr.getListStyle(sStyleName);
        if (style != null) {
            if (style.isAutomatic()) {
                this.applyStyle(nLevel, style.getParentName(), info);
                if (this.bConvertHard) {
                    this.cssList(style, nLevel, info.props);
                }
            } else {
                String sDisplayName = style.getDisplayName();
                if (this.styleMap.contains(sDisplayName)) {
                    info.sTagName = this.styleMap.getElement(sDisplayName);
                    if (!"(none)".equals(this.styleMap.getCss(sDisplayName))) {
                        info.sClass = this.styleMap.getCss(sDisplayName);
                    }
                } else {
                    info.sClass = "listlevel" + Integer.toString(nLevel) + this.styleNames.getExportName(sDisplayName);
                }
            }
        }
    }

    public String getStyleDeclarations(String sIndent) {
        if (this.bConvertStyles) {
            StringBuffer buf = new StringBuffer();
            Enumeration names = this.styleNames.keys();
            while (names.hasMoreElements()) {
                String sDisplayName = (String)names.nextElement();
                ListStyle style = (ListStyle)this.getStyles().getStyleByDisplayName(sDisplayName);
                if (style.isAutomatic()) continue;
                int nLevel = 1;
                while (nLevel < 10) {
                    CSVList props = new CSVList(";");
                    this.cssList(style, nLevel, props);
                    buf.append(sIndent);
                    buf.append(".listlevel");
                    buf.append(nLevel);
                    buf.append(this.styleNames.getExportName(sDisplayName));
                    buf.append(" {");
                    buf.append(props.toString());
                    buf.append("}\n");
                    ++nLevel;
                }
            }
            return buf.toString();
        }
        return "";
    }

    public OfficeStyleFamily getStyles() {
        return this.ofr.getListStyles();
    }

    private void cssList(ListStyle style, int nLevel, CSVList props) {
        String sHref;
        props.addValue("margin-top", "0");
        props.addValue("margin-bottom", "0");
        String sLevelType = style.getLevelType(nLevel);
        if ("text:list-level-style-number".equals(sLevelType)) {
            String sNumFormat = style.getLevelProperty(nLevel, "style:num-format");
            if ("1".equals(sNumFormat)) {
                props.addValue("list-style-type", "decimal");
            } else if ("i".equals(sNumFormat)) {
                props.addValue("list-style-type", "lower-roman");
            } else if ("I".equals(sNumFormat)) {
                props.addValue("list-style-type", "upper-roman");
            } else if ("a".equals(sNumFormat)) {
                props.addValue("list-style-type", "lower-alpha");
            } else if ("A".equals(sNumFormat)) {
                props.addValue("list-style-type", "upper-alpha");
            }
        } else if ("text:list-level-style-bullet".equals(sLevelType)) {
            switch (nLevel % 3) {
                case 1: {
                    props.addValue("list-style-type", "disc");
                    break;
                }
                case 2: {
                    props.addValue("list-style-type", "bullet");
                    break;
                }
                case 0: {
                    props.addValue("list-style-type", "square");
                }
            }
        } else if ("text:list-level-style-image".equals(sLevelType) && (sHref = style.getLevelProperty(nLevel, "xlink:href")) != null) {
            props.addValue("list-style-image", "url('" + sHref + "')");
        }
        props.addValue("clear:left");
    }
}

