/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.office;

import java.util.Hashtable;
import java.util.Set;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import writer2latex.util.Misc;

public class TocReader {
    Element tocSource = null;
    Element indexBody = null;
    String sName = null;
    String sStyleName = null;
    int nOutlineLevel = 10;
    boolean bUseOutlineLevel = true;
    boolean bUseIndexSourceStyles = false;
    boolean bUseIndexMarks = true;
    boolean bIsByChapter = false;
    Element indexTitleTemplate = null;
    Element[] tocEntryTemplate = new Element[11];
    Hashtable indexSourceStyles = new Hashtable();

    public TocReader(Element onode) {
        this.sName = Misc.getAttribute(onode, "text:name");
        this.sStyleName = Misc.getAttribute(onode, "text:style-name");
        Element tocSource = Misc.getChildByTagName(onode, "text:table-of-content-source");
        Element indexBody = Misc.getChildByTagName(onode, "text:index-body");
        if (tocSource != null) {
            this.nOutlineLevel = Misc.getPosInteger(tocSource.getAttribute("text:outline-level"), 1);
            this.bUseOutlineLevel = !"false".equals(tocSource.getAttribute("text:use-outline-level"));
            this.bUseIndexSourceStyles = "true".equals(tocSource.getAttribute("text:use-index-source-styles"));
            this.bUseIndexMarks = !"false".equals(tocSource.getAttribute("text:use-index-marks"));
            this.bIsByChapter = "chapter".equals(tocSource.getAttribute("text:index-scope"));
            Node child = tocSource.getFirstChild();
            while (child != null) {
                if (child.getNodeType() == 1) {
                    int nLevel;
                    Element elm = (Element)child;
                    if ("text:index-title-template".equals(elm.getTagName())) {
                        this.indexTitleTemplate = elm;
                    }
                    if ("text:table-of-content-entry-template".equals(elm.getTagName()) && 1 <= (nLevel = Misc.getPosInteger(elm.getAttribute("text:outline-level"), 1)) && nLevel <= 10) {
                        this.tocEntryTemplate[nLevel] = elm;
                    }
                    if ("text:index-source-styles".equals(elm.getTagName()) && 1 <= (nLevel = Misc.getPosInteger(elm.getAttribute("text:outline-level"), 1)) && nLevel <= 10) {
                        Node child1 = elm.getFirstChild();
                        while (child1 != null) {
                            String sIndexSourceStyle;
                            Element elm1;
                            if (child1.getNodeType() == 1 && "text:index-source-style".equals((elm1 = (Element)child1).getTagName()) && (sIndexSourceStyle = Misc.getAttribute(elm1, "text:style-name")) != null) {
                                this.indexSourceStyles.put(sIndexSourceStyle, new Integer(nLevel));
                            }
                            child1 = child1.getNextSibling();
                        }
                    }
                }
                child = child.getNextSibling();
            }
        }
    }

    public String getName() {
        return this.sName;
    }

    public String getStyleName() {
        return this.sStyleName;
    }

    public int getOutlineLevel() {
        return this.nOutlineLevel;
    }

    public boolean useOutlineLevel() {
        return this.bUseOutlineLevel;
    }

    public boolean useIndexSourceStyles() {
        return this.bUseIndexSourceStyles;
    }

    public boolean useIndexMarks() {
        return this.bUseIndexMarks;
    }

    public boolean isByChapter() {
        return this.bIsByChapter;
    }

    public Element getIndexTitleTemplate() {
        return this.indexTitleTemplate;
    }

    public Element getTocEntryTemplate(int nLevel) {
        if (1 <= nLevel && nLevel <= 10) {
            return this.tocEntryTemplate[nLevel];
        }
        return null;
    }

    public Set getIndexSourceStyles() {
        return this.indexSourceStyles.keySet();
    }

    public int getIndexSourceStyleLevel(String sStyleName) {
        if (this.indexSourceStyles.containsKey(sStyleName)) {
            return (Integer)this.indexSourceStyles.get(sStyleName);
        }
        return -1;
    }

    public Element getIndexBody() {
        return this.indexBody;
    }
}

