// Clears the view generated source selection
function webdeveloper_clearViewGeneratedSourceSelection(selection, generatedSourceWindow)
{
    selection.removeAllRanges();
    generatedSourceWindow.getBrowser().contentWindow.getSelection().removeAllRanges();
}

// Displays the view frame source menu
function webdeveloper_displayViewFrameSourceMenu(menu)
{
    var documentList   = webdeveloper_getDocuments(webdeveloper_getContentWindow());
    var documentLength = documentList.length;
    var menuItem       = null;
    var pageDocument   = null;

    webdeveloper_removeGeneratedMenuItems(menu);

    // Loop through the documents
    for(var i = 0; i < documentLength; i++)
    {
        menuItem              = document.createElement("menuitem");
        pageDocument          = documentList[i];
        menuItem.pageDocument = pageDocument;

        menuItem.setAttribute("class", "webdeveloper-generated-menu");
        menuItem.setAttribute("label", pageDocument.documentURI);
        menuItem.setAttribute("oncommand", "webdeveloper_viewSource(this.pageDocument)");
        menu.appendChild(menuItem);
    }
}

// Displays the view source with menu
function webdeveloper_displayViewSourceWithMenu(menu, suffix)
{
    var description             = null;
    var descriptionPreference   = null;
    var key                     = null;
    var menuItem                = document.createElement("menuitem");
    var path                    = null;
    var viewSourceWithCount     = webdeveloper_getIntegerPreference("webdeveloper.view.source.with.count", true);
    var viewSourceWithSeparator = menu.getElementsByAttribute("id", "webdeveloper-view-source-separator3-" + suffix)[0];

    webdeveloper_removeGeneratedMenuItems(menu);

    // If there are no view source with applications
    if(viewSourceWithCount == 0)
    {
        viewSourceWithSeparator.setAttribute("hidden", true);
    }
    else
    {
        viewSourceWithSeparator.setAttribute("hidden", false);

        // Loop through the view source with options
        for(var i = 1; i <= viewSourceWithCount; i++)
        {
            description = "webdeveloper.view.source.with." + i + ".description";
            key         = "webdeveloper.view.source.with." + i + ".key";
            path        = "webdeveloper.view.source.with." + i + ".path";

            // If the description and path are set
            if(webdeveloper_isPreferenceSet(description) && webdeveloper_isPreferenceSet(path))
            {
                descriptionPreference = webdeveloper_getStringPreference(description, true);

                // If the description is not blank
                if(descriptionPreference != "")
                {
                    menuItem = document.createElement("menuitem");
                    menuItem.setAttribute("class", "webdeveloper-generated-menu");
                    menuItem.setAttribute("label", descriptionPreference);
                    menuItem.setAttribute("oncommand", "webdeveloper_loadApplicationWithSource('" + webdeveloper_getStringPreference(path, true).replace(/\\/gi, "\\\\") + "')");

                    // If the key preference is set
                    if(webdeveloper_isPreferenceSet(key))
                    {
                        menuItem.setAttribute("key", key);
                    }

                    menu.insertBefore(menuItem, viewSourceWithSeparator);
                }
            }
        }
    }
}

// Loads the given application with the source of the current page
function webdeveloper_loadApplicationWithSource(application)
{
    // If the application is set
    if(application)
    {
        application = new WebDeveloperApplication(application);

        application.launchWithSource(getBrowser().currentURI);
    }
}

// Toggles the view frame source menu
function webdeveloper_toggleViewFrameSourceMenu(suffix)
{
    var disabled   = true;
    var frameCount = webdeveloper_getContentWindow().frames.length;
    var menu       = document.getElementById("webdeveloper-view-frame-source-" + suffix);

    // If there are frames
    if(frameCount > 0)
    {
        disabled = false;
    }

    webdeveloper_configureElement(menu, "disabled", disabled);
}

// Adjusts the view source menu
function webdeveloper_updateViewSourceMenu(menu, suffix)
{
    webdeveloper_toggleViewFrameSourceMenu(suffix);
    webdeveloper_displayViewSourceWithMenu(menu, suffix);
}

// View the generated source
function webdeveloper_viewGeneratedSource(chromeLocation)
{
    var currentDocument       = webdeveloper_getContentDocument();
    var currentWindow         = webdeveloper_getContentWindow();
    var generatedSourceWindow = null;
    var selection             = currentWindow.getSelection();

    selection.selectAllChildren(currentDocument.documentElement);

    generatedSourceWindow = window.openDialog(chromeLocation, "_blank", "chrome,dialog=no,resizable,scrollbars", getBrowser().currentURI.spec, "charset=" + currentDocument.characterSet, currentWindow.getSelection(), "selection");

    window.setTimeout(webdeveloper_clearViewGeneratedSourceSelection, 1500, selection, generatedSourceWindow);
}

// View source
function webdeveloper_viewSource(frameDocument)
{
    // If the view source in tab preference is set to true
    if(webdeveloper_getBooleanPreference("webdeveloper.view.source.tab", true))
    {
        var newTab = getBrowser().addTab("view-source:" + frameDocument.documentURI);

        // If the open tabs in background preference is not set to true
        if(!webdeveloper_getBooleanPreference("webdeveloper.open.tabs.background", true))
        {
            getBrowser().selectedTab = newTab;
        }
    }
    else
    {
        BrowserViewSourceOfDocument(frameDocument);
    }
}
