var webdeveloper_optionsDataBoolean        = new Array();
var webdeveloper_optionsDataInteger        = new Array();
var webdeveloper_optionsDataString         = new Array();
var webdeveloper_resizeDescription         = null;
var webdeveloper_resizeHeight              = null;
var webdeveloper_resizeViewport            = false;
var webdeveloper_resizeWidth               = null;
var webdeveloper_toolBookmarklet           = null;
var webdeveloper_toolDescription           = null;
var webdeveloper_toolKey                   = null;
var webdeveloper_toolPath                  = null;
var webdeveloper_toolURL                   = null;
var webdeveloper_viewSourceWithDescription = null;
var webdeveloper_viewSourceWithKey         = null;
var webdeveloper_viewSourceWithPath        = null;

// Adds a resize option
function webdeveloper_addResize()
{
    window.openDialog("chrome://webdeveloper/content/options/dialogs/resize.xul", "webdeveloper-resize-dialog", "centerscreen,chrome,modal", "add");

    // If the description, height and width are set
    if(webdeveloper_resizeDescription && webdeveloper_resizeHeight && webdeveloper_resizeWidth)
    {
        var pageDocument = document.getElementById("webdeveloper-options-iframe").contentDocument;
        var listCell     = pageDocument.createElement("listcell");
        var listItem     = pageDocument.createElement("listitem");
        var resizeBox    = pageDocument.getElementById("webdeveloper-listbox");
        var stringBundle = document.getElementById("webdeveloper-string-bundle");

        listCell.setAttribute("label", webdeveloper_resizeDescription);
        listItem.appendChild(listCell);

        listCell = pageDocument.createElement("listcell");
        listCell.setAttribute("label", webdeveloper_resizeWidth);
        listItem.appendChild(listCell);

        listCell = pageDocument.createElement("listcell");
        listCell.setAttribute("label", webdeveloper_resizeHeight);
        listItem.appendChild(listCell);

        listCell = pageDocument.createElement("listcell");

        // If resizing the viewport
        if(webdeveloper_resizeViewport)
        {
            listCell.setAttribute("label", stringBundle.getString("webdeveloper_yes"));
        }
        else
        {
            listCell.setAttribute("label", stringBundle.getString("webdeveloper_no"));
        }

        listItem.appendChild(listCell);

        resizeBox.selectItem(resizeBox.appendChild(listItem));
        resizeBox.ensureElementIsVisible(resizeBox.selectedItem);
    }
}

// Adds a tool
function webdeveloper_addTool()
{
    window.openDialog("chrome://webdeveloper/content/options/dialogs/tool.xul", "webdeveloper-tool-dialog", "centerscreen,chrome,modal", "add");

    // If the description and the bookmarklet, path or URL are set
    if(webdeveloper_toolDescription && (webdeveloper_toolBookmarklet || webdeveloper_toolPath || webdeveloper_toolURL))
    {
        var pageDocument = document.getElementById("webdeveloper-options-iframe").contentDocument;
        var listCell     = pageDocument.createElement("listcell");
        var listItem     = pageDocument.createElement("listitem");
        var stringBundle = document.getElementById("webdeveloper-string-bundle");
        var toolBox      = pageDocument.getElementById("webdeveloper-listbox");

        listCell.setAttribute("label", webdeveloper_toolDescription);

        // If the bookmarklet is set
        if(webdeveloper_toolBookmarklet)
        {
            listCell.setAttribute("type", stringBundle.getString("webdeveloper_bookmarklet"));
        }
        else if(webdeveloper_toolPath)
        {
            listCell.setAttribute("type", stringBundle.getString("webdeveloper_application"));
        }
        else
        {
            listCell.setAttribute("type", stringBundle.getString("webdeveloper_url"));
        }

        listItem.appendChild(listCell);

        listCell = pageDocument.createElement("listcell");

        // If the bookmarklet is set
        if(webdeveloper_toolBookmarklet)
        {
            listCell.setAttribute("label", webdeveloper_toolBookmarklet);
        }
        else if(webdeveloper_toolPath)
        {
            listCell.setAttribute("label", webdeveloper_toolPath);
        }
        else
        {
            listCell.setAttribute("label", webdeveloper_toolURL);
        }

        listCell.setAttribute("crop", "end");
        listItem.appendChild(listCell);

        listCell = pageDocument.createElement("listcell");

        // If the key is set
        if(webdeveloper_toolKey)
        {
            listCell.setAttribute("label", webdeveloper_toolKey);
        }

        listItem.appendChild(listCell);

        toolBox.selectItem(toolBox.appendChild(listItem));
        toolBox.ensureElementIsVisible(toolBox.selectedItem);
    }
}

// Adds a view source with option
function webdeveloper_addViewSourceWith()
{
    window.openDialog("chrome://webdeveloper/content/options/dialogs/view_source_with.xul", "webdeveloper-view-source-with-dialog", "centerscreen,chrome,modal", "add");

    // If the description and path are set
    if(webdeveloper_viewSourceWithDescription && webdeveloper_viewSourceWithPath)
    {
        var pageDocument      = document.getElementById("webdeveloper-options-iframe").contentDocument;
        var listCell          = pageDocument.createElement("listcell");
        var listItem          = pageDocument.createElement("listitem");
        var stringBundle      = document.getElementById("webdeveloper-string-bundle");
        var viewSourceWithBox = pageDocument.getElementById("webdeveloper-listbox");

        listCell.setAttribute("label", webdeveloper_viewSourceWithDescription);
        listItem.appendChild(listCell);

        listCell = pageDocument.createElement("listcell");
        listCell.setAttribute("label", webdeveloper_viewSourceWithPath);
        listCell.setAttribute("crop", "end");
        listItem.appendChild(listCell);

        listCell = pageDocument.createElement("listcell");

        // If the key is set
        if(webdeveloper_viewSourceWithKey)
        {
            listCell.setAttribute("label", webdeveloper_viewSourceWithKey);
        }

        listItem.appendChild(listCell);

        viewSourceWithBox.selectItem(viewSourceWithBox.appendChild(listItem));
        viewSourceWithBox.ensureElementIsVisible(viewSourceWithBox.selectedItem);
    }
}

// Handles changing the options page
function webdeveloper_changePage(pageList)
{
    webdeveloper_storeOptions();
    webdeveloper_setIntegerPreference("webdeveloper.options.last.page", pageList.selectedIndex);

    document.getElementById("webdeveloper-options-iframe").setAttribute("src", pageList.selectedItem.value);
}

// Deletes a resize option
function webdeveloper_deleteResize()
{
    var pageDocument = document.getElementById("webdeveloper-options-iframe").contentDocument;
    var resizeBox    = pageDocument.getElementById("webdeveloper-listbox");
    var selectedItem = resizeBox.selectedItem;

    // If an item is selected and the deletion is confirmed
    if(selectedItem && webdeveloper_deleteConfirmation(document.getElementById("webdeveloper-string-bundle").getString("webdeveloper_resizeDeleteConfirmation")))
    {
        resizeBox.removeChild(selectedItem);
    }
}

// Deletes a tool
function webdeveloper_deleteTool()
{
    var pageDocument = document.getElementById("webdeveloper-options-iframe").contentDocument;
    var toolBox      = pageDocument.getElementById("webdeveloper-listbox");
    var selectedItem = toolBox.selectedItem;

    // If an item is selected and it is a separator or the deletion is confirmed
    if(selectedItem && (selectedItem.childNodes[0].tagName == "separator" || webdeveloper_deleteConfirmation(document.getElementById("webdeveloper-string-bundle").getString("webdeveloper_toolDeleteConfirmation"))))
    {
        toolBox.removeChild(selectedItem);
    }
}

// Deletes a tool
function webdeveloper_deleteViewSourceWith()
{
    var pageDocument      = document.getElementById("webdeveloper-options-iframe").contentDocument;
    var viewSourceWithBox = pageDocument.getElementById("webdeveloper-listbox");
    var selectedItem      = viewSourceWithBox.selectedItem;

    // If an item is selected and the deletion is confirmed
    if(selectedItem && webdeveloper_deleteConfirmation(document.getElementById("webdeveloper-string-bundle").getString("webdeveloper_viewSourceWithDeleteConfirmation")))
    {
        viewSourceWithBox.removeChild(selectedItem);
    }
}

// Edits a resize option
function webdeveloper_editResize()
{
    var pageDocument = document.getElementById("webdeveloper-options-iframe").contentDocument;
    var resizeBox    = pageDocument.getElementById("webdeveloper-listbox");
    var selectedItem = resizeBox.selectedItem;

    // If an option is selected
    if(selectedItem)
    {
        var stringBundle  = document.getElementById("webdeveloper-string-bundle");
        var viewportValue = false;

        // If the viewport value is set to yes
        if(selectedItem.childNodes[3].getAttribute("label") == stringBundle.getString("webdeveloper_yes"))
        {
            viewportValue = true;
        }

        window.openDialog("chrome://webdeveloper/content/options/dialogs/resize.xul", "webdeveloper-resize-dialog", "centerscreen,chrome,modal", "edit", selectedItem.childNodes[0].getAttribute("label"), selectedItem.childNodes[1].getAttribute("label"), selectedItem.childNodes[2].getAttribute("label"), viewportValue);

        // If the description, height and width are set
        if(webdeveloper_resizeDescription && webdeveloper_resizeHeight && webdeveloper_resizeWidth)
        {
            var listCell = pageDocument.createElement("listcell");

            webdeveloper_removeAllChildElements(selectedItem);

            listCell.setAttribute("label", webdeveloper_resizeDescription);
            selectedItem.appendChild(listCell);

            listCell = pageDocument.createElement("listcell");
            listCell.setAttribute("label", webdeveloper_resizeWidth);
            selectedItem.appendChild(listCell);

            listCell = pageDocument.createElement("listcell");
            listCell.setAttribute("label", webdeveloper_resizeHeight);
            selectedItem.appendChild(listCell);

            listCell = pageDocument.createElement("listcell");

            // If resizing the viewport
            if(webdeveloper_resizeViewport)
            {
                listCell.setAttribute("label", stringBundle.getString("webdeveloper_yes"));
            }
            else
            {
                listCell.setAttribute("label", stringBundle.getString("webdeveloper_no"));
            }

            selectedItem.appendChild(listCell);
            resizeBox.ensureElementIsVisible(selectedItem);
        }
    }
}

// Edits a tool
function webdeveloper_editTool()
{
    var pageDocument = document.getElementById("webdeveloper-options-iframe").contentDocument;
    var toolBox      = pageDocument.getElementById("webdeveloper-listbox");
    var selectedItem = toolBox.selectedItem;

    // If an option is selected
    if(selectedItem)
    {
        var selectedCell = selectedItem.childNodes[0];

        // If this is not a separator
        if(selectedCell.tagName != "separator")
        {
            window.openDialog("chrome://webdeveloper/content/options/dialogs/tool.xul", "webdeveloper-tool-dialog", "centerscreen,chrome,modal", "edit", selectedCell.getAttribute("label"), selectedItem.childNodes[2].getAttribute("label"), selectedItem.childNodes[1].getAttribute("label"), selectedCell.getAttribute("type"));

            // If the description and the bookmarklet, path or URL are set
            if(webdeveloper_toolDescription && (webdeveloper_toolBookmarklet || webdeveloper_toolPath || webdeveloper_toolURL))
            {
                var listCell     = pageDocument.createElement("listcell");
                var stringBundle = document.getElementById("webdeveloper-string-bundle");

                webdeveloper_removeAllChildElements(selectedItem);

                listCell.setAttribute("label", webdeveloper_toolDescription);

                // If the bookmarklet is set
                if(webdeveloper_toolBookmarklet)
                {
                    listCell.setAttribute("type", stringBundle.getString("webdeveloper_bookmarklet"));
                }
                else if(webdeveloper_toolPath)
                {
                    listCell.setAttribute("type", stringBundle.getString("webdeveloper_application"));
                }
                else
                {
                    listCell.setAttribute("type", stringBundle.getString("webdeveloper_url"));
                }

                selectedItem.appendChild(listCell);

                listCell = pageDocument.createElement("listcell");

                // If the bookmarklet is set
                if(webdeveloper_toolBookmarklet)
                {
                    listCell.setAttribute("label", webdeveloper_toolBookmarklet);
                }
                else if(webdeveloper_toolPath)
                {
                    listCell.setAttribute("label", webdeveloper_toolPath);
                }
                else
                {
                    listCell.setAttribute("label", webdeveloper_toolURL);
                }

                listCell.setAttribute("crop", "end");
                selectedItem.appendChild(listCell);

                listCell = pageDocument.createElement("listcell");

                // If the key is set
                if(webdeveloper_toolKey)
                {
                    listCell.setAttribute("label", webdeveloper_toolKey);
                }

                selectedItem.appendChild(listCell);
                toolBox.ensureElementIsVisible(selectedItem);
            }
        }
    }
}

// Edits a view source with option
function webdeveloper_editViewSourceWith()
{
    var pageDocument      = document.getElementById("webdeveloper-options-iframe").contentDocument;
    var viewSourceWithBox = pageDocument.getElementById("webdeveloper-listbox");
    var selectedItem      = viewSourceWithBox.selectedItem;

    // If an option is selected
    if(selectedItem)
    {
        window.openDialog("chrome://webdeveloper/content/options/dialogs/view_source_with.xul", "webdeveloper-view-source-with-dialog", "centerscreen,chrome,modal", "edit", selectedItem.childNodes[0].getAttribute("label"), selectedItem.childNodes[1].getAttribute("label"), selectedItem.childNodes[2].getAttribute("label"));

        // If the description and path are set
        if(webdeveloper_viewSourceWithDescription && webdeveloper_viewSourceWithPath)
        {
            var listCell = pageDocument.createElement("listcell");

            webdeveloper_removeAllChildElements(selectedItem);

            listCell.setAttribute("label", webdeveloper_viewSourceWithDescription);
            selectedItem.appendChild(listCell);

            listCell = pageDocument.createElement("listcell");
            listCell.setAttribute("label", webdeveloper_viewSourceWithPath);
            listCell.setAttribute("crop", "end");
            selectedItem.appendChild(listCell);

            listCell = pageDocument.createElement("listcell");

            // If the key is set
            if(webdeveloper_viewSourceWithKey)
            {
                listCell.setAttribute("label", webdeveloper_viewSourceWithKey);
            }

            selectedItem.appendChild(listCell);
            viewSourceWithBox.ensureElementIsVisible(selectedItem);
        }
    }
}

// Initializes the colors and fonts page
function webdeveloper_initializeColorsAndFonts()
{
    var pageDocument = document.getElementById("webdeveloper-options-iframe").contentDocument;

    // If the generated content font size preference is set
    if(typeof webdeveloper_optionsDataInteger["webdeveloper.generated.content.font.size"] != "undefined")
    {
        pageDocument.getElementById("webdeveloper.generated.content.font.size").value = webdeveloper_optionsDataInteger["webdeveloper.generated.content.font.size"];
    }
    else if(webdeveloper_isPreferenceSet("webdeveloper.generated.content.font.size"))
    {
        pageDocument.getElementById("webdeveloper.generated.content.font.size").value = webdeveloper_getIntegerPreference("webdeveloper.generated.content.font.size", true);
    }

    // If the feature tooltip text color is set
    if(typeof webdeveloper_optionsDataString["webdeveloper.feature.tooltip.color.text"] != "undefined")
    {
        pageDocument.getElementById("webdeveloper.feature.tooltip.color.text").color = webdeveloper_optionsDataString["webdeveloper.feature.tooltip.color.text"].trim();
    }
    else if(webdeveloper_isPreferenceSet("webdeveloper.feature.tooltip.color.text"))
    {
        pageDocument.getElementById("webdeveloper.feature.tooltip.color.text").color = webdeveloper_getStringPreference("webdeveloper.feature.tooltip.color.text", true);
    }

    // If the feature tooltip background color is set
    if(typeof webdeveloper_optionsDataString["webdeveloper.feature.tooltip.color.background"] != "undefined")
    {
        pageDocument.getElementById("webdeveloper.feature.tooltip.color.background").color = webdeveloper_optionsDataString["webdeveloper.feature.tooltip.color.background"].trim();
    }
    else if(webdeveloper_isPreferenceSet("webdeveloper.feature.tooltip.color.background"))
    {
        pageDocument.getElementById("webdeveloper.feature.tooltip.color.background").color = webdeveloper_getStringPreference("webdeveloper.feature.tooltip.color.background", true);
    }

    // If the feature tooltip border color is set
    if(typeof webdeveloper_optionsDataString["webdeveloper.feature.tooltip.color.border"] != "undefined")
    {
        pageDocument.getElementById("webdeveloper.feature.tooltip.color.border").color = webdeveloper_optionsDataString["webdeveloper.feature.tooltip.color.border"].trim();
    }
    else if(webdeveloper_isPreferenceSet("webdeveloper.feature.tooltip.color.border"))
    {
        pageDocument.getElementById("webdeveloper.feature.tooltip.color.border").color = webdeveloper_getStringPreference("webdeveloper.feature.tooltip.color.border", true);
    }

    // If the feature tooltip opacity is set
    if(typeof webdeveloper_optionsDataString["webdeveloper.feature.tooltip.opacity"] != "undefined")
    {
        pageDocument.getElementById("webdeveloper.feature.tooltip.opacity").value = webdeveloper_optionsDataString["webdeveloper.feature.tooltip.opacity"];
    }
    else if(webdeveloper_isPreferenceSet("webdeveloper.feature.tooltip.opacity"))
    {
        pageDocument.getElementById("webdeveloper.feature.tooltip.opacity").value = webdeveloper_getStringPreference("webdeveloper.feature.tooltip.opacity", true);
    }
}

// Initializes the dashboard page
function webdeveloper_initializeDashboard()
{
    var pageDocument = document.getElementById("webdeveloper-options-iframe").contentDocument;

    // If the edit CSS text color is set
    if(typeof webdeveloper_optionsDataString["webdeveloper.edit.color.text"] != "undefined")
    {
        pageDocument.getElementById("webdeveloper.edit.color.text").color = webdeveloper_optionsDataString["webdeveloper.edit.color.text"].trim();
    }
    else if(webdeveloper_isPreferenceSet("webdeveloper.edit.color.text"))
    {
        pageDocument.getElementById("webdeveloper.edit.color.text").color = webdeveloper_getStringPreference("webdeveloper.edit.color.text", true);
    }

    // If the edit CSS background color is set
    if(typeof webdeveloper_optionsDataString["webdeveloper.edit.color.background"] != "undefined")
    {
        pageDocument.getElementById("webdeveloper.edit.color.background").color = webdeveloper_optionsDataString["webdeveloper.edit.color.background"].trim();
    }
    else if(webdeveloper_isPreferenceSet("webdeveloper.edit.color.background"))
    {
        pageDocument.getElementById("webdeveloper.edit.color.background").color = webdeveloper_getStringPreference("webdeveloper.edit.color.background", true);
    }

    // If the edit CSS font preference is set
    if(typeof webdeveloper_optionsDataInteger["webdeveloper.edit.font.size"] != "undefined")
    {
        pageDocument.getElementById("webdeveloper.edit.font.size").value = webdeveloper_optionsDataInteger["webdeveloper.edit.font.size"];
    }
    else if(webdeveloper_isPreferenceSet("webdeveloper.edit.font.size"))
    {
        pageDocument.getElementById("webdeveloper.edit.font.size").value = webdeveloper_getIntegerPreference("webdeveloper.edit.font.size", true);
    }

    // If the edit CSS update frequency preference is set
    if(typeof webdeveloper_optionsDataInteger["webdeveloper.edit.update.frequency"] != "undefined")
    {
        pageDocument.getElementById("webdeveloper.edit.update.frequency").value = webdeveloper_optionsDataInteger["webdeveloper.edit.update.frequency"];
    }
    else if(webdeveloper_isPreferenceSet("webdeveloper.edit.update.frequency"))
    {
        pageDocument.getElementById("webdeveloper.edit.update.frequency").value = webdeveloper_getIntegerPreference("webdeveloper.edit.update.frequency", true);
    }

    // If the edit CSS wrap preference is set
    if(typeof webdeveloper_optionsDataBoolean["webdeveloper.edit.wrap"] != "undefined")
    {
        pageDocument.getElementById("webdeveloper.edit.wrap").checked = webdeveloper_optionsDataBoolean["webdeveloper.edit.wrap"];
    }
    else if(webdeveloper_isPreferenceSet("webdeveloper.edit.wrap"))
    {
        pageDocument.getElementById("webdeveloper.edit.wrap").checked = webdeveloper_getBooleanPreference("webdeveloper.edit.wrap", true);
    }

    // If the style information dashboard preference is set
    if(typeof webdeveloper_optionsDataBoolean["webdeveloper.style.information.dashboard"] != "undefined")
    {
        pageDocument.getElementById("webdeveloper.style.information.dashboard").checked = webdeveloper_optionsDataBoolean["webdeveloper.style.information.dashboard"];
    }
    else if(webdeveloper_isPreferenceSet("webdeveloper.style.information.dashboard"))
    {
        pageDocument.getElementById("webdeveloper.style.information.dashboard").checked = webdeveloper_getBooleanPreference("webdeveloper.style.information.dashboard", true);
    }

    // If the DOM Inspector dashboard preference is set
    if(typeof webdeveloper_optionsDataBoolean["webdeveloper.dom.inspector.dashboard"] != "undefined")
    {
        pageDocument.getElementById("webdeveloper.dom.inspector.dashboard").checked = webdeveloper_optionsDataBoolean["webdeveloper.dom.inspector.dashboard"];
    }
    else if(webdeveloper_isPreferenceSet("webdeveloper.dom.inspector.dashboard"))
    {
        pageDocument.getElementById("webdeveloper.dom.inspector.dashboard").checked = webdeveloper_getBooleanPreference("webdeveloper.dom.inspector.dashboard", true);
    }

    // If the error console dashboard preference is set
    if(typeof webdeveloper_optionsDataBoolean["webdeveloper.error.console.dashboard"] != "undefined")
    {
        pageDocument.getElementById("webdeveloper.error.console.dashboard").checked = webdeveloper_optionsDataBoolean["webdeveloper.error.console.dashboard"];
    }
    else if(webdeveloper_isPreferenceSet("webdeveloper.error.console.dashboard"))
    {
        pageDocument.getElementById("webdeveloper.error.console.dashboard").checked = webdeveloper_getBooleanPreference("webdeveloper.error.console.dashboard", true);
    }
}

// Initializes the general page
function webdeveloper_initializeGeneral()
{
    var pageDocument = document.getElementById("webdeveloper-options-iframe").contentDocument;

    // If the hide menu preference is set
    if(typeof webdeveloper_optionsDataBoolean["webdeveloper.menu.hide"] != "undefined")
    {
        pageDocument.getElementById("webdeveloper.menu.hide").checked = webdeveloper_optionsDataBoolean["webdeveloper.menu.hide"];
    }
    else if(webdeveloper_isPreferenceSet("webdeveloper.menu.hide"))
    {
        pageDocument.getElementById("webdeveloper.menu.hide").checked = webdeveloper_getBooleanPreference("webdeveloper.menu.hide", true);
    }
    else
    {
        pageDocument.getElementById("webdeveloper.menu.hide").checked = false;
    }

    // If the hide context menu preference is set
    if(typeof webdeveloper_optionsDataBoolean["webdeveloper.context.hide"] != "undefined")
    {
        pageDocument.getElementById("webdeveloper.context.hide").checked = webdeveloper_optionsDataBoolean["webdeveloper.context.hide"];
    }
    else if(webdeveloper_isPreferenceSet("webdeveloper.context.hide"))
    {
        pageDocument.getElementById("webdeveloper.context.hide").checked = webdeveloper_getBooleanPreference("webdeveloper.context.hide", true);
    }
    else
    {
        pageDocument.getElementById("webdeveloper.context.hide").checked = false;
    }

    // If the hide confirmation dialogs preference is set
    if(typeof webdeveloper_optionsDataBoolean["webdeveloper.confirmation.dialogs.hide"] != "undefined")
    {
        pageDocument.getElementById("webdeveloper.confirmation.dialogs.hide").checked = webdeveloper_optionsDataBoolean["webdeveloper.confirmation.dialogs.hide"];
    }
    else if(webdeveloper_isPreferenceSet("webdeveloper.confirmation.dialogs.hide"))
    {
        pageDocument.getElementById("webdeveloper.confirmation.dialogs.hide").checked = webdeveloper_getBooleanPreference("webdeveloper.confirmation.dialogs.hide", true);
    }
    else
    {
        pageDocument.getElementById("webdeveloper.confirmation.dialogs.hide").checked = false;
    }

    // If the hide informational dialogs preference is set
    if(typeof webdeveloper_optionsDataBoolean["webdeveloper.informational.dialogs.hide"] != "undefined")
    {
        pageDocument.getElementById("webdeveloper.informational.dialogs.hide").checked = webdeveloper_optionsDataBoolean["webdeveloper.informational.dialogs.hide"];
    }
    else if(webdeveloper_isPreferenceSet("webdeveloper.informational.dialogs.hide"))
    {
        pageDocument.getElementById("webdeveloper.informational.dialogs.hide").checked = webdeveloper_getBooleanPreference("webdeveloper.informational.dialogs.hide", true);
    }
    else
    {
        pageDocument.getElementById("webdeveloper.informational.dialogs.hide").checked = false;
    }

    // If the toolbar icons preference is set
    if(typeof webdeveloper_optionsDataString["webdeveloper.toolbar.icons"] != "undefined")
    {
        pageDocument.getElementById("webdeveloper.toolbar.icons").value = webdeveloper_optionsDataString["webdeveloper.toolbar.icons"];
    }
    else if(webdeveloper_isPreferenceSet("webdeveloper.toolbar.icons"))
    {
        pageDocument.getElementById("webdeveloper.toolbar.icons").value = webdeveloper_getStringPreference("webdeveloper.toolbar.icons", true);
    }
    else
    {
        pageDocument.getElementById("webdeveloper.toolbar.icons").selectedIndex = 0;
    }

    // If the open tabs preference is set
    if(typeof webdeveloper_optionsDataBoolean["webdeveloper.open.tabs"] != "undefined")
    {
        pageDocument.getElementById("webdeveloper.open.tabs").checked = webdeveloper_optionsDataBoolean["webdeveloper.open.tabs"];
    }
    else if(webdeveloper_isPreferenceSet("webdeveloper.open.tabs"))
    {
        pageDocument.getElementById("webdeveloper.open.tabs").checked = webdeveloper_getBooleanPreference("webdeveloper.open.tabs", true);
    }

    // If the open tabs background preference is set
    if(typeof webdeveloper_optionsDataBoolean["webdeveloper.open.tabs.background"] != "undefined")
    {
        pageDocument.getElementById("webdeveloper.open.tabs.background").checked = webdeveloper_optionsDataBoolean["webdeveloper.open.tabs.background"];
    }
    else if(webdeveloper_isPreferenceSet("webdeveloper.open.tabs.background"))
    {
        pageDocument.getElementById("webdeveloper.open.tabs.background").checked = webdeveloper_getBooleanPreference("webdeveloper.open.tabs.background", true);
    }
    else
    {
        pageDocument.getElementById("webdeveloper.open.tabs.background").checked = false;
    }

    pageDocument.getElementById("webdeveloper.open.tabs.background").disabled = !pageDocument.getElementById("webdeveloper.open.tabs").checked;
}

// Initializes the keys page
function webdeveloper_initializeKeys()
{
    var mainDocument = null;

    // If there is a parent window
    if(window.opener)
    {
        // If there is a grand parent window
        if(window.opener.opener)
        {
            mainDocument = window.opener.opener.document;
        }
        else
        {
            mainDocument = window.opener.document;
        }
    }
    else
    {
        mainDocument = document;
    }

    // If a main document was found
    if(mainDocument)
    {
        var keySet = mainDocument.getElementById("mainKeyset");

        // If the key set was not found
        if(!keySet)
        {
            keySet = mainDocument.getElementById("navKeys");
        }

        // If the key set was found
        if(keySet)
        {
            var description   = null;
            var horizontalBox = null;
            var id            = null;
            var labelElement         = null;
            var key           = null;
            var keys          = keySet.childNodes;
            var keysLength    = keys.length;
            var pageDocument  = document.getElementById("webdeveloper-options-iframe").contentDocument;
            var row           = null;
            var rows          = pageDocument.getElementById("webdeveloper-key-rows");
            var spacer        = null;
            var stringBundle  = document.getElementById("webdeveloper-string-bundle");
            var modifiers     = null;
            var textBox       = null;

            // If running on a Mac
            if(webdeveloper_isMac())
            {
                modifiers = stringBundle.getString("webdeveloper_keyboardShortcutModifiersMac");
            }
            else
            {
                modifiers = stringBundle.getString("webdeveloper_keyboardShortcutModifiers");
            }

            // Loop through the keys
            for(var i = 0; i < keysLength; i++)
            {
                key = keys.item(i);

                // If the key has and id attribute starting with webdeveloper-
                if(key.hasAttribute("id") && key.getAttribute("id").indexOf("webdeveloper-") == 0)
                {
                    description   = pageDocument.createElement("description");
                    horizontalBox = pageDocument.createElement("hbox");
                    id            = key.getAttribute("id").split("-").join(".");
                    labelElement  = pageDocument.createElement("label");
                    row           = pageDocument.createElement("row");
                    textBox       = pageDocument.createElement("textbox");

                    labelElement.setAttribute("control", id);
                    labelElement.setAttribute("value", key.getAttribute("label"));
                    row.appendChild(labelElement);

                    description.setAttribute("value", modifiers);
                    horizontalBox.appendChild(description);

                    // If the option is defined
                    if(typeof webdeveloper_optionsDataString[id] != "undefined")
                    {
                        textBox.setAttribute("value", webdeveloper_optionsDataString[id].trim());
                    }
                    else if(webdeveloper_isPreferenceSet(id))
                    {
                        textBox.setAttribute("value", webdeveloper_getStringPreference(id, true));
                    }
                    else
                    {
                        textBox.setAttribute("value", key.getAttribute("key"));
                    }

                    textBox.setAttribute("id", id);
                    textBox.setAttribute("size", "1");
                    textBox.setAttribute("maxlength", "1");
                    horizontalBox.appendChild(textBox);

                    horizontalBox.setAttribute("align", "center");
                    row.appendChild(horizontalBox);

                    row.setAttribute("align", "center");
                    rows.appendChild(row);
                }
            }
        }
    }
}

// Initializes the miscellaneous page
function webdeveloper_initializeMiscellaneous()
{
    var pageDocument = document.getElementById("webdeveloper-options-iframe").contentDocument;

    // If the populate form fields email preference is set
    if(typeof webdeveloper_optionsDataString["webdeveloper.populate.form.fields.email"] != "undefined")
    {
        pageDocument.getElementById("webdeveloper.populate.form.fields.email").value = webdeveloper_optionsDataString["webdeveloper.populate.form.fields.email"];
    }
    else if(webdeveloper_isPreferenceSet("webdeveloper.populate.form.fields.email"))
    {
        pageDocument.getElementById("webdeveloper.populate.form.fields.email").value = webdeveloper_getStringPreference("webdeveloper.populate.form.fields.email", true);
    }

    // If the tidy information preference is set
    if(typeof webdeveloper_optionsDataBoolean["webdeveloper.information.tidy"] != "undefined")
    {
        pageDocument.getElementById("webdeveloper.information.tidy").checked = webdeveloper_optionsDataBoolean["webdeveloper.information.tidy"];
    }
    else if(webdeveloper_isPreferenceSet("webdeveloper.information.tidy"))
    {
        pageDocument.getElementById("webdeveloper.information.tidy").checked = webdeveloper_getBooleanPreference("webdeveloper.information.tidy", true);
    }
    else
    {
        pageDocument.getElementById("webdeveloper.information.tidy").checked = false;
    }

    // If the open CSS console error preference is set
    if(typeof webdeveloper_optionsDataBoolean["webdeveloper.open.css.console.error"] != "undefined")
    {
        pageDocument.getElementById("webdeveloper.open.css.console.error").checked = webdeveloper_optionsDataBoolean["webdeveloper.open.css.console.error"];
    }
    else if(webdeveloper_isPreferenceSet("webdeveloper.open.css.console.error"))
    {
        pageDocument.getElementById("webdeveloper.open.css.console.error").checked = webdeveloper_getBooleanPreference("webdeveloper.open.css.console.error", true);
    }
    else
    {
        pageDocument.getElementById("webdeveloper.open.css.console.error").checked = false;
    }

    // If the open JavaScript console warning preference is set
    if(typeof webdeveloper_optionsDataBoolean["webdeveloper.open.javascript.console.warning"] != "undefined")
    {
        pageDocument.getElementById("webdeveloper.open.javascript.console.warning").checked = webdeveloper_optionsDataBoolean["webdeveloper.open.javascript.console.warning"];
    }
    else if(webdeveloper_isPreferenceSet("webdeveloper.open.javascript.console.warning"))
    {
        pageDocument.getElementById("webdeveloper.open.javascript.console.warning").checked = webdeveloper_getBooleanPreference("webdeveloper.open.javascript.console.warning", true);
    }
    else
    {
        pageDocument.getElementById("webdeveloper.open.javascript.console.warning").checked = false;
    }

    // If the open JavaScript console error preference is set
    if(typeof webdeveloper_optionsDataBoolean["webdeveloper.open.javascript.console.error"] != "undefined")
    {
        pageDocument.getElementById("webdeveloper.open.javascript.console.error").checked = webdeveloper_optionsDataBoolean["webdeveloper.open.javascript.console.error"];
    }
    else if(webdeveloper_isPreferenceSet("webdeveloper.open.javascript.console.error"))
    {
        pageDocument.getElementById("webdeveloper.open.javascript.console.error").checked = webdeveloper_getBooleanPreference("webdeveloper.open.javascript.console.error", true);
    }
    else
    {
        pageDocument.getElementById("webdeveloper.open.javascript.console.error").checked = false;
    }
}

// Initializes the options dialog
function webdeveloper_initializeOptions(checkDialogParameters)
{
	var pageList   = document.getElementById("webdeveloper-options-page-list");
    var selectPage = 0;

    // If check dialog parameters and window arguments are set
	if(checkDialogParameters && window.arguments)
	{
        selectPage = webdeveloper_translatePageNameToIndex(window.arguments[0]);
    }
	else if(webdeveloper_isPreferenceSet("webdeveloper.options.last.page"))
	{
        selectPage = webdeveloper_getIntegerPreference("webdeveloper.options.last.page");
	}

    pageList.selectedIndex = selectPage;

    document.getElementById("webdeveloper-options-iframe").setAttribute("src", pageList.selectedItem.value);
}

// Initializes the resize page
function webdeveloper_initializeResize()
{
    var description      = null;
    var descriptionValue = null;
    var height           = null;
    var heightValue      = null;
    var listCell         = null;
    var listItem         = null;
    var pageDocument     = document.getElementById("webdeveloper-options-iframe").contentDocument;
    var resizeBox        = pageDocument.getElementById("webdeveloper-listbox");
    var resizeCount      = 0;
    var stringBundle     = document.getElementById("webdeveloper-string-bundle");
    var no               = stringBundle.getString("webdeveloper_no");
    var viewport         = null;
    var viewportValue    = false;
    var width            = null;
    var widthValue       = null;
    var yes              = stringBundle.getString("webdeveloper_yes");

    // If the resize count preference is set
    if(typeof webdeveloper_optionsDataInteger["webdeveloper.resize.count"] != "undefined")
    {
        resizeCount = webdeveloper_optionsDataInteger["webdeveloper.resize.count"];
    }
    else if(webdeveloper_isPreferenceSet("webdeveloper.resize.count"))
    {
        resizeCount = webdeveloper_getIntegerPreference("webdeveloper.resize.count", true);
    }

    // Loop through the possible resize options
    for(var i = 1; i <= resizeCount; i++)
    {
	    description = "webdeveloper.resize." + i + ".description";
	    height      = "webdeveloper.resize." + i + ".height";
	    viewport    = "webdeveloper.resize." + i + ".viewport";
	    width       = "webdeveloper.resize." + i + ".width";

        // If the description is set
        if(typeof webdeveloper_optionsDataString[description] != "undefined")
        {
            descriptionValue = webdeveloper_optionsDataString[description].trim();
        }
        else if(webdeveloper_isPreferenceSet(description))
        {
	        descriptionValue = webdeveloper_getStringPreference(description, true);
        }
        else
        {
            descriptionValue = null;
        }

        // If the width is set
        if(typeof webdeveloper_optionsDataInteger[width] != "undefined")
        {
            widthValue = webdeveloper_optionsDataInteger[width];
        }
        else if(webdeveloper_isPreferenceSet(width))
        {
            widthValue = webdeveloper_getIntegerPreference(width, true);
        }
        else
        {
            widthValue = null;
        }

        // If the height is set
        if(typeof webdeveloper_optionsDataInteger[height] != "undefined")
        {
            heightValue = webdeveloper_optionsDataInteger[height];
        }
        else if(webdeveloper_isPreferenceSet(height))
        {
            heightValue = webdeveloper_getIntegerPreference(height, true);
        }
        else
        {
            heightValue = null;
        }

        // If the viewport is set
        if(typeof webdeveloper_optionsDataBoolean[viewport] != "undefined")
        {
            viewportValue = webdeveloper_optionsDataBoolean[viewport];
        }
        else if(webdeveloper_isPreferenceSet(viewport))
        {
            viewportValue = webdeveloper_getBooleanPreference(viewport, true);
        }
        else
        {
            viewportValue = false;
        }

        // If the description, width and height are set
        if(descriptionValue && widthValue && heightValue)
        {
            listItem = pageDocument.createElement("listitem");

            listCell = pageDocument.createElement("listcell");
            listCell.setAttribute("label", descriptionValue);
            listItem.appendChild(listCell);

            listCell = pageDocument.createElement("listcell");
            listCell.setAttribute("label", widthValue);
            listItem.appendChild(listCell);

            listCell = pageDocument.createElement("listcell");
            listCell.setAttribute("label", heightValue);
            listItem.appendChild(listCell);

            listCell = pageDocument.createElement("listcell");

            // If resizing the viewport
            if(viewportValue)
            {
                listCell.setAttribute("label", yes);
            }
            else
            {
                listCell.setAttribute("label", no);
            }

            listItem.appendChild(listCell);
            resizeBox.appendChild(listItem);
        }
    }

    webdeveloper_listBoxSelected();
}

// Initializes the tools page
function webdeveloper_initializeTools()
{
    var bookmarklet      = null;
    var bookmarkletValue = null;
    var description      = null;
    var descriptionValue = null;
    var key              = null;
    var keyValue         = null;
    var listCell         = null;
    var listItem         = null;
    var pageDocument     = document.getElementById("webdeveloper-options-iframe").contentDocument;
    var path             = null;
    var pathValue        = null;
    var separator        = null;
    var separatorValue   = false;
    var stringBundle     = document.getElementById("webdeveloper-string-bundle");
    var applicationType  = stringBundle.getString("webdeveloper_application");
    var bookmarkletType  = stringBundle.getString("webdeveloper_bookmarklet");
    var toolBox          = pageDocument.getElementById("webdeveloper-listbox");
    var toolCount        = 0;
    var url              = null;
    var urlType          = stringBundle.getString("webdeveloper_url");
    var urlValue         = null;

    // If the tool count preference is set
    if(typeof webdeveloper_optionsDataInteger["webdeveloper.tool.count"] != "undefined")
    {
        toolCount = webdeveloper_optionsDataInteger["webdeveloper.tool.count"];
    }
    else if(webdeveloper_isPreferenceSet("webdeveloper.tool.count"))
    {
        toolCount = webdeveloper_getIntegerPreference("webdeveloper.tool.count", true);
    }

    // Loop through the possible tools
    for(var i = 1; i <= toolCount; i++)
    {
	    bookmarklet = "webdeveloper.tool." + i + ".bookmarklet";
	    description = "webdeveloper.tool." + i + ".description";
	    key         = "webdeveloper.tool." + i + ".key";
	    path        = "webdeveloper.tool." + i + ".path";
	    separator   = "webdeveloper.tool." + i + ".separator";
	    url         = "webdeveloper.tool." + i + ".url";

        // If the bookmarklet is set
        if(typeof webdeveloper_optionsDataString[bookmarklet] != "undefined")
        {
            bookmarkletValue = webdeveloper_optionsDataString[bookmarklet].trim();
        }
        else if(webdeveloper_isPreferenceSet(bookmarklet))
        {
	        bookmarkletValue = webdeveloper_getStringPreference(bookmarklet, true);
        }
        else
        {
            bookmarkletValue = null;
        }

        // If the description is set
        if(typeof webdeveloper_optionsDataString[description] != "undefined")
        {
            descriptionValue = webdeveloper_optionsDataString[description].trim();
        }
        else if(webdeveloper_isPreferenceSet(description))
        {
	        descriptionValue = webdeveloper_getStringPreference(description, true);
        }
        else
        {
            descriptionValue = null;
        }

        // If the key is set
        if(typeof webdeveloper_optionsDataString[key] != "undefined")
        {
            keyValue = webdeveloper_optionsDataString[key].trim();
        }
        else if(webdeveloper_isPreferenceSet(key))
        {
            keyValue = webdeveloper_getStringPreference(key, true);
        }
        else
        {
            keyValue = null;
        }

        // If the path is set
        if(typeof webdeveloper_optionsDataString[path] != "undefined")
        {
            pathValue = webdeveloper_optionsDataString[path].trim();
        }
        else if(webdeveloper_isPreferenceSet(path))
        {
            pathValue = webdeveloper_getStringPreference(path, true);
        }
        else
        {
            pathValue = null;
        }

        // If the separator is set
        if(typeof webdeveloper_optionsDataBoolean[separator] != "undefined")
        {
            separatorValue = webdeveloper_optionsDataBoolean[separator];
        }
        else if(webdeveloper_isPreferenceSet(separator))
        {
            separatorValue = webdeveloper_getBooleanPreference(separator, true);
        }
        else
        {
            separatorValue = false;
        }

        // If the URL is set
        if(typeof webdeveloper_optionsDataString[url] != "undefined")
        {
            urlValue = webdeveloper_optionsDataString[url].trim();
        }
        else if(webdeveloper_isPreferenceSet(url))
        {
            urlValue = webdeveloper_getStringPreference(url, true);
        }
        else
        {
            urlValue = null;
        }

        // If the separator is set
        if(separatorValue)
        {
            listItem  = pageDocument.createElement("listitem");
            separator = pageDocument.createElement("separator");

            separator.setAttribute("class", "groove");
            listItem.appendChild(separator);

            separator = pageDocument.createElement("separator");
            separator.setAttribute("class", "groove");
            listItem.appendChild(separator);

            separator = pageDocument.createElement("separator");
            separator.setAttribute("class", "groove");
            listItem.appendChild(separator);

            toolBox.appendChild(listItem);
        }
        else if(descriptionValue && (bookmarkletValue || pathValue || urlValue))
        {
            listItem = pageDocument.createElement("listitem");

            listCell = pageDocument.createElement("listcell");
            listCell.setAttribute("label", descriptionValue);

            // If the bookmarklet is set
            if(bookmarkletValue)
            {
                listCell.setAttribute("type", bookmarkletType);
            }
            else if(pathValue)
            {
                listCell.setAttribute("type", applicationType);
            }
            else
            {
                listCell.setAttribute("type", urlType);
            }

            listItem.appendChild(listCell);

            listCell = pageDocument.createElement("listcell");

            // If the bookmarklet is set
            if(bookmarkletValue)
            {
                listCell.setAttribute("label", bookmarkletValue);
            }
            else if(pathValue)
            {
                listCell.setAttribute("label", pathValue);
            }
            else
            {
                listCell.setAttribute("label", urlValue);
            }

            listCell.setAttribute("crop", "end");
            listItem.appendChild(listCell);

            listCell = pageDocument.createElement("listcell");

            // If the key is set
            if(keyValue)
            {
                listCell.setAttribute("label", keyValue);
            }

            listItem.appendChild(listCell);
            toolBox.appendChild(listItem);
        }
    }

    webdeveloper_listBoxSelected();
}

// Initializes the validation page
function webdeveloper_initializeValidation()
{
    var pageDocument                 = document.getElementById("webdeveloper-options-iframe").contentDocument;
    var validateLocalCSSProfile      = "css21";
    var validateLocalCSSProfileRadio = pageDocument.getElementById("webdeveloper-validate-local-css21-radio");

    // If the Section 508 preference is set
    if(typeof webdeveloper_optionsDataBoolean["webdeveloper.validate.local.accessibility.section508"] != "undefined")
    {
        pageDocument.getElementById("webdeveloper.validate.local.accessibility.section508").checked = webdeveloper_optionsDataBoolean["webdeveloper.validate.local.accessibility.section508"];
    }
    else if(webdeveloper_isPreferenceSet("webdeveloper.validate.local.accessibility.section508"))
    {
        pageDocument.getElementById("webdeveloper.validate.local.accessibility.section508").checked = webdeveloper_getBooleanPreference("webdeveloper.validate.local.accessibility.section508", true);
    }

    // If the WAI priority 1 preference is set
    if(typeof webdeveloper_optionsDataBoolean["webdeveloper.validate.local.accessibility.wai.priority1"] != "undefined")
    {
        pageDocument.getElementById("webdeveloper.validate.local.accessibility.wai.priority1").checked = webdeveloper_optionsDataBoolean["webdeveloper.validate.local.accessibility.wai.priority1"];
    }
    else if(webdeveloper_isPreferenceSet("webdeveloper.validate.local.accessibility.wai.priority1"))
    {
        pageDocument.getElementById("webdeveloper.validate.local.accessibility.wai.priority1").checked = webdeveloper_getBooleanPreference("webdeveloper.validate.local.accessibility.wai.priority1", true);
    }

    // If the WAI priority 2 preference is set
    if(typeof webdeveloper_optionsDataBoolean["webdeveloper.validate.local.accessibility.wai.priority2"] != "undefined")
    {
        pageDocument.getElementById("webdeveloper.validate.local.accessibility.wai.priority2").checked = webdeveloper_optionsDataBoolean["webdeveloper.validate.local.accessibility.wai.priority2"];
    }
    else if(webdeveloper_isPreferenceSet("webdeveloper.validate.local.accessibility.wai.priority2"))
    {
        pageDocument.getElementById("webdeveloper.validate.local.accessibility.wai.priority2").checked = webdeveloper_getBooleanPreference("webdeveloper.validate.local.accessibility.wai.priority2", true);
    }

    // If the WAI priority 3 preference is set
    if(typeof webdeveloper_optionsDataBoolean["webdeveloper.validate.local.accessibility.wai.priority3"] != "undefined")
    {
        pageDocument.getElementById("webdeveloper.validate.local.accessibility.wai.priority3").checked = webdeveloper_optionsDataBoolean["webdeveloper.validate.local.accessibility.wai.priority3"];
    }
    else if(webdeveloper_isPreferenceSet("webdeveloper.validate.local.accessibility.wai.priority3"))
    {
        pageDocument.getElementById("webdeveloper.validate.local.accessibility.wai.priority3").checked = webdeveloper_getBooleanPreference("webdeveloper.validate.local.accessibility.wai.priority3", true);
    }

    // If the CSS profile preference is set
    if(typeof webdeveloper_optionsDataString["webdeveloper.validate.local.css.profile"] != "undefined")
    {
        validateLocalCSSProfile = webdeveloper_optionsDataString["webdeveloper.validate.local.css.profile"];
    }
    else if(webdeveloper_isPreferenceSet("webdeveloper.validate.local.css.profile"))
    {
        validateLocalCSSProfile = webdeveloper_getStringPreference("webdeveloper.validate.local.css.profile", true);
    }

    // If validate local CSS profile is set to CSS 3
    if(validateLocalCSSProfile == "css3")
    {
        validateLocalCSSProfileRadio = pageDocument.getElementById("webdeveloper-validate-local-css3-radio");
    }

    validateLocalCSSProfileRadio.radioGroup.selectedItem = validateLocalCSSProfileRadio;

    // If the show outline preference is set
    if(typeof webdeveloper_optionsDataBoolean["webdeveloper.validate.local.html.show.outline"] != "undefined")
    {
        pageDocument.getElementById("webdeveloper.validate.local.html.show.outline").checked = webdeveloper_optionsDataBoolean["webdeveloper.validate.local.html.show.outline"];
    }
    else if(webdeveloper_isPreferenceSet("webdeveloper.validate.local.html.show.outline"))
    {
        pageDocument.getElementById("webdeveloper.validate.local.html.show.outline").checked = webdeveloper_getBooleanPreference("webdeveloper.validate.local.html.show.outline", true);
    }

    // If the show parse tree preference is set
    if(typeof webdeveloper_optionsDataBoolean["webdeveloper.validate.local.html.show.parse.tree"] != "undefined")
    {
        pageDocument.getElementById("webdeveloper.validate.local.html.show.parse.tree").checked = webdeveloper_optionsDataBoolean["webdeveloper.validate.local.html.show.parse.tree"];
    }
    else if(webdeveloper_isPreferenceSet("webdeveloper.validate.local.html.show.parse.tree"))
    {
        pageDocument.getElementById("webdeveloper.validate.local.html.show.parse.tree").checked = webdeveloper_getBooleanPreference("webdeveloper.validate.local.html.show.parse.tree", true);
    }

    // If the show source preference is set
    if(typeof webdeveloper_optionsDataBoolean["webdeveloper.validate.local.html.show.source"] != "undefined")
    {
        pageDocument.getElementById("webdeveloper.validate.local.html.show.source").checked = webdeveloper_optionsDataBoolean["webdeveloper.validate.local.html.show.source"];
    }
    else if(webdeveloper_isPreferenceSet("webdeveloper.validate.local.html.show.source"))
    {
        pageDocument.getElementById("webdeveloper.validate.local.html.show.source").checked = webdeveloper_getBooleanPreference("webdeveloper.validate.local.html.show.source", true);
    }
}

// Initializes the view source page
function webdeveloper_initializeViewSource()
{
    var description         = null;
    var descriptionValue    = null;
    var key                 = null;
    var keyValue            = null;
    var listCell            = null;
    var listItem            = null;
    var pageDocument        = document.getElementById("webdeveloper-options-iframe").contentDocument;
    var path                = null;
    var pathValue           = null;
    var viewSourceWithBox   = pageDocument.getElementById("webdeveloper-listbox");
    var viewSourceWithCount = 0;

    // If the view source in tab preference is set
    if(typeof webdeveloper_optionsDataBoolean["webdeveloper.view.source.tab"] != "undefined")
    {
        pageDocument.getElementById("webdeveloper.view.source.tab").checked = webdeveloper_optionsDataBoolean["webdeveloper.view.source.tab"];
    }
    else if(webdeveloper_isPreferenceSet("webdeveloper.view.source.tab"))
    {
        pageDocument.getElementById("webdeveloper.view.source.tab").checked = webdeveloper_getBooleanPreference("webdeveloper.view.source.tab", true);
    }
    else
    {
        pageDocument.getElementById("webdeveloper.view.source.tab").checked = false;
    }

    // If the view source with count preference is set
    if(typeof webdeveloper_optionsDataInteger["webdeveloper.view.source.with.count"] != "undefined")
    {
        viewSourceWithCount = webdeveloper_optionsDataInteger["webdeveloper.view.source.with.count"];
    }
    else if(webdeveloper_isPreferenceSet("webdeveloper.view.source.with.count"))
    {
        viewSourceWithCount = webdeveloper_getIntegerPreference("webdeveloper.view.source.with.count", true);
    }

    // Loop through the possible view source with options
    for(var i = 1; i <= viewSourceWithCount; i++)
    {
	    description = "webdeveloper.view.source.with." + i + ".description";
	    key         = "webdeveloper.view.source.with." + i + ".key";
	    path        = "webdeveloper.view.source.with." + i + ".path";

        // If the description is set
        if(typeof webdeveloper_optionsDataString[description] != "undefined")
        {
            descriptionValue = webdeveloper_optionsDataString[description].trim();
        }
        else if(webdeveloper_isPreferenceSet(description))
        {
	        descriptionValue = webdeveloper_getStringPreference(description, true);
        }
        else
        {
            descriptionValue = null;
        }

        // If the key is set
        if(typeof webdeveloper_optionsDataString[key] != "undefined")
        {
            keyValue = webdeveloper_optionsDataString[key].trim();
        }
        else if(webdeveloper_isPreferenceSet(key))
        {
            keyValue = webdeveloper_getStringPreference(key, true);
        }
        else
        {
            keyValue = null;
        }

        // If the path is set
        if(typeof webdeveloper_optionsDataString[path] != "undefined")
        {
            pathValue = webdeveloper_optionsDataString[path].trim();
        }
        else if(webdeveloper_isPreferenceSet(path))
        {
            pathValue = webdeveloper_getStringPreference(path, true);
        }
        else
        {
            pathValue = null;
        }

        // If the description and path are set
        if(descriptionValue && pathValue)
        {
            listItem = pageDocument.createElement("listitem");
            listCell = pageDocument.createElement("listcell");

            listCell.setAttribute("label", descriptionValue);
            listItem.appendChild(listCell);

            listCell = pageDocument.createElement("listcell");
            listCell.setAttribute("label", pathValue);
            listCell.setAttribute("crop", "end");
            listItem.appendChild(listCell);

            listCell = pageDocument.createElement("listcell");

            // If the key is set
            if(keyValue)
            {
                listCell.setAttribute("label", keyValue);
            }

            listItem.appendChild(listCell);
            viewSourceWithBox.appendChild(listItem);
       }
    }

    webdeveloper_listBoxSelected();
}

// Called whenever a list box is selected
function webdeveloper_listBoxSelected()
{
    var pageDocument   = document.getElementById("webdeveloper-options-iframe").contentDocument;
    var deleteButton   = pageDocument.getElementById("webdeveloper-delete");
    var editButton     = pageDocument.getElementById("webdeveloper-edit");
    var listBox        = pageDocument.getElementById("webdeveloper-listbox");
    var moveDownButton = pageDocument.getElementById("webdeveloper-move-down");
    var moveUpButton   = pageDocument.getElementById("webdeveloper-move-up");
    var selectedIndex  = listBox.selectedIndex;

    // If an item is selected
    if(listBox.selectedItem)
    {
        deleteButton.disabled   = false;
        editButton.disabled     = false;

        // If this is the first item
        if(selectedIndex == 0)
        {
            moveUpButton.disabled = true;
        }
        else
        {
            moveUpButton.disabled = false;
        }

        // If this is the last item
        if(selectedIndex == listBox.getRowCount() - 1)
        {
            moveDownButton.disabled = true;
        }
        else
        {
            moveDownButton.disabled = false;
        }
    }
    else
    {
        deleteButton.disabled   = true;
        editButton.disabled     = true;
        moveDownButton.disabled = true;
        moveUpButton.disabled   = true;
    }
}

// Moves the selected item down
function webdeveloper_moveDown()
{
    var pageDocument  = document.getElementById("webdeveloper-options-iframe").contentDocument;
    var resizeBox     = pageDocument.getElementById("webdeveloper-listbox");
    var selectedItem  = resizeBox.selectedItem;

    // If an item is selected and it is not at the bottom
    if(selectedItem && resizeBox.selectedIndex != resizeBox.getRowCount() - 1)
    {
        resizeBox.selectItem(resizeBox.insertBefore(selectedItem, resizeBox.getNextItem(selectedItem, 2)));
    }
}

// Moves the selected item up
function webdeveloper_moveUp()
{
    var pageDocument  = document.getElementById("webdeveloper-options-iframe").contentDocument;
    var resizeBox     = pageDocument.getElementById("webdeveloper-listbox");
    var selectedItem  = resizeBox.selectedItem;

    // If an item is selected and it is not at the top
    if(selectedItem && resizeBox.selectedIndex != 0)
    {
        resizeBox.selectItem(resizeBox.insertBefore(selectedItem, resizeBox.getPreviousItem(selectedItem, 1)));
    }
}

// Adds a new separator
function webdeveloper_newSeparator()
{
    var pageDocument = document.getElementById("webdeveloper-options-iframe").contentDocument;
    var listItem     = pageDocument.createElement("listitem");
    var separator    = pageDocument.createElement("separator");
    var toolBox      = pageDocument.getElementById("webdeveloper-listbox");

    separator.setAttribute("class", "groove");
    listItem.appendChild(separator);

    separator = pageDocument.createElement("separator");
    separator.setAttribute("class", "groove");
    listItem.appendChild(separator);

    separator = pageDocument.createElement("separator");
    separator.setAttribute("class", "groove");
    listItem.appendChild(separator);

    toolBox.selectItem(toolBox.appendChild(listItem));
    toolBox.ensureElementIsVisible(toolBox.selectedItem);
}

// Resets the user's options
function webdeveloper_resetOptions()
{
    var promptServiceInterface = Components.interfaces.nsIPromptService;
    var stringBundle           = document.getElementById("webdeveloper-string-bundle");

    // If the reset is confirmed
    if(Components.classes["@mozilla.org/embedcomp/prompt-service;1"].getService(promptServiceInterface).confirmEx(null, stringBundle.getString("webdeveloper_resetConfirmation"), stringBundle.getString("webdeveloper_resetConfirmationMessage"), promptServiceInterface.BUTTON_TITLE_YES * promptServiceInterface.BUTTON_POS_0 + promptServiceInterface.BUTTON_TITLE_CANCEL * promptServiceInterface.BUTTON_POS_1, stringBundle.getString("webdeveloper_reset"), null, null, null, {}) == 0)
    {
        webdeveloper_optionsDataBoolean = new Array();
        webdeveloper_optionsDataInteger = new Array();
        webdeveloper_optionsDataString  = new Array();

        webdeveloper_deletePreferenceBranch("webdeveloper.");
        webdeveloper_setStringPreference("webdeveloper.version", webdeveloper_parseVersion("@version@"));

        webdeveloper_configureKeyboardShortcuts(true);
        webdeveloper_setupDefaultOptions();
        webdeveloper_setupLocalizedOptions();
        webdeveloper_initializeOptions(false);
    }
}

// Saves the user's options
function webdeveloper_saveOptions()
{
    var parentWindow = null;
    var option       = null;
    var optionValue  = null;

    // Make sure current page is stored
    webdeveloper_storeOptions();

    // Loop through the boolean options
    for(option in webdeveloper_optionsDataBoolean)
    {
        webdeveloper_setBooleanPreference(option, webdeveloper_optionsDataBoolean[option]);
    }

    // Loop through the integer options
    for(option in webdeveloper_optionsDataInteger)
    {
        optionValue = webdeveloper_optionsDataInteger[option];

        // If the option value is set
        if(optionValue)
        {
            webdeveloper_setIntegerPreference(option, optionValue);
        }
        else if(webdeveloper_isPreferenceSet(option))
        {
            webdeveloper_deletePreference(option);
        }
    }

    // Loop through the string options
    for(option in webdeveloper_optionsDataString)
    {
        optionValue = webdeveloper_optionsDataString[option];

        // If the option value is set or the preference currently has a value
        if(optionValue || webdeveloper_isPreferenceSet(option))
        {
            webdeveloper_setStringPreference(option, optionValue);
        }
    }

    webdeveloper_changeOptions();
    webdeveloper_configureKeyboardShortcuts(false);
}

// Stores the user's options to be saved later
function webdeveloper_storeOptions()
{
    var childNodes   = null;
    var description  = null;
    var i            = 0;
    var iFrame       = document.getElementById("webdeveloper-options-iframe");
    var iFrameSrc    = iFrame.getAttribute("src");
    var key          = null;
    var listCell     = null;
    var listItem     = null;
    var pageDocument = iFrame.contentDocument;
    var path         = null;
    var stringBundle = document.getElementById("webdeveloper-string-bundle");

    // If this is the colors page
    if(iFrameSrc.indexOf("colors_fonts") != -1)
    {
        webdeveloper_optionsDataInteger["webdeveloper.generated.content.font.size"]     = pageDocument.getElementById("webdeveloper.generated.content.font.size").value;
        webdeveloper_optionsDataString["webdeveloper.feature.tooltip.color.background"] = pageDocument.getElementById("webdeveloper.feature.tooltip.color.background").color;
        webdeveloper_optionsDataString["webdeveloper.feature.tooltip.color.border"]     = pageDocument.getElementById("webdeveloper.feature.tooltip.color.border").color;
        webdeveloper_optionsDataString["webdeveloper.feature.tooltip.color.text"]       = pageDocument.getElementById("webdeveloper.feature.tooltip.color.text").color;
        webdeveloper_optionsDataString["webdeveloper.feature.tooltip.opacity"]          = pageDocument.getElementById("webdeveloper.feature.tooltip.opacity").value;
    }
    else if(iFrameSrc.indexOf("dashboard") != -1)
    {
        var updateFrequency = pageDocument.getElementById("webdeveloper.edit.update.frequency").value;

        webdeveloper_optionsDataBoolean["webdeveloper.dom.inspector.dashboard"]     = pageDocument.getElementById("webdeveloper.dom.inspector.dashboard").checked;
        webdeveloper_optionsDataBoolean["webdeveloper.edit.wrap"]                   = pageDocument.getElementById("webdeveloper.edit.wrap").checked;
        webdeveloper_optionsDataBoolean["webdeveloper.error.console.dashboard"]     = pageDocument.getElementById("webdeveloper.error.console.dashboard").checked;
        webdeveloper_optionsDataBoolean["webdeveloper.style.information.dashboard"] = pageDocument.getElementById("webdeveloper.style.information.dashboard").checked;
        webdeveloper_optionsDataInteger["webdeveloper.edit.font.size"]              = pageDocument.getElementById("webdeveloper.edit.font.size").value;
        webdeveloper_optionsDataString["webdeveloper.edit.color.background"]        = pageDocument.getElementById("webdeveloper.edit.color.background").color;
        webdeveloper_optionsDataString["webdeveloper.edit.color.text"]              = pageDocument.getElementById("webdeveloper.edit.color.text").color;

        // If the update frequency is set and is a valid integer and is positive
        if(updateFrequency && parseInt(updateFrequency) == updateFrequency && updateFrequency >= 0)
        {
            webdeveloper_optionsDataInteger["webdeveloper.edit.update.frequency"] = updateFrequency;
        }
        else
        {
            webdeveloper_optionsDataInteger["webdeveloper.edit.update.frequency"] = 0;
        }
    }
    else if(iFrameSrc.indexOf("general") != -1)
    {
        webdeveloper_optionsDataBoolean["webdeveloper.context.hide"]               = pageDocument.getElementById("webdeveloper.context.hide").checked;
        webdeveloper_optionsDataBoolean["webdeveloper.confirmation.dialogs.hide"]  = pageDocument.getElementById("webdeveloper.confirmation.dialogs.hide").checked;
        webdeveloper_optionsDataBoolean["webdeveloper.informational.dialogs.hide"] = pageDocument.getElementById("webdeveloper.informational.dialogs.hide").checked;
        webdeveloper_optionsDataBoolean["webdeveloper.menu.hide"]                  = pageDocument.getElementById("webdeveloper.menu.hide").checked;
        webdeveloper_optionsDataBoolean["webdeveloper.open.tabs"]                  = pageDocument.getElementById("webdeveloper.open.tabs").checked;
        webdeveloper_optionsDataBoolean["webdeveloper.open.tabs.background"]       = pageDocument.getElementById("webdeveloper.open.tabs.background").checked;
        webdeveloper_optionsDataString["webdeveloper.toolbar.icons"]               = pageDocument.getElementById("webdeveloper.toolbar.icons").value;
    }
    else if(iFrameSrc.indexOf("keys") != -1)
    {
        var textBox         = null;
        var textBoxes       = pageDocument.getElementById("webdeveloper-key-rows").getElementsByTagName("textbox");
        var textBoxesLength = textBoxes.length;

        // Loop through the text boxes
        for(i = 0; i < textBoxesLength; i++)
        {
            textBox = textBoxes.item(i);

            webdeveloper_optionsDataString[textBox.getAttribute("id")] = textBox.value.trim();
        }
    }
    else if(iFrameSrc.indexOf("miscellaneous") != -1)
    {
        webdeveloper_optionsDataBoolean["webdeveloper.information.tidy"]                = pageDocument.getElementById("webdeveloper.information.tidy").checked;
        webdeveloper_optionsDataBoolean["webdeveloper.open.css.console.error"]          = pageDocument.getElementById("webdeveloper.open.css.console.error").checked;
        webdeveloper_optionsDataBoolean["webdeveloper.open.javascript.console.warning"] = pageDocument.getElementById("webdeveloper.open.javascript.console.warning").checked;
        webdeveloper_optionsDataBoolean["webdeveloper.open.javascript.console.error"]   = pageDocument.getElementById("webdeveloper.open.javascript.console.error").checked;
        webdeveloper_optionsDataString["webdeveloper.populate.form.fields.email"]       = pageDocument.getElementById("webdeveloper.populate.form.fields.email").value;
    }
    else if(iFrameSrc.indexOf("resize") != -1)
    {
        var height        = null;
        var resizeBox     = pageDocument.getElementById("webdeveloper-listbox");
        var resizeCount   = webdeveloper_getIntegerPreference("webdeveloper.resize.count", true);
        var viewport      = null;
        var viewportValue = false;
        var width         = null;
        var yes           = stringBundle.getString("webdeveloper_yes");

        // Loop through the previous resize options
        for(i = 1; i <= resizeCount; i++)
        {
            description = "webdeveloper.resize." + i + ".description";
            height      = "webdeveloper.resize." + i + ".height";
            width       = "webdeveloper.resize." + i + ".width";

            webdeveloper_optionsDataInteger[height]     = "";
            webdeveloper_optionsDataInteger[width]      = "";
            webdeveloper_optionsDataString[description] = "";
        }

        resizeCount = resizeBox.getRowCount();

        // Loop through the possible resize options
        for(i = 1; i <= resizeCount; i++)
        {
            description   = "webdeveloper.resize." + i + ".description";
            height        = "webdeveloper.resize." + i + ".height";
            listItem      = resizeBox.getItemAtIndex(i - 1);
            childNodes    = listItem.childNodes;
            viewport      = "webdeveloper.resize." + i + ".viewport";
            viewportValue = false;
            width         = "webdeveloper.resize." + i + ".width";

            // If the viewport label is set to yes
            if(listItem.childNodes[3].getAttribute("label") == yes)
            {
                viewportValue = true;
            }

            webdeveloper_optionsDataBoolean[viewport]   = viewportValue;
            webdeveloper_optionsDataInteger[width]      = listItem.childNodes[1].getAttribute("label");
            webdeveloper_optionsDataInteger[height]     = listItem.childNodes[2].getAttribute("label");
            webdeveloper_optionsDataString[description] = listItem.childNodes[0].getAttribute("label").trim();
        }

        webdeveloper_optionsDataInteger["webdeveloper.resize.count"] = resizeCount;
    }
    else if(iFrameSrc.indexOf("tools") != -1)
    {
        var applicationType   = stringBundle.getString("webdeveloper_application");
        var bookmarklet       = null;
        var bookmarkletType   = stringBundle.getString("webdeveloper_bookmarklet");
        var separator         = null;
        var toolBox           = pageDocument.getElementById("webdeveloper-listbox");
        var toolCount         = toolBox.getRowCount();
        var toolPreviousCount = webdeveloper_getIntegerPreference("webdeveloper.tool.count", true);
        var url               = null;

        // Loop through the previous tools
        for(i = 1; i <= toolCount || i <= toolPreviousCount; i++)
        {
            bookmarklet = "webdeveloper.tool." + i + ".bookmarklet";
            description = "webdeveloper.tool." + i + ".description";
            key         = "webdeveloper.tool." + i + ".key";
            path        = "webdeveloper.tool." + i + ".path";
            separator   = "webdeveloper.tool." + i + ".separator";
            url         = "webdeveloper.tool." + i + ".url";

            webdeveloper_optionsDataBoolean[separator]  = false;
            webdeveloper_optionsDataString[bookmarklet] = "";
            webdeveloper_optionsDataString[description] = "";
            webdeveloper_optionsDataString[key]         = "";
            webdeveloper_optionsDataString[path]        = "";
            webdeveloper_optionsDataString[url]         = "";
        }

        // Loop through the possible tools
        for(i = 1; i <= toolCount; i++)
        {
            bookmarklet = "webdeveloper.tool." + i + ".bookmarklet";
            description = "webdeveloper.tool." + i + ".description";
            listItem    = toolBox.getItemAtIndex(i - 1);
            childNodes  = listItem.childNodes;
            listCell    = listItem.childNodes[0];
            key         = "webdeveloper.tool." + i + ".key";
            path        = "webdeveloper.tool." + i + ".path";
            separator   = "webdeveloper.tool." + i + ".separator";
            url         = "webdeveloper.tool." + i + ".url";

            // If the first cell is a separator
            if(listCell.tagName == "separator")
            {
                webdeveloper_optionsDataBoolean[separator] = true;
            }
            else
            {
                webdeveloper_optionsDataString[description] = listCell.getAttribute("label").trim();
                webdeveloper_optionsDataString[key]         = listItem.childNodes[2].getAttribute("label").trim();

                // If the tool type equals application
                if(listCell.getAttribute("type") == applicationType)
                {
                    webdeveloper_optionsDataString[path] = listItem.childNodes[1].getAttribute("label").trim();
                }
                else if(listCell.getAttribute("type") == bookmarkletType)
                {
                    webdeveloper_optionsDataString[bookmarklet] = listItem.childNodes[1].getAttribute("label").trim();
                }
                else
                {
                    webdeveloper_optionsDataString[url] = listItem.childNodes[1].getAttribute("label").trim();
                }
            }
        }

        webdeveloper_optionsDataInteger["webdeveloper.tool.count"] = toolCount;
    }
    else if(iFrameSrc.indexOf("validation") != -1)
    {
        var validateLocalCSSProfile = "css21";

        // If the validate local CSS 3 radio button is selected
        if(pageDocument.getElementById("webdeveloper-validate-local-css3-radio").selected)
        {
            validateLocalCSSProfile = "css3";
        }

        webdeveloper_optionsDataBoolean["webdeveloper.validate.local.accessibility.section508"]    = pageDocument.getElementById("webdeveloper.validate.local.accessibility.section508").checked;
        webdeveloper_optionsDataBoolean["webdeveloper.validate.local.accessibility.wai.priority1"] = pageDocument.getElementById("webdeveloper.validate.local.accessibility.wai.priority1").checked;
        webdeveloper_optionsDataBoolean["webdeveloper.validate.local.accessibility.wai.priority2"] = pageDocument.getElementById("webdeveloper.validate.local.accessibility.wai.priority2").checked;
        webdeveloper_optionsDataBoolean["webdeveloper.validate.local.accessibility.wai.priority3"] = pageDocument.getElementById("webdeveloper.validate.local.accessibility.wai.priority3").checked;
        webdeveloper_optionsDataBoolean["webdeveloper.validate.local.html.show.outline"]           = pageDocument.getElementById("webdeveloper.validate.local.html.show.outline").checked;
        webdeveloper_optionsDataBoolean["webdeveloper.validate.local.html.show.parse.tree"]        = pageDocument.getElementById("webdeveloper.validate.local.html.show.parse.tree").checked;
        webdeveloper_optionsDataBoolean["webdeveloper.validate.local.html.show.source"]            = pageDocument.getElementById("webdeveloper.validate.local.html.show.source").checked;
        webdeveloper_optionsDataString["webdeveloper.validate.local.css.profile"]                  = validateLocalCSSProfile;
    }
    else if(iFrameSrc.indexOf("view_source") != -1)
    {
        var viewSourceWithBox           = pageDocument.getElementById("webdeveloper-listbox");
        var viewSourceWithCount         = viewSourceWithBox.getRowCount();
        var viewSourceWithPreviousCount = webdeveloper_getIntegerPreference("webdeveloper.view.source.with.count", true);

        // Loop through the previous view source with options
        for(i = 1; i <= viewSourceWithCount || i <= viewSourceWithPreviousCount; i++)
        {
            description = "webdeveloper.view.source.with." + i + ".description";
            key         = "webdeveloper.view.source.with." + i + ".key";
            path        = "webdeveloper.view.source.with." + i + ".path";

            webdeveloper_optionsDataString[description] = "";
            webdeveloper_optionsDataString[key]         = "";
            webdeveloper_optionsDataString[path]        = "";
        }

        // Loop through the possible view source with options
        for(i = 1; i <= viewSourceWithCount; i++)
        {
            description = "webdeveloper.view.source.with." + i + ".description";
            listItem    = viewSourceWithBox.getItemAtIndex(i - 1);
            childNodes  = listItem.childNodes;
            key         = "webdeveloper.view.source.with." + i + ".key";
            path        = "webdeveloper.view.source.with." + i + ".path";

            webdeveloper_optionsDataString[description] = listItem.childNodes[0].getAttribute("label").trim();
            webdeveloper_optionsDataString[key]         = listItem.childNodes[2].getAttribute("label").trim();
            webdeveloper_optionsDataString[path]        = listItem.childNodes[1].getAttribute("label").trim();
        }

        webdeveloper_optionsDataBoolean["webdeveloper.view.source.tab"]        = pageDocument.getElementById("webdeveloper.view.source.tab").checked;
        webdeveloper_optionsDataInteger["webdeveloper.view.source.with.count"] = viewSourceWithCount;
    }
}

// Returns the index of the given page name
function webdeveloper_translatePageNameToIndex(pageName)
{
    // If the page name is set
    if(pageName)
    {
        // Switch on the page name
        switch(pageName)
        {
            case "general":
                return 0;
            case "colors-fonts":
                return 1;
            case "dashboard":
                return 2;
            case "keys":
                return 3;
            case "miscellaneous":
                return 4;
            case "resize":
                return 5;
            case "tools":
                return 6;
            case "validation":
                return 7;
            case "view-source":
                return 8;
            default:
                return 0;
        }
    }

    return 0;
}

// Updates the tab option status
function webdeveloper_updateTabOptionStatus()
{
    var disabled     = true;
    var pageDocument = document.getElementById("webdeveloper-options-iframe").contentDocument;

    // If open tabs is checked
    if(pageDocument.getElementById("webdeveloper.open.tabs").checked)
    {
        disabled = false;
    }

    pageDocument.getElementById("webdeveloper.open.tabs.background").disabled = disabled;
}