#!/bin/bash

LOCKFILE=/tmp/.toggle_wbar.sh.lock

LAUNCHER_SWITCH=0
if [ -f "$HOME/.launcher" ];then
    LAUNCHER_SWITCH=`cat ~/.launcher`
fi


if [ $LAUNCHER_SWITCH = 1 ];then
    sleep 1

    NETBOOKLAUNCHER=$(pidof netbook-launcher-efl )
    echo $NETBOOKLAUNCHER
    if [ "$NETBOOKLAUNCHER" != "" ]; then
	if [ -e $LOCKFILE ]; then
	    exit
	fi
	touch $LOCKFILE
	zenity --info --title="Wbarランチャーの表示／非表示切り替え" --text="Netbookランチャーが動作しています。\n一度ログアウトしてください。"
	rm $LOCKFILE
	exit
    fi

    WBARP=$(pidof wbar)
    echo $WBARP
    if [ "$WBARP" != "" ]; then
	kill -9 $WBARP
    else
	wbar -above-desk -pos center -isize 105 -idist 15 -nanim 1 -zoomf 1.5 -jumpf 1.7 &
    fi
else
    if [ -e $LOCKFILE ]; then
	exit
    fi
    touch $LOCKFILE
    zenity --info --title="Wbarランチャーの表示／非表示切り替え" --text="Wbarランチャーは選択されていません。"
    rm $LOCKFILE
fi

