/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * main.c
 * Copyright (C) a 2009 <a@a>
 * 
 * main.c is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * main.c is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>

#include <config.h>

#include <gtk/gtk.h>
#include <glade/glade.h>

#include <gconf/gconf-client.h>
#include <gconf/gconf-value.h>

/*
 * Standard gettext macros.
 */
#ifdef ENABLE_NLS
#  include <libintl.h>
#  undef _
#  define _(String) dgettext (PACKAGE, String)
#  ifdef gettext_noop
#    define N_(String) gettext_noop (String)
#  else
#    define N_(String) (String)
#  endif
#else
#  define textdomain(String) (String)
#  define gettext(String) (String)
#  define dgettext(Domain,Message) (Message)
#  define dcgettext(Domain,Message,Type) (Message)
#  define bindtextdomain(Domain,Directory) (Domain)
#  define _(String) (String)
#  define N_(String) (String)
#endif



#include "callbacks.h"
#include "common.h"

/* For testing propose use the local (not installed) glade file */
#if 1
#define GLADE_FILE "/usr/share/wallpaper_select/glade/wallpaper_select.glade"
#else
#define GLADE_FILE "/home/fukuroi/work/wallpaper-select/wallpaper-select/src/wallpaper_select.glade"
#endif

//******************************
// Structer/Variables
//******************************
typedef struct _IconviewManager	IconviewManager;

struct _IconviewManager {
	gchar *model_name;
	gchar *wp_name;
};

IconviewManager *iconview_mng;
gint wp_num = 0;
gchar *default_wp = NULL;

gint
find_iconview_index(gchar *model)
{
	gint i, ret = -1;

	for( i = 0; i < wp_num; i ++ )
	{
		if( strcmp(model, iconview_mng[i].model_name) == 0 ){
			ret = i;
			break;
		}
	}
	return ret;
}

gboolean
update_gconf (gchar *theme)
{
	gboolean result = FALSE;
	gint index = 0;

	g_print ("update_gconf() start\n");

	index = find_iconview_index(theme);
	if ( (index == -1) || (index >= wp_num))
	{
		g_print ("It is skin besides the selection range.\n");
		return result;
	}

	/* set wallpaper */
	result = set_gconf_sub_string (WS_SOURCE_SCHEME_WP_FILE, iconview_mng[index].wp_name);
	result = set_gconf_sub_string (WS_SOURCE_SCHEME_WP_OPT, WS_WP_OPT_VALUE);
	
	g_print ("update_gconf() end\n");
	return result;
}

static void
select_iconview_iter (GtkIconView *icon_view, GtkTreeIter *iter)
{
	GtkTreePath *path;

	path = gtk_tree_model_get_path (gtk_icon_view_get_model (icon_view), iter);
	gtk_icon_view_select_path (icon_view, path);
	gtk_icon_view_scroll_to_path (icon_view, path, FALSE, 0.5, 0.0);
	gtk_tree_path_free (path);
}

void
select_gconf_wp (GtkIconView *icon_view)
{
	GtkTreeModel *model;
	GtkListStore *icon_model = (GtkListStore*)NULL;
	GtkTreeIter iter, iter_bk, iter_default;
	gboolean default_valid = FALSE;
	gchar *wp_name;
	gchar *name;
	gint i, index = -1;

	wp_name = get_gconf_sub_string(WS_SOURCE_SCHEME_WP_FILE);
	g_print ("select_gconf_wp() gconf wallpeper[%s]\n", wp_name);
	
	model = gtk_icon_view_get_model (icon_view);
	icon_model = GTK_LIST_STORE(gtk_icon_view_get_model (icon_view));

	for (i = 0; gtk_tree_model_iter_nth_child (model, &iter, NULL, i); i++)
	{
		iter_bk = iter;
	
		gtk_tree_model_get (model, &iter, COL_NAME, &name, -1);
		index = find_iconview_index(name);
		g_free (name);
		if ( index == -1 )
		{
			continue;
		}
		if ( strcmp(iconview_mng[index].model_name, default_wp) == 0 ){
			iter_default = iter;
			default_valid = TRUE;
		}
		if ( (wp_name != NULL) &&
		     (strcmp(iconview_mng[index].wp_name, wp_name) == 0) ){
			break;
		}
	}

	if ( (wp_name != NULL) &&
	     (strcmp(iconview_mng[index].wp_name, wp_name) == 0) ){
		g_print ("select_gconf_wp() choice wallpaper umber[%d]\n", index);
		select_iconview_iter(icon_view, &iter_bk);
	}
	else
	{
		g_print ("select_gconf_wp() wallpaper nothing.\n");
		if ( default_valid == TRUE )
		{
			select_iconview_iter(icon_view, &iter_default);
		}
		else
		{
			g_print ("select_gconf_wp() default_wp nothing.\n");
		}
	}

	if ( wp_name != NULL )
	{
		g_free (wp_name);
	}
}

GtkWidget*
create_dialog (void)
{
	gxml = glade_xml_new (GLADE_FILE, NULL, NULL);
	
	/* This is important */
	glade_xml_signal_autoconnect (gxml);
	dialog = glade_xml_get_widget(gxml, "dialog1");
	
	g_print ("create_dialog() dialog[%x]\n",(guint)dialog);
	
	g_signal_connect (dialog,
			  "destroy",
			  G_CALLBACK (destroy),
			  &dialog);
	
	return dialog;
}

static GtkWidget*
set_iconview_model (void)
{
	GtkWidget *icon_view = (GtkWidget*)NULL;
	GtkListStore *icon_model = (GtkListStore*)NULL;

	g_print ("set_iconview_model() start\n");

	icon_view = glade_xml_get_widget (gxml, "iconview1");
	g_print ("main() icon_view[%x]\n",(guint)icon_view);
	icon_model = gtk_list_store_new(2, GDK_TYPE_PIXBUF, G_TYPE_STRING); 
	gtk_icon_view_set_model(GTK_ICON_VIEW(icon_view), GTK_TREE_MODEL(icon_model));

	gtk_icon_view_set_pixbuf_column (GTK_ICON_VIEW(icon_view), COL_PIXBUF1);
	gtk_icon_view_set_text_column (GTK_ICON_VIEW(icon_view), COL_NAME);
	gtk_icon_view_set_item_width (GTK_ICON_VIEW(icon_view), WS_ICON_WIDTH);

	g_print ("set_iconview_model() end\n");

	return icon_view;
}

static void
add_iconview_data (GtkIconView *icon_view, 
                   GtkListStore	*icon_model, gchar *model_name, gchar *wp_name, GtkTreeIter *iter)
{
	GdkPixbuf *pixbuf1 = (GdkPixbuf*)NULL;

	g_print ("add_iconview_data() start\n");
	g_print ("add_iconview_data() icon_view[%x]\n",(guint)icon_view);
	g_print ("add_iconview_data() icon_model[%x]\n",(guint)icon_model);
	g_print ("add_iconview_data() model_name[%s]\n",model_name);
	g_print ("add_iconview_data() wp_name[%s]\n",wp_name);
	g_print ("add_iconview_data() iter[%x]\n",(guint)iter);

	pixbuf1 = gdk_pixbuf_new_from_file_at_size (wp_name, WS_PICT_WIDTH, WS_PICT_HEIGHT, NULL);

	gtk_list_store_append (icon_model, iter);
	gtk_list_store_set (icon_model, iter, COL_PIXBUF1, pixbuf1, COL_NAME, model_name, -1);
	
	g_print ("add_iconview_data() end\n");
}

static void
set_iconview_data (GtkIconView *icon_view)
{
	GtkListStore *icon_model = (GtkListStore*)NULL;
	GtkTreeIter	iter;
	gint icnt = (gint)0;
	
	g_print ("set_iconview_data() start\n");
	g_print ("set_iconview_data() icon_view[%x]\n",(guint)icon_view);

	/* read image file */
	icon_model = GTK_LIST_STORE(gtk_icon_view_get_model (icon_view));
	gtk_list_store_clear (icon_model);

	for (icnt=0; icnt<wp_num; icnt++)
	{
		g_print ("set_iconview_data() model_name[%s]\n",iconview_mng[icnt].model_name);
		g_print ("set_iconview_data() wp_name[%s]\n",iconview_mng[icnt].wp_name);
		add_iconview_data (icon_view, icon_model, iconview_mng[icnt].model_name, iconview_mng[icnt].wp_name, &iter);
	}
	g_print ("set_iconview_data() end\n");
}

gboolean
image_load(void)
{
	FILE *fp;
	gchar buf[256], *p, **split;
	gint i;
	gboolean ret = TRUE;

	g_print ("image_load() start\n");

	fp = fopen (WS_SOURCE_CFG_FILE, "r");
	if( fp == NULL ){
		g_print ("[%s] open error.\n", WS_SOURCE_CFG_FILE);
		return FALSE;
	}

	if( fgets (buf, sizeof(buf), fp) == NULL ){
		g_print ("num read error.\n");
		return FALSE;
	}
	wp_num = atoi (buf);
	if (wp_num > WS_SKIN_MAX )
	{
		wp_num = WS_SKIN_MAX;
	}
	iconview_mng = g_malloc0 (sizeof(IconviewManager)*wp_num);

	if( fgets (buf, sizeof(buf), fp) == NULL ){
		g_print ("default read error.\n");
		return FALSE;
	}
	p = g_strchomp (buf);
	default_wp = strdup ((const gchar*)p);

	for ( i = 0; i < wp_num; i++ ){
		if ( fgets (buf, sizeof(buf), fp) == NULL ){
			g_print ("config it ends on the way.\n");
			ret = FALSE;
			break;
		}
		p = g_strchomp (buf);
		split = g_strsplit(p, ",", 0);

		/* model name */
		iconview_mng[i].model_name = g_strconcat (split[0], NULL);
		
		/* wall paper png */
		iconview_mng[i].wp_name = g_strconcat (WS_PICT_BASE_PATH, "/", split[1], NULL);

		g_strfreev(split);
	}
	fclose(fp);

	g_print ("image_load() end\n");
	return ret;
}

void
image_free(void)
{
	gint i;

	g_print ("image_free() start\n");

	for( i = 0; i < wp_num; i++ ){
		if ( iconview_mng[i].model_name != NULL )
		{
			g_free (iconview_mng[i].model_name);
		}
		if ( iconview_mng[i].wp_name != NULL )
		{
			g_free (iconview_mng[i].wp_name);
		}
	}
	g_free (iconview_mng);
	
	if ( default_wp != NULL )
	{
		g_free (default_wp);
	}

	g_print ("image_free() end\n");
}

void
ws_term(void)
{
	gchar *url, command[256];
	int ret;
	
	url = g_build_filename (g_get_home_dir (), WS_SOURCE_ATSTART_PATH, NULL);
	sprintf (command, "mkdir -p %s", url);
	g_free (url);

	g_print ("ws_term() mkdir [%s]\n", command);
	ret = system (command);
	if ( ret == -1 )
	{
		g_print ("ws_term() mkdir failed.");
	}
	else
	{
		url = g_build_filename (g_get_home_dir (), WS_SOURCE_ATSTART_PATH, "/", WS_SOURCE_ATSTART_FILE, NULL);
		sprintf (command, "cp %s %s", WS_SOURCE_DESKTOP_FILE, url);
		g_free (url);

		g_print ("ws_term() cp [%s]\n", command);
		ret = system (command);
		if ( ret == -1 )
		{
			g_print ("ws_term() cp failed.");
		}
	}
}

int
main (int argc, char *argv[])
{
#ifdef ENABLE_NLS
	bindtextdomain (GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
#endif

	gtk_set_locale ();
	gtk_init (&argc, &argv);

	gconf_manager_init();
	image_load();
	dialog = create_dialog ();

	icon_view = set_iconview_model ();
	set_iconview_data (GTK_ICON_VIEW(icon_view));
	select_gconf_wp (GTK_ICON_VIEW(icon_view));
	
	gtk_widget_show (dialog);

	gtk_main ();

	image_free();
//	ws_term ();
	
	return 0;
}
