#include "common.h"

GConfClient *gconf_client;

void
gconf_manager_init (void)
{
	g_print ("gconf_manager_init() start\n");
	gconf_client = gconf_client_get_default ();
	g_print ("gconf_manager_init() end\n");
}

gboolean
set_gconf_sub_string (gchar* key, const gchar *str)
{
	gchar *gconf_str = (gchar*)NULL;

	g_print ("update_gconf_sub_string() start\n");
	g_print ("update_gconf_sub_string() gxml[%x]\n",(guint)gxml);

	gconf_str = gconf_client_get_string(gconf_client, key, NULL);

	g_print ("update_gconf_sub_string() key[%s]\n",key);
	g_print ("update_gconf_sub_string() str[%s]\n",str);

	if ( (gconf_str != NULL) && (strcmp (gconf_str, str) != 0) )
	{
		/* Set File-Path to Gconf-Value */
		gconf_client_set_string(gconf_client, key, str, NULL);
	}

	if ( gconf_str != NULL )
	{
		g_free (gconf_str);
	}
	g_print ("update_gconf_sub_string() end\n");
	return TRUE;
}

gchar*
get_gconf_sub_string (gchar* key)
{
	gchar *gconf_str = (gchar*)NULL;

	g_print ("get_gconf_sub_string() start\n");
	g_print ("get_gconf_sub_string() gxml[%x]\n",(guint)gxml);

	gconf_str = gconf_client_get_string(gconf_client, key, NULL);

	g_print ("get_gconf_sub_string() key[%s]\n",key);
	g_print ("get_gconf_sub_string() str[%s]\n",gconf_str);

	g_print ("get_gconf_sub_string() end\n");

	return gconf_str;
}
