/* Copyright 2011 Canonical, Ltd. This software is licensed under the GNU
 * Lesser General Public License version 3 or later (see the file COPYING).
 */

#ifndef UTOUCH_QML_CONTINUOUSGESTUREAREA_H_
#define UTOUCH_QML_CONTINUOUSGESTUREAREA_H_

#include <QDeclarativeItem>

#include "gesturearea.h"

class ContinuousGestureArea : public GestureArea {
  Q_OBJECT

  /**
   * This property denotes whether the gesture is currently active.
   *
   * The value is set to true after onGestureStart is emitted, and set to false
   * before onGestureEnd is emitted.
   */
  Q_PROPERTY(bool active READ active NOTIFY activeChanged)

 public:
  ContinuousGestureArea() {}    /* To satisfy QML */
  ContinuousGestureArea(QDeclarativeItem* parent, Primitive primitive);

  bool active() const { return active_; }

  virtual bool IsGestureEventHandled(GestureEvent* event);
  virtual void HandleGestureUpdateEvent(bool end, GestureEvent* event);

 signals:
  void activeChanged();

  /**
   * This handler is called when a gesture starts.
   *
   * The gesture parameter provides information about the gesture.
   *
   * If the accepted property of the GestureEvent parameter is set to false in
   * the handler, the gesture is rejected and no further signals will be emitted
   * for the gesture. The accepted property defaults to true.
   */
  void gestureStart(GestureEvent* gesture);

  /**
   * This handler is called when a gesture is updated.
   *
   * The gesture parameter provides information about the gesture.
   *
   * The accepted property of the GestureEvent parameter is ignored in this
   * handler.
   */
  void gestureUpdate(GestureEvent* gesture);

  /**
   * This handler is called when a gesture ends.
   *
   * The gesture parameter provides information about the gesture.
   *
   * The accepted property of the GestureEvent parameter is ignored in this
   * handler.
   */
  void gestureEnd(GestureEvent* gesture);

 private:
  bool active_;

  Q_DISABLE_COPY(ContinuousGestureArea)
};

QML_DECLARE_TYPE(ContinuousGestureArea)

#endif  // UTOUCH_QML_CONTINUOUSGESTUREAREA_H_
