// Returns the content document from a page load event
function useragentswitcher_getPageLoadEventContentDocument(event)
{
    // Try to get the event targets
    try
    {
        var eventTarget    = event.target;
        var originalTarget = event.originalTarget;
    
        // If the event targets are set and the original target is the document or the event target is the browser
        if(eventTarget && originalTarget && (originalTarget.nodeName == "#document" || eventTarget == getBrowser()))
        {
            var contentDocument = eventTarget.contentDocument;

            // If the content document is not set and the original target default view parent is set
            if(!contentDocument && originalTarget.defaultView && originalTarget.defaultView.parent)
            {
                contentDocument = originalTarget.defaultView.parent.document;
            }

            // If the content document is set and has the same URI as the original target
            if(contentDocument && contentDocument.documentURI == originalTarget.documentURI)
            {
                return contentDocument;
            }
        }
    }
    catch(exception)
    {
        // Do nothing
    }
    
    return null;
}
