/* webapp-fetcher.c generated by valac 0.10.0, the Vala compiler
 * generated from webapp-fetcher.vala, do not modify */

/*
 * Copyright (C) 2010 Canonical, Ltd.
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License
 * version 3.0 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3.0 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see
 * <http://www.gnu.org/licenses/>.
 *
 * Authored by Gordon Allott <gord.allott@canonical.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gee.h>
#include <gdk-pixbuf/gdk-pixdata.h>
#include <clutter/clutter.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define UNITY_WEBAPP_TYPE_FETCH_FILE (unity_webapp_fetch_file_get_type ())
#define UNITY_WEBAPP_FETCH_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_WEBAPP_TYPE_FETCH_FILE, UnityWebappFetchFile))
#define UNITY_WEBAPP_FETCH_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_WEBAPP_TYPE_FETCH_FILE, UnityWebappFetchFileClass))
#define UNITY_WEBAPP_IS_FETCH_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_WEBAPP_TYPE_FETCH_FILE))
#define UNITY_WEBAPP_IS_FETCH_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_WEBAPP_TYPE_FETCH_FILE))
#define UNITY_WEBAPP_FETCH_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_WEBAPP_TYPE_FETCH_FILE, UnityWebappFetchFileClass))

typedef struct _UnityWebappFetchFile UnityWebappFetchFile;
typedef struct _UnityWebappFetchFileClass UnityWebappFetchFileClass;
typedef struct _UnityWebappFetchFilePrivate UnityWebappFetchFilePrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_byte_array_free0(var) ((var == NULL) ? NULL : (var = (g_byte_array_free (var, TRUE), NULL)))
typedef struct _UnityWebappFetchFileFetchDataData UnityWebappFetchFileFetchDataData;
typedef struct _UnityWebappFetchFileReadSomethingAsyncData UnityWebappFetchFileReadSomethingAsyncData;
#define _g_match_info_free0(var) ((var == NULL) ? NULL : (var = (g_match_info_free (var), NULL)))

#define UNITY_WEBAPP_TYPE_WEBICON_FETCHER (unity_webapp_webicon_fetcher_get_type ())
#define UNITY_WEBAPP_WEBICON_FETCHER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_WEBAPP_TYPE_WEBICON_FETCHER, UnityWebappWebiconFetcher))
#define UNITY_WEBAPP_WEBICON_FETCHER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_WEBAPP_TYPE_WEBICON_FETCHER, UnityWebappWebiconFetcherClass))
#define UNITY_WEBAPP_IS_WEBICON_FETCHER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_WEBAPP_TYPE_WEBICON_FETCHER))
#define UNITY_WEBAPP_IS_WEBICON_FETCHER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_WEBAPP_TYPE_WEBICON_FETCHER))
#define UNITY_WEBAPP_WEBICON_FETCHER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_WEBAPP_TYPE_WEBICON_FETCHER, UnityWebappWebiconFetcherClass))

typedef struct _UnityWebappWebiconFetcher UnityWebappWebiconFetcher;
typedef struct _UnityWebappWebiconFetcherClass UnityWebappWebiconFetcherClass;
typedef struct _UnityWebappWebiconFetcherPrivate UnityWebappWebiconFetcherPrivate;
#define _g_key_file_free0(var) ((var == NULL) ? NULL : (var = (g_key_file_free (var), NULL)))

#define UNITY_TYPE_SHELL (unity_shell_get_type ())
#define UNITY_SHELL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_TYPE_SHELL, UnityShell))
#define UNITY_IS_SHELL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_TYPE_SHELL))
#define UNITY_SHELL_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), UNITY_TYPE_SHELL, UnityShellIface))

typedef struct _UnityShell UnityShell;
typedef struct _UnityShellIface UnityShellIface;

#define UNITY_TYPE_SHELL_MODE (unity_shell_mode_get_type ())

#define UNITY_TYPE_WINDOW_ACTION (unity_window_action_get_type ())

struct _UnityWebappFetchFile {
	GObject parent_instance;
	UnityWebappFetchFilePrivate * priv;
};

struct _UnityWebappFetchFileClass {
	GObjectClass parent_class;
};

struct _UnityWebappFetchFilePrivate {
	char* _uri;
	GDataInputStream* stream;
	GFile* file;
	GByteArray* data;
};

struct _UnityWebappFetchFileFetchDataData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	UnityWebappFetchFile* self;
	GFileInputStream* _tmp0_;
	GFileInputStream* _tmp1_;
	GDataInputStream* _tmp2_;
	GError * e;
	GError * _inner_error_;
};

struct _UnityWebappFetchFileReadSomethingAsyncData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	UnityWebappFetchFile* self;
	gssize size;
	guint8* buffer;
	gint buffer_length1;
	gint _buffer_size_;
	guint8* _tmp0_;
	gssize bufsize;
	gboolean _tmp1_;
	gssize _tmp2_;
	guint8* cpybuf;
	gint cpybuf_length1;
	gint _cpybuf_size_;
	guint8* _tmp3_;
	GError * e;
	GError * _inner_error_;
};

struct _UnityWebappWebiconFetcher {
	GObject parent_instance;
	UnityWebappWebiconFetcherPrivate * priv;
};

struct _UnityWebappWebiconFetcherClass {
	GObjectClass parent_class;
};

struct _UnityWebappWebiconFetcherPrivate {
	char* _uri;
	char* _destination;
	char* _desktop_location;
	UnityWebappFetchFile* fetcher;
	gboolean html_phase;
	gboolean icon_phase;
	GeeList* icon_uris;
};

typedef enum  {
	UNITY_SHELL_MODE_MINIMIZED,
	UNITY_SHELL_MODE_DASH,
	UNITY_SHELL_MODE_EXPOSE
} UnityShellMode;

typedef enum  {
	UNITY_WINDOW_ACTION_CLOSE,
	UNITY_WINDOW_ACTION_MINIMIZE,
	UNITY_WINDOW_ACTION_MAXIMIZE,
	UNITY_WINDOW_ACTION_UNMAXIMIZE
} UnityWindowAction;

struct _UnityShellIface {
	GTypeInterface parent_iface;
	guint32 (*get_current_time) (UnityShell* self);
	UnityShellMode (*get_mode) (UnityShell* self);
	ClutterStage* (*get_stage) (UnityShell* self);
	void (*show_unity) (UnityShell* self);
	void (*hide_unity) (UnityShell* self);
	gint (*get_indicators_width) (UnityShell* self);
	gint (*get_launcher_width_foobar) (UnityShell* self);
	gint (*get_panel_height_foobar) (UnityShell* self);
	void (*ensure_input_region) (UnityShell* self);
	void (*add_fullscreen_request) (UnityShell* self, GObject* o);
	gboolean (*remove_fullscreen_request) (UnityShell* self, GObject* o);
	void (*grab_keyboard) (UnityShell* self, gboolean grab, guint32 timestamp);
	void (*about_to_show_places) (UnityShell* self);
	void (*close_xids) (UnityShell* self, GArray* xids);
	void (*show_window) (UnityShell* self, guint32 xid);
	void (*expose_xids) (UnityShell* self, GArray* xids);
	void (*stop_expose) (UnityShell* self);
	void (*get_window_details) (UnityShell* self, guint32 xid, gboolean* allows_resize, gboolean* is_maximised);
	void (*do_window_action) (UnityShell* self, guint32 xid, UnityWindowAction action);
	gboolean (*get_menus_swallow_events) (UnityShell* self);
	gboolean (*get_super_key_active) (UnityShell* self);
	void (*set_super_key_active) (UnityShell* self, gboolean value);
	gboolean (*get_is_starting) (UnityShell* self);
	void (*set_is_starting) (UnityShell* self, gboolean value);
};


static gpointer unity_webapp_fetch_file_parent_class = NULL;
extern GRegex* unity_webapp_primary_match_prefix;
GRegex* unity_webapp_primary_match_prefix = NULL;
extern GRegex* unity_webapp_primary_match_suffix;
GRegex* unity_webapp_primary_match_suffix = NULL;
extern GRegex* unity_webapp_secondary_match_prefix;
GRegex* unity_webapp_secondary_match_prefix = NULL;
extern GRegex* unity_webapp_secondary_match_suffix;
GRegex* unity_webapp_secondary_match_suffix = NULL;
extern GRegex* unity_webapp_hostname_match;
GRegex* unity_webapp_hostname_match = NULL;
extern UnityShell* unity_global_shell;
static gpointer unity_webapp_webicon_fetcher_parent_class = NULL;

#define apple_string "rel=\"apple-touch-icon\""
#define fav_string "rel=\"(icon|SHORTCUT ICON|shortcut icon|ICON)\""
#define uri_match_string "href=\"(?P<icon_uri>[^\"]*)\""
#define tag_start_string "<link[^>]*"
#define tag_end_string "[^>]*/?>"
#define hostname_string "(s)?http://(?P<hostname>.*)(/|$)"
char* unity_webapp_urlify (const char* uri);
GType unity_webapp_fetch_file_get_type (void) G_GNUC_CONST;
#define UNITY_WEBAPP_FETCH_FILE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), UNITY_WEBAPP_TYPE_FETCH_FILE, UnityWebappFetchFilePrivate))
enum  {
	UNITY_WEBAPP_FETCH_FILE_DUMMY_PROPERTY,
	UNITY_WEBAPP_FETCH_FILE_URI
};
UnityWebappFetchFile* unity_webapp_fetch_file_new (const char* uri);
UnityWebappFetchFile* unity_webapp_fetch_file_construct (GType object_type, const char* uri);
static void unity_webapp_fetch_file_fetch_data_data_free (gpointer _data);
static void unity_webapp_fetch_file_fetch_data_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void unity_webapp_fetch_file_fetch_data (UnityWebappFetchFile* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void unity_webapp_fetch_file_fetch_data_finish (UnityWebappFetchFile* self, GAsyncResult* _res_);
static gboolean unity_webapp_fetch_file_fetch_data_co (UnityWebappFetchFileFetchDataData* data);
static void unity_webapp_fetch_file_read_something_async (UnityWebappFetchFile* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void unity_webapp_fetch_file_read_something_finish (UnityWebappFetchFile* self, GAsyncResult* _res_);
static void unity_webapp_fetch_file_read_something_async_data_free (gpointer _data);
static void unity_webapp_fetch_file_read_something_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean unity_webapp_fetch_file_read_something_async_co (UnityWebappFetchFileReadSomethingAsyncData* data);
const char* unity_webapp_fetch_file_get_uri (UnityWebappFetchFile* self);
static void unity_webapp_fetch_file_set_uri (UnityWebappFetchFile* self, const char* value);
static GObject * unity_webapp_fetch_file_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void unity_webapp_fetch_file_finalize (GObject* obj);
static void unity_webapp_fetch_file_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void unity_webapp_fetch_file_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
char* unity_webapp_get_hostname (const char* uri);
GType unity_webapp_webicon_fetcher_get_type (void) G_GNUC_CONST;
#define UNITY_WEBAPP_WEBICON_FETCHER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), UNITY_WEBAPP_TYPE_WEBICON_FETCHER, UnityWebappWebiconFetcherPrivate))
enum  {
	UNITY_WEBAPP_WEBICON_FETCHER_DUMMY_PROPERTY,
	UNITY_WEBAPP_WEBICON_FETCHER_URI,
	UNITY_WEBAPP_WEBICON_FETCHER_DESTINATION,
	UNITY_WEBAPP_WEBICON_FETCHER_DESKTOP_LOCATION
};
UnityWebappWebiconFetcher* unity_webapp_webicon_fetcher_new (const char* uri, const char* destination, const char* desktop_file);
UnityWebappWebiconFetcher* unity_webapp_webicon_fetcher_construct (GType object_type, const char* uri, const char* destination, const char* desktop_file);
static void unity_webapp_webicon_fetcher_set_desktop_file_icon (UnityWebappWebiconFetcher* self, const char* iconname);
const char* unity_webapp_webicon_fetcher_get_desktop_location (UnityWebappWebiconFetcher* self);
void unity_webapp_webicon_fetcher_fetch_webapp_data (UnityWebappWebiconFetcher* self);
const char* unity_webapp_webicon_fetcher_get_uri (UnityWebappWebiconFetcher* self);
static void _lambda5_ (UnityWebappWebiconFetcher* self);
static void __lambda5__unity_webapp_fetch_file_failed (UnityWebappFetchFile* _sender, gpointer self);
static void unity_webapp_webicon_fetcher_on_fetcher_completed (UnityWebappWebiconFetcher* self, GByteArray* data);
static void _unity_webapp_webicon_fetcher_on_fetcher_completed_unity_webapp_fetch_file_completed (UnityWebappFetchFile* _sender, GByteArray* data, gpointer self);
static GeePriorityQueue* unity_webapp_webicon_fetcher_extract_icon_from_html (UnityWebappWebiconFetcher* self, const char* html, gboolean preferred);
static void unity_webapp_webicon_fetcher_attempt_fetch_icon (UnityWebappWebiconFetcher* self);
const char* unity_webapp_webicon_fetcher_get_destination (UnityWebappWebiconFetcher* self);
static gboolean _lambda7_ (UnityWebappWebiconFetcher* self);
GType unity_shell_mode_get_type (void) G_GNUC_CONST;
GType unity_window_action_get_type (void) G_GNUC_CONST;
GType unity_shell_get_type (void) G_GNUC_CONST;
static gboolean __lambda7__gsource_func (gpointer self);
static void unity_webapp_webicon_fetcher_on_fetcher_failed (UnityWebappWebiconFetcher* self);
static void _lambda6_ (UnityWebappWebiconFetcher* self);
static void __lambda6__unity_webapp_fetch_file_failed (UnityWebappFetchFile* _sender, gpointer self);
static void unity_webapp_webicon_fetcher_set_uri (UnityWebappWebiconFetcher* self, const char* value);
static void unity_webapp_webicon_fetcher_set_destination (UnityWebappWebiconFetcher* self, const char* value);
static void unity_webapp_webicon_fetcher_set_desktop_location (UnityWebappWebiconFetcher* self, const char* value);
static GObject * unity_webapp_webicon_fetcher_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void unity_webapp_webicon_fetcher_finalize (GObject* obj);
static void unity_webapp_webicon_fetcher_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void unity_webapp_webicon_fetcher_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static int _vala_strcmp0 (const char * str1, const char * str2);



char* unity_webapp_urlify (const char* uri) {
	char* result = NULL;
	char* return_string;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (uri != NULL, NULL);
	return_string = g_uri_unescape_string (uri, NULL);
	{
		GRegex* regex;
		char* _tmp0_;
		char* _tmp1_;
		regex = g_regex_new ("^[ \\\\]+|[ \\\\]+$", 0, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch42_g_regex_error;
			}
			_g_free0 (return_string);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp0_ = g_regex_replace (regex, return_string, (gssize) (-1), 0, "_", 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch42_g_regex_error;
			}
			_g_regex_unref0 (regex);
			_g_free0 (return_string);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		return_string = (_tmp1_ = _tmp0_, _g_free0 (return_string), _tmp1_);
		_g_regex_unref0 (regex);
	}
	goto __finally42;
	__catch42_g_regex_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("webapp-fetcher.vala:38: %s", e->message);
			_g_error_free0 (e);
		}
	}
	__finally42:
	if (_inner_error_ != NULL) {
		_g_free0 (return_string);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	{
		GRegex* regex;
		char* _tmp2_;
		char* _tmp3_;
		regex = g_regex_new ("^.*?://", 0, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch43_g_regex_error;
			}
			_g_free0 (return_string);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp2_ = g_regex_replace (regex, return_string, (gssize) (-1), 0, "", 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch43_g_regex_error;
			}
			_g_regex_unref0 (regex);
			_g_free0 (return_string);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		return_string = (_tmp3_ = _tmp2_, _g_free0 (return_string), _tmp3_);
		_g_regex_unref0 (regex);
	}
	goto __finally43;
	__catch43_g_regex_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("webapp-fetcher.vala:44: %s", e->message);
			_g_error_free0 (e);
		}
	}
	__finally43:
	if (_inner_error_ != NULL) {
		_g_free0 (return_string);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	{
		GRegex* regex;
		char* _tmp4_;
		char* _tmp5_;
		regex = g_regex_new ("(\\s|/)", 0, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch44_g_regex_error;
			}
			_g_free0 (return_string);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp4_ = g_regex_replace (regex, return_string, (gssize) (-1), 0, "_", 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch44_g_regex_error;
			}
			_g_regex_unref0 (regex);
			_g_free0 (return_string);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		return_string = (_tmp5_ = _tmp4_, _g_free0 (return_string), _tmp5_);
		_g_regex_unref0 (regex);
	}
	goto __finally44;
	__catch44_g_regex_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("webapp-fetcher.vala:50: %s", e->message);
			_g_error_free0 (e);
		}
	}
	__finally44:
	if (_inner_error_ != NULL) {
		_g_free0 (return_string);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	{
		GRegex* regex;
		char* _tmp6_;
		char* _tmp7_;
		regex = g_regex_new ("[^([:alnum:]|\\.|_)]+", 0, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch45_g_regex_error;
			}
			_g_free0 (return_string);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp6_ = g_regex_replace (regex, return_string, (gssize) (-1), 0, "", 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch45_g_regex_error;
			}
			_g_regex_unref0 (regex);
			_g_free0 (return_string);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		return_string = (_tmp7_ = _tmp6_, _g_free0 (return_string), _tmp7_);
		_g_regex_unref0 (regex);
	}
	goto __finally45;
	__catch45_g_regex_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("webapp-fetcher.vala:56: %s", e->message);
			_g_error_free0 (e);
		}
	}
	__finally45:
	if (_inner_error_ != NULL) {
		_g_free0 (return_string);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = return_string;
	return result;
}


UnityWebappFetchFile* unity_webapp_fetch_file_construct (GType object_type, const char* uri) {
	UnityWebappFetchFile * self;
	g_return_val_if_fail (uri != NULL, NULL);
	self = (UnityWebappFetchFile*) g_object_new (object_type, "uri", uri, NULL);
	return self;
}


UnityWebappFetchFile* unity_webapp_fetch_file_new (const char* uri) {
	return unity_webapp_fetch_file_construct (UNITY_WEBAPP_TYPE_FETCH_FILE, uri);
}


static void unity_webapp_fetch_file_fetch_data_data_free (gpointer _data) {
	UnityWebappFetchFileFetchDataData* data;
	data = _data;
	g_object_unref (data->self);
	g_slice_free (UnityWebappFetchFileFetchDataData, data);
}


void unity_webapp_fetch_file_fetch_data (UnityWebappFetchFile* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UnityWebappFetchFileFetchDataData* _data_;
	_data_ = g_slice_new0 (UnityWebappFetchFileFetchDataData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, unity_webapp_fetch_file_fetch_data);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, unity_webapp_fetch_file_fetch_data_data_free);
	_data_->self = g_object_ref (self);
	unity_webapp_fetch_file_fetch_data_co (_data_);
}


void unity_webapp_fetch_file_fetch_data_finish (UnityWebappFetchFile* self, GAsyncResult* _res_) {
	UnityWebappFetchFileFetchDataData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void unity_webapp_fetch_file_fetch_data_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	UnityWebappFetchFileFetchDataData* data;
	data = _user_data_;
	data->_res_ = _res_;
	unity_webapp_fetch_file_fetch_data_co (data);
}


static gboolean unity_webapp_fetch_file_fetch_data_co (UnityWebappFetchFileFetchDataData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		data->_tmp0_ = g_file_read (data->self->priv->file, NULL, &data->_inner_error_);
		if (data->_inner_error_ != NULL) {
			goto __catch46_g_error;
		}
		data->self->priv->stream = (data->_tmp2_ = g_data_input_stream_new ((GInputStream*) (data->_tmp1_ = data->_tmp0_)), _g_object_unref0 (data->self->priv->stream), data->_tmp2_);
		_g_object_unref0 (data->_tmp1_);
		g_data_input_stream_set_byte_order (data->self->priv->stream, G_DATA_STREAM_BYTE_ORDER_LITTLE_ENDIAN);
	}
	goto __finally46;
	__catch46_g_error:
	{
		data->e = data->_inner_error_;
		data->_inner_error_ = NULL;
		{
			g_signal_emit_by_name (data->self, "failed");
			_g_error_free0 (data->e);
		}
	}
	__finally46:
	if (data->_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	unity_webapp_fetch_file_read_something_async (data->self, NULL, NULL);
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static void unity_webapp_fetch_file_read_something_async_data_free (gpointer _data) {
	UnityWebappFetchFileReadSomethingAsyncData* data;
	data = _data;
	g_object_unref (data->self);
	g_slice_free (UnityWebappFetchFileReadSomethingAsyncData, data);
}


static void unity_webapp_fetch_file_read_something_async (UnityWebappFetchFile* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UnityWebappFetchFileReadSomethingAsyncData* _data_;
	_data_ = g_slice_new0 (UnityWebappFetchFileReadSomethingAsyncData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, unity_webapp_fetch_file_read_something_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, unity_webapp_fetch_file_read_something_async_data_free);
	_data_->self = g_object_ref (self);
	unity_webapp_fetch_file_read_something_async_co (_data_);
}


static void unity_webapp_fetch_file_read_something_finish (UnityWebappFetchFile* self, GAsyncResult* _res_) {
	UnityWebappFetchFileReadSomethingAsyncData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void unity_webapp_fetch_file_read_something_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	UnityWebappFetchFileReadSomethingAsyncData* data;
	data = _user_data_;
	data->_res_ = _res_;
	unity_webapp_fetch_file_read_something_async_co (data);
}


static gboolean unity_webapp_fetch_file_read_something_async_co (UnityWebappFetchFileReadSomethingAsyncData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
		case 20:
		goto _state_20;
	}
	_state_0:
	data->size = (gssize) 1024;
	data->buffer = (data->_tmp0_ = g_new0 (guint8, data->size), data->buffer_length1 = data->size, data->_buffer_size_ = data->buffer_length1, data->_tmp0_);
	data->bufsize = (gssize) 1;
	{
		data->_tmp1_ = TRUE;
		while (TRUE) {
			if (!data->_tmp1_) {
				if (!(data->bufsize > 0)) {
					break;
				}
			}
			data->_tmp1_ = FALSE;
			{
				data->_state_ = 20;
				g_input_stream_read_async ((GInputStream*) data->self->priv->stream, data->buffer, (gsize) data->size, G_PRIORITY_DEFAULT, NULL, unity_webapp_fetch_file_read_something_async_ready, data);
				return FALSE;
				_state_20:
				data->_tmp2_ = g_input_stream_read_finish ((GInputStream*) data->self->priv->stream, data->_res_, &data->_inner_error_);
				if (data->_inner_error_ != NULL) {
					goto __catch47_g_error;
				}
				data->bufsize = data->_tmp2_;
				if (data->bufsize < 1) {
					break;
				}
				if (data->bufsize != data->size) {
					data->cpybuf = (data->_tmp3_ = g_new0 (guint8, data->bufsize), data->cpybuf_length1 = data->bufsize, data->_cpybuf_size_ = data->cpybuf_length1, data->_tmp3_);
					memcpy (data->cpybuf, data->buffer, (gsize) data->bufsize);
					g_byte_array_append (data->self->priv->data, data->cpybuf, data->cpybuf_length1);
					data->cpybuf = (g_free (data->cpybuf), NULL);
				} else {
					g_byte_array_append (data->self->priv->data, data->buffer, data->buffer_length1);
				}
			}
			goto __finally47;
			__catch47_g_error:
			{
				data->e = data->_inner_error_;
				data->_inner_error_ = NULL;
				{
					g_signal_emit_by_name (data->self, "failed");
					_g_error_free0 (data->e);
				}
			}
			__finally47:
			if (data->_inner_error_ != NULL) {
				data->buffer = (g_free (data->buffer), NULL);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
				g_clear_error (&data->_inner_error_);
				return FALSE;
			}
		}
	}
	g_signal_emit_by_name (data->self, "completed", data->self->priv->data);
	data->buffer = (g_free (data->buffer), NULL);
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


const char* unity_webapp_fetch_file_get_uri (UnityWebappFetchFile* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_uri;
	return result;
}


static void unity_webapp_fetch_file_set_uri (UnityWebappFetchFile* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_uri = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_uri), _tmp0_);
	g_object_notify ((GObject *) self, "uri");
}


static GObject * unity_webapp_fetch_file_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	UnityWebappFetchFile * self;
	parent_class = G_OBJECT_CLASS (unity_webapp_fetch_file_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = UNITY_WEBAPP_FETCH_FILE (obj);
	{
		GFile* _tmp0_;
		GByteArray* _tmp1_;
		self->priv->file = (_tmp0_ = g_file_new_for_uri (self->priv->_uri), _g_object_unref0 (self->priv->file), _tmp0_);
		self->priv->data = (_tmp1_ = g_byte_array_new (), _g_byte_array_free0 (self->priv->data), _tmp1_);
	}
	return obj;
}


static void unity_webapp_fetch_file_class_init (UnityWebappFetchFileClass * klass) {
	unity_webapp_fetch_file_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UnityWebappFetchFilePrivate));
	G_OBJECT_CLASS (klass)->get_property = unity_webapp_fetch_file_get_property;
	G_OBJECT_CLASS (klass)->set_property = unity_webapp_fetch_file_set_property;
	G_OBJECT_CLASS (klass)->constructor = unity_webapp_fetch_file_constructor;
	G_OBJECT_CLASS (klass)->finalize = unity_webapp_fetch_file_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_WEBAPP_FETCH_FILE_URI, g_param_spec_string ("uri", "uri", "uri", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_signal_new ("failed", UNITY_WEBAPP_TYPE_FETCH_FILE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("completed", UNITY_WEBAPP_TYPE_FETCH_FILE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__POINTER, G_TYPE_NONE, 1, G_TYPE_POINTER);
}


static void unity_webapp_fetch_file_instance_init (UnityWebappFetchFile * self) {
	self->priv = UNITY_WEBAPP_FETCH_FILE_GET_PRIVATE (self);
}


static void unity_webapp_fetch_file_finalize (GObject* obj) {
	UnityWebappFetchFile * self;
	self = UNITY_WEBAPP_FETCH_FILE (obj);
	_g_free0 (self->priv->_uri);
	_g_object_unref0 (self->priv->stream);
	_g_object_unref0 (self->priv->file);
	_g_byte_array_free0 (self->priv->data);
	G_OBJECT_CLASS (unity_webapp_fetch_file_parent_class)->finalize (obj);
}


GType unity_webapp_fetch_file_get_type (void) {
	static volatile gsize unity_webapp_fetch_file_type_id__volatile = 0;
	if (g_once_init_enter (&unity_webapp_fetch_file_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnityWebappFetchFileClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_webapp_fetch_file_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityWebappFetchFile), 0, (GInstanceInitFunc) unity_webapp_fetch_file_instance_init, NULL };
		GType unity_webapp_fetch_file_type_id;
		unity_webapp_fetch_file_type_id = g_type_register_static (G_TYPE_OBJECT, "UnityWebappFetchFile", &g_define_type_info, 0);
		g_once_init_leave (&unity_webapp_fetch_file_type_id__volatile, unity_webapp_fetch_file_type_id);
	}
	return unity_webapp_fetch_file_type_id__volatile;
}


static void unity_webapp_fetch_file_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	UnityWebappFetchFile * self;
	self = UNITY_WEBAPP_FETCH_FILE (object);
	switch (property_id) {
		case UNITY_WEBAPP_FETCH_FILE_URI:
		g_value_set_string (value, unity_webapp_fetch_file_get_uri (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void unity_webapp_fetch_file_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	UnityWebappFetchFile * self;
	self = UNITY_WEBAPP_FETCH_FILE (object);
	switch (property_id) {
		case UNITY_WEBAPP_FETCH_FILE_URI:
		unity_webapp_fetch_file_set_uri (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


char* unity_webapp_get_hostname (const char* uri) {
	char* result = NULL;
	GMatchInfo* matchinfo;
	GMatchInfo* _tmp2_ = NULL;
	gboolean _tmp3_;
	GMatchInfo* _tmp4_;
	gboolean ismatch;
	char* hostname;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (uri != NULL, NULL);
	if (unity_webapp_hostname_match == NULL) {
		{
			GRegex* _tmp0_;
			GRegex* _tmp1_;
			_tmp0_ = g_regex_new (hostname_string, G_REGEX_UNGREEDY, 0, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch48_g_error;
			}
			unity_webapp_hostname_match = (_tmp1_ = _tmp0_, _g_regex_unref0 (unity_webapp_hostname_match), _tmp1_);
		}
		goto __finally48;
		__catch48_g_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			{
				g_warning ("webapp-fetcher.vala:141: %s", e->message);
				_g_error_free0 (e);
			}
		}
		__finally48:
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	matchinfo = NULL;
	ismatch = (_tmp3_ = g_regex_match (unity_webapp_hostname_match, uri, 0, &_tmp2_), matchinfo = (_tmp4_ = _tmp2_, _g_match_info_free0 (matchinfo), _tmp4_), _tmp3_);
	hostname = g_strdup ("");
	if (ismatch) {
		char* _tmp5_;
		hostname = (_tmp5_ = g_match_info_fetch_named (matchinfo, "hostname"), _g_free0 (hostname), _tmp5_);
	}
	result = hostname;
	_g_match_info_free0 (matchinfo);
	return result;
}


UnityWebappWebiconFetcher* unity_webapp_webicon_fetcher_construct (GType object_type, const char* uri, const char* destination, const char* desktop_file) {
	UnityWebappWebiconFetcher * self;
	g_return_val_if_fail (uri != NULL, NULL);
	g_return_val_if_fail (destination != NULL, NULL);
	g_return_val_if_fail (desktop_file != NULL, NULL);
	self = (UnityWebappWebiconFetcher*) g_object_new (object_type, "uri", uri, "destination", destination, "desktop-location", desktop_file, NULL);
	return self;
}


UnityWebappWebiconFetcher* unity_webapp_webicon_fetcher_new (const char* uri, const char* destination, const char* desktop_file) {
	return unity_webapp_webicon_fetcher_construct (UNITY_WEBAPP_TYPE_WEBICON_FETCHER, uri, destination, desktop_file);
}


static void unity_webapp_webicon_fetcher_set_desktop_file_icon (UnityWebappWebiconFetcher* self, const char* iconname) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (iconname != NULL);
	{
		GFile* file;
		GFileOutputStream* file_stream;
		GKeyFile* desktop_file;
		char* desktop_data;
		GDataOutputStream* data_stream;
		file = g_file_new_for_path (self->priv->_desktop_location);
		file_stream = g_file_replace (file, NULL, FALSE, G_FILE_CREATE_NONE, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (file);
			goto __catch49_g_error;
		}
		desktop_file = g_key_file_new ();
		g_key_file_load_from_file (desktop_file, self->priv->_desktop_location, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_key_file_free0 (desktop_file);
			_g_object_unref0 (file_stream);
			_g_object_unref0 (file);
			goto __catch49_g_error;
		}
		g_key_file_set_string (desktop_file, "Desktop Entry", "Icon", iconname);
		desktop_data = g_key_file_to_data (desktop_file, NULL, NULL);
		data_stream = g_data_output_stream_new ((GOutputStream*) file_stream);
		g_data_output_stream_put_string (data_stream, desktop_data, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (data_stream);
			_g_free0 (desktop_data);
			_g_key_file_free0 (desktop_file);
			_g_object_unref0 (file_stream);
			_g_object_unref0 (file);
			goto __catch49_g_error;
		}
		g_output_stream_close ((GOutputStream*) data_stream, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (data_stream);
			_g_free0 (desktop_data);
			_g_key_file_free0 (desktop_file);
			_g_object_unref0 (file_stream);
			_g_object_unref0 (file);
			goto __catch49_g_error;
		}
		_g_object_unref0 (data_stream);
		_g_free0 (desktop_data);
		_g_key_file_free0 (desktop_file);
		_g_object_unref0 (file_stream);
		_g_object_unref0 (file);
	}
	goto __finally49;
	__catch49_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("webapp-fetcher.vala:229: %s", e->message);
			_g_error_free0 (e);
		}
	}
	__finally49:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void _lambda5_ (UnityWebappWebiconFetcher* self) {
	g_signal_emit_by_name (self, "failed");
}


static void __lambda5__unity_webapp_fetch_file_failed (UnityWebappFetchFile* _sender, gpointer self) {
	_lambda5_ (self);
}


static void _unity_webapp_webicon_fetcher_on_fetcher_completed_unity_webapp_fetch_file_completed (UnityWebappFetchFile* _sender, GByteArray* data, gpointer self) {
	unity_webapp_webicon_fetcher_on_fetcher_completed (self, data);
}


void unity_webapp_webicon_fetcher_fetch_webapp_data (UnityWebappWebiconFetcher* self) {
	UnityWebappFetchFile* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->fetcher = (_tmp0_ = unity_webapp_fetch_file_new (self->priv->_uri), _g_object_unref0 (self->priv->fetcher), _tmp0_);
	g_signal_connect_object (self->priv->fetcher, "failed", (GCallback) __lambda5__unity_webapp_fetch_file_failed, self, 0);
	g_signal_connect_object (self->priv->fetcher, "completed", (GCallback) _unity_webapp_webicon_fetcher_on_fetcher_completed_unity_webapp_fetch_file_completed, self, 0);
	self->priv->html_phase = TRUE;
	unity_webapp_fetch_file_fetch_data (self->priv->fetcher, NULL, NULL);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gboolean _lambda7_ (UnityWebappWebiconFetcher* self) {
	gboolean result = FALSE;
	g_signal_emit_by_name (unity_global_shell, "need-new-icon-cache");
	result = FALSE;
	return result;
}


static gboolean __lambda7__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda7_ (self);
	return result;
}


static void unity_webapp_webicon_fetcher_on_fetcher_completed (UnityWebappWebiconFetcher* self, GByteArray* data) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (data != NULL);
	if (self->priv->html_phase) {
		char* html;
		char* hostname;
		char* _tmp0_;
		char* _tmp1_;
		GeePriorityQueue* primary_icons;
		char* _tmp2_;
		char* _tmp3_;
		GeePriorityQueue* secondary_icons;
		char* _tmp4_;
		char* _tmp5_;
		char* _tmp6_;
		char* _tmp7_;
		g_debug ("webapp-fetcher.vala:248: we got the html");
		self->priv->html_phase = FALSE;
		html = g_strdup ((const char*) data->data);
		hostname = unity_webapp_get_hostname (self->priv->_uri);
		gee_collection_add ((GeeCollection*) self->priv->icon_uris, _tmp1_ = g_strconcat (_tmp0_ = g_strconcat ("http://", hostname, NULL), "/ubuntu-launcher.png", NULL));
		_g_free0 (_tmp1_);
		_g_free0 (_tmp0_);
		primary_icons = unity_webapp_webicon_fetcher_extract_icon_from_html (self, html, TRUE);
		{
			GeeIterator* _uri_it;
			_uri_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) primary_icons);
			while (TRUE) {
				char* uri;
				if (!gee_iterator_next (_uri_it)) {
					break;
				}
				uri = (char*) gee_iterator_get (_uri_it);
				gee_collection_add ((GeeCollection*) self->priv->icon_uris, uri);
				_g_free0 (uri);
			}
			_g_object_unref0 (_uri_it);
		}
		gee_collection_add ((GeeCollection*) self->priv->icon_uris, _tmp3_ = g_strconcat (_tmp2_ = g_strconcat ("http://", hostname, NULL), "/apple-touch-icon.png", NULL));
		_g_free0 (_tmp3_);
		_g_free0 (_tmp2_);
		secondary_icons = unity_webapp_webicon_fetcher_extract_icon_from_html (self, html, FALSE);
		{
			GeeIterator* _uri_it;
			_uri_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) secondary_icons);
			while (TRUE) {
				char* uri;
				if (!gee_iterator_next (_uri_it)) {
					break;
				}
				uri = (char*) gee_iterator_get (_uri_it);
				gee_collection_add ((GeeCollection*) self->priv->icon_uris, uri);
				_g_free0 (uri);
			}
			_g_object_unref0 (_uri_it);
		}
		gee_collection_add ((GeeCollection*) self->priv->icon_uris, _tmp5_ = g_strconcat (_tmp4_ = g_strconcat ("http://", hostname, NULL), "/favicon.ico", NULL));
		_g_free0 (_tmp5_);
		_g_free0 (_tmp4_);
		gee_collection_add ((GeeCollection*) self->priv->icon_uris, _tmp7_ = g_strconcat (_tmp6_ = g_strconcat ("http://", hostname, NULL), "/favicon.png", NULL));
		_g_free0 (_tmp7_);
		_g_free0 (_tmp6_);
		unity_webapp_webicon_fetcher_attempt_fetch_icon (self);
		_g_object_unref0 (secondary_icons);
		_g_object_unref0 (primary_icons);
		_g_free0 (hostname);
		_g_free0 (html);
	} else {
		if (self->priv->icon_phase) {
			char* _tmp8_;
			g_debug ("webapp-fetcher.vala:275: we got the icon");
			{
				GdkPixbufLoader* loader;
				GdkPixbuf* icon;
				loader = gdk_pixbuf_loader_new ();
				gdk_pixbuf_loader_write (loader, data->data, (gsize) data->len, &_inner_error_);
				if (_inner_error_ != NULL) {
					_g_object_unref0 (loader);
					goto __catch50_g_error;
				}
				gdk_pixbuf_loader_close (loader, &_inner_error_);
				if (_inner_error_ != NULL) {
					_g_object_unref0 (loader);
					goto __catch50_g_error;
				}
				icon = _g_object_ref0 (gdk_pixbuf_loader_get_pixbuf (loader));
				gdk_pixbuf_save (icon, self->priv->_destination, "png", &_inner_error_, NULL);
				if (_inner_error_ != NULL) {
					_g_object_unref0 (icon);
					_g_object_unref0 (loader);
					goto __catch50_g_error;
				}
				_g_object_unref0 (icon);
				_g_object_unref0 (loader);
			}
			goto __finally50;
			__catch50_g_error:
			{
				GError * e;
				e = _inner_error_;
				_inner_error_ = NULL;
				{
					unity_webapp_webicon_fetcher_attempt_fetch_icon (self);
					_g_error_free0 (e);
					return;
				}
			}
			__finally50:
			if (_inner_error_ != NULL) {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			unity_webapp_webicon_fetcher_set_desktop_file_icon (self, _tmp8_ = unity_webapp_get_hostname (self->priv->_uri));
			_g_free0 (_tmp8_);
			g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, __lambda7__gsource_func, g_object_ref (self), g_object_unref);
		}
	}
}


static void unity_webapp_webicon_fetcher_on_fetcher_failed (UnityWebappWebiconFetcher* self) {
	g_return_if_fail (self != NULL);
	if (self->priv->html_phase) {
		g_signal_emit_by_name (self, "failed");
		return;
	}
	if (self->priv->icon_phase) {
		unity_webapp_webicon_fetcher_attempt_fetch_icon (self);
	}
}


static gboolean string_contains (const char* self, const char* needle) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	result = strstr (self, needle) != NULL;
	return result;
}


static void _lambda6_ (UnityWebappWebiconFetcher* self) {
	unity_webapp_webicon_fetcher_on_fetcher_failed (self);
}


static void __lambda6__unity_webapp_fetch_file_failed (UnityWebappFetchFile* _sender, gpointer self) {
	_lambda6_ (self);
}


static void unity_webapp_webicon_fetcher_attempt_fetch_icon (UnityWebappWebiconFetcher* self) {
	char* uri;
	char* _tmp0_;
	UnityWebappFetchFile* _tmp2_;
	g_return_if_fail (self != NULL);
	if (gee_collection_get_size ((GeeCollection*) self->priv->icon_uris) < 1) {
		g_signal_emit_by_name (self, "failed");
		return;
	}
	self->priv->icon_phase = TRUE;
	uri = (char*) gee_list_get (self->priv->icon_uris, 0);
	_tmp0_ = (char*) gee_list_remove_at (self->priv->icon_uris, 0);
	_g_free0 (_tmp0_);
	if (!string_contains (uri, "http://")) {
		char* _tmp1_;
		uri = (_tmp1_ = g_strconcat (self->priv->_uri, uri, NULL), _g_free0 (uri), _tmp1_);
	}
	self->priv->fetcher = (_tmp2_ = unity_webapp_fetch_file_new (uri), _g_object_unref0 (self->priv->fetcher), _tmp2_);
	g_signal_connect_object (self->priv->fetcher, "failed", (GCallback) __lambda6__unity_webapp_fetch_file_failed, self, 0);
	g_signal_connect_object (self->priv->fetcher, "completed", (GCallback) _unity_webapp_webicon_fetcher_on_fetcher_completed_unity_webapp_fetch_file_completed, self, 0);
	unity_webapp_fetch_file_fetch_data (self->priv->fetcher, NULL, NULL);
	_g_free0 (uri);
}


static gpointer _g_regex_ref0 (gpointer self) {
	return self ? g_regex_ref (self) : NULL;
}


static GeePriorityQueue* unity_webapp_webicon_fetcher_extract_icon_from_html (UnityWebappWebiconFetcher* self, const char* html, gboolean preferred) {
	GeePriorityQueue* result = NULL;
	GeePriorityQueue* return_uris;
	GMatchInfo* matchinfo;
	gint regex_array_length1;
	gint _regex_array_size_;
	GRegex** regex_array;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (html != NULL, NULL);
	return_uris = gee_priority_queue_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
	matchinfo = NULL;
	regex_array = (regex_array_length1 = 0, NULL);
	if (preferred) {
		GRegex** _tmp0_ = NULL;
		GRegex** _tmp1_;
		regex_array = (_tmp1_ = (_tmp0_ = g_new0 (GRegex*, 2 + 1), _tmp0_[0] = _g_regex_ref0 (unity_webapp_primary_match_prefix), _tmp0_[1] = _g_regex_ref0 (unity_webapp_primary_match_suffix), _tmp0_), regex_array = (_vala_array_free (regex_array, regex_array_length1, (GDestroyNotify) g_regex_unref), NULL), regex_array_length1 = 2, _regex_array_size_ = regex_array_length1, _tmp1_);
	} else {
		GRegex** _tmp2_ = NULL;
		GRegex** _tmp3_;
		regex_array = (_tmp3_ = (_tmp2_ = g_new0 (GRegex*, 2 + 1), _tmp2_[0] = _g_regex_ref0 (unity_webapp_secondary_match_prefix), _tmp2_[1] = _g_regex_ref0 (unity_webapp_secondary_match_suffix), _tmp2_), regex_array = (_vala_array_free (regex_array, regex_array_length1, (GDestroyNotify) g_regex_unref), NULL), regex_array_length1 = 2, _regex_array_size_ = regex_array_length1, _tmp3_);
	}
	{
		GRegex** regex_collection;
		int regex_collection_length1;
		int regex_it;
		regex_collection = regex_array;
		regex_collection_length1 = regex_array_length1;
		for (regex_it = 0; regex_it < regex_array_length1; regex_it = regex_it + 1) {
			GRegex* regex;
			regex = _g_regex_ref0 (regex_collection[regex_it]);
			{
				GMatchInfo* _tmp4_ = NULL;
				gboolean _tmp5_;
				GMatchInfo* _tmp6_;
				if ((_tmp5_ = g_regex_match (regex, html, 0, &_tmp4_), matchinfo = (_tmp6_ = _tmp4_, _g_match_info_free0 (matchinfo), _tmp6_), _tmp5_)) {
					char* match;
					gboolean _tmp7_ = FALSE;
					match = g_match_info_fetch_named (matchinfo, "icon_uri");
					if (_vala_strcmp0 (match, "") != 0) {
						_tmp7_ = match != NULL;
					} else {
						_tmp7_ = FALSE;
					}
					if (_tmp7_) {
						gee_abstract_queue_offer ((GeeAbstractQueue*) return_uris, match);
					}
					;
					_g_free0 (match);
				}
				_g_regex_unref0 (regex);
			}
		}
	}
	result = return_uris;
	regex_array = (_vala_array_free (regex_array, regex_array_length1, (GDestroyNotify) g_regex_unref), NULL);
	_g_match_info_free0 (matchinfo);
	return result;
}


const char* unity_webapp_webicon_fetcher_get_uri (UnityWebappWebiconFetcher* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_uri;
	return result;
}


static void unity_webapp_webicon_fetcher_set_uri (UnityWebappWebiconFetcher* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_uri = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_uri), _tmp0_);
	g_object_notify ((GObject *) self, "uri");
}


const char* unity_webapp_webicon_fetcher_get_destination (UnityWebappWebiconFetcher* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_destination;
	return result;
}


static void unity_webapp_webicon_fetcher_set_destination (UnityWebappWebiconFetcher* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_destination = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_destination), _tmp0_);
	g_object_notify ((GObject *) self, "destination");
}


const char* unity_webapp_webicon_fetcher_get_desktop_location (UnityWebappWebiconFetcher* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_desktop_location;
	return result;
}


static void unity_webapp_webicon_fetcher_set_desktop_location (UnityWebappWebiconFetcher* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_desktop_location = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_desktop_location), _tmp0_);
	g_object_notify ((GObject *) self, "desktop-location");
}


static GObject * unity_webapp_webicon_fetcher_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	UnityWebappWebiconFetcher * self;
	GError * _inner_error_;
	parent_class = G_OBJECT_CLASS (unity_webapp_webicon_fetcher_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = UNITY_WEBAPP_WEBICON_FETCHER (obj);
	_inner_error_ = NULL;
	{
		GeeList* _tmp10_;
		if (unity_webapp_primary_match_prefix == NULL) {
			char* primary_match_prefix;
			char* primary_match_suffix;
			char* secondary_match_prefix;
			char* secondary_match_suffix;
			primary_match_prefix = g_strdup (tag_start_string apple_string "[^>]*" uri_match_string tag_end_string);
			primary_match_suffix = g_strdup (tag_start_string uri_match_string "[^>]*" apple_string tag_end_string);
			secondary_match_prefix = g_strdup (tag_start_string fav_string "[^>]*" uri_match_string tag_end_string);
			secondary_match_suffix = g_strdup (tag_start_string uri_match_string "[^>]*" fav_string tag_end_string);
			{
				GRegex* _tmp0_;
				GRegex* _tmp1_;
				GRegex* _tmp2_;
				GRegex* _tmp3_;
				GRegex* _tmp4_;
				GRegex* _tmp5_;
				GRegex* _tmp6_;
				GRegex* _tmp7_;
				GRegex* _tmp8_;
				GRegex* _tmp9_;
				_tmp0_ = g_regex_new (primary_match_prefix, G_REGEX_UNGREEDY, 0, &_inner_error_);
				if (_inner_error_ != NULL) {
					goto __catch51_g_error;
				}
				unity_webapp_primary_match_prefix = (_tmp1_ = _tmp0_, _g_regex_unref0 (unity_webapp_primary_match_prefix), _tmp1_);
				_tmp2_ = g_regex_new (primary_match_suffix, G_REGEX_UNGREEDY, 0, &_inner_error_);
				if (_inner_error_ != NULL) {
					goto __catch51_g_error;
				}
				unity_webapp_primary_match_suffix = (_tmp3_ = _tmp2_, _g_regex_unref0 (unity_webapp_primary_match_suffix), _tmp3_);
				_tmp4_ = g_regex_new (secondary_match_prefix, G_REGEX_UNGREEDY, 0, &_inner_error_);
				if (_inner_error_ != NULL) {
					goto __catch51_g_error;
				}
				unity_webapp_secondary_match_prefix = (_tmp5_ = _tmp4_, _g_regex_unref0 (unity_webapp_secondary_match_prefix), _tmp5_);
				_tmp6_ = g_regex_new (secondary_match_suffix, G_REGEX_UNGREEDY, 0, &_inner_error_);
				if (_inner_error_ != NULL) {
					goto __catch51_g_error;
				}
				unity_webapp_secondary_match_suffix = (_tmp7_ = _tmp6_, _g_regex_unref0 (unity_webapp_secondary_match_suffix), _tmp7_);
				_tmp8_ = g_regex_new (hostname_string, G_REGEX_UNGREEDY, 0, &_inner_error_);
				if (_inner_error_ != NULL) {
					goto __catch51_g_error;
				}
				unity_webapp_hostname_match = (_tmp9_ = _tmp8_, _g_regex_unref0 (unity_webapp_hostname_match), _tmp9_);
			}
			goto __finally51;
			__catch51_g_error:
			{
				GError * e;
				e = _inner_error_;
				_inner_error_ = NULL;
				{
					g_warning ("webapp-fetcher.vala:197: %s", e->message);
					_g_error_free0 (e);
				}
			}
			__finally51:
			if (_inner_error_ != NULL) {
				_g_free0 (secondary_match_suffix);
				_g_free0 (secondary_match_prefix);
				_g_free0 (primary_match_suffix);
				_g_free0 (primary_match_prefix);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
			}
			_g_free0 (secondary_match_suffix);
			_g_free0 (secondary_match_prefix);
			_g_free0 (primary_match_suffix);
			_g_free0 (primary_match_prefix);
		}
		self->priv->icon_uris = (_tmp10_ = (GeeList*) gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL), _g_object_unref0 (self->priv->icon_uris), _tmp10_);
		{
			GFile* make_file;
			GFileOutputStream* _tmp11_;
			make_file = g_file_new_for_path (self->priv->_destination);
			_tmp11_ = g_file_create (make_file, G_FILE_CREATE_NONE, NULL, &_inner_error_);
			_g_object_unref0 (_tmp11_);
			if (_inner_error_ != NULL) {
				_g_object_unref0 (make_file);
				goto __catch52_g_error;
			}
			_g_object_unref0 (make_file);
		}
		goto __finally52;
		__catch52_g_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			{
				_g_error_free0 (e);
			}
		}
		__finally52:
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
		unity_webapp_webicon_fetcher_set_desktop_file_icon (self, "emblem-web");
	}
	return obj;
}


static void unity_webapp_webicon_fetcher_class_init (UnityWebappWebiconFetcherClass * klass) {
	unity_webapp_webicon_fetcher_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UnityWebappWebiconFetcherPrivate));
	G_OBJECT_CLASS (klass)->get_property = unity_webapp_webicon_fetcher_get_property;
	G_OBJECT_CLASS (klass)->set_property = unity_webapp_webicon_fetcher_set_property;
	G_OBJECT_CLASS (klass)->constructor = unity_webapp_webicon_fetcher_constructor;
	G_OBJECT_CLASS (klass)->finalize = unity_webapp_webicon_fetcher_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_WEBAPP_WEBICON_FETCHER_URI, g_param_spec_string ("uri", "uri", "uri", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_WEBAPP_WEBICON_FETCHER_DESTINATION, g_param_spec_string ("destination", "destination", "destination", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_WEBAPP_WEBICON_FETCHER_DESKTOP_LOCATION, g_param_spec_string ("desktop-location", "desktop-location", "desktop-location", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_signal_new ("failed", UNITY_WEBAPP_TYPE_WEBICON_FETCHER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("completed", UNITY_WEBAPP_TYPE_WEBICON_FETCHER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
}


static void unity_webapp_webicon_fetcher_instance_init (UnityWebappWebiconFetcher * self) {
	self->priv = UNITY_WEBAPP_WEBICON_FETCHER_GET_PRIVATE (self);
	self->priv->html_phase = FALSE;
	self->priv->icon_phase = FALSE;
}


static void unity_webapp_webicon_fetcher_finalize (GObject* obj) {
	UnityWebappWebiconFetcher * self;
	self = UNITY_WEBAPP_WEBICON_FETCHER (obj);
	_g_free0 (self->priv->_uri);
	_g_free0 (self->priv->_destination);
	_g_free0 (self->priv->_desktop_location);
	_g_object_unref0 (self->priv->fetcher);
	_g_object_unref0 (self->priv->icon_uris);
	G_OBJECT_CLASS (unity_webapp_webicon_fetcher_parent_class)->finalize (obj);
}


GType unity_webapp_webicon_fetcher_get_type (void) {
	static volatile gsize unity_webapp_webicon_fetcher_type_id__volatile = 0;
	if (g_once_init_enter (&unity_webapp_webicon_fetcher_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnityWebappWebiconFetcherClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_webapp_webicon_fetcher_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityWebappWebiconFetcher), 0, (GInstanceInitFunc) unity_webapp_webicon_fetcher_instance_init, NULL };
		GType unity_webapp_webicon_fetcher_type_id;
		unity_webapp_webicon_fetcher_type_id = g_type_register_static (G_TYPE_OBJECT, "UnityWebappWebiconFetcher", &g_define_type_info, 0);
		g_once_init_leave (&unity_webapp_webicon_fetcher_type_id__volatile, unity_webapp_webicon_fetcher_type_id);
	}
	return unity_webapp_webicon_fetcher_type_id__volatile;
}


static void unity_webapp_webicon_fetcher_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	UnityWebappWebiconFetcher * self;
	self = UNITY_WEBAPP_WEBICON_FETCHER (object);
	switch (property_id) {
		case UNITY_WEBAPP_WEBICON_FETCHER_URI:
		g_value_set_string (value, unity_webapp_webicon_fetcher_get_uri (self));
		break;
		case UNITY_WEBAPP_WEBICON_FETCHER_DESTINATION:
		g_value_set_string (value, unity_webapp_webicon_fetcher_get_destination (self));
		break;
		case UNITY_WEBAPP_WEBICON_FETCHER_DESKTOP_LOCATION:
		g_value_set_string (value, unity_webapp_webicon_fetcher_get_desktop_location (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void unity_webapp_webicon_fetcher_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	UnityWebappWebiconFetcher * self;
	self = UNITY_WEBAPP_WEBICON_FETCHER (object);
	switch (property_id) {
		case UNITY_WEBAPP_WEBICON_FETCHER_URI:
		unity_webapp_webicon_fetcher_set_uri (self, g_value_get_string (value));
		break;
		case UNITY_WEBAPP_WEBICON_FETCHER_DESTINATION:
		unity_webapp_webicon_fetcher_set_destination (self, g_value_get_string (value));
		break;
		case UNITY_WEBAPP_WEBICON_FETCHER_DESKTOP_LOCATION:
		unity_webapp_webicon_fetcher_set_desktop_location (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




