/* utils.c generated by valac, the Vala compiler
 * generated from utils.vala, do not modify */

/*
 * Copyright (C) 2010 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Mikkel Kamstrup Erlandsen <mikkel.kamstrup@canonical.com>
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <zeitgeist.h>
#include <dee.h>
#include <gee.h>
#include <unity.h>

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _UnityFilesPlaceUtilsGetIconForUriAsyncData UnityFilesPlaceUtilsGetIconForUriAsyncData;

#define UNITY_FILES_PLACE_TYPE_GROUP (unity_files_place_group_get_type ())
#define __g_slist_free_g_object_unref0(var) ((var == NULL) ? NULL : (var = (_g_slist_free_g_object_unref (var), NULL)))
#define __g_list_free_g_object_unref0(var) ((var == NULL) ? NULL : (var = (_g_list_free_g_object_unref (var), NULL)))
typedef struct _UnityFilesPlaceUtilsListDirData UnityFilesPlaceUtilsListDirData;

#define UNITY_FILES_PLACE_TYPE_RESULTS_COLUMN (unity_files_place_results_column_get_type ())

struct _UnityFilesPlaceUtilsGetIconForUriAsyncData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	char* uri;
	char* mimetype;
	char* result;
	GFile* f;
	GFileInfo* info;
	GIcon* icon2;
	GError * e;
	GError * _inner_error_;
};

typedef enum  {
	UNITY_FILES_PLACE_GROUP_TOP_RESULTS,
	UNITY_FILES_PLACE_GROUP_RECENT,
	UNITY_FILES_PLACE_GROUP_DOWNLOADS,
	UNITY_FILES_PLACE_GROUP_FAVORITE_FOLDERS,
	UNITY_FILES_PLACE_GROUP_FILES,
	UNITY_FILES_PLACE_GROUP_EMPTY_SEARCH,
	UNITY_FILES_PLACE_GROUP_EMPTY_SECTION,
	UNITY_FILES_PLACE_GROUP_TODAY,
	UNITY_FILES_PLACE_GROUP_YESTERDAY,
	UNITY_FILES_PLACE_GROUP_THIS_WEEK,
	UNITY_FILES_PLACE_GROUP_LAST_WEEK,
	UNITY_FILES_PLACE_GROUP_THIS_MONTH,
	UNITY_FILES_PLACE_GROUP_PAST_SIX_MONTHS,
	UNITY_FILES_PLACE_GROUP_THIS_YEAR,
	UNITY_FILES_PLACE_GROUP_LAST_YEAR
} UnityFilesPlaceGroup;

struct _UnityFilesPlaceUtilsListDirData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	GFile* folder;
	GSList* result;
	GSList* _result_;
	GFileEnumerator* e;
	GList* file_infos;
	gboolean _tmp0_;
	char* colkey;
	GList* info_collection;
	GList* info_it;
	GFileInfo* info;
	GCompareFunc cmpfunc;
	GError * _inner_error_;
};

typedef enum  {
	UNITY_FILES_PLACE_RESULTS_COLUMN_URI = 0,
	UNITY_FILES_PLACE_RESULTS_COLUMN_ICON_HINT,
	UNITY_FILES_PLACE_RESULTS_COLUMN_GROUP_ID,
	UNITY_FILES_PLACE_RESULTS_COLUMN_MIMETYPE,
	UNITY_FILES_PLACE_RESULTS_COLUMN_DISPLAY_NAME,
	UNITY_FILES_PLACE_RESULTS_COLUMN_COMMENT
} UnityFilesPlaceResultsColumn;



#define UNITY_FILES_PLACE_UTILS_icon_attribs G_FILE_ATTRIBUTE_PREVIEW_ICON "," G_FILE_ATTRIBUTE_STANDARD_ICON "," G_FILE_ATTRIBUTE_THUMBNAIL_PATH
#define UNITY_FILES_PLACE_UTILS_file_attribs G_FILE_ATTRIBUTE_STANDARD_NAME "," G_FILE_ATTRIBUTE_STANDARD_DISPLAY_NAME "," G_FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE "," G_FILE_ATTRIBUTE_STANDARD_IS_HIDDEN "," G_FILE_ATTRIBUTE_STANDARD_IS_BACKUP "," G_FILE_ATTRIBUTE_TIME_MODIFIED "," G_FILE_ATTRIBUTE_TIME_ACCESS
#define UNITY_FILES_PLACE_UTILS_hide_attribs G_FILE_ATTRIBUTE_STANDARD_IS_BACKUP "," G_FILE_ATTRIBUTE_STANDARD_IS_HIDDEN
#define UNITY_FILES_PLACE_UTILS_all_attribs UNITY_FILES_PLACE_UTILS_icon_attribs "," UNITY_FILES_PLACE_UTILS_file_attribs "," UNITY_FILES_PLACE_UTILS_hide_attribs
char* unity_files_place_utils_check_icon_string (const char* uri, const char* mimetype, GFileInfo* info);
char* unity_files_place_utils_get_icon_for_uri (const char* uri, const char* mimetype);
static void unity_files_place_utils_get_icon_for_uri_async_data_free (gpointer _data);
static void unity_files_place_utils_get_icon_for_uri_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void unity_files_place_utils_get_icon_for_uri_async (const char* uri, const char* mimetype, GAsyncReadyCallback _callback_, gpointer _user_data_);
char* unity_files_place_utils_get_icon_for_uri_finish (GAsyncResult* _res_);
static gboolean unity_files_place_utils_get_icon_for_uri_async_co (UnityFilesPlaceUtilsGetIconForUriAsyncData* data);
gint unity_files_place_utils_cmp_file_info_by_mtime (GFileInfo* info1, GFileInfo* info2);
char* unity_files_place_utils_get_month_name (GDateMonth month);
char* unity_files_place_utils_get_day_name (GDateWeekday weekday);
GType unity_files_place_group_get_type (void) G_GNUC_CONST;
guint unity_files_place_utils_get_time_group (ZeitgeistEvent* event, DeeModel* groups_model, char** comment);
static void _g_slist_free_g_object_unref (GSList* self);
static void unity_files_place_utils_list_dir_data_free (gpointer _data);
static void unity_files_place_utils_list_dir_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _g_list_free_g_object_unref (GList* self);
static gint _lambda0_ (void* info1, void* info2);
static gint __lambda0__gcompare_func (void* a, void* b);
void unity_files_place_utils_list_dir (GFile* folder, GAsyncReadyCallback _callback_, gpointer _user_data_);
GSList* unity_files_place_utils_list_dir_finish (GAsyncResult* _res_, GError** error);
static gboolean unity_files_place_utils_list_dir_co (UnityFilesPlaceUtilsListDirData* data);
GType unity_files_place_results_column_get_type (void) G_GNUC_CONST;
void unity_files_place_utils_apply_uri_filter (GeeSet* valid_uris, DeeResultSet* filter_set);
gboolean unity_files_place_utils_check_is_filter_search (UnityPlaceSearch* new_search, UnityPlaceSearch* old_search);
GeeSet* unity_files_place_utils_get_uri_set (ZeitgeistResultSet* results);
gboolean unity_files_place_utils_search_has_really_changed (UnityPlaceSearch* old_search, UnityPlaceSearch* new_search);
static int _vala_strcmp0 (const char * str1, const char * str2);



char* unity_files_place_utils_get_icon_for_uri (const char* uri, const char* mimetype) {
	char* result = NULL;
	GError * _inner_error_;
	g_return_val_if_fail (uri != NULL, NULL);
	g_return_val_if_fail (mimetype != NULL, NULL);
	_inner_error_ = NULL;
	{
		GFile* f;
		GFileInfo* info;
		f = g_file_new_for_uri (uri);
		info = g_file_query_info (f, UNITY_FILES_PLACE_UTILS_icon_attribs, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (f);
			goto __catch11_g_error;
		}
		result = unity_files_place_utils_check_icon_string (uri, mimetype, info);
		_g_object_unref0 (info);
		_g_object_unref0 (f);
		return result;
	}
	goto __finally11;
	__catch11_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			GIcon* icon2;
			icon2 = g_content_type_get_icon (mimetype);
			result = g_strdup (g_icon_to_string (icon2));
			_g_object_unref0 (icon2);
			_g_error_free0 (e);
			return result;
		}
	}
	__finally11:
	{
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static void unity_files_place_utils_get_icon_for_uri_async_data_free (gpointer _data) {
	UnityFilesPlaceUtilsGetIconForUriAsyncData* data;
	data = _data;
	_g_free0 (data->uri);
	_g_free0 (data->mimetype);
	_g_free0 (data->result);
	g_slice_free (UnityFilesPlaceUtilsGetIconForUriAsyncData, data);
}


void unity_files_place_utils_get_icon_for_uri_async (const char* uri, const char* mimetype, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UnityFilesPlaceUtilsGetIconForUriAsyncData* _data_;
	_data_ = g_slice_new0 (UnityFilesPlaceUtilsGetIconForUriAsyncData);
	_data_->_async_result = g_simple_async_result_new (g_object_newv (G_TYPE_OBJECT, 0, NULL), _callback_, _user_data_, unity_files_place_utils_get_icon_for_uri_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, unity_files_place_utils_get_icon_for_uri_async_data_free);
	_data_->uri = g_strdup (uri);
	_data_->mimetype = g_strdup (mimetype);
	unity_files_place_utils_get_icon_for_uri_async_co (_data_);
}


char* unity_files_place_utils_get_icon_for_uri_finish (GAsyncResult* _res_) {
	char* result;
	UnityFilesPlaceUtilsGetIconForUriAsyncData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void unity_files_place_utils_get_icon_for_uri_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	UnityFilesPlaceUtilsGetIconForUriAsyncData* data;
	data = _user_data_;
	data->_res_ = _res_;
	unity_files_place_utils_get_icon_for_uri_async_co (data);
}


static gboolean unity_files_place_utils_get_icon_for_uri_async_co (UnityFilesPlaceUtilsGetIconForUriAsyncData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 10:
		goto _state_10;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		{
			data->f = g_file_new_for_uri (data->uri);
			data->_state_ = 10;
			g_file_query_info_async (data->f, UNITY_FILES_PLACE_UTILS_icon_attribs, G_FILE_QUERY_INFO_NONE, G_PRIORITY_LOW, NULL, unity_files_place_utils_get_icon_for_uri_async_ready, data);
			return FALSE;
			_state_10:
			data->info = g_file_query_info_finish (data->f, data->_res_, &data->_inner_error_);
			if (data->_inner_error_ != NULL) {
				_g_object_unref0 (data->f);
				goto __catch12_g_error;
			}
			data->result = unity_files_place_utils_check_icon_string (data->uri, data->mimetype, data->info);
			_g_object_unref0 (data->info);
			_g_object_unref0 (data->f);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
			_g_object_unref0 (data->info);
			_g_object_unref0 (data->f);
		}
		goto __finally12;
		__catch12_g_error:
		{
			data->e = data->_inner_error_;
			data->_inner_error_ = NULL;
			{
				data->icon2 = g_content_type_get_icon (data->mimetype);
				data->result = g_strdup (g_icon_to_string (data->icon2));
				_g_object_unref0 (data->icon2);
				_g_error_free0 (data->e);
				{
					if (data->_state_ == 0) {
						g_simple_async_result_complete_in_idle (data->_async_result);
					} else {
						g_simple_async_result_complete (data->_async_result);
					}
					g_object_unref (data->_async_result);
					return FALSE;
				}
				_g_object_unref0 (data->icon2);
				_g_error_free0 (data->e);
			}
		}
		__finally12:
		{
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


char* unity_files_place_utils_check_icon_string (const char* uri, const char* mimetype, GFileInfo* info) {
	char* result = NULL;
	GIcon* icon;
	char* thumbnail_path;
	g_return_val_if_fail (uri != NULL, NULL);
	g_return_val_if_fail (mimetype != NULL, NULL);
	g_return_val_if_fail (info != NULL, NULL);
	icon = _g_object_ref0 (g_file_info_get_icon (info));
	thumbnail_path = g_strdup (g_file_info_get_attribute_byte_string (info, G_FILE_ATTRIBUTE_THUMBNAIL_PATH));
	if (thumbnail_path == NULL) {
		result = g_strdup (g_icon_to_string (icon));
		_g_free0 (thumbnail_path);
		_g_object_unref0 (icon);
		return result;
	} else {
		GFileIcon* _tmp1_;
		GFile* _tmp0_;
		char* _tmp2_;
		result = (_tmp2_ = g_strdup (g_icon_to_string ((GIcon*) (_tmp1_ = (GFileIcon*) g_file_icon_new (_tmp0_ = g_file_new_for_path (thumbnail_path))))), _g_object_unref0 (_tmp1_), _g_object_unref0 (_tmp0_), _tmp2_);
		_g_free0 (thumbnail_path);
		_g_object_unref0 (icon);
		return result;
	}
	_g_free0 (thumbnail_path);
	_g_object_unref0 (icon);
}


gint unity_files_place_utils_cmp_file_info_by_mtime (GFileInfo* info1, GFileInfo* info2) {
	gint result = 0;
	GTimeVal tv1 = {0};
	GTimeVal tv2 = {0};
	glong cmp;
	gint _tmp0_ = 0;
	g_return_val_if_fail (info1 != NULL, 0);
	g_return_val_if_fail (info2 != NULL, 0);
	g_file_info_get_modification_time (info1, &tv1);
	g_file_info_get_modification_time (info2, &tv2);
	cmp = tv1.tv_sec - tv2.tv_sec;
	if (cmp < 0) {
		_tmp0_ = 1;
	} else {
		gint _tmp1_ = 0;
		if (cmp > 0) {
			_tmp1_ = -1;
		} else {
			_tmp1_ = 0;
		}
		_tmp0_ = _tmp1_;
	}
	result = _tmp0_;
	return result;
}


char* unity_files_place_utils_get_month_name (GDateMonth month) {
	char* result = NULL;
	switch (month) {
		case G_DATE_BAD_MONTH:
		{
			result = g_strdup (_ ("Invalid Month"));
			return result;
		}
		case G_DATE_JANUARY:
		{
			result = g_strdup (_ ("January"));
			return result;
		}
		case G_DATE_FEBRUARY:
		{
			result = g_strdup (_ ("February"));
			return result;
		}
		case G_DATE_MARCH:
		{
			result = g_strdup (_ ("March"));
			return result;
		}
		case G_DATE_APRIL:
		{
			result = g_strdup (_ ("April"));
			return result;
		}
		case G_DATE_MAY:
		{
			result = g_strdup (_ ("May"));
			return result;
		}
		case G_DATE_JUNE:
		{
			result = g_strdup (_ ("June"));
			return result;
		}
		case G_DATE_JULY:
		{
			result = g_strdup (_ ("July"));
			return result;
		}
		case G_DATE_AUGUST:
		{
			result = g_strdup (_ ("August"));
			return result;
		}
		case G_DATE_SEPTEMBER:
		{
			result = g_strdup (_ ("September"));
			return result;
		}
		case G_DATE_OCTOBER:
		{
			result = g_strdup (_ ("October"));
			return result;
		}
		case G_DATE_NOVEMBER:
		{
			result = g_strdup (_ ("November"));
			return result;
		}
		case G_DATE_DECEMBER:
		{
			result = g_strdup (_ ("December"));
			return result;
		}
	}
	result = g_strdup ("Internal Error");
	return result;
}


char* unity_files_place_utils_get_day_name (GDateWeekday weekday) {
	char* result = NULL;
	switch (weekday) {
		case G_DATE_MONDAY:
		{
			result = g_strdup (_ ("Monday"));
			return result;
		}
		case G_DATE_TUESDAY:
		{
			result = g_strdup (_ ("Tuesday"));
			return result;
		}
		case G_DATE_WEDNESDAY:
		{
			result = g_strdup (_ ("Wednesday"));
			return result;
		}
		case G_DATE_THURSDAY:
		{
			result = g_strdup (_ ("Thursday"));
			return result;
		}
		case G_DATE_FRIDAY:
		{
			result = g_strdup (_ ("Friday"));
			return result;
		}
		case G_DATE_SATURDAY:
		{
			result = g_strdup (_ ("Saturday"));
			return result;
		}
		case G_DATE_SUNDAY:
		{
			result = g_strdup (_ ("Sunday"));
			return result;
		}
		default:
		{
			result = g_strdup ("Internal Error");
			return result;
		}
	}
}


guint unity_files_place_utils_get_time_group (ZeitgeistEvent* event, DeeModel* groups_model, char** comment) {
	guint result = 0U;
	gint64 t;
	gint64 now;
	gint64 delta;
	gint64 limit;
	GDate date = {0};
	GDate datethen = {0};
	char* _tmp8_;
	char* _tmp11_;
	g_return_val_if_fail (event != NULL, 0U);
	g_return_val_if_fail (groups_model != NULL, 0U);
	if (comment != NULL) {
		*comment = NULL;
	}
	t = zeitgeist_event_get_timestamp (event);
	now = zeitgeist_timestamp_for_now ();
	delta = now - t;
	limit = zeitgeist_timestamp_prev_midnight (now);
	if (t > limit) {
		gint64 hour;
		hour = ZEITGEIST_TIMESTAMP_HOUR;
		if (delta > (hour * 7)) {
			char* _tmp0_;
			*comment = (_tmp0_ = g_strdup (_ ("Earlier today")), _g_free0 (*comment), _tmp0_);
		} else {
			if (delta > (hour * 6)) {
				char* _tmp1_;
				*comment = (_tmp1_ = g_strdup (_ ("Five hours ago")), _g_free0 (*comment), _tmp1_);
			} else {
				if (delta > (hour * 5)) {
					char* _tmp2_;
					*comment = (_tmp2_ = g_strdup (_ ("Four hours ago")), _g_free0 (*comment), _tmp2_);
				} else {
					if (delta > (hour * 4)) {
						char* _tmp3_;
						*comment = (_tmp3_ = g_strdup (_ ("Three hours ago")), _g_free0 (*comment), _tmp3_);
					} else {
						if (delta > (hour * 3)) {
							char* _tmp4_;
							*comment = (_tmp4_ = g_strdup (_ ("Two hours ago")), _g_free0 (*comment), _tmp4_);
						} else {
							if (delta > (hour * 2)) {
								char* _tmp5_;
								*comment = (_tmp5_ = g_strdup (_ ("1 hour ago")), _g_free0 (*comment), _tmp5_);
							} else {
								char* _tmp6_;
								*comment = (_tmp6_ = g_strdup (_ ("Past hour")), _g_free0 (*comment), _tmp6_);
							}
						}
					}
				}
			}
		}
		result = (guint) UNITY_FILES_PLACE_GROUP_TODAY;
		return result;
	} else {
		if (t > (limit - ZEITGEIST_TIMESTAMP_DAY)) {
			char* _tmp7_;
			*comment = (_tmp7_ = g_strdup (_ ("Yesterday")), _g_free0 (*comment), _tmp7_);
			result = (guint) UNITY_FILES_PLACE_GROUP_YESTERDAY;
			return result;
		}
	}
	memset (&date, 0, sizeof (GDate));
	zeitgeist_timestamp_to_date (now, &date);
	limit = limit - ((g_date_get_weekday (&date) - 1) * ZEITGEIST_TIMESTAMP_DAY);
	memset (&datethen, 0, sizeof (GDate));
	zeitgeist_timestamp_to_date (t, &datethen);
	*comment = (_tmp8_ = unity_files_place_utils_get_day_name (g_date_get_weekday (&datethen)), _g_free0 (*comment), _tmp8_);
	if (t > limit) {
		result = (guint) UNITY_FILES_PLACE_GROUP_THIS_WEEK;
		return result;
	} else {
		if (t > (limit - ZEITGEIST_TIMESTAMP_WEEK)) {
			result = (guint) UNITY_FILES_PLACE_GROUP_LAST_WEEK;
			return result;
		}
	}
	g_date_set_day (&date, (GDateDay) 1);
	limit = zeitgeist_timestamp_from_date (&date);
	if (t > limit) {
		gint days;
		days = g_date_days_between (&datethen, &date);
		if (days < (7 * 3)) {
			char* _tmp9_;
			*comment = (_tmp9_ = g_strdup (_ ("Three weeks ago")), _g_free0 (*comment), _tmp9_);
		} else {
			if (days < (7 * 4)) {
				char* _tmp10_;
				*comment = (_tmp10_ = g_strdup (_ ("A month ago")), _g_free0 (*comment), _tmp10_);
			}
		}
		result = (guint) UNITY_FILES_PLACE_GROUP_THIS_MONTH;
		return result;
	}
	*comment = (_tmp11_ = unity_files_place_utils_get_month_name (g_date_get_month (&datethen)), _g_free0 (*comment), _tmp11_);
	g_date_subtract_months (&date, (guint) 1);
	limit = zeitgeist_timestamp_from_date (&date);
	if (t > (now - ((6 * 30) * ZEITGEIST_TIMESTAMP_DAY))) {
		result = (guint) UNITY_FILES_PLACE_GROUP_PAST_SIX_MONTHS;
		return result;
	}
	zeitgeist_timestamp_to_date (now, &date);
	g_date_set_month (&date, G_DATE_JANUARY);
	g_date_set_day (&date, (GDateDay) 1);
	limit = zeitgeist_timestamp_from_date (&date);
	if (t > limit) {
		result = (guint) UNITY_FILES_PLACE_GROUP_THIS_YEAR;
		return result;
	} else {
		result = (guint) UNITY_FILES_PLACE_GROUP_LAST_YEAR;
		return result;
	}
}


static void _g_slist_free_g_object_unref (GSList* self) {
	g_slist_foreach (self, (GFunc) g_object_unref, NULL);
	g_slist_free (self);
}


static void unity_files_place_utils_list_dir_data_free (gpointer _data) {
	UnityFilesPlaceUtilsListDirData* data;
	data = _data;
	_g_object_unref0 (data->folder);
	__g_slist_free_g_object_unref0 (data->result);
	g_slice_free (UnityFilesPlaceUtilsListDirData, data);
}


void unity_files_place_utils_list_dir (GFile* folder, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UnityFilesPlaceUtilsListDirData* _data_;
	_data_ = g_slice_new0 (UnityFilesPlaceUtilsListDirData);
	_data_->_async_result = g_simple_async_result_new (g_object_newv (G_TYPE_OBJECT, 0, NULL), _callback_, _user_data_, unity_files_place_utils_list_dir);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, unity_files_place_utils_list_dir_data_free);
	_data_->folder = _g_object_ref0 (folder);
	unity_files_place_utils_list_dir_co (_data_);
}


GSList* unity_files_place_utils_list_dir_finish (GAsyncResult* _res_, GError** error) {
	GSList* result;
	UnityFilesPlaceUtilsListDirData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void unity_files_place_utils_list_dir_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	UnityFilesPlaceUtilsListDirData* data;
	data = _user_data_;
	data->_res_ = _res_;
	unity_files_place_utils_list_dir_co (data);
}


static void _g_list_free_g_object_unref (GList* self) {
	g_list_foreach (self, (GFunc) g_object_unref, NULL);
	g_list_free (self);
}


static gint _lambda0_ (void* info1, void* info2) {
	gint result = 0;
	void* _tmp0_;
	void* _tmp1_;
	result = g_strcmp0 (g_file_info_get_attribute_string ((_tmp0_ = info1, G_IS_FILE_INFO (_tmp0_) ? ((GFileInfo*) _tmp0_) : NULL), "unity::collation-key"), g_file_info_get_attribute_string ((_tmp1_ = info2, G_IS_FILE_INFO (_tmp1_) ? ((GFileInfo*) _tmp1_) : NULL), "unity::collation-key"));
	return result;
}


static gint __lambda0__gcompare_func (void* a, void* b) {
	gint result;
	result = _lambda0_ (a, b);
	return result;
}


static gboolean unity_files_place_utils_list_dir_co (UnityFilesPlaceUtilsListDirData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 11:
		goto _state_11;
		case 12:
		goto _state_12;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		data->_result_ = NULL;
		data->_state_ = 11;
		g_file_enumerate_children_async (data->folder, UNITY_FILES_PLACE_UTILS_all_attribs, 0, G_PRIORITY_DEFAULT, NULL, unity_files_place_utils_list_dir_ready, data);
		return FALSE;
		_state_11:
		data->e = g_file_enumerate_children_finish (data->folder, data->_res_, &data->_inner_error_);
		if (data->_inner_error_ != NULL) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			__g_slist_free_g_object_unref0 (data->_result_);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
		}
		while (TRUE) {
			data->_state_ = 12;
			g_file_enumerator_next_files_async (data->e, 10, G_PRIORITY_DEFAULT, NULL, unity_files_place_utils_list_dir_ready, data);
			return FALSE;
			_state_12:
			data->file_infos = g_file_enumerator_next_files_finish (data->e, data->_res_, &data->_inner_error_);
			if (data->_inner_error_ != NULL) {
				g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
				g_error_free (data->_inner_error_);
				_g_object_unref0 (data->e);
				__g_slist_free_g_object_unref0 (data->_result_);
				{
					if (data->_state_ == 0) {
						g_simple_async_result_complete_in_idle (data->_async_result);
					} else {
						g_simple_async_result_complete (data->_async_result);
					}
					g_object_unref (data->_async_result);
					return FALSE;
				}
			}
			if (data->file_infos == NULL) {
				__g_list_free_g_object_unref0 (data->file_infos);
				break;
			}
			{
				data->info_collection = data->file_infos;
				for (data->info_it = data->info_collection; data->info_it != NULL; data->info_it = data->info_it->next) {
					data->info = _g_object_ref0 ((GFileInfo*) data->info_it->data);
					{
						if (g_file_info_get_is_hidden (data->info)) {
							data->_tmp0_ = TRUE;
						} else {
							data->_tmp0_ = g_file_info_get_is_backup (data->info);
						}
						if (data->_tmp0_) {
							_g_object_unref0 (data->info);
							continue;
						}
						data->colkey = g_utf8_collate_key_for_filename (g_file_info_get_display_name (data->info), -1);
						g_file_info_set_attribute_string (data->info, "unity::collation-key", data->colkey);
						data->_result_ = g_slist_prepend (data->_result_, _g_object_ref0 (data->info));
						_g_free0 (data->colkey);
						_g_object_unref0 (data->info);
					}
				}
			}
			__g_list_free_g_object_unref0 (data->file_infos);
		}
		data->cmpfunc = __lambda0__gcompare_func;
		data->_result_ = g_slist_sort (data->_result_, data->cmpfunc);
		data->result = data->_result_;
		_g_object_unref0 (data->e);
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
		_g_object_unref0 (data->e);
		__g_slist_free_g_object_unref0 (data->_result_);
	}
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


void unity_files_place_utils_apply_uri_filter (GeeSet* valid_uris, DeeResultSet* filter_set) {
	DeeModel* model;
	guint n_removed;
	char* uri;
	g_return_if_fail (valid_uris != NULL);
	g_return_if_fail (filter_set != NULL);
	model = _g_object_ref0 (dee_result_set_get_model (filter_set));
	n_removed = (guint) 0;
	uri = NULL;
	{
		DeeResultSet* _row_it;
		DeeModelIter* row;
		_row_it = _vala_dee_result_set_iterator (filter_set);
		row = NULL;
		while (TRUE) {
			char* _tmp0_;
			if (!((row = _vala_dee_result_set_next_value (_row_it)) != NULL)) {
				break;
			}
			uri = (_tmp0_ = g_strdup (dee_model_get_string (model, row, (guint) UNITY_FILES_PLACE_RESULTS_COLUMN_URI)), _g_free0 (uri), _tmp0_);
			if (!gee_collection_contains ((GeeCollection*) valid_uris, uri)) {
				dee_model_remove (model, row);
				n_removed++;
				g_debug ("utils.vala:314: Removed: %s", uri);
			}
		}
		_g_object_unref0 (_row_it);
	}
	if (n_removed > 0) {
		g_debug ("utils.vala:319: Removed %u rows from result set", n_removed);
	}
	_g_free0 (uri);
	_g_object_unref0 (model);
}


gboolean unity_files_place_utils_check_is_filter_search (UnityPlaceSearch* new_search, UnityPlaceSearch* old_search) {
	gboolean result = FALSE;
	gboolean is_filter_search;
	g_return_val_if_fail (new_search != NULL, FALSE);
	is_filter_search = FALSE;
	if (old_search != NULL) {
		char* previous_search_string;
		gboolean _tmp0_ = FALSE;
		previous_search_string = unity_place_search_get_search_string (old_search);
		if (previous_search_string != NULL) {
			_tmp0_ = _vala_strcmp0 (previous_search_string, "") != 0;
		} else {
			_tmp0_ = FALSE;
		}
		if (_tmp0_) {
			char* _tmp1_;
			is_filter_search = g_str_has_prefix (_tmp1_ = unity_place_search_get_search_string (new_search), previous_search_string);
			_g_free0 (_tmp1_);
		}
		_g_free0 (previous_search_string);
	}
	result = is_filter_search;
	return result;
}


GeeSet* unity_files_place_utils_get_uri_set (ZeitgeistResultSet* results) {
	GeeSet* result = NULL;
	GeeSet* uris;
	g_return_val_if_fail (results != NULL, NULL);
	uris = (GeeSet*) gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL);
	{
		ZeitgeistResultSet* _ev_it;
		ZeitgeistEvent* ev;
		_ev_it = _vala_zeitgeist_result_set_iterator (results);
		ev = NULL;
		while (TRUE) {
			if (!((ev = _vala_zeitgeist_result_set_next_value (_ev_it)) != NULL)) {
				break;
			}
			{
				gint i;
				i = 0;
				{
					gboolean _tmp0_;
					_tmp0_ = TRUE;
					while (TRUE) {
						if (!_tmp0_) {
							i++;
						}
						_tmp0_ = FALSE;
						if (!(i < zeitgeist_event_num_subjects (ev))) {
							break;
						}
						gee_collection_add ((GeeCollection*) uris, zeitgeist_subject_get_uri (zeitgeist_event_get_subject (ev, i)));
					}
				}
			}
		}
		_g_object_unref0 (_ev_it);
	}
	result = uris;
	return result;
}


static char* string_strip (const char* self) {
	char* result = NULL;
	char* _result_;
	g_return_val_if_fail (self != NULL, NULL);
	_result_ = g_strdup (self);
	g_strstrip (_result_);
	result = _result_;
	return result;
}


gboolean unity_files_place_utils_search_has_really_changed (UnityPlaceSearch* old_search, UnityPlaceSearch* new_search) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	char* s1;
	char* s2;
	if (old_search == NULL) {
		_tmp0_ = new_search == NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	s1 = NULL;
	s2 = NULL;
	if (old_search == NULL) {
		char* _tmp1_;
		gboolean _tmp2_ = FALSE;
		s1 = (_tmp1_ = unity_place_search_get_search_string (new_search), _g_free0 (s1), _tmp1_);
		if (s1 == NULL) {
			_tmp2_ = TRUE;
		} else {
			char* _tmp3_;
			_tmp2_ = _vala_strcmp0 (_tmp3_ = string_strip (s1), "") == 0;
			_g_free0 (_tmp3_);
		}
		if (_tmp2_) {
			result = FALSE;
			_g_free0 (s2);
			_g_free0 (s1);
			return result;
		} else {
			result = TRUE;
			_g_free0 (s2);
			_g_free0 (s1);
			return result;
		}
	} else {
		if (new_search == NULL) {
			char* _tmp4_;
			gboolean _tmp5_ = FALSE;
			s2 = (_tmp4_ = unity_place_search_get_search_string (old_search), _g_free0 (s2), _tmp4_);
			if (s2 == NULL) {
				_tmp5_ = TRUE;
			} else {
				char* _tmp6_;
				_tmp5_ = _vala_strcmp0 (_tmp6_ = string_strip (s2), "") == 0;
				_g_free0 (_tmp6_);
			}
			if (_tmp5_) {
				result = FALSE;
				_g_free0 (s2);
				_g_free0 (s1);
				return result;
			} else {
				result = TRUE;
				_g_free0 (s2);
				_g_free0 (s1);
				return result;
			}
		} else {
			char* _tmp7_;
			char* _tmp8_;
			s1 = (_tmp7_ = unity_place_search_get_search_string (new_search), _g_free0 (s1), _tmp7_);
			s2 = (_tmp8_ = unity_place_search_get_search_string (old_search), _g_free0 (s2), _tmp8_);
			if (s1 == NULL) {
				gboolean _tmp9_ = FALSE;
				if (s2 == NULL) {
					_tmp9_ = TRUE;
				} else {
					char* _tmp10_;
					_tmp9_ = _vala_strcmp0 (_tmp10_ = string_strip (s2), "") == 0;
					_g_free0 (_tmp10_);
				}
				if (_tmp9_) {
					result = FALSE;
					_g_free0 (s2);
					_g_free0 (s1);
					return result;
				} else {
					result = TRUE;
					_g_free0 (s2);
					_g_free0 (s1);
					return result;
				}
			} else {
				if (s2 == NULL) {
					gboolean _tmp11_ = FALSE;
					if (s1 == NULL) {
						_tmp11_ = TRUE;
					} else {
						char* _tmp12_;
						_tmp11_ = _vala_strcmp0 (_tmp12_ = string_strip (s1), "") == 0;
						_g_free0 (_tmp12_);
					}
					if (_tmp11_) {
						result = FALSE;
						_g_free0 (s2);
						_g_free0 (s1);
						return result;
					} else {
						result = TRUE;
						_g_free0 (s2);
						_g_free0 (s1);
						return result;
					}
				} else {
					char* _tmp14_;
					char* _tmp13_;
					gboolean _tmp15_;
					result = (_tmp15_ = _vala_strcmp0 (_tmp13_ = string_strip (s1), _tmp14_ = string_strip (s2)) != 0, _g_free0 (_tmp14_), _g_free0 (_tmp13_), _tmp15_);
					_g_free0 (s2);
					_g_free0 (s1);
					return result;
				}
			}
		}
	}
	_g_free0 (s2);
	_g_free0 (s1);
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




