/* rhythmbox-collection.c generated by valac 0.14.2, the Vala compiler
 * generated from rhythmbox-collection.vala, do not modify */

/*
 * Copyright (C) 2012 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by David Calle <davidc@framli.eu>
 *             Michal Hruby <michal.hruby@canonical.com>
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <dee.h>
#include <stdlib.h>
#include <string.h>
#include <tdb.h>
#include <gio/gio.h>
#include <dee-icu.h>
#include <glib/gstdio.h>
#include <fcntl.h>
#include <sys/types.h>
#include <unity.h>
#include <gee.h>


#define UNITY_MUSIC_LENS_TYPE_COLUMNS (unity_music_lens_columns_get_type ())

#define UNITY_MUSIC_LENS_TYPE_RHYTHMBOX_COLLECTION (unity_music_lens_rhythmbox_collection_get_type ())
#define UNITY_MUSIC_LENS_RHYTHMBOX_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_MUSIC_LENS_TYPE_RHYTHMBOX_COLLECTION, UnityMusicLensRhythmboxCollection))
#define UNITY_MUSIC_LENS_RHYTHMBOX_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_MUSIC_LENS_TYPE_RHYTHMBOX_COLLECTION, UnityMusicLensRhythmboxCollectionClass))
#define UNITY_MUSIC_LENS_IS_RHYTHMBOX_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_MUSIC_LENS_TYPE_RHYTHMBOX_COLLECTION))
#define UNITY_MUSIC_LENS_IS_RHYTHMBOX_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_MUSIC_LENS_TYPE_RHYTHMBOX_COLLECTION))
#define UNITY_MUSIC_LENS_RHYTHMBOX_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_MUSIC_LENS_TYPE_RHYTHMBOX_COLLECTION, UnityMusicLensRhythmboxCollectionClass))

typedef struct _UnityMusicLensRhythmboxCollection UnityMusicLensRhythmboxCollection;
typedef struct _UnityMusicLensRhythmboxCollectionClass UnityMusicLensRhythmboxCollectionClass;
typedef struct _UnityMusicLensRhythmboxCollectionPrivate UnityMusicLensRhythmboxCollectionPrivate;

#define UNITY_MUSIC_LENS_RHYTHMBOX_COLLECTION_TYPE_RESULT_TYPE (unity_music_lens_rhythmbox_collection_result_type_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _tdb_close0(var) ((var == NULL) ? NULL : (var = (tdb_close (var), NULL)))
#define _dee_icu_term_filter_destroy0(var) ((var == NULL) ? NULL : (var = (dee_icu_term_filter_destroy (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_variant_type_free0(var) ((var == NULL) ? NULL : (var = (g_variant_type_free (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_byte_array_unref0(var) ((var == NULL) ? NULL : (var = (g_byte_array_unref (var), NULL)))

#define UNITY_MUSIC_LENS_TYPE_TRACK (unity_music_lens_track_get_type ())
#define UNITY_MUSIC_LENS_TRACK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_MUSIC_LENS_TYPE_TRACK, UnityMusicLensTrack))
#define UNITY_MUSIC_LENS_TRACK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_MUSIC_LENS_TYPE_TRACK, UnityMusicLensTrackClass))
#define UNITY_MUSIC_LENS_IS_TRACK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_MUSIC_LENS_TYPE_TRACK))
#define UNITY_MUSIC_LENS_IS_TRACK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_MUSIC_LENS_TYPE_TRACK))
#define UNITY_MUSIC_LENS_TRACK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_MUSIC_LENS_TYPE_TRACK, UnityMusicLensTrackClass))

typedef struct _UnityMusicLensTrack UnityMusicLensTrack;
typedef struct _UnityMusicLensTrackClass UnityMusicLensTrackClass;
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
#define _g_slist_free0(var) ((var == NULL) ? NULL : (var = (g_slist_free (var), NULL)))
typedef struct _Block2Data Block2Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define UNITY_MUSIC_LENS_RHYTHMBOX_COLLECTION_TYPE_XML_PARSER (unity_music_lens_rhythmbox_collection_xml_parser_get_type ())
#define UNITY_MUSIC_LENS_RHYTHMBOX_COLLECTION_XML_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_MUSIC_LENS_RHYTHMBOX_COLLECTION_TYPE_XML_PARSER, UnityMusicLensRhythmboxCollectionXmlParser))
#define UNITY_MUSIC_LENS_RHYTHMBOX_COLLECTION_XML_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_MUSIC_LENS_RHYTHMBOX_COLLECTION_TYPE_XML_PARSER, UnityMusicLensRhythmboxCollectionXmlParserClass))
#define UNITY_MUSIC_LENS_RHYTHMBOX_COLLECTION_IS_XML_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_MUSIC_LENS_RHYTHMBOX_COLLECTION_TYPE_XML_PARSER))
#define UNITY_MUSIC_LENS_RHYTHMBOX_COLLECTION_IS_XML_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_MUSIC_LENS_RHYTHMBOX_COLLECTION_TYPE_XML_PARSER))
#define UNITY_MUSIC_LENS_RHYTHMBOX_COLLECTION_XML_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_MUSIC_LENS_RHYTHMBOX_COLLECTION_TYPE_XML_PARSER, UnityMusicLensRhythmboxCollectionXmlParserClass))

typedef struct _UnityMusicLensRhythmboxCollectionXmlParser UnityMusicLensRhythmboxCollectionXmlParser;
typedef struct _UnityMusicLensRhythmboxCollectionXmlParserClass UnityMusicLensRhythmboxCollectionXmlParserClass;
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

#define UNITY_MUSIC_LENS_TYPE_FILTER_PARSER (unity_music_lens_filter_parser_get_type ())
#define UNITY_MUSIC_LENS_FILTER_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_MUSIC_LENS_TYPE_FILTER_PARSER, UnityMusicLensFilterParser))
#define UNITY_MUSIC_LENS_FILTER_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_MUSIC_LENS_TYPE_FILTER_PARSER, UnityMusicLensFilterParserClass))
#define UNITY_MUSIC_LENS_IS_FILTER_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_MUSIC_LENS_TYPE_FILTER_PARSER))
#define UNITY_MUSIC_LENS_IS_FILTER_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_MUSIC_LENS_TYPE_FILTER_PARSER))
#define UNITY_MUSIC_LENS_FILTER_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_MUSIC_LENS_TYPE_FILTER_PARSER, UnityMusicLensFilterParserClass))

typedef struct _UnityMusicLensFilterParser UnityMusicLensFilterParser;
typedef struct _UnityMusicLensFilterParserClass UnityMusicLensFilterParserClass;

#define UNITY_MUSIC_LENS_TYPE_CATEGORY (unity_music_lens_category_get_type ())
#define _g_sequence_free0(var) ((var == NULL) ? NULL : (var = (g_sequence_free (var), NULL)))

#define UNITY_MUSIC_LENS_TYPE_DECADE_FILTER_PARSER (unity_music_lens_decade_filter_parser_get_type ())
#define UNITY_MUSIC_LENS_DECADE_FILTER_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_MUSIC_LENS_TYPE_DECADE_FILTER_PARSER, UnityMusicLensDecadeFilterParser))
#define UNITY_MUSIC_LENS_DECADE_FILTER_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_MUSIC_LENS_TYPE_DECADE_FILTER_PARSER, UnityMusicLensDecadeFilterParserClass))
#define UNITY_MUSIC_LENS_IS_DECADE_FILTER_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_MUSIC_LENS_TYPE_DECADE_FILTER_PARSER))
#define UNITY_MUSIC_LENS_IS_DECADE_FILTER_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_MUSIC_LENS_TYPE_DECADE_FILTER_PARSER))
#define UNITY_MUSIC_LENS_DECADE_FILTER_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_MUSIC_LENS_TYPE_DECADE_FILTER_PARSER, UnityMusicLensDecadeFilterParserClass))

typedef struct _UnityMusicLensDecadeFilterParser UnityMusicLensDecadeFilterParser;
typedef struct _UnityMusicLensDecadeFilterParserClass UnityMusicLensDecadeFilterParserClass;

#define UNITY_MUSIC_LENS_TYPE_GENRE_FILTER_PARSER (unity_music_lens_genre_filter_parser_get_type ())
#define UNITY_MUSIC_LENS_GENRE_FILTER_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_MUSIC_LENS_TYPE_GENRE_FILTER_PARSER, UnityMusicLensGenreFilterParser))
#define UNITY_MUSIC_LENS_GENRE_FILTER_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_MUSIC_LENS_TYPE_GENRE_FILTER_PARSER, UnityMusicLensGenreFilterParserClass))
#define UNITY_MUSIC_LENS_IS_GENRE_FILTER_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_MUSIC_LENS_TYPE_GENRE_FILTER_PARSER))
#define UNITY_MUSIC_LENS_IS_GENRE_FILTER_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_MUSIC_LENS_TYPE_GENRE_FILTER_PARSER))
#define UNITY_MUSIC_LENS_GENRE_FILTER_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_MUSIC_LENS_TYPE_GENRE_FILTER_PARSER, UnityMusicLensGenreFilterParserClass))

typedef struct _UnityMusicLensGenreFilterParser UnityMusicLensGenreFilterParser;
typedef struct _UnityMusicLensGenreFilterParserClass UnityMusicLensGenreFilterParserClass;
typedef struct _UnityMusicLensRhythmboxCollectionXmlParserPrivate UnityMusicLensRhythmboxCollectionXmlParserPrivate;

#define UNITY_MUSIC_LENS_TYPE_GENRE (unity_music_lens_genre_get_type ())
#define UNITY_MUSIC_LENS_GENRE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_MUSIC_LENS_TYPE_GENRE, UnityMusicLensGenre))
#define UNITY_MUSIC_LENS_GENRE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_MUSIC_LENS_TYPE_GENRE, UnityMusicLensGenreClass))
#define UNITY_MUSIC_LENS_IS_GENRE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_MUSIC_LENS_TYPE_GENRE))
#define UNITY_MUSIC_LENS_IS_GENRE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_MUSIC_LENS_TYPE_GENRE))
#define UNITY_MUSIC_LENS_GENRE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_MUSIC_LENS_TYPE_GENRE, UnityMusicLensGenreClass))

typedef struct _UnityMusicLensGenre UnityMusicLensGenre;
typedef struct _UnityMusicLensGenreClass UnityMusicLensGenreClass;
#define _g_markup_parse_context_free0(var) ((var == NULL) ? NULL : (var = (g_markup_parse_context_free (var), NULL)))

typedef enum  {
	UNITY_MUSIC_LENS_COLUMNS_URI,
	UNITY_MUSIC_LENS_COLUMNS_TITLE,
	UNITY_MUSIC_LENS_COLUMNS_ARTIST,
	UNITY_MUSIC_LENS_COLUMNS_ALBUM,
	UNITY_MUSIC_LENS_COLUMNS_ARTWORK,
	UNITY_MUSIC_LENS_COLUMNS_MIMETYPE,
	UNITY_MUSIC_LENS_COLUMNS_GENRE,
	UNITY_MUSIC_LENS_COLUMNS_ALBUM_ARTIST,
	UNITY_MUSIC_LENS_COLUMNS_TRACK_NUMBER,
	UNITY_MUSIC_LENS_COLUMNS_YEAR,
	UNITY_MUSIC_LENS_COLUMNS_PLAY_COUNT,
	UNITY_MUSIC_LENS_COLUMNS_N_COLUMNS
} UnityMusicLensColumns;

struct _UnityMusicLensRhythmboxCollection {
	GObject parent_instance;
	UnityMusicLensRhythmboxCollectionPrivate * priv;
};

struct _UnityMusicLensRhythmboxCollectionClass {
	GObjectClass parent_class;
};

struct _UnityMusicLensRhythmboxCollectionPrivate {
	DeeSequenceModel* all_tracks;
	DeeModelTag* album_art_tag;
	DeeFilterModel* tracks_by_play_count;
	GHashTable* album_to_tracks_map;
	TDB_CONTEXT* album_art_tdb;
	GFileMonitor* tdb_monitor;
	gint current_album_art_tag;
	GHashTable* variant_store;
	GHashTable* int_variant_store;
	GVariant* row_buffer[11];
	DeeAnalyzer* analyzer;
	DeeIndex* index;
	DeeICUTermFilter* ascii_filter;
	gchar* media_art_dir;
};

typedef enum  {
	UNITY_MUSIC_LENS_RHYTHMBOX_COLLECTION_RESULT_TYPE_ALBUM,
	UNITY_MUSIC_LENS_RHYTHMBOX_COLLECTION_RESULT_TYPE_SONG
} UnityMusicLensRhythmboxCollectionResultType;

struct _Block2Data {
	int _ref_count_;
	UnityMusicLensRhythmboxCollection * self;
	gchar* path;
};

typedef enum  {
	UNITY_MUSIC_LENS_CATEGORY_SONGS,
	UNITY_MUSIC_LENS_CATEGORY_ALBUMS,
	UNITY_MUSIC_LENS_CATEGORY_PURCHASE,
	UNITY_MUSIC_LENS_CATEGORY_MUSIC
} UnityMusicLensCategory;

struct _UnityMusicLensRhythmboxCollectionXmlParser {
	GObject parent_instance;
	UnityMusicLensRhythmboxCollectionXmlParserPrivate * priv;
};

struct _UnityMusicLensRhythmboxCollectionXmlParserClass {
	GObjectClass parent_class;
};

struct _UnityMusicLensRhythmboxCollectionXmlParserPrivate {
	UnityMusicLensGenre* genre;
	GMarkupParseContext* context;
	gboolean is_rhythmdb_xml;
	gboolean processing_song;
	UnityMusicLensTrack* current_track;
	gint current_data;
};


static gpointer unity_music_lens_rhythmbox_collection_parent_class = NULL;
static gpointer unity_music_lens_rhythmbox_collection_xml_parser_parent_class = NULL;

GType unity_music_lens_columns_get_type (void) G_GNUC_CONST;
GType unity_music_lens_rhythmbox_collection_get_type (void) G_GNUC_CONST;
#define UNITY_MUSIC_LENS_RHYTHMBOX_COLLECTION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), UNITY_MUSIC_LENS_TYPE_RHYTHMBOX_COLLECTION, UnityMusicLensRhythmboxCollectionPrivate))
enum  {
	UNITY_MUSIC_LENS_RHYTHMBOX_COLLECTION_DUMMY_PROPERTY
};
static GType unity_music_lens_rhythmbox_collection_result_type_get_type (void) G_GNUC_UNUSED;
#define UNITY_MUSIC_LENS_RHYTHMBOX_COLLECTION_UNKNOWN_ALBUM "Unknown"
static void unity_music_lens_rhythmbox_collection_initialize_index (UnityMusicLensRhythmboxCollection* self);
static gchar* __lambda4_ (UnityMusicLensRhythmboxCollection* self, DeeModel* model, DeeModelIter* iter);
static gchar* ___lambda4__dee_model_reader_func (DeeModel* model, DeeModelIter* iter, gpointer self);
static gchar* unity_music_lens_rhythmbox_collection_check_album_art_tdb (UnityMusicLensRhythmboxCollection* self, const gchar* artist, const gchar* album);
GType unity_music_lens_track_get_type (void) G_GNUC_CONST;
static gchar* unity_music_lens_rhythmbox_collection_get_albumart (UnityMusicLensRhythmboxCollection* self, UnityMusicLensTrack* track);
const gchar* unity_music_lens_track_get_album_artist (UnityMusicLensTrack* self);
const gchar* unity_music_lens_track_get_artist (UnityMusicLensTrack* self);
const gchar* unity_music_lens_track_get_album (UnityMusicLensTrack* self);
const gchar* unity_music_lens_track_get_uri (UnityMusicLensTrack* self);
GSList* unity_music_lens_rhythmbox_collection_get_album_tracks (UnityMusicLensRhythmboxCollection* self, const gchar* album_key);
static GVariant* unity_music_lens_rhythmbox_collection_cached_variant_for_string (UnityMusicLensRhythmboxCollection* self, const gchar* input);
static GVariant* unity_music_lens_rhythmbox_collection_cached_variant_for_int (UnityMusicLensRhythmboxCollection* self, gint input);
static void unity_music_lens_rhythmbox_collection_prepare_row_buffer (UnityMusicLensRhythmboxCollection* self, UnityMusicLensTrack* track);
const gchar* unity_music_lens_track_get_title (UnityMusicLensTrack* self);
const gchar* unity_music_lens_track_get_mime_type (UnityMusicLensTrack* self);
const gchar* unity_music_lens_track_get_artwork_path (UnityMusicLensTrack* self);
const gchar* unity_music_lens_track_get_genre (UnityMusicLensTrack* self);
gint unity_music_lens_track_get_track_number (UnityMusicLensTrack* self);
gint unity_music_lens_track_get_year (UnityMusicLensTrack* self);
gint unity_music_lens_track_get_play_count (UnityMusicLensTrack* self);
void unity_music_lens_rhythmbox_collection_parse_metadata_file (UnityMusicLensRhythmboxCollection* self, const gchar* path);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (Block2Data* _data2_);
static void ____lambda5_ (Block2Data* _data2_);
static void _____lambda5__g_file_monitor_changed (GFileMonitor* _sender, GFile* file, GFile* other_file, GFileMonitorEvent event_type, gpointer self);
void unity_music_lens_rhythmbox_collection_parse_file (UnityMusicLensRhythmboxCollection* self, const gchar* path);
static UnityMusicLensRhythmboxCollectionXmlParser* unity_music_lens_rhythmbox_collection_xml_parser_new (void);
static UnityMusicLensRhythmboxCollectionXmlParser* unity_music_lens_rhythmbox_collection_xml_parser_construct (GType object_type);
static GType unity_music_lens_rhythmbox_collection_xml_parser_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static void __lambda6_ (UnityMusicLensRhythmboxCollection* self, UnityMusicLensTrack* track);
void unity_music_lens_track_set_artwork_path (UnityMusicLensTrack* self, const gchar* value);
static void ___lambda6__unity_music_lens_rhythmbox_collection_xml_parser_track_info_ready (UnityMusicLensRhythmboxCollectionXmlParser* _sender, UnityMusicLensTrack* track, gpointer self);
static gboolean unity_music_lens_rhythmbox_collection_xml_parser_parse (UnityMusicLensRhythmboxCollectionXmlParser* self, const gchar* content, gsize len, GError** error);
static gint ____lambda7_ (UnityMusicLensRhythmboxCollection* self, DeeModelIter** a, DeeModelIter** b);
static gint _____lambda7__gcompare_data_func (gconstpointer a, gconstpointer b, gpointer self);
static void unity_music_lens_rhythmbox_collection_add_result (UnityMusicLensRhythmboxCollection* self, DeeModel* results_model, DeeModel* model, DeeModelIter* iter, UnityMusicLensRhythmboxCollectionResultType result_type, guint category_id);
GType unity_music_lens_filter_parser_get_type (void) G_GNUC_CONST;
void unity_music_lens_rhythmbox_collection_search (UnityMusicLensRhythmboxCollection* self, UnityLensSearch* search, UnitySearchType search_type, GList* filters, gint max_results, gint category_override);
static void unity_music_lens_rhythmbox_collection_get_decade_filter (UnityMusicLensRhythmboxCollection* self, GList* filters, gint* min_year, gint* max_year);
static GeeSet* unity_music_lens_rhythmbox_collection_get_genre_filter (UnityMusicLensRhythmboxCollection* self, GList* filters);
GType unity_music_lens_category_get_type (void) G_GNUC_CONST;
static gint ____lambda8_ (UnityMusicLensRhythmboxCollection* self, DeeModelIter* a, DeeModelIter* b);
static gint _____lambda8__gcompare_data_func (gconstpointer a, gconstpointer b, gpointer self);
GType unity_music_lens_decade_filter_parser_get_type (void) G_GNUC_CONST;
UnityFilter* unity_music_lens_filter_parser_get_filter (UnityMusicLensFilterParser* self);
GType unity_music_lens_genre_filter_parser_get_type (void) G_GNUC_CONST;
UnityMusicLensRhythmboxCollection* unity_music_lens_rhythmbox_collection_new (void);
UnityMusicLensRhythmboxCollection* unity_music_lens_rhythmbox_collection_construct (GType object_type);
static GObject * unity_music_lens_rhythmbox_collection_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _g_variant_unref0_ (gpointer var);
static void _g_free0_ (gpointer var);
static void _g_ptr_array_unref0_ (gpointer var);
static gint _unity_music_lens_rhythmbox_collection___lambda9_ (UnityMusicLensRhythmboxCollection* self, GVariant** row1, int row1_length1, GVariant** row2, int row2_length1);
static gint __unity_music_lens_rhythmbox_collection___lambda9__dee_compare_row_func (GVariant** row1, GVariant** row2, gpointer self);
static void _unity_music_lens_rhythmbox_collection___lambda10_ (UnityMusicLensRhythmboxCollection* self, DeeTermList* terms_in, DeeTermList* terms_out);
static void __unity_music_lens_rhythmbox_collection___lambda10__dee_term_filter_func (DeeTermList* terms_in, DeeTermList* terms_out, gpointer self);
GType unity_music_lens_genre_get_type (void) G_GNUC_CONST;
#define UNITY_MUSIC_LENS_RHYTHMBOX_COLLECTION_XML_PARSER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), UNITY_MUSIC_LENS_RHYTHMBOX_COLLECTION_TYPE_XML_PARSER, UnityMusicLensRhythmboxCollectionXmlParserPrivate))
enum  {
	UNITY_MUSIC_LENS_RHYTHMBOX_COLLECTION_XML_PARSER_DUMMY_PROPERTY
};
UnityMusicLensGenre* unity_music_lens_genre_new (void);
UnityMusicLensGenre* unity_music_lens_genre_construct (GType object_type);
static void unity_music_lens_rhythmbox_collection_xml_parser_start_tag (UnityMusicLensRhythmboxCollectionXmlParser* self, GMarkupParseContext* context, const gchar* name, gchar** attr_names, gchar** attr_values, GError** error);
static void _unity_music_lens_rhythmbox_collection_xml_parser_start_tag_gmarkup_parser_start_element_func (GMarkupParseContext* context, const gchar* element_name, gchar** attribute_names, gchar** attribute_values, gpointer self, GError** error);
static void unity_music_lens_rhythmbox_collection_xml_parser_end_tag (UnityMusicLensRhythmboxCollectionXmlParser* self, GMarkupParseContext* content, const gchar* name, GError** error);
static void _unity_music_lens_rhythmbox_collection_xml_parser_end_tag_gmarkup_parser_end_element_func (GMarkupParseContext* context, const gchar* element_name, gpointer self, GError** error);
static void unity_music_lens_rhythmbox_collection_xml_parser_process_text (UnityMusicLensRhythmboxCollectionXmlParser* self, GMarkupParseContext* context, const gchar* text, gsize text_len, GError** error);
static void _unity_music_lens_rhythmbox_collection_xml_parser_process_text_gmarkup_parser_text_func (GMarkupParseContext* context, const gchar* text, gsize text_len, gpointer self, GError** error);
UnityMusicLensTrack* unity_music_lens_track_new (void);
UnityMusicLensTrack* unity_music_lens_track_construct (GType object_type);
void unity_music_lens_track_set_uri (UnityMusicLensTrack* self, const gchar* value);
void unity_music_lens_track_set_title (UnityMusicLensTrack* self, const gchar* value);
void unity_music_lens_track_set_artist (UnityMusicLensTrack* self, const gchar* value);
void unity_music_lens_track_set_album (UnityMusicLensTrack* self, const gchar* value);
void unity_music_lens_track_set_album_artist (UnityMusicLensTrack* self, const gchar* value);
gchar* unity_music_lens_genre_get_id_for_genre (UnityMusicLensGenre* self, const gchar* genre);
void unity_music_lens_track_set_genre (UnityMusicLensTrack* self, const gchar* value);
void unity_music_lens_track_set_mime_type (UnityMusicLensTrack* self, const gchar* value);
void unity_music_lens_track_set_year (UnityMusicLensTrack* self, gint value);
void unity_music_lens_track_set_play_count (UnityMusicLensTrack* self, gint value);
void unity_music_lens_track_set_track_number (UnityMusicLensTrack* self, gint value);
static GObject * unity_music_lens_rhythmbox_collection_xml_parser_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void unity_music_lens_rhythmbox_collection_xml_parser_finalize (GObject* obj);
static void unity_music_lens_rhythmbox_collection_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const GMarkupParser UNITY_MUSIC_LENS_RHYTHMBOX_COLLECTION_XML_PARSER_parser = {_unity_music_lens_rhythmbox_collection_xml_parser_start_tag_gmarkup_parser_start_element_func, _unity_music_lens_rhythmbox_collection_xml_parser_end_tag_gmarkup_parser_end_element_func, _unity_music_lens_rhythmbox_collection_xml_parser_process_text_gmarkup_parser_text_func, NULL, NULL};

GType unity_music_lens_columns_get_type (void) {
	static volatile gsize unity_music_lens_columns_type_id__volatile = 0;
	if (g_once_init_enter (&unity_music_lens_columns_type_id__volatile)) {
		static const GEnumValue values[] = {{UNITY_MUSIC_LENS_COLUMNS_URI, "UNITY_MUSIC_LENS_COLUMNS_URI", "uri"}, {UNITY_MUSIC_LENS_COLUMNS_TITLE, "UNITY_MUSIC_LENS_COLUMNS_TITLE", "title"}, {UNITY_MUSIC_LENS_COLUMNS_ARTIST, "UNITY_MUSIC_LENS_COLUMNS_ARTIST", "artist"}, {UNITY_MUSIC_LENS_COLUMNS_ALBUM, "UNITY_MUSIC_LENS_COLUMNS_ALBUM", "album"}, {UNITY_MUSIC_LENS_COLUMNS_ARTWORK, "UNITY_MUSIC_LENS_COLUMNS_ARTWORK", "artwork"}, {UNITY_MUSIC_LENS_COLUMNS_MIMETYPE, "UNITY_MUSIC_LENS_COLUMNS_MIMETYPE", "mimetype"}, {UNITY_MUSIC_LENS_COLUMNS_GENRE, "UNITY_MUSIC_LENS_COLUMNS_GENRE", "genre"}, {UNITY_MUSIC_LENS_COLUMNS_ALBUM_ARTIST, "UNITY_MUSIC_LENS_COLUMNS_ALBUM_ARTIST", "album-artist"}, {UNITY_MUSIC_LENS_COLUMNS_TRACK_NUMBER, "UNITY_MUSIC_LENS_COLUMNS_TRACK_NUMBER", "track-number"}, {UNITY_MUSIC_LENS_COLUMNS_YEAR, "UNITY_MUSIC_LENS_COLUMNS_YEAR", "year"}, {UNITY_MUSIC_LENS_COLUMNS_PLAY_COUNT, "UNITY_MUSIC_LENS_COLUMNS_PLAY_COUNT", "play-count"}, {UNITY_MUSIC_LENS_COLUMNS_N_COLUMNS, "UNITY_MUSIC_LENS_COLUMNS_N_COLUMNS", "n-columns"}, {0, NULL, NULL}};
		GType unity_music_lens_columns_type_id;
		unity_music_lens_columns_type_id = g_enum_register_static ("UnityMusicLensColumns", values);
		g_once_init_leave (&unity_music_lens_columns_type_id__volatile, unity_music_lens_columns_type_id);
	}
	return unity_music_lens_columns_type_id__volatile;
}


static GType unity_music_lens_rhythmbox_collection_result_type_get_type (void) {
	static volatile gsize unity_music_lens_rhythmbox_collection_result_type_type_id__volatile = 0;
	if (g_once_init_enter (&unity_music_lens_rhythmbox_collection_result_type_type_id__volatile)) {
		static const GEnumValue values[] = {{UNITY_MUSIC_LENS_RHYTHMBOX_COLLECTION_RESULT_TYPE_ALBUM, "UNITY_MUSIC_LENS_RHYTHMBOX_COLLECTION_RESULT_TYPE_ALBUM", "album"}, {UNITY_MUSIC_LENS_RHYTHMBOX_COLLECTION_RESULT_TYPE_SONG, "UNITY_MUSIC_LENS_RHYTHMBOX_COLLECTION_RESULT_TYPE_SONG", "song"}, {0, NULL, NULL}};
		GType unity_music_lens_rhythmbox_collection_result_type_type_id;
		unity_music_lens_rhythmbox_collection_result_type_type_id = g_enum_register_static ("UnityMusicLensRhythmboxCollectionResultType", values);
		g_once_init_leave (&unity_music_lens_rhythmbox_collection_result_type_type_id__volatile, unity_music_lens_rhythmbox_collection_result_type_type_id);
	}
	return unity_music_lens_rhythmbox_collection_result_type_type_id__volatile;
}


static gchar* __lambda4_ (UnityMusicLensRhythmboxCollection* self, DeeModel* model, DeeModelIter* iter) {
	gchar* result = NULL;
	DeeModel* _tmp0_;
	DeeModelIter* _tmp1_;
	const gchar* _tmp2_ = NULL;
	DeeModel* _tmp3_;
	DeeModelIter* _tmp4_;
	const gchar* _tmp5_ = NULL;
	DeeModel* _tmp6_;
	DeeModelIter* _tmp7_;
	const gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* s;
	g_return_val_if_fail (model != NULL, NULL);
	g_return_val_if_fail (iter != NULL, NULL);
	_tmp0_ = model;
	_tmp1_ = iter;
	_tmp2_ = dee_model_get_string (_tmp0_, _tmp1_, (guint) UNITY_MUSIC_LENS_COLUMNS_TITLE);
	_tmp3_ = model;
	_tmp4_ = iter;
	_tmp5_ = dee_model_get_string (_tmp3_, _tmp4_, (guint) UNITY_MUSIC_LENS_COLUMNS_ARTIST);
	_tmp6_ = model;
	_tmp7_ = iter;
	_tmp8_ = dee_model_get_string (_tmp6_, _tmp7_, (guint) UNITY_MUSIC_LENS_COLUMNS_ALBUM);
	_tmp9_ = g_strdup_printf ("%s\n%s\n%s", _tmp2_, _tmp5_, _tmp8_);
	s = _tmp9_;
	result = s;
	return result;
}


static gchar* ___lambda4__dee_model_reader_func (DeeModel* model, DeeModelIter* iter, gpointer self) {
	gchar* result;
	result = __lambda4_ (self, model, iter);
	return result;
}


static void unity_music_lens_rhythmbox_collection_initialize_index (UnityMusicLensRhythmboxCollection* self) {
	DeeModelReader _tmp0_ = {0};
	DeeModelReader reader;
	DeeSequenceModel* _tmp1_;
	DeeAnalyzer* _tmp2_;
	DeeModelReader _tmp3_;
	DeeTreeIndex* _tmp4_;
	g_return_if_fail (self != NULL);
	dee_model_reader_new (___lambda4__dee_model_reader_func, g_object_ref (self), g_object_unref, &_tmp0_);
	reader = _tmp0_;
	_tmp1_ = self->priv->all_tracks;
	_tmp2_ = self->priv->analyzer;
	_tmp3_ = reader;
	_tmp4_ = dee_tree_index_new ((DeeModel*) _tmp1_, _tmp2_, &_tmp3_);
	_g_object_unref0 (self->priv->index);
	self->priv->index = (DeeIndex*) _tmp4_;
}


static guint8* string_get_data (const gchar* self, int* result_length1) {
	guint8* result;
	guint8* res;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	guint8* _tmp3_;
	gint _tmp3__length1;
	guint8* _tmp4_;
	gint _tmp4__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res_length1;
	_tmp3_ = res;
	_tmp3__length1 = res_length1;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp3__length1;
	if (result_length1) {
		*result_length1 = _tmp4__length1;
	}
	result = _tmp4_;
	return result;
}


static gchar* unity_music_lens_rhythmbox_collection_check_album_art_tdb (UnityMusicLensRhythmboxCollection* self, const gchar* artist, const gchar* album) {
	gchar* result = NULL;
	TDB_CONTEXT* _tmp0_;
	guint8 _tmp1_[1] = {0};
	guint8 null_helper[1];
	GByteArray* _tmp2_;
	GByteArray* byte_arr;
	GByteArray* _tmp3_;
	guint8* _tmp4_;
	gint _tmp4__length1;
	guint8* _tmp5_;
	gint _tmp5__length1;
	GByteArray* _tmp6_;
	GByteArray* _tmp7_;
	const gchar* _tmp8_;
	guint8* _tmp9_;
	gint _tmp9__length1;
	guint8* _tmp10_;
	gint _tmp10__length1;
	GByteArray* _tmp11_;
	GByteArray* _tmp12_;
	guint8* _tmp13_;
	gint _tmp13__length1;
	guint8* _tmp14_;
	gint _tmp14__length1;
	GByteArray* _tmp15_;
	GByteArray* _tmp16_;
	const gchar* _tmp17_;
	guint8* _tmp18_;
	gint _tmp18__length1;
	guint8* _tmp19_;
	gint _tmp19__length1;
	GByteArray* _tmp20_;
	TDB_DATA key;
	GByteArray* _tmp21_;
	guint8* _tmp22_;
	gint _tmp22__length1;
	TDB_CONTEXT* _tmp23_;
	TDB_DATA _tmp24_;
	TDB_DATA _tmp25_ = {0};
	TDB_DATA val;
	TDB_DATA _tmp26_;
	guint8* _tmp27_;
	gint _tmp27__length1;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (artist != NULL, NULL);
	g_return_val_if_fail (album != NULL, NULL);
	_tmp0_ = self->priv->album_art_tdb;
	if (_tmp0_ == NULL) {
		result = NULL;
		return result;
	}
	_tmp1_[0] = (guint8) 0;
	memcpy (null_helper, _tmp1_, 1 * sizeof (guint8));
	_tmp2_ = g_byte_array_new ();
	byte_arr = _tmp2_;
	_tmp3_ = byte_arr;
	_tmp4_ = string_get_data ("album", &_tmp4__length1);
	_tmp5_ = _tmp4_;
	_tmp5__length1 = _tmp4__length1;
	g_byte_array_append (_tmp3_, _tmp5_, _tmp5__length1);
	_tmp6_ = byte_arr;
	g_byte_array_append (_tmp6_, null_helper, 1);
	_tmp7_ = byte_arr;
	_tmp8_ = album;
	_tmp9_ = string_get_data (_tmp8_, &_tmp9__length1);
	_tmp10_ = _tmp9_;
	_tmp10__length1 = _tmp9__length1;
	g_byte_array_append (_tmp7_, _tmp10_, _tmp10__length1);
	_tmp11_ = byte_arr;
	g_byte_array_append (_tmp11_, null_helper, 1);
	_tmp12_ = byte_arr;
	_tmp13_ = string_get_data ("artist", &_tmp13__length1);
	_tmp14_ = _tmp13_;
	_tmp14__length1 = _tmp13__length1;
	g_byte_array_append (_tmp12_, _tmp14_, _tmp14__length1);
	_tmp15_ = byte_arr;
	g_byte_array_append (_tmp15_, null_helper, 1);
	_tmp16_ = byte_arr;
	_tmp17_ = artist;
	_tmp18_ = string_get_data (_tmp17_, &_tmp18__length1);
	_tmp19_ = _tmp18_;
	_tmp19__length1 = _tmp18__length1;
	g_byte_array_append (_tmp16_, _tmp19_, _tmp19__length1);
	_tmp20_ = byte_arr;
	g_byte_array_append (_tmp20_, null_helper, 1);
	key = tdb_null;
	_tmp21_ = byte_arr;
	_tmp22_ = _tmp21_->data;
	_tmp22__length1 = (gint) _tmp21_->len;
	key.dptr = _tmp22_;
	key.dsize = _tmp22__length1;
	_tmp23_ = self->priv->album_art_tdb;
	_tmp24_ = key;
	_tmp25_ = tdb_fetch (_tmp23_, _tmp24_);
	val = _tmp25_;
	_tmp26_ = val;
	_tmp27_ = _tmp26_.dptr;
	_tmp27__length1 = (gint) _tmp26_.dsize;
	if (_tmp27_ != NULL) {
		GVariantType* _tmp28_;
		GVariantType* _tmp29_;
		TDB_DATA _tmp30_;
		guint8* _tmp31_;
		gint _tmp31__length1;
		GVariant* _tmp32_ = NULL;
		GVariant* _tmp33_;
		GVariant* _tmp34_;
		GVariant* v;
		GVariant* _tmp35_;
		const GVariantType* _tmp36_;
		GVariant* _tmp37_ = NULL;
		GVariant* file_variant;
		GVariant* _tmp38_;
		_tmp28_ = g_variant_type_new ("a{sv}");
		_tmp29_ = _tmp28_;
		_tmp30_ = val;
		_tmp31_ = _tmp30_.dptr;
		_tmp31__length1 = (gint) _tmp30_.dsize;
		_tmp32_ = g_variant_new_from_data (_tmp29_, _tmp31_, _tmp31__length1, FALSE, NULL, NULL);
		_tmp33_ = g_variant_ref_sink (_tmp32_);
		_tmp34_ = _tmp33_;
		_g_variant_type_free0 (_tmp29_);
		v = _tmp34_;
		_tmp35_ = v;
		_tmp36_ = G_VARIANT_TYPE_STRING;
		_tmp37_ = g_variant_lookup_value (_tmp35_, "file", _tmp36_);
		file_variant = _tmp37_;
		_tmp38_ = file_variant;
		if (_tmp38_ != NULL) {
			GVariant* _tmp39_;
			const gchar* _tmp40_ = NULL;
			gchar* _tmp41_;
			_tmp39_ = file_variant;
			_tmp40_ = g_variant_get_string (_tmp39_, NULL);
			_tmp41_ = g_strdup (_tmp40_);
			result = _tmp41_;
			_g_variant_unref0 (file_variant);
			_g_variant_unref0 (v);
			_g_byte_array_unref0 (byte_arr);
			return result;
		}
		_g_variant_unref0 (file_variant);
		_g_variant_unref0 (v);
	}
	result = NULL;
	_g_byte_array_unref0 (byte_arr);
	return result;
}


static gchar* unity_music_lens_rhythmbox_collection_get_albumart (UnityMusicLensRhythmboxCollection* self, UnityMusicLensTrack* track) {
	gchar* result = NULL;
	gchar* filename = NULL;
	UnityMusicLensTrack* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* artist;
	UnityMusicLensTrack* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* album;
	const gchar* _tmp16_;
	gchar* _tmp17_ = NULL;
	gchar* artist_norm;
	const gchar* _tmp18_;
	gchar* _tmp19_ = NULL;
	gchar* album_norm;
	const gchar* _tmp20_;
	const gchar* _tmp21_;
	gchar* _tmp22_ = NULL;
	const gchar* _tmp23_;
	const gchar* _tmp29_;
	gchar* _tmp30_ = NULL;
	gchar* artist_md5;
	const gchar* _tmp31_;
	gchar* _tmp32_ = NULL;
	gchar* album_md5;
	const gchar* _tmp33_;
	const gchar* _tmp34_;
	const gchar* _tmp35_;
	gchar* _tmp36_ = NULL;
	gchar* _tmp37_;
	gchar* _tmp38_ = NULL;
	const gchar* _tmp39_;
	gboolean _tmp40_ = FALSE;
	const gchar* _tmp41_;
	const gchar* _tmp42_;
	gchar* _tmp43_ = NULL;
	gchar* _tmp44_;
	gchar* _tmp45_ = NULL;
	gchar* _tmp46_;
	gchar* combined;
	const gchar* _tmp47_;
	const gchar* _tmp48_;
	gchar* _tmp49_ = NULL;
	gchar* _tmp50_;
	gchar* _tmp51_ = NULL;
	gchar* _tmp52_;
	gchar* _tmp53_ = NULL;
	const gchar* _tmp54_;
	gboolean _tmp55_ = FALSE;
	const gchar* _tmp66_ = NULL;
	UnityMusicLensTrack* _tmp67_;
	const gchar* _tmp68_;
	const gchar* _tmp69_;
	UnityMusicLensTrack* _tmp70_;
	const gchar* _tmp71_;
	const gchar* _tmp72_;
	gchar* _tmp73_ = NULL;
	gchar* _tmp74_;
	gchar* _tmp75_ = NULL;
	gchar* _tmp76_;
	gchar* artwork;
	const gchar* _tmp77_;
	gboolean _tmp78_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (track != NULL, NULL);
	_tmp0_ = track;
	_tmp1_ = unity_music_lens_track_get_album_artist (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_;
	if (_tmp5_ == NULL) {
		UnityMusicLensTrack* _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp6_ = track;
		_tmp7_ = unity_music_lens_track_get_artist (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_strdup (_tmp8_);
		_g_free0 (_tmp4_);
		_tmp4_ = _tmp9_;
	}
	_tmp10_ = _tmp4_;
	_tmp11_ = g_strdup (_tmp10_);
	artist = _tmp11_;
	_tmp12_ = track;
	_tmp13_ = unity_music_lens_track_get_album (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = g_strdup (_tmp14_);
	album = _tmp15_;
	_tmp16_ = artist;
	_tmp17_ = g_utf8_normalize (_tmp16_, (gssize) (-1), G_NORMALIZE_NFKD);
	artist_norm = _tmp17_;
	_tmp18_ = album;
	_tmp19_ = g_utf8_normalize (_tmp18_, (gssize) (-1), G_NORMALIZE_NFKD);
	album_norm = _tmp19_;
	_tmp20_ = artist;
	_tmp21_ = album;
	_tmp22_ = unity_music_lens_rhythmbox_collection_check_album_art_tdb (self, _tmp20_, _tmp21_);
	_g_free0 (filename);
	filename = _tmp22_;
	_tmp23_ = filename;
	if (_tmp23_ != NULL) {
		const gchar* _tmp24_ = NULL;
		const gchar* _tmp25_;
		gchar* _tmp26_ = NULL;
		const gchar* _tmp27_;
		gboolean _tmp28_ = FALSE;
		_tmp24_ = g_get_user_cache_dir ();
		_tmp25_ = filename;
		_tmp26_ = g_build_filename (_tmp24_, "rhythmbox", "album-art", _tmp25_, NULL);
		_g_free0 (filename);
		filename = _tmp26_;
		_tmp27_ = filename;
		_tmp28_ = g_file_test (_tmp27_, G_FILE_TEST_EXISTS);
		if (_tmp28_) {
			result = filename;
			_g_free0 (album_norm);
			_g_free0 (artist_norm);
			_g_free0 (album);
			_g_free0 (artist);
			_g_free0 (_tmp4_);
			return result;
		}
	}
	_tmp29_ = artist_norm;
	_tmp30_ = g_compute_checksum_for_string (G_CHECKSUM_MD5, _tmp29_, (gsize) (-1));
	artist_md5 = _tmp30_;
	_tmp31_ = album_norm;
	_tmp32_ = g_compute_checksum_for_string (G_CHECKSUM_MD5, _tmp31_, (gsize) (-1));
	album_md5 = _tmp32_;
	_tmp33_ = self->priv->media_art_dir;
	_tmp34_ = artist_md5;
	_tmp35_ = album_md5;
	_tmp36_ = g_strdup_printf ("album-%s-%s", _tmp34_, _tmp35_);
	_tmp37_ = _tmp36_;
	_tmp38_ = g_build_filename (_tmp33_, _tmp37_, NULL);
	_g_free0 (filename);
	filename = _tmp38_;
	_g_free0 (_tmp37_);
	_tmp39_ = filename;
	_tmp40_ = g_file_test (_tmp39_, G_FILE_TEST_EXISTS);
	if (_tmp40_) {
		result = filename;
		_g_free0 (album_md5);
		_g_free0 (artist_md5);
		_g_free0 (album_norm);
		_g_free0 (artist_norm);
		_g_free0 (album);
		_g_free0 (artist);
		_g_free0 (_tmp4_);
		return result;
	}
	_tmp41_ = artist;
	_tmp42_ = album;
	_tmp43_ = g_strdup_printf ("%s\t%s", _tmp41_, _tmp42_);
	_tmp44_ = _tmp43_;
	_tmp45_ = g_utf8_normalize (_tmp44_, (gssize) (-1), G_NORMALIZE_NFKD);
	_tmp46_ = _tmp45_;
	_g_free0 (_tmp44_);
	combined = _tmp46_;
	_tmp47_ = self->priv->media_art_dir;
	_tmp48_ = combined;
	_tmp49_ = g_compute_checksum_for_string (G_CHECKSUM_MD5, _tmp48_, (gsize) (-1));
	_tmp50_ = _tmp49_;
	_tmp51_ = g_strdup_printf ("album-%s.jpg", _tmp50_);
	_tmp52_ = _tmp51_;
	_tmp53_ = g_build_filename (_tmp47_, _tmp52_, NULL);
	_g_free0 (filename);
	filename = _tmp53_;
	_g_free0 (_tmp52_);
	_g_free0 (_tmp50_);
	_tmp54_ = filename;
	_tmp55_ = g_file_test (_tmp54_, G_FILE_TEST_EXISTS);
	if (_tmp55_) {
		result = filename;
		_g_free0 (combined);
		_g_free0 (album_md5);
		_g_free0 (artist_md5);
		_g_free0 (album_norm);
		_g_free0 (artist_norm);
		_g_free0 (album);
		_g_free0 (artist);
		_g_free0 (_tmp4_);
		return result;
	}
	{
		UnityMusicLensTrack* _tmp56_;
		const gchar* _tmp57_;
		const gchar* _tmp58_;
		GFile* _tmp59_ = NULL;
		GFile* artwork_file;
		GFile* _tmp60_;
		GFileInfo* _tmp61_ = NULL;
		GFileInfo* info;
		GFileInfo* _tmp62_;
		const gchar* _tmp63_ = NULL;
		gchar* _tmp64_;
		gchar* thumbnail_path;
		const gchar* _tmp65_;
		_tmp56_ = track;
		_tmp57_ = unity_music_lens_track_get_uri (_tmp56_);
		_tmp58_ = _tmp57_;
		_tmp59_ = g_file_new_for_uri (_tmp58_);
		artwork_file = _tmp59_;
		_tmp60_ = artwork_file;
		_tmp61_ = g_file_query_info (_tmp60_, G_FILE_ATTRIBUTE_THUMBNAIL_PATH, 0, NULL, &_inner_error_);
		info = _tmp61_;
		if (_inner_error_ != NULL) {
			_g_object_unref0 (artwork_file);
			goto __catch8_g_error;
		}
		_tmp62_ = info;
		_tmp63_ = g_file_info_get_attribute_string (_tmp62_, G_FILE_ATTRIBUTE_THUMBNAIL_PATH);
		_tmp64_ = g_strdup (_tmp63_);
		thumbnail_path = _tmp64_;
		_tmp65_ = thumbnail_path;
		if (_tmp65_ != NULL) {
			result = thumbnail_path;
			_g_object_unref0 (info);
			_g_object_unref0 (artwork_file);
			_g_free0 (combined);
			_g_free0 (album_md5);
			_g_free0 (artist_md5);
			_g_free0 (album_norm);
			_g_free0 (artist_norm);
			_g_free0 (album);
			_g_free0 (artist);
			_g_free0 (_tmp4_);
			_g_free0 (filename);
			return result;
		}
		_g_free0 (thumbnail_path);
		_g_object_unref0 (info);
		_g_object_unref0 (artwork_file);
	}
	goto __finally8;
	__catch8_g_error:
	{
		g_clear_error (&_inner_error_);
		_inner_error_ = NULL;
	}
	__finally8:
	if (_inner_error_ != NULL) {
		_g_free0 (combined);
		_g_free0 (album_md5);
		_g_free0 (artist_md5);
		_g_free0 (album_norm);
		_g_free0 (artist_norm);
		_g_free0 (album);
		_g_free0 (artist);
		_g_free0 (_tmp4_);
		_g_free0 (filename);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp66_ = g_get_user_cache_dir ();
	_tmp67_ = track;
	_tmp68_ = unity_music_lens_track_get_artist (_tmp67_);
	_tmp69_ = _tmp68_;
	_tmp70_ = track;
	_tmp71_ = unity_music_lens_track_get_album (_tmp70_);
	_tmp72_ = _tmp71_;
	_tmp73_ = g_strdup_printf ("%s - %s.jpg", _tmp69_, _tmp72_);
	_tmp74_ = _tmp73_;
	_tmp75_ = g_build_filename (_tmp66_, "rhythmbox", "covers", _tmp74_, NULL);
	_tmp76_ = _tmp75_;
	_g_free0 (_tmp74_);
	artwork = _tmp76_;
	_tmp77_ = artwork;
	_tmp78_ = g_file_test (_tmp77_, G_FILE_TEST_EXISTS);
	if (_tmp78_) {
		result = artwork;
		_g_free0 (combined);
		_g_free0 (album_md5);
		_g_free0 (artist_md5);
		_g_free0 (album_norm);
		_g_free0 (artist_norm);
		_g_free0 (album);
		_g_free0 (artist);
		_g_free0 (_tmp4_);
		_g_free0 (filename);
		return result;
	}
	result = NULL;
	_g_free0 (artwork);
	_g_free0 (combined);
	_g_free0 (album_md5);
	_g_free0 (artist_md5);
	_g_free0 (album_norm);
	_g_free0 (artist_norm);
	_g_free0 (album);
	_g_free0 (artist);
	_g_free0 (_tmp4_);
	_g_free0 (filename);
	return result;
}


static gpointer _g_ptr_array_ref0 (gpointer self) {
	return self ? g_ptr_array_ref (self) : NULL;
}


static gint g_ptr_array_get_length (GPtrArray* self) {
	gint result;
	guint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->len;
	result = (gint) _tmp0_;
	return result;
}


static void g_ptr_array_set_length (GPtrArray* self, gint value) {
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	g_ptr_array_set_size (self, _tmp0_);
}


GSList* unity_music_lens_rhythmbox_collection_get_album_tracks (UnityMusicLensRhythmboxCollection* self, const gchar* album_key) {
	GSList* result = NULL;
	GSList* results;
	GHashTable* _tmp0_;
	const gchar* _tmp1_;
	gconstpointer _tmp2_ = NULL;
	GPtrArray* _tmp3_;
	GPtrArray* iter_arr;
	GPtrArray* _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (album_key != NULL, NULL);
	results = NULL;
	_tmp0_ = self->priv->album_to_tracks_map;
	_tmp1_ = album_key;
	_tmp2_ = g_hash_table_lookup (_tmp0_, _tmp1_);
	_tmp3_ = _g_ptr_array_ref0 ((GPtrArray*) _tmp2_);
	iter_arr = _tmp3_;
	_tmp4_ = iter_arr;
	if (_tmp4_ != NULL) {
		{
			GPtrArray* _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			gint i;
			_tmp5_ = iter_arr;
			_tmp6_ = g_ptr_array_get_length (_tmp5_);
			_tmp7_ = _tmp6_;
			i = _tmp7_ - 1;
			{
				gboolean _tmp8_;
				_tmp8_ = TRUE;
				while (TRUE) {
					gboolean _tmp9_;
					gint _tmp11_;
					DeeSequenceModel* _tmp12_;
					GPtrArray* _tmp13_;
					gint _tmp14_;
					gconstpointer _tmp15_ = NULL;
					const gchar* _tmp16_ = NULL;
					_tmp9_ = _tmp8_;
					if (!_tmp9_) {
						gint _tmp10_;
						_tmp10_ = i;
						i = _tmp10_ - 1;
					}
					_tmp8_ = FALSE;
					_tmp11_ = i;
					if (!(_tmp11_ >= 0)) {
						break;
					}
					_tmp12_ = self->priv->all_tracks;
					_tmp13_ = iter_arr;
					_tmp14_ = i;
					_tmp15_ = g_ptr_array_index (_tmp13_, (guint) _tmp14_);
					_tmp16_ = dee_model_get_string ((DeeModel*) _tmp12_, (DeeModelIter*) _tmp15_, (guint) UNITY_MUSIC_LENS_COLUMNS_URI);
					results = g_slist_prepend (results, _tmp16_);
				}
			}
		}
	}
	result = results;
	_g_ptr_array_unref0 (iter_arr);
	return result;
}


static gpointer _g_variant_ref0 (gpointer self) {
	return self ? g_variant_ref (self) : NULL;
}


static GVariant* unity_music_lens_rhythmbox_collection_cached_variant_for_string (UnityMusicLensRhythmboxCollection* self, const gchar* input) {
	GVariant* result = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_;
	const gchar* _tmp3_;
	const gchar* text;
	GHashTable* _tmp4_;
	const gchar* _tmp5_;
	gconstpointer _tmp6_ = NULL;
	GVariant* _tmp7_;
	GVariant* v;
	GVariant* _tmp8_;
	const gchar* _tmp9_;
	GVariant* _tmp10_;
	GVariant* _tmp11_;
	GHashTable* _tmp12_;
	GVariant* _tmp13_;
	const gchar* _tmp14_ = NULL;
	GVariant* _tmp15_;
	GVariant* _tmp16_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = input;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_;
		_tmp2_ = input;
		_tmp0_ = _tmp2_;
	} else {
		_tmp0_ = "";
	}
	_tmp3_ = _tmp0_;
	text = _tmp3_;
	_tmp4_ = self->priv->variant_store;
	_tmp5_ = text;
	_tmp6_ = g_hash_table_lookup (_tmp4_, _tmp5_);
	_tmp7_ = _g_variant_ref0 ((GVariant*) _tmp6_);
	v = _tmp7_;
	_tmp8_ = v;
	if (_tmp8_ != NULL) {
		result = v;
		return result;
	}
	_tmp9_ = text;
	_tmp10_ = g_variant_new_string (_tmp9_);
	_tmp11_ = g_variant_ref_sink (_tmp10_);
	_g_variant_unref0 (v);
	v = _tmp11_;
	_tmp12_ = self->priv->variant_store;
	_tmp13_ = v;
	_tmp14_ = g_variant_get_string (_tmp13_, NULL);
	_tmp15_ = v;
	_tmp16_ = _g_variant_ref0 (_tmp15_);
	g_hash_table_insert (_tmp12_, _tmp14_, _tmp16_);
	result = v;
	return result;
}


static GVariant* unity_music_lens_rhythmbox_collection_cached_variant_for_int (UnityMusicLensRhythmboxCollection* self, gint input) {
	GVariant* result = NULL;
	GHashTable* _tmp0_;
	gint _tmp1_;
	gconstpointer _tmp2_ = NULL;
	GVariant* _tmp3_;
	GVariant* v;
	GVariant* _tmp4_;
	gint _tmp5_;
	GVariant* _tmp6_;
	GVariant* _tmp7_;
	gint _tmp8_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->int_variant_store;
	_tmp1_ = input;
	_tmp2_ = g_hash_table_lookup (_tmp0_, GINT_TO_POINTER (_tmp1_));
	_tmp3_ = _g_variant_ref0 ((GVariant*) _tmp2_);
	v = _tmp3_;
	_tmp4_ = v;
	if (_tmp4_ != NULL) {
		result = v;
		return result;
	}
	_tmp5_ = input;
	_tmp6_ = g_variant_new_int32 ((gint32) _tmp5_);
	_tmp7_ = g_variant_ref_sink (_tmp6_);
	_g_variant_unref0 (v);
	v = _tmp7_;
	_tmp8_ = input;
	if (_tmp8_ < 128) {
		GHashTable* _tmp9_;
		gint _tmp10_;
		GVariant* _tmp11_;
		GVariant* _tmp12_;
		_tmp9_ = self->priv->int_variant_store;
		_tmp10_ = input;
		_tmp11_ = v;
		_tmp12_ = _g_variant_ref0 (_tmp11_);
		g_hash_table_insert (_tmp9_, GINT_TO_POINTER (_tmp10_), _tmp12_);
	}
	result = v;
	return result;
}


static void unity_music_lens_rhythmbox_collection_prepare_row_buffer (UnityMusicLensRhythmboxCollection* self, UnityMusicLensTrack* track) {
	UnityMusicLensTrack* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GVariant* _tmp3_;
	GVariant* _tmp4_;
	GVariant* uri;
	UnityMusicLensTrack* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	GVariant* _tmp8_;
	GVariant* _tmp9_;
	GVariant* title;
	UnityMusicLensTrack* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	GVariant* _tmp13_ = NULL;
	GVariant* artist;
	UnityMusicLensTrack* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	GVariant* _tmp17_ = NULL;
	GVariant* album_artist;
	UnityMusicLensTrack* _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	GVariant* _tmp21_ = NULL;
	GVariant* album;
	UnityMusicLensTrack* _tmp22_;
	const gchar* _tmp23_;
	const gchar* _tmp24_;
	GVariant* _tmp25_ = NULL;
	GVariant* mime_type;
	UnityMusicLensTrack* _tmp26_;
	const gchar* _tmp27_;
	const gchar* _tmp28_;
	GVariant* _tmp29_ = NULL;
	GVariant* artwork;
	UnityMusicLensTrack* _tmp30_;
	const gchar* _tmp31_;
	const gchar* _tmp32_;
	GVariant* _tmp33_ = NULL;
	GVariant* genre;
	UnityMusicLensTrack* _tmp34_;
	gint _tmp35_;
	gint _tmp36_;
	GVariant* _tmp37_ = NULL;
	GVariant* track_number;
	UnityMusicLensTrack* _tmp38_;
	gint _tmp39_;
	gint _tmp40_;
	GVariant* _tmp41_ = NULL;
	GVariant* year;
	UnityMusicLensTrack* _tmp42_;
	gint _tmp43_;
	gint _tmp44_;
	GVariant* _tmp45_ = NULL;
	GVariant* play_count;
	GVariant* _tmp46_;
	GVariant* _tmp47_;
	GVariant* _tmp48_;
	GVariant* _tmp49_;
	GVariant* _tmp50_;
	GVariant* _tmp51_;
	GVariant* _tmp52_;
	GVariant* _tmp53_;
	GVariant* _tmp54_;
	GVariant* _tmp55_;
	GVariant* _tmp56_;
	GVariant* _tmp57_;
	GVariant* _tmp58_;
	GVariant* _tmp59_;
	GVariant* _tmp60_;
	GVariant* _tmp61_;
	GVariant* _tmp62_;
	GVariant* _tmp63_;
	GVariant* _tmp64_;
	GVariant* _tmp65_;
	GVariant* _tmp66_;
	GVariant* _tmp67_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (track != NULL);
	_tmp0_ = track;
	_tmp1_ = unity_music_lens_track_get_uri (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_variant_new_string (_tmp2_);
	_tmp4_ = g_variant_ref_sink (_tmp3_);
	uri = _tmp4_;
	_tmp5_ = track;
	_tmp6_ = unity_music_lens_track_get_title (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_variant_new_string (_tmp7_);
	_tmp9_ = g_variant_ref_sink (_tmp8_);
	title = _tmp9_;
	_tmp10_ = track;
	_tmp11_ = unity_music_lens_track_get_artist (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = unity_music_lens_rhythmbox_collection_cached_variant_for_string (self, _tmp12_);
	artist = _tmp13_;
	_tmp14_ = track;
	_tmp15_ = unity_music_lens_track_get_album_artist (_tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = unity_music_lens_rhythmbox_collection_cached_variant_for_string (self, _tmp16_);
	album_artist = _tmp17_;
	_tmp18_ = track;
	_tmp19_ = unity_music_lens_track_get_album (_tmp18_);
	_tmp20_ = _tmp19_;
	_tmp21_ = unity_music_lens_rhythmbox_collection_cached_variant_for_string (self, _tmp20_);
	album = _tmp21_;
	_tmp22_ = track;
	_tmp23_ = unity_music_lens_track_get_mime_type (_tmp22_);
	_tmp24_ = _tmp23_;
	_tmp25_ = unity_music_lens_rhythmbox_collection_cached_variant_for_string (self, _tmp24_);
	mime_type = _tmp25_;
	_tmp26_ = track;
	_tmp27_ = unity_music_lens_track_get_artwork_path (_tmp26_);
	_tmp28_ = _tmp27_;
	_tmp29_ = unity_music_lens_rhythmbox_collection_cached_variant_for_string (self, _tmp28_);
	artwork = _tmp29_;
	_tmp30_ = track;
	_tmp31_ = unity_music_lens_track_get_genre (_tmp30_);
	_tmp32_ = _tmp31_;
	_tmp33_ = unity_music_lens_rhythmbox_collection_cached_variant_for_string (self, _tmp32_);
	genre = _tmp33_;
	_tmp34_ = track;
	_tmp35_ = unity_music_lens_track_get_track_number (_tmp34_);
	_tmp36_ = _tmp35_;
	_tmp37_ = unity_music_lens_rhythmbox_collection_cached_variant_for_int (self, _tmp36_);
	track_number = _tmp37_;
	_tmp38_ = track;
	_tmp39_ = unity_music_lens_track_get_year (_tmp38_);
	_tmp40_ = _tmp39_;
	_tmp41_ = unity_music_lens_rhythmbox_collection_cached_variant_for_int (self, _tmp40_);
	year = _tmp41_;
	_tmp42_ = track;
	_tmp43_ = unity_music_lens_track_get_play_count (_tmp42_);
	_tmp44_ = _tmp43_;
	_tmp45_ = unity_music_lens_rhythmbox_collection_cached_variant_for_int (self, _tmp44_);
	play_count = _tmp45_;
	_tmp46_ = _g_variant_ref0 (uri);
	_g_variant_unref0 (self->priv->row_buffer[0]);
	self->priv->row_buffer[0] = _tmp46_;
	_tmp47_ = self->priv->row_buffer[0];
	_tmp48_ = _g_variant_ref0 (title);
	_g_variant_unref0 (self->priv->row_buffer[1]);
	self->priv->row_buffer[1] = _tmp48_;
	_tmp49_ = self->priv->row_buffer[1];
	_tmp50_ = _g_variant_ref0 (artist);
	_g_variant_unref0 (self->priv->row_buffer[2]);
	self->priv->row_buffer[2] = _tmp50_;
	_tmp51_ = self->priv->row_buffer[2];
	_tmp52_ = _g_variant_ref0 (album);
	_g_variant_unref0 (self->priv->row_buffer[3]);
	self->priv->row_buffer[3] = _tmp52_;
	_tmp53_ = self->priv->row_buffer[3];
	_tmp54_ = _g_variant_ref0 (artwork);
	_g_variant_unref0 (self->priv->row_buffer[4]);
	self->priv->row_buffer[4] = _tmp54_;
	_tmp55_ = self->priv->row_buffer[4];
	_tmp56_ = _g_variant_ref0 (mime_type);
	_g_variant_unref0 (self->priv->row_buffer[5]);
	self->priv->row_buffer[5] = _tmp56_;
	_tmp57_ = self->priv->row_buffer[5];
	_tmp58_ = _g_variant_ref0 (genre);
	_g_variant_unref0 (self->priv->row_buffer[6]);
	self->priv->row_buffer[6] = _tmp58_;
	_tmp59_ = self->priv->row_buffer[6];
	_tmp60_ = _g_variant_ref0 (album_artist);
	_g_variant_unref0 (self->priv->row_buffer[7]);
	self->priv->row_buffer[7] = _tmp60_;
	_tmp61_ = self->priv->row_buffer[7];
	_tmp62_ = _g_variant_ref0 (track_number);
	_g_variant_unref0 (self->priv->row_buffer[8]);
	self->priv->row_buffer[8] = _tmp62_;
	_tmp63_ = self->priv->row_buffer[8];
	_tmp64_ = _g_variant_ref0 (year);
	_g_variant_unref0 (self->priv->row_buffer[9]);
	self->priv->row_buffer[9] = _tmp64_;
	_tmp65_ = self->priv->row_buffer[9];
	_tmp66_ = _g_variant_ref0 (play_count);
	_g_variant_unref0 (self->priv->row_buffer[10]);
	self->priv->row_buffer[10] = _tmp66_;
	_tmp67_ = self->priv->row_buffer[10];
	_g_variant_unref0 (play_count);
	_g_variant_unref0 (year);
	_g_variant_unref0 (track_number);
	_g_variant_unref0 (genre);
	_g_variant_unref0 (artwork);
	_g_variant_unref0 (mime_type);
	_g_variant_unref0 (album);
	_g_variant_unref0 (album_artist);
	_g_variant_unref0 (artist);
	_g_variant_unref0 (title);
	_g_variant_unref0 (uri);
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (Block2Data* _data2_) {
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		_g_object_unref0 (_data2_->self);
		_g_free0 (_data2_->path);
		g_slice_free (Block2Data, _data2_);
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void ____lambda5_ (Block2Data* _data2_) {
	UnityMusicLensRhythmboxCollection * self;
	TDB_CONTEXT* _tmp0_;
	self = _data2_->self;
	_tmp0_ = self->priv->album_art_tdb;
	if (_tmp0_ == NULL) {
		const gchar* _tmp1_;
		_tmp1_ = _data2_->path;
		unity_music_lens_rhythmbox_collection_parse_metadata_file (self, _tmp1_);
	} else {
		gint _tmp2_;
		_tmp2_ = self->priv->current_album_art_tag;
		self->priv->current_album_art_tag = _tmp2_ + 1;
	}
}


static void _____lambda5__g_file_monitor_changed (GFileMonitor* _sender, GFile* file, GFile* other_file, GFileMonitorEvent event_type, gpointer self) {
	____lambda5_ (self);
}


void unity_music_lens_rhythmbox_collection_parse_metadata_file (UnityMusicLensRhythmboxCollection* self, const gchar* path) {
	Block2Data* _data2_;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	TDB_CONTEXT* _tmp2_;
	GFileMonitor* _tmp3_;
	int flags;
	const gchar* _tmp13_;
	int _tmp14_;
	TDB_CONTEXT* _tmp15_;
	TDB_CONTEXT* _tmp16_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_tmp0_ = path;
	_tmp1_ = g_strdup (_tmp0_);
	_data2_->path = _tmp1_;
	_tmp2_ = self->priv->album_art_tdb;
	if (_tmp2_ != NULL) {
		block2_data_unref (_data2_);
		_data2_ = NULL;
		return;
	}
	_tmp3_ = self->priv->tdb_monitor;
	if (_tmp3_ == NULL) {
		const gchar* _tmp4_;
		GFile* _tmp5_ = NULL;
		GFile* tdb_file;
		_tmp4_ = _data2_->path;
		_tmp5_ = g_file_new_for_path (_tmp4_);
		tdb_file = _tmp5_;
		{
			GFile* _tmp6_;
			GFileMonitor* _tmp7_ = NULL;
			GFileMonitor* _tmp8_;
			GFileMonitor* _tmp9_;
			GFileMonitor* _tmp10_;
			_tmp6_ = tdb_file;
			_tmp7_ = g_file_monitor (_tmp6_, G_FILE_MONITOR_NONE, NULL, &_inner_error_);
			_tmp8_ = _tmp7_;
			if (_inner_error_ != NULL) {
				goto __catch9_g_error;
			}
			_tmp9_ = _g_object_ref0 (_tmp8_);
			_g_object_unref0 (self->priv->tdb_monitor);
			self->priv->tdb_monitor = _tmp9_;
			_tmp10_ = self->priv->tdb_monitor;
			g_signal_connect_data (_tmp10_, "changed", (GCallback) _____lambda5__g_file_monitor_changed, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
		}
		goto __finally9;
		__catch9_g_error:
		{
			GError* err = NULL;
			GError* _tmp11_;
			const gchar* _tmp12_;
			err = _inner_error_;
			_inner_error_ = NULL;
			_tmp11_ = err;
			_tmp12_ = _tmp11_->message;
			g_warning ("rhythmbox-collection.vala:429: %s", _tmp12_);
			_g_error_free0 (err);
		}
		__finally9:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (tdb_file);
			block2_data_unref (_data2_);
			_data2_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_g_object_unref0 (tdb_file);
	}
	flags = (TDB_INCOMPATIBLE_HASH | TDB_SEQNUM) | TDB_NOLOCK;
	_tmp13_ = _data2_->path;
	_tmp14_ = flags;
	_tmp15_ = tdb_open (_tmp13_, 999, _tmp14_, O_RDONLY, (mode_t) 0600);
	_tdb_close0 (self->priv->album_art_tdb);
	self->priv->album_art_tdb = _tmp15_;
	_tmp16_ = self->priv->album_art_tdb;
	if (_tmp16_ == NULL) {
		g_warning ("rhythmbox-collection.vala:438: Unable to open album-art DB!");
		block2_data_unref (_data2_);
		_data2_ = NULL;
		return;
	}
	block2_data_unref (_data2_);
	_data2_ = NULL;
}


static void __lambda6_ (UnityMusicLensRhythmboxCollection* self, UnityMusicLensTrack* track) {
	UnityMusicLensTrack* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* albumart;
	const gchar* _tmp2_;
	UnityMusicLensTrack* _tmp6_;
	DeeSequenceModel* _tmp7_;
	DeeModelIter* _tmp8_ = NULL;
	DeeModelIter* iter;
	UnityMusicLensTrack* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_ = NULL;
	UnityMusicLensTrack* _tmp13_;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	UnityMusicLensTrack* _tmp22_;
	const gchar* _tmp23_;
	const gchar* _tmp24_;
	const gchar* _tmp25_;
	gchar* _tmp26_ = NULL;
	gchar* album_key;
	GHashTable* _tmp27_;
	const gchar* _tmp28_;
	gconstpointer _tmp29_ = NULL;
	GPtrArray* _tmp30_;
	GPtrArray* arr;
	GPtrArray* _tmp31_;
	GPtrArray* _tmp38_;
	DeeModelIter* _tmp39_;
	g_return_if_fail (track != NULL);
	_tmp0_ = track;
	_tmp1_ = unity_music_lens_rhythmbox_collection_get_albumart (self, _tmp0_);
	albumart = _tmp1_;
	_tmp2_ = albumart;
	if (_tmp2_ != NULL) {
		UnityMusicLensTrack* _tmp3_;
		const gchar* _tmp4_;
		_tmp3_ = track;
		_tmp4_ = albumart;
		unity_music_lens_track_set_artwork_path (_tmp3_, _tmp4_);
	} else {
		UnityMusicLensTrack* _tmp5_;
		_tmp5_ = track;
		unity_music_lens_track_set_artwork_path (_tmp5_, "audio-x-generic");
	}
	_tmp6_ = track;
	unity_music_lens_rhythmbox_collection_prepare_row_buffer (self, _tmp6_);
	_tmp7_ = self->priv->all_tracks;
	_tmp8_ = dee_model_append_row ((DeeModel*) _tmp7_, self->priv->row_buffer);
	iter = _tmp8_;
	_tmp9_ = track;
	_tmp10_ = unity_music_lens_track_get_album (_tmp9_);
	_tmp11_ = _tmp10_;
	if (g_strcmp0 (_tmp11_, UNITY_MUSIC_LENS_RHYTHMBOX_COLLECTION_UNKNOWN_ALBUM) == 0) {
		_g_free0 (albumart);
		return;
	}
	_tmp13_ = track;
	_tmp14_ = unity_music_lens_track_get_album_artist (_tmp13_);
	_tmp15_ = _tmp14_;
	if (_tmp15_ != NULL) {
		UnityMusicLensTrack* _tmp16_;
		const gchar* _tmp17_;
		const gchar* _tmp18_;
		_tmp16_ = track;
		_tmp17_ = unity_music_lens_track_get_album_artist (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp12_ = _tmp18_;
	} else {
		UnityMusicLensTrack* _tmp19_;
		const gchar* _tmp20_;
		const gchar* _tmp21_;
		_tmp19_ = track;
		_tmp20_ = unity_music_lens_track_get_artist (_tmp19_);
		_tmp21_ = _tmp20_;
		_tmp12_ = _tmp21_;
	}
	_tmp22_ = track;
	_tmp23_ = unity_music_lens_track_get_album (_tmp22_);
	_tmp24_ = _tmp23_;
	_tmp25_ = _tmp12_;
	_tmp26_ = g_strdup_printf ("%s - %s", _tmp24_, _tmp25_);
	album_key = _tmp26_;
	_tmp27_ = self->priv->album_to_tracks_map;
	_tmp28_ = album_key;
	_tmp29_ = g_hash_table_lookup (_tmp27_, _tmp28_);
	_tmp30_ = _g_ptr_array_ref0 ((GPtrArray*) _tmp29_);
	arr = _tmp30_;
	_tmp31_ = arr;
	if (_tmp31_ == NULL) {
		GPtrArray* _tmp32_;
		GHashTable* _tmp33_;
		const gchar* _tmp34_;
		gchar* _tmp35_;
		GPtrArray* _tmp36_;
		GPtrArray* _tmp37_;
		_tmp32_ = g_ptr_array_new_with_free_func (NULL);
		_g_ptr_array_unref0 (arr);
		arr = _tmp32_;
		_tmp33_ = self->priv->album_to_tracks_map;
		_tmp34_ = album_key;
		_tmp35_ = g_strdup (_tmp34_);
		_tmp36_ = arr;
		_tmp37_ = _g_ptr_array_ref0 (_tmp36_);
		g_hash_table_insert (_tmp33_, _tmp35_, _tmp37_);
	}
	_tmp38_ = arr;
	_tmp39_ = iter;
	g_ptr_array_add (_tmp38_, _tmp39_);
	_g_ptr_array_unref0 (arr);
	_g_free0 (album_key);
	_g_free0 (albumart);
}


static void ___lambda6__unity_music_lens_rhythmbox_collection_xml_parser_track_info_ready (UnityMusicLensRhythmboxCollectionXmlParser* _sender, UnityMusicLensTrack* track, gpointer self) {
	__lambda6_ (self, track);
}


static gint ____lambda7_ (UnityMusicLensRhythmboxCollection* self, DeeModelIter** a, DeeModelIter** b) {
	gint result = 0;
	DeeSequenceModel* _tmp0_;
	DeeModelIter* _tmp1_;
	gint32 _tmp2_ = 0;
	gint32 trackno1;
	DeeSequenceModel* _tmp3_;
	DeeModelIter* _tmp4_;
	gint32 _tmp5_ = 0;
	gint32 trackno2;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = self->priv->all_tracks;
	_tmp1_ = *a;
	_tmp2_ = dee_model_get_int32 ((DeeModel*) _tmp0_, _tmp1_, (guint) UNITY_MUSIC_LENS_COLUMNS_TRACK_NUMBER);
	trackno1 = _tmp2_;
	_tmp3_ = self->priv->all_tracks;
	_tmp4_ = *b;
	_tmp5_ = dee_model_get_int32 ((DeeModel*) _tmp3_, _tmp4_, (guint) UNITY_MUSIC_LENS_COLUMNS_TRACK_NUMBER);
	trackno2 = _tmp5_;
	result = (gint) (trackno1 - trackno2);
	return result;
}


static gint _____lambda7__gcompare_data_func (gconstpointer a, gconstpointer b, gpointer self) {
	gint result;
	result = ____lambda7_ (self, a, b);
	return result;
}


void unity_music_lens_rhythmbox_collection_parse_file (UnityMusicLensRhythmboxCollection* self, const gchar* path) {
	DeeSequenceModel* _tmp0_;
	GHashTable* _tmp1_;
	UnityMusicLensRhythmboxCollectionXmlParser* _tmp2_;
	UnityMusicLensRhythmboxCollectionXmlParser* parser;
	UnityMusicLensRhythmboxCollectionXmlParser* _tmp3_;
	const gchar* _tmp4_;
	GFile* _tmp5_ = NULL;
	GFile* file;
	GHashTable* _tmp16_;
	GList* _tmp17_ = NULL;
	GList* all_albums;
	GList* _tmp18_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	_g_object_unref0 (self->priv->index);
	self->priv->index = NULL;
	_tmp0_ = self->priv->all_tracks;
	dee_model_clear ((DeeModel*) _tmp0_);
	unity_music_lens_rhythmbox_collection_initialize_index (self);
	self->priv->current_album_art_tag = 0;
	_tmp1_ = self->priv->album_to_tracks_map;
	g_hash_table_remove_all (_tmp1_);
	_tmp2_ = unity_music_lens_rhythmbox_collection_xml_parser_new ();
	parser = _tmp2_;
	_tmp3_ = parser;
	g_signal_connect_object (_tmp3_, "track-info-ready", (GCallback) ___lambda6__unity_music_lens_rhythmbox_collection_xml_parser_track_info_ready, self, 0);
	_tmp4_ = path;
	_tmp5_ = g_file_new_for_path (_tmp4_);
	file = _tmp5_;
	{
		GFile* _tmp6_;
		GFileInputStream* _tmp7_ = NULL;
		GFileInputStream* stream;
		guint8 buffer[65536] = {0};
		gsize bytes_read = 0UL;
		_tmp6_ = file;
		_tmp7_ = g_file_read (_tmp6_, NULL, &_inner_error_);
		stream = _tmp7_;
		if (_inner_error_ != NULL) {
			goto __catch10_g_error;
		}
		while (TRUE) {
			GFileInputStream* _tmp8_;
			gssize _tmp9_ = 0L;
			gssize _tmp10_;
			gsize _tmp11_;
			UnityMusicLensRhythmboxCollectionXmlParser* _tmp12_;
			gsize _tmp13_;
			_tmp8_ = stream;
			_tmp9_ = g_input_stream_read ((GInputStream*) _tmp8_, buffer, (gsize) 65536, NULL, &_inner_error_);
			_tmp10_ = _tmp9_;
			if (_inner_error_ != NULL) {
				_g_object_unref0 (stream);
				goto __catch10_g_error;
			}
			bytes_read = (gsize) _tmp10_;
			_tmp11_ = bytes_read;
			if (!(_tmp11_ > ((gsize) 0))) {
				break;
			}
			_tmp12_ = parser;
			_tmp13_ = bytes_read;
			unity_music_lens_rhythmbox_collection_xml_parser_parse (_tmp12_, (const gchar*) buffer, _tmp13_, &_inner_error_);
			if (_inner_error_ != NULL) {
				_g_object_unref0 (stream);
				goto __catch10_g_error;
			}
		}
		_g_object_unref0 (stream);
	}
	goto __finally10;
	__catch10_g_error:
	{
		GError* err = NULL;
		GError* _tmp14_;
		const gchar* _tmp15_;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp14_ = err;
		_tmp15_ = _tmp14_->message;
		g_warning ("rhythmbox-collection.vala:504: Error while parsing rhythmbox DB: %s", _tmp15_);
		_g_error_free0 (err);
	}
	__finally10:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (file);
		_g_object_unref0 (parser);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp16_ = self->priv->album_to_tracks_map;
	_tmp17_ = g_hash_table_get_keys (_tmp16_);
	all_albums = _tmp17_;
	_tmp18_ = all_albums;
	{
		GList* s_collection = NULL;
		GList* s_it = NULL;
		s_collection = _tmp18_;
		for (s_it = s_collection; s_it != NULL; s_it = s_it->next) {
			const gchar* s = NULL;
			s = (const gchar*) s_it->data;
			{
				GHashTable* _tmp19_;
				const gchar* _tmp20_;
				gconstpointer _tmp21_ = NULL;
				_tmp19_ = self->priv->album_to_tracks_map;
				_tmp20_ = s;
				_tmp21_ = g_hash_table_lookup (_tmp19_, _tmp20_);
				g_ptr_array_sort_with_data ((GPtrArray*) _tmp21_, _____lambda7__gcompare_data_func, self);
			}
		}
	}
	_g_list_free0 (all_albums);
	_g_object_unref0 (file);
	_g_object_unref0 (parser);
}


static void unity_music_lens_rhythmbox_collection_add_result (UnityMusicLensRhythmboxCollection* self, DeeModel* results_model, DeeModel* model, DeeModelIter* iter, UnityMusicLensRhythmboxCollectionResultType result_type, guint category_id) {
	DeeModelTag* _tmp0_;
	DeeModel* _tmp1_;
	DeeModelIter* _tmp2_;
	gconstpointer _tmp3_ = NULL;
	gint tag;
	gint _tmp4_;
	gint _tmp5_;
	UnityMusicLensColumns _tmp42_ = 0;
	UnityMusicLensRhythmboxCollectionResultType _tmp43_;
	UnityMusicLensColumns _tmp44_;
	UnityMusicLensColumns title_col;
	DeeModel* _tmp45_;
	DeeModelIter* _tmp46_;
	UnityMusicLensColumns _tmp47_;
	const gchar* _tmp48_ = NULL;
	const gchar* title;
	DeeModel* _tmp49_;
	DeeModelIter* _tmp50_;
	const gchar* _tmp51_ = NULL;
	gchar* _tmp52_;
	gchar* uri;
	DeeModel* _tmp53_;
	DeeModelIter* _tmp54_;
	const gchar* _tmp55_ = NULL;
	gchar* _tmp56_;
	gchar* dnd_uri;
	UnityMusicLensRhythmboxCollectionResultType _tmp57_;
	DeeModel* _tmp78_;
	const gchar* _tmp79_;
	DeeModel* _tmp80_;
	DeeModelIter* _tmp81_;
	const gchar* _tmp82_ = NULL;
	guint _tmp83_;
	DeeModel* _tmp84_;
	DeeModelIter* _tmp85_;
	const gchar* _tmp86_ = NULL;
	const gchar* _tmp87_;
	DeeModel* _tmp88_;
	DeeModelIter* _tmp89_;
	const gchar* _tmp90_ = NULL;
	const gchar* _tmp91_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (results_model != NULL);
	g_return_if_fail (model != NULL);
	g_return_if_fail (iter != NULL);
	_tmp0_ = self->priv->album_art_tag;
	_tmp1_ = model;
	_tmp2_ = iter;
	_tmp3_ = dee_model_get_tag (_tmp1_, _tmp2_, _tmp0_);
	tag = GPOINTER_TO_INT (_tmp3_);
	_tmp4_ = tag;
	_tmp5_ = self->priv->current_album_art_tag;
	if (_tmp4_ < _tmp5_) {
		DeeModel* _tmp6_;
		DeeModelIter* _tmp7_;
		const gchar* _tmp8_ = NULL;
		const gchar* album;
		DeeModel* _tmp9_;
		DeeModelIter* _tmp10_;
		const gchar* _tmp11_ = NULL;
		const gchar* artist;
		const gchar* _tmp12_;
		const gchar* _tmp16_;
		const gchar* _tmp17_;
		gchar* _tmp18_ = NULL;
		gchar* album_art_string;
		const gchar* _tmp19_;
		DeeModelTag* _tmp38_;
		DeeModel* _tmp39_;
		DeeModelIter* _tmp40_;
		gint _tmp41_;
		_tmp6_ = model;
		_tmp7_ = iter;
		_tmp8_ = dee_model_get_string (_tmp6_, _tmp7_, (guint) UNITY_MUSIC_LENS_COLUMNS_ALBUM);
		album = _tmp8_;
		_tmp9_ = model;
		_tmp10_ = iter;
		_tmp11_ = dee_model_get_string (_tmp9_, _tmp10_, (guint) UNITY_MUSIC_LENS_COLUMNS_ALBUM_ARTIST);
		artist = _tmp11_;
		_tmp12_ = artist;
		if (g_strcmp0 (_tmp12_, "") == 0) {
			DeeModel* _tmp13_;
			DeeModelIter* _tmp14_;
			const gchar* _tmp15_ = NULL;
			_tmp13_ = model;
			_tmp14_ = iter;
			_tmp15_ = dee_model_get_string (_tmp13_, _tmp14_, (guint) UNITY_MUSIC_LENS_COLUMNS_ARTIST);
			artist = _tmp15_;
		}
		_tmp16_ = artist;
		_tmp17_ = album;
		_tmp18_ = unity_music_lens_rhythmbox_collection_check_album_art_tdb (self, _tmp16_, _tmp17_);
		album_art_string = _tmp18_;
		_tmp19_ = album_art_string;
		if (_tmp19_ != NULL) {
			gchar* filename = NULL;
			const gchar* _tmp20_ = NULL;
			const gchar* _tmp21_;
			gchar* _tmp22_ = NULL;
			const gchar* _tmp23_ = NULL;
			const gchar* _tmp24_;
			gboolean _tmp25_ = FALSE;
			const gchar* _tmp27_;
			gchar* _tmp28_;
			const gchar* _tmp29_;
			DeeModel* _tmp30_;
			DeeModelIter* _tmp31_;
			const gchar* _tmp32_ = NULL;
			_tmp20_ = g_get_user_cache_dir ();
			_tmp21_ = album_art_string;
			_tmp22_ = g_build_filename (_tmp20_, "rhythmbox", "album-art", _tmp21_, NULL);
			_g_free0 (filename);
			filename = _tmp22_;
			_tmp24_ = filename;
			_tmp25_ = g_file_test (_tmp24_, G_FILE_TEST_EXISTS);
			if (_tmp25_) {
				const gchar* _tmp26_;
				_tmp26_ = filename;
				_tmp23_ = _tmp26_;
			} else {
				_tmp23_ = "audio-x-generic";
			}
			_tmp27_ = _tmp23_;
			_tmp28_ = g_strdup (_tmp27_);
			_g_free0 (album_art_string);
			album_art_string = _tmp28_;
			_tmp29_ = album_art_string;
			_tmp30_ = model;
			_tmp31_ = iter;
			_tmp32_ = dee_model_get_string (_tmp30_, _tmp31_, (guint) UNITY_MUSIC_LENS_COLUMNS_ARTWORK);
			if (g_strcmp0 (_tmp29_, _tmp32_) != 0) {
				DeeModel* _tmp33_;
				DeeModelIter* _tmp34_;
				const gchar* _tmp35_;
				GVariant* _tmp36_ = NULL;
				GVariant* _tmp37_;
				_tmp33_ = model;
				_tmp34_ = iter;
				_tmp35_ = album_art_string;
				_tmp36_ = unity_music_lens_rhythmbox_collection_cached_variant_for_string (self, _tmp35_);
				_tmp37_ = _tmp36_;
				dee_model_set_value (_tmp33_, _tmp34_, (guint) UNITY_MUSIC_LENS_COLUMNS_ARTWORK, _tmp37_);
				_g_variant_unref0 (_tmp37_);
			}
			_g_free0 (filename);
		}
		_tmp38_ = self->priv->album_art_tag;
		_tmp39_ = model;
		_tmp40_ = iter;
		_tmp41_ = self->priv->current_album_art_tag;
		dee_model_set_tag (_tmp39_, _tmp40_, _tmp38_, GINT_TO_POINTER (_tmp41_));
		_g_free0 (album_art_string);
	}
	_tmp43_ = result_type;
	if (_tmp43_ == UNITY_MUSIC_LENS_RHYTHMBOX_COLLECTION_RESULT_TYPE_SONG) {
		_tmp42_ = UNITY_MUSIC_LENS_COLUMNS_TITLE;
	} else {
		_tmp42_ = UNITY_MUSIC_LENS_COLUMNS_ALBUM;
	}
	_tmp44_ = _tmp42_;
	title_col = _tmp44_;
	_tmp45_ = model;
	_tmp46_ = iter;
	_tmp47_ = title_col;
	_tmp48_ = dee_model_get_string (_tmp45_, _tmp46_, (guint) _tmp47_);
	title = _tmp48_;
	_tmp49_ = model;
	_tmp50_ = iter;
	_tmp51_ = dee_model_get_string (_tmp49_, _tmp50_, (guint) UNITY_MUSIC_LENS_COLUMNS_URI);
	_tmp52_ = g_strdup (_tmp51_);
	uri = _tmp52_;
	_tmp53_ = model;
	_tmp54_ = iter;
	_tmp55_ = dee_model_get_string (_tmp53_, _tmp54_, (guint) UNITY_MUSIC_LENS_COLUMNS_URI);
	_tmp56_ = g_strdup (_tmp55_);
	dnd_uri = _tmp56_;
	_tmp57_ = result_type;
	if (_tmp57_ == UNITY_MUSIC_LENS_RHYTHMBOX_COLLECTION_RESULT_TYPE_ALBUM) {
		const gchar* _tmp58_;
		DeeModel* _tmp59_;
		DeeModelIter* _tmp60_;
		const gchar* _tmp61_ = NULL;
		const gchar* artist;
		const gchar* _tmp62_;
		const gchar* _tmp66_;
		const gchar* _tmp67_;
		gchar* _tmp68_ = NULL;
		gchar* album_key;
		GString* _tmp69_;
		GString* sb;
		const gchar* _tmp70_;
		GSList* _tmp71_ = NULL;
		GString* _tmp74_;
		gchar* _tmp75_;
		const gchar* _tmp76_;
		gchar* _tmp77_ = NULL;
		_tmp58_ = title;
		if (g_strcmp0 (_tmp58_, UNITY_MUSIC_LENS_RHYTHMBOX_COLLECTION_UNKNOWN_ALBUM) == 0) {
			_g_free0 (dnd_uri);
			_g_free0 (uri);
			return;
		}
		_tmp59_ = model;
		_tmp60_ = iter;
		_tmp61_ = dee_model_get_string (_tmp59_, _tmp60_, (guint) UNITY_MUSIC_LENS_COLUMNS_ALBUM_ARTIST);
		artist = _tmp61_;
		_tmp62_ = artist;
		if (g_strcmp0 (_tmp62_, "") == 0) {
			DeeModel* _tmp63_;
			DeeModelIter* _tmp64_;
			const gchar* _tmp65_ = NULL;
			_tmp63_ = model;
			_tmp64_ = iter;
			_tmp65_ = dee_model_get_string (_tmp63_, _tmp64_, (guint) UNITY_MUSIC_LENS_COLUMNS_ARTIST);
			artist = _tmp65_;
		}
		_tmp66_ = title;
		_tmp67_ = artist;
		_tmp68_ = g_strdup_printf ("%s - %s", _tmp66_, _tmp67_);
		album_key = _tmp68_;
		_tmp69_ = g_string_new ("");
		sb = _tmp69_;
		_tmp70_ = album_key;
		_tmp71_ = unity_music_lens_rhythmbox_collection_get_album_tracks (self, _tmp70_);
		{
			GSList* track_uri_collection = NULL;
			GSList* track_uri_it = NULL;
			track_uri_collection = _tmp71_;
			for (track_uri_it = track_uri_collection; track_uri_it != NULL; track_uri_it = track_uri_it->next) {
				const gchar* track_uri = NULL;
				track_uri = (const gchar*) track_uri_it->data;
				{
					GString* _tmp72_;
					const gchar* _tmp73_;
					_tmp72_ = sb;
					_tmp73_ = track_uri;
					g_string_append_printf (_tmp72_, "%s\r\n", _tmp73_);
				}
			}
			_g_slist_free0 (track_uri_collection);
		}
		_tmp74_ = sb;
		_tmp75_ = _tmp74_->str;
		_tmp74_->str = NULL;
		_g_free0 (dnd_uri);
		dnd_uri = _tmp75_;
		_tmp76_ = album_key;
		_tmp77_ = g_strdup_printf ("album://%s", _tmp76_);
		_g_free0 (uri);
		uri = _tmp77_;
		_g_string_free0 (sb);
		_g_free0 (album_key);
	}
	_tmp78_ = results_model;
	_tmp79_ = uri;
	_tmp80_ = model;
	_tmp81_ = iter;
	_tmp82_ = dee_model_get_string (_tmp80_, _tmp81_, (guint) UNITY_MUSIC_LENS_COLUMNS_ARTWORK);
	_tmp83_ = category_id;
	_tmp84_ = model;
	_tmp85_ = iter;
	_tmp86_ = dee_model_get_string (_tmp84_, _tmp85_, (guint) UNITY_MUSIC_LENS_COLUMNS_MIMETYPE);
	_tmp87_ = title;
	_tmp88_ = model;
	_tmp89_ = iter;
	_tmp90_ = dee_model_get_string (_tmp88_, _tmp89_, (guint) UNITY_MUSIC_LENS_COLUMNS_ARTIST);
	_tmp91_ = dnd_uri;
	dee_model_append (_tmp78_, _tmp79_, _tmp82_, _tmp83_, _tmp86_, _tmp87_, _tmp90_, _tmp91_, NULL);
	_g_free0 (dnd_uri);
	_g_free0 (uri);
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _result_;
	const gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


static gint ____lambda8_ (UnityMusicLensRhythmboxCollection* self, DeeModelIter* a, DeeModelIter* b) {
	gint result = 0;
	gint _tmp0_ = 0;
	DeeModelIter* _tmp1_;
	DeeModelIter* _tmp2_;
	gint _tmp7_;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp1_ = a;
	_tmp2_ = b;
	if (_tmp1_ == _tmp2_) {
		_tmp0_ = 0;
	} else {
		gint _tmp3_ = 0;
		DeeModelIter* _tmp4_;
		DeeModelIter* _tmp5_;
		gint _tmp6_;
		_tmp4_ = a;
		_tmp5_ = b;
		if (((void*) _tmp4_) > ((void*) _tmp5_)) {
			_tmp3_ = 1;
		} else {
			_tmp3_ = -1;
		}
		_tmp6_ = _tmp3_;
		_tmp0_ = _tmp6_;
	}
	_tmp7_ = _tmp0_;
	result = _tmp7_;
	return result;
}


static gint _____lambda8__gcompare_data_func (gconstpointer a, gconstpointer b, gpointer self) {
	gint result;
	result = ____lambda8_ (self, a, b);
	return result;
}


void unity_music_lens_rhythmbox_collection_search (UnityMusicLensRhythmboxCollection* self, UnityLensSearch* search, UnitySearchType search_type, GList* filters, gint max_results, gint category_override) {
	gint num_results;
	UnityLensSearch* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	gboolean _tmp5_;
	gboolean empty_search;
	gint min_year = 0;
	gint max_year = 0;
	gint category_id = 0;
	DeeSequenceModel* _tmp6_;
	DeeModel* _tmp7_;
	DeeModel* model;
	GList* _tmp8_;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	GList* _tmp11_;
	GeeSet* _tmp12_ = NULL;
	GeeSet* active_genres;
	UnityLensSearch* _tmp13_;
	DeeSerializableModel* _tmp14_;
	DeeSerializableModel* _tmp15_;
	DeeSerializableModel* _tmp16_;
	DeeSerializableModel* helper_model;
	gint _tmp17_;
	gboolean _tmp25_;
	GObject* _tmp93_ = NULL;
	GObject* _tmp94_;
	DeeTermList* term_list;
	DeeAnalyzer* _tmp95_;
	DeeICUTermFilter* _tmp96_;
	UnityLensSearch* _tmp97_;
	const gchar* _tmp98_;
	const gchar* _tmp99_;
	gchar* _tmp100_ = NULL;
	gchar* _tmp101_;
	DeeTermList* _tmp102_;
	GSequence* _tmp103_;
	GSequence* matches;
	gboolean first_pass;
	GSequence* _tmp143_;
	GSequenceIter* _tmp144_ = NULL;
	GSequenceIter* seq_iter;
	GSequence* _tmp145_;
	GSequenceIter* _tmp146_ = NULL;
	GSequenceIter* seq_end_iter;
	GeeHashSet* _tmp147_;
	GeeHashSet* albums_list;
	DeeSerializableModel* _tmp209_;
	UnityLensSearch* _tmp210_;
	DeeSerializableModel* _tmp211_;
	DeeSerializableModel* _tmp212_;
	DeeSerializableModel* _tmp213_;
	DeeModelIter* _tmp214_ = NULL;
	DeeModelIter* iter;
	DeeSerializableModel* _tmp215_;
	DeeModelIter* _tmp216_ = NULL;
	DeeModelIter* last;
	g_return_if_fail (self != NULL);
	g_return_if_fail (search != NULL);
	num_results = 0;
	_tmp0_ = search;
	_tmp1_ = unity_lens_search_get_search_string (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = string_strip (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strcmp0 (_tmp4_, "") == 0;
	_g_free0 (_tmp4_);
	empty_search = _tmp5_;
	_tmp6_ = self->priv->all_tracks;
	_tmp7_ = _g_object_ref0 ((DeeModel*) _tmp6_);
	model = _tmp7_;
	_tmp8_ = filters;
	unity_music_lens_rhythmbox_collection_get_decade_filter (self, _tmp8_, &_tmp9_, &_tmp10_);
	min_year = _tmp9_;
	max_year = _tmp10_;
	_tmp11_ = filters;
	_tmp12_ = unity_music_lens_rhythmbox_collection_get_genre_filter (self, _tmp11_);
	active_genres = _tmp12_;
	_tmp13_ = search;
	_tmp14_ = unity_lens_search_get_results_model (_tmp13_);
	_tmp15_ = _tmp14_;
	_tmp16_ = _g_object_ref0 (_tmp15_);
	helper_model = _tmp16_;
	_tmp17_ = category_override;
	if (_tmp17_ >= 0) {
		DeeSequenceModel* _tmp18_;
		DeeSerializableModel* _tmp19_;
		UnityLensSearch* _tmp20_;
		DeeSerializableModel* _tmp21_;
		DeeSerializableModel* _tmp22_;
		guint _tmp23_;
		gchar** _tmp24_ = NULL;
		_tmp18_ = (DeeSequenceModel*) dee_sequence_model_new ();
		_g_object_unref0 (helper_model);
		helper_model = (DeeSerializableModel*) _tmp18_;
		_tmp19_ = helper_model;
		_tmp20_ = search;
		_tmp21_ = unity_lens_search_get_results_model (_tmp20_);
		_tmp22_ = _tmp21_;
		_tmp24_ = dee_model_get_schema ((DeeModel*) _tmp22_, &_tmp23_);
		dee_model_set_schema_full ((DeeModel*) _tmp19_, _tmp24_, (guint) _tmp23_);
	}
	_tmp25_ = empty_search;
	if (_tmp25_) {
		DeeFilterModel* _tmp26_;
		DeeModel* _tmp27_;
		DeeModel* _tmp28_;
		DeeModelIter* _tmp29_ = NULL;
		DeeModelIter* iter;
		DeeModel* _tmp30_;
		DeeModelIter* _tmp31_ = NULL;
		DeeModelIter* end_iter;
		GeeHashSet* _tmp32_;
		GeeHashSet* albums_list_nosearch;
		_tmp26_ = self->priv->tracks_by_play_count;
		_tmp27_ = _g_object_ref0 ((DeeModel*) _tmp26_);
		_g_object_unref0 (model);
		model = _tmp27_;
		_tmp28_ = model;
		_tmp29_ = dee_model_get_first_iter (_tmp28_);
		iter = _tmp29_;
		_tmp30_ = model;
		_tmp31_ = dee_model_get_last_iter (_tmp30_);
		end_iter = _tmp31_;
		_tmp32_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL);
		albums_list_nosearch = _tmp32_;
		while (TRUE) {
			DeeModelIter* _tmp33_;
			DeeModelIter* _tmp34_;
			DeeModel* _tmp35_;
			DeeModelIter* _tmp36_;
			gint32 _tmp37_ = 0;
			gint year;
			DeeModel* _tmp38_;
			DeeModelIter* _tmp39_;
			const gchar* _tmp40_ = NULL;
			const gchar* genre;
			gboolean _tmp41_ = FALSE;
			gint _tmp42_;
			gint _tmp43_;
			gboolean _tmp46_;
			GeeSet* _tmp50_;
			DeeModel* _tmp57_;
			DeeModelIter* _tmp58_;
			const gchar* _tmp59_ = NULL;
			const gchar* album;
			GeeHashSet* _tmp60_;
			const gchar* _tmp61_;
			gboolean _tmp62_ = FALSE;
			gboolean first_track_from_album;
			GeeHashSet* _tmp63_;
			const gchar* _tmp64_;
			gboolean _tmp65_;
			gint _tmp76_ = 0;
			gint _tmp77_;
			gint _tmp79_;
			DeeSerializableModel* _tmp80_;
			DeeModel* _tmp81_;
			DeeModelIter* _tmp82_;
			gint _tmp83_;
			gint _tmp84_;
			gboolean _tmp85_ = FALSE;
			gint _tmp86_;
			gboolean _tmp89_;
			DeeModel* _tmp90_;
			DeeModelIter* _tmp91_;
			DeeModelIter* _tmp92_ = NULL;
			_tmp33_ = iter;
			_tmp34_ = end_iter;
			if (!(_tmp33_ != _tmp34_)) {
				break;
			}
			_tmp35_ = model;
			_tmp36_ = iter;
			_tmp37_ = dee_model_get_int32 (_tmp35_, _tmp36_, (guint) UNITY_MUSIC_LENS_COLUMNS_YEAR);
			year = (gint) _tmp37_;
			_tmp38_ = model;
			_tmp39_ = iter;
			_tmp40_ = dee_model_get_string (_tmp38_, _tmp39_, (guint) UNITY_MUSIC_LENS_COLUMNS_GENRE);
			genre = _tmp40_;
			_tmp42_ = year;
			_tmp43_ = min_year;
			if (_tmp42_ < _tmp43_) {
				_tmp41_ = TRUE;
			} else {
				gint _tmp44_;
				gint _tmp45_;
				_tmp44_ = year;
				_tmp45_ = max_year;
				_tmp41_ = _tmp44_ > _tmp45_;
			}
			_tmp46_ = _tmp41_;
			if (_tmp46_) {
				DeeModel* _tmp47_;
				DeeModelIter* _tmp48_;
				DeeModelIter* _tmp49_ = NULL;
				_tmp47_ = model;
				_tmp48_ = iter;
				_tmp49_ = dee_model_next (_tmp47_, _tmp48_);
				iter = _tmp49_;
				continue;
			}
			_tmp50_ = active_genres;
			if (_tmp50_ != NULL) {
				GeeSet* _tmp51_;
				const gchar* _tmp52_;
				gboolean _tmp53_ = FALSE;
				_tmp51_ = active_genres;
				_tmp52_ = genre;
				_tmp53_ = gee_collection_contains ((GeeCollection*) _tmp51_, _tmp52_);
				if (!_tmp53_) {
					DeeModel* _tmp54_;
					DeeModelIter* _tmp55_;
					DeeModelIter* _tmp56_ = NULL;
					_tmp54_ = model;
					_tmp55_ = iter;
					_tmp56_ = dee_model_next (_tmp54_, _tmp55_);
					iter = _tmp56_;
					continue;
				}
			}
			_tmp57_ = model;
			_tmp58_ = iter;
			_tmp59_ = dee_model_get_string (_tmp57_, _tmp58_, (guint) UNITY_MUSIC_LENS_COLUMNS_ALBUM);
			album = _tmp59_;
			_tmp60_ = albums_list_nosearch;
			_tmp61_ = album;
			_tmp62_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp60_, _tmp61_);
			first_track_from_album = !_tmp62_;
			_tmp63_ = albums_list_nosearch;
			_tmp64_ = album;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp63_, _tmp64_);
			_tmp65_ = first_track_from_album;
			if (_tmp65_) {
				gint _tmp66_ = 0;
				gint _tmp67_;
				gint _tmp69_;
				UnityLensSearch* _tmp70_;
				DeeSerializableModel* _tmp71_;
				DeeSerializableModel* _tmp72_;
				DeeModel* _tmp73_;
				DeeModelIter* _tmp74_;
				gint _tmp75_;
				_tmp67_ = category_override;
				if (_tmp67_ >= 0) {
					gint _tmp68_;
					_tmp68_ = category_override;
					_tmp66_ = _tmp68_;
				} else {
					_tmp66_ = (gint) UNITY_MUSIC_LENS_CATEGORY_ALBUMS;
				}
				_tmp69_ = _tmp66_;
				category_id = _tmp69_;
				_tmp70_ = search;
				_tmp71_ = unity_lens_search_get_results_model (_tmp70_);
				_tmp72_ = _tmp71_;
				_tmp73_ = model;
				_tmp74_ = iter;
				_tmp75_ = category_id;
				unity_music_lens_rhythmbox_collection_add_result (self, (DeeModel*) _tmp72_, _tmp73_, _tmp74_, UNITY_MUSIC_LENS_RHYTHMBOX_COLLECTION_RESULT_TYPE_ALBUM, (guint) _tmp75_);
			}
			_tmp77_ = category_override;
			if (_tmp77_ >= 0) {
				gint _tmp78_;
				_tmp78_ = category_override;
				_tmp76_ = _tmp78_;
			} else {
				_tmp76_ = (gint) UNITY_MUSIC_LENS_CATEGORY_SONGS;
			}
			_tmp79_ = _tmp76_;
			category_id = _tmp79_;
			_tmp80_ = helper_model;
			_tmp81_ = model;
			_tmp82_ = iter;
			_tmp83_ = category_id;
			unity_music_lens_rhythmbox_collection_add_result (self, (DeeModel*) _tmp80_, _tmp81_, _tmp82_, UNITY_MUSIC_LENS_RHYTHMBOX_COLLECTION_RESULT_TYPE_SONG, (guint) _tmp83_);
			_tmp84_ = num_results;
			num_results = _tmp84_ + 1;
			_tmp86_ = max_results;
			if (_tmp86_ >= 0) {
				gint _tmp87_;
				gint _tmp88_;
				_tmp87_ = num_results;
				_tmp88_ = max_results;
				_tmp85_ = _tmp87_ >= _tmp88_;
			} else {
				_tmp85_ = FALSE;
			}
			_tmp89_ = _tmp85_;
			if (_tmp89_) {
				break;
			}
			_tmp90_ = model;
			_tmp91_ = iter;
			_tmp92_ = dee_model_next (_tmp90_, _tmp91_);
			iter = _tmp92_;
		}
		_g_object_unref0 (albums_list_nosearch);
		_g_object_unref0 (helper_model);
		_g_object_unref0 (active_genres);
		_g_object_unref0 (model);
		return;
	}
	_tmp93_ = g_object_new (dee_term_list_get_type (), NULL);
	_tmp94_ = G_IS_INITIALLY_UNOWNED (_tmp93_) ? g_object_ref_sink (_tmp93_) : _tmp93_;
	term_list = DEE_IS_TERM_LIST (_tmp94_) ? ((DeeTermList*) _tmp94_) : NULL;
	_tmp95_ = self->priv->analyzer;
	_tmp96_ = self->priv->ascii_filter;
	_tmp97_ = search;
	_tmp98_ = unity_lens_search_get_search_string (_tmp97_);
	_tmp99_ = _tmp98_;
	_tmp100_ = dee_icu_term_filter_apply (_tmp96_, _tmp99_);
	_tmp101_ = _tmp100_;
	_tmp102_ = term_list;
	dee_analyzer_tokenize (_tmp95_, _tmp101_, _tmp102_);
	_g_free0 (_tmp101_);
	_tmp103_ = g_sequence_new (NULL);
	matches = _tmp103_;
	first_pass = TRUE;
	{
		DeeTermList* _tmp104_;
		DeeTermList* _tmp105_;
		DeeTermList* _term_list;
		DeeTermList* _tmp106_;
		guint _tmp107_;
		guint _tmp108_;
		guint _term_size;
		gint _term_index;
		_tmp104_ = term_list;
		_tmp105_ = _g_object_ref0 (_tmp104_);
		_term_list = _tmp105_;
		_tmp106_ = _term_list;
		_tmp107_ = dee_term_list_num_terms (_tmp106_);
		_tmp108_ = _tmp107_;
		_term_size = _tmp108_;
		_term_index = -1;
		while (TRUE) {
			gint _tmp109_;
			gint _tmp110_;
			guint _tmp111_;
			DeeTermList* _tmp112_;
			gint _tmp113_;
			const gchar* _tmp114_ = NULL;
			const gchar* term;
			DeeIndex* _tmp115_;
			const gchar* _tmp116_;
			DeeResultSet* _tmp117_ = NULL;
			DeeResultSet* result_set;
			GCompareDataFunc cmp_func;
			void* cmp_func_target;
			GDestroyNotify cmp_func_target_destroy_notify;
			GSequence* _tmp118_;
			GSequence* remaining;
			gboolean _tmp137_;
			GSequence* _tmp139_;
			GSequenceIter* _tmp140_ = NULL;
			GSequence* _tmp141_;
			GSequenceIter* _tmp142_ = NULL;
			_tmp109_ = _term_index;
			_term_index = _tmp109_ + 1;
			_tmp110_ = _term_index;
			_tmp111_ = _term_size;
			if (!(((guint) _tmp110_) < _tmp111_)) {
				break;
			}
			_tmp112_ = _term_list;
			_tmp113_ = _term_index;
			_tmp114_ = dee_term_list_get_term (_tmp112_, (guint) _tmp113_);
			term = _tmp114_;
			_tmp115_ = self->priv->index;
			_tmp116_ = term;
			_tmp117_ = dee_index_lookup (_tmp115_, _tmp116_, DEE_TERM_MATCH_PREFIX);
			result_set = _tmp117_;
			cmp_func = _____lambda8__gcompare_data_func;
			cmp_func_target = g_object_ref (self);
			cmp_func_target_destroy_notify = g_object_unref;
			_tmp118_ = g_sequence_new (NULL);
			remaining = _tmp118_;
			{
				DeeResultSet* _tmp119_;
				DeeResultSet* _tmp120_ = NULL;
				DeeResultSet* _item_it;
				DeeModelIter* item = NULL;
				_tmp119_ = result_set;
				_tmp120_ = _vala_dee_result_set_iterator (_tmp119_);
				_item_it = _tmp120_;
				while (TRUE) {
					DeeResultSet* _tmp121_;
					DeeModelIter* _tmp122_ = NULL;
					DeeModelIter* _tmp123_;
					gboolean _tmp124_;
					_tmp121_ = _item_it;
					_tmp122_ = _vala_dee_result_set_next_value (_tmp121_);
					item = _tmp122_;
					_tmp123_ = item;
					if (!(_tmp123_ != NULL)) {
						break;
					}
					_tmp124_ = first_pass;
					if (_tmp124_) {
						GSequence* _tmp125_;
						DeeModelIter* _tmp126_;
						GCompareDataFunc _tmp127_;
						void* _tmp127__target;
						GSequenceIter* _tmp128_ = NULL;
						_tmp125_ = matches;
						_tmp126_ = item;
						_tmp127_ = cmp_func;
						_tmp127__target = cmp_func_target;
						_tmp128_ = g_sequence_insert_sorted (_tmp125_, _tmp126_, _tmp127_, _tmp127__target);
					} else {
						GSequence* _tmp129_;
						DeeModelIter* _tmp130_;
						GCompareDataFunc _tmp131_;
						void* _tmp131__target;
						GSequenceIter* _tmp132_ = NULL;
						_tmp129_ = matches;
						_tmp130_ = item;
						_tmp131_ = cmp_func;
						_tmp131__target = cmp_func_target;
						_tmp132_ = g_sequence_lookup (_tmp129_, _tmp130_, _tmp131_, _tmp131__target);
						if (_tmp132_ != NULL) {
							GSequence* _tmp133_;
							DeeModelIter* _tmp134_;
							GCompareDataFunc _tmp135_;
							void* _tmp135__target;
							GSequenceIter* _tmp136_ = NULL;
							_tmp133_ = remaining;
							_tmp134_ = item;
							_tmp135_ = cmp_func;
							_tmp135__target = cmp_func_target;
							_tmp136_ = g_sequence_insert_sorted (_tmp133_, _tmp134_, _tmp135_, _tmp135__target);
						}
					}
				}
				_g_object_unref0 (_item_it);
			}
			_tmp137_ = first_pass;
			if (!_tmp137_) {
				GSequence* _tmp138_;
				_tmp138_ = remaining;
				remaining = NULL;
				_g_sequence_free0 (matches);
				matches = _tmp138_;
			}
			_tmp139_ = matches;
			_tmp140_ = g_sequence_get_begin_iter (_tmp139_);
			_tmp141_ = matches;
			_tmp142_ = g_sequence_get_end_iter (_tmp141_);
			if (_tmp140_ == _tmp142_) {
				_g_sequence_free0 (remaining);
				(cmp_func_target_destroy_notify == NULL) ? NULL : (cmp_func_target_destroy_notify (cmp_func_target), NULL);
				cmp_func = NULL;
				cmp_func_target = NULL;
				cmp_func_target_destroy_notify = NULL;
				_g_object_unref0 (result_set);
				break;
			}
			first_pass = FALSE;
			_g_sequence_free0 (remaining);
			(cmp_func_target_destroy_notify == NULL) ? NULL : (cmp_func_target_destroy_notify (cmp_func_target), NULL);
			cmp_func = NULL;
			cmp_func_target = NULL;
			cmp_func_target_destroy_notify = NULL;
			_g_object_unref0 (result_set);
		}
		_g_object_unref0 (_term_list);
	}
	_tmp143_ = matches;
	_tmp144_ = g_sequence_get_begin_iter (_tmp143_);
	seq_iter = _tmp144_;
	_tmp145_ = matches;
	_tmp146_ = g_sequence_get_end_iter (_tmp145_);
	seq_end_iter = _tmp146_;
	_tmp147_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL);
	albums_list = _tmp147_;
	while (TRUE) {
		GSequenceIter* _tmp148_;
		GSequenceIter* _tmp149_;
		GSequenceIter* _tmp150_;
		gconstpointer _tmp151_ = NULL;
		DeeModelIter* model_iter;
		DeeModel* _tmp152_;
		DeeModelIter* _tmp153_;
		gint32 _tmp154_ = 0;
		gint year;
		DeeModel* _tmp155_;
		DeeModelIter* _tmp156_;
		const gchar* _tmp157_ = NULL;
		gchar* _tmp158_;
		gchar* genre;
		gboolean _tmp159_ = FALSE;
		gint _tmp160_;
		gint _tmp161_;
		gboolean _tmp164_;
		GeeSet* _tmp167_;
		DeeModel* _tmp174_;
		DeeModelIter* _tmp175_;
		const gchar* _tmp176_ = NULL;
		const gchar* album;
		GeeHashSet* _tmp177_;
		const gchar* _tmp178_;
		gboolean _tmp179_ = FALSE;
		gboolean first_track_from_album;
		GeeHashSet* _tmp180_;
		const gchar* _tmp181_;
		gboolean _tmp182_;
		gint _tmp193_ = 0;
		gint _tmp194_;
		gint _tmp196_;
		DeeSerializableModel* _tmp197_;
		DeeModel* _tmp198_;
		DeeModelIter* _tmp199_;
		gint _tmp200_;
		gint _tmp201_;
		gboolean _tmp202_ = FALSE;
		gint _tmp203_;
		gboolean _tmp206_;
		GSequenceIter* _tmp207_;
		GSequenceIter* _tmp208_ = NULL;
		_tmp148_ = seq_iter;
		_tmp149_ = seq_end_iter;
		if (!(_tmp148_ != _tmp149_)) {
			break;
		}
		_tmp150_ = seq_iter;
		_tmp151_ = g_sequence_get (_tmp150_);
		model_iter = (DeeModelIter*) _tmp151_;
		_tmp152_ = model;
		_tmp153_ = model_iter;
		_tmp154_ = dee_model_get_int32 (_tmp152_, _tmp153_, (guint) UNITY_MUSIC_LENS_COLUMNS_YEAR);
		year = (gint) _tmp154_;
		_tmp155_ = model;
		_tmp156_ = model_iter;
		_tmp157_ = dee_model_get_string (_tmp155_, _tmp156_, (guint) UNITY_MUSIC_LENS_COLUMNS_GENRE);
		_tmp158_ = g_strdup (_tmp157_);
		genre = _tmp158_;
		_tmp160_ = year;
		_tmp161_ = min_year;
		if (_tmp160_ < _tmp161_) {
			_tmp159_ = TRUE;
		} else {
			gint _tmp162_;
			gint _tmp163_;
			_tmp162_ = year;
			_tmp163_ = max_year;
			_tmp159_ = _tmp162_ > _tmp163_;
		}
		_tmp164_ = _tmp159_;
		if (_tmp164_) {
			GSequenceIter* _tmp165_;
			GSequenceIter* _tmp166_ = NULL;
			_tmp165_ = seq_iter;
			_tmp166_ = g_sequence_iter_next (_tmp165_);
			seq_iter = _tmp166_;
			_g_free0 (genre);
			continue;
		}
		_tmp167_ = active_genres;
		if (_tmp167_ != NULL) {
			GeeSet* _tmp168_;
			const gchar* _tmp169_;
			gboolean _tmp170_ = FALSE;
			gboolean genre_match;
			gboolean _tmp171_;
			_tmp168_ = active_genres;
			_tmp169_ = genre;
			_tmp170_ = gee_collection_contains ((GeeCollection*) _tmp168_, _tmp169_);
			genre_match = _tmp170_;
			_tmp171_ = genre_match;
			if (!_tmp171_) {
				GSequenceIter* _tmp172_;
				GSequenceIter* _tmp173_ = NULL;
				_tmp172_ = seq_iter;
				_tmp173_ = g_sequence_iter_next (_tmp172_);
				seq_iter = _tmp173_;
				_g_free0 (genre);
				continue;
			}
		}
		_tmp174_ = model;
		_tmp175_ = model_iter;
		_tmp176_ = dee_model_get_string (_tmp174_, _tmp175_, (guint) UNITY_MUSIC_LENS_COLUMNS_ALBUM);
		album = _tmp176_;
		_tmp177_ = albums_list;
		_tmp178_ = album;
		_tmp179_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp177_, _tmp178_);
		first_track_from_album = !_tmp179_;
		_tmp180_ = albums_list;
		_tmp181_ = album;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp180_, _tmp181_);
		_tmp182_ = first_track_from_album;
		if (_tmp182_) {
			gint _tmp183_ = 0;
			gint _tmp184_;
			gint _tmp186_;
			UnityLensSearch* _tmp187_;
			DeeSerializableModel* _tmp188_;
			DeeSerializableModel* _tmp189_;
			DeeModel* _tmp190_;
			DeeModelIter* _tmp191_;
			gint _tmp192_;
			_tmp184_ = category_override;
			if (_tmp184_ >= 0) {
				gint _tmp185_;
				_tmp185_ = category_override;
				_tmp183_ = _tmp185_;
			} else {
				_tmp183_ = (gint) UNITY_MUSIC_LENS_CATEGORY_ALBUMS;
			}
			_tmp186_ = _tmp183_;
			category_id = _tmp186_;
			_tmp187_ = search;
			_tmp188_ = unity_lens_search_get_results_model (_tmp187_);
			_tmp189_ = _tmp188_;
			_tmp190_ = model;
			_tmp191_ = model_iter;
			_tmp192_ = category_id;
			unity_music_lens_rhythmbox_collection_add_result (self, (DeeModel*) _tmp189_, _tmp190_, _tmp191_, UNITY_MUSIC_LENS_RHYTHMBOX_COLLECTION_RESULT_TYPE_ALBUM, (guint) _tmp192_);
		}
		_tmp194_ = category_override;
		if (_tmp194_ >= 0) {
			gint _tmp195_;
			_tmp195_ = category_override;
			_tmp193_ = _tmp195_;
		} else {
			_tmp193_ = (gint) UNITY_MUSIC_LENS_CATEGORY_SONGS;
		}
		_tmp196_ = _tmp193_;
		category_id = _tmp196_;
		_tmp197_ = helper_model;
		_tmp198_ = model;
		_tmp199_ = model_iter;
		_tmp200_ = category_id;
		unity_music_lens_rhythmbox_collection_add_result (self, (DeeModel*) _tmp197_, _tmp198_, _tmp199_, UNITY_MUSIC_LENS_RHYTHMBOX_COLLECTION_RESULT_TYPE_SONG, (guint) _tmp200_);
		_tmp201_ = num_results;
		num_results = _tmp201_ + 1;
		_tmp203_ = max_results;
		if (_tmp203_ >= 0) {
			gint _tmp204_;
			gint _tmp205_;
			_tmp204_ = num_results;
			_tmp205_ = max_results;
			_tmp202_ = _tmp204_ >= _tmp205_;
		} else {
			_tmp202_ = FALSE;
		}
		_tmp206_ = _tmp202_;
		if (_tmp206_) {
			_g_free0 (genre);
			break;
		}
		_tmp207_ = seq_iter;
		_tmp208_ = g_sequence_iter_next (_tmp207_);
		seq_iter = _tmp208_;
		_g_free0 (genre);
	}
	_tmp209_ = helper_model;
	_tmp210_ = search;
	_tmp211_ = unity_lens_search_get_results_model (_tmp210_);
	_tmp212_ = _tmp211_;
	if (_tmp209_ == _tmp212_) {
		_g_object_unref0 (albums_list);
		_g_sequence_free0 (matches);
		_g_object_unref0 (term_list);
		_g_object_unref0 (helper_model);
		_g_object_unref0 (active_genres);
		_g_object_unref0 (model);
		return;
	}
	_tmp213_ = helper_model;
	_tmp214_ = dee_model_get_first_iter ((DeeModel*) _tmp213_);
	iter = _tmp214_;
	_tmp215_ = helper_model;
	_tmp216_ = dee_model_get_last_iter ((DeeModel*) _tmp215_);
	last = _tmp216_;
	while (TRUE) {
		DeeModelIter* _tmp217_;
		DeeModelIter* _tmp218_;
		DeeSerializableModel* _tmp219_;
		DeeModelIter* _tmp220_;
		GVariant** _tmp221_;
		GVariant** _tmp222_ = NULL;
		GVariant** row;
		gint row_length1;
		gint _row_size_;
		UnityLensSearch* _tmp223_;
		DeeSerializableModel* _tmp224_;
		DeeSerializableModel* _tmp225_;
		GVariant** _tmp226_;
		gint _tmp226__length1;
		DeeSerializableModel* _tmp227_;
		DeeModelIter* _tmp228_;
		DeeModelIter* _tmp229_ = NULL;
		_tmp217_ = iter;
		_tmp218_ = last;
		if (!(_tmp217_ != _tmp218_)) {
			break;
		}
		_tmp219_ = helper_model;
		_tmp220_ = iter;
		_tmp222_ = _tmp221_ = dee_model_get_row ((DeeModel*) _tmp219_, _tmp220_, NULL);
		row = _tmp222_;
		row_length1 = _vala_array_length (_tmp221_);
		_row_size_ = row_length1;
		_tmp223_ = search;
		_tmp224_ = unity_lens_search_get_results_model (_tmp223_);
		_tmp225_ = _tmp224_;
		_tmp226_ = row;
		_tmp226__length1 = row_length1;
		dee_model_append_row ((DeeModel*) _tmp225_, _tmp226_);
		_tmp227_ = helper_model;
		_tmp228_ = iter;
		_tmp229_ = dee_model_next ((DeeModel*) _tmp227_, _tmp228_);
		iter = _tmp229_;
		row = (_vala_array_free (row, row_length1, (GDestroyNotify) g_variant_unref), NULL);
	}
	_g_object_unref0 (albums_list);
	_g_sequence_free0 (matches);
	_g_object_unref0 (term_list);
	_g_object_unref0 (helper_model);
	_g_object_unref0 (active_genres);
	_g_object_unref0 (model);
}


static void unity_music_lens_rhythmbox_collection_get_decade_filter (UnityMusicLensRhythmboxCollection* self, GList* filters, gint* min_year, gint* max_year) {
	gint _vala_min_year = 0;
	gint _vala_max_year = 0;
	UnityFilter* filter;
	GList* _tmp0_;
	gboolean _tmp7_ = FALSE;
	UnityFilter* _tmp8_;
	gboolean _tmp12_;
	UnityFilter* _tmp14_;
	UnityMultiRangeFilter* _tmp15_;
	UnityMultiRangeFilter* mrf;
	UnityMultiRangeFilter* _tmp16_;
	UnityFilterOption* _tmp17_ = NULL;
	UnityFilterOption* _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	gint _tmp21_ = 0;
	UnityMultiRangeFilter* _tmp22_;
	UnityFilterOption* _tmp23_ = NULL;
	UnityFilterOption* _tmp24_;
	const gchar* _tmp25_;
	const gchar* _tmp26_;
	gint _tmp27_ = 0;
	g_return_if_fail (self != NULL);
	filter = NULL;
	_tmp0_ = filters;
	{
		GList* parser_collection = NULL;
		GList* parser_it = NULL;
		parser_collection = _tmp0_;
		for (parser_it = parser_collection; parser_it != NULL; parser_it = parser_it->next) {
			UnityMusicLensFilterParser* _tmp1_;
			UnityMusicLensFilterParser* parser = NULL;
			_tmp1_ = _g_object_ref0 ((UnityMusicLensFilterParser*) parser_it->data);
			parser = _tmp1_;
			{
				UnityMusicLensFilterParser* _tmp2_;
				_tmp2_ = parser;
				if (UNITY_MUSIC_LENS_IS_DECADE_FILTER_PARSER (_tmp2_)) {
					UnityMusicLensFilterParser* _tmp3_;
					UnityFilter* _tmp4_;
					UnityFilter* _tmp5_;
					UnityFilter* _tmp6_;
					_tmp3_ = parser;
					_tmp4_ = unity_music_lens_filter_parser_get_filter (_tmp3_);
					_tmp5_ = _tmp4_;
					_tmp6_ = _g_object_ref0 (_tmp5_);
					_g_object_unref0 (filter);
					filter = _tmp6_;
				}
				_g_object_unref0 (parser);
			}
		}
	}
	_tmp8_ = filter;
	if (_tmp8_ == NULL) {
		_tmp7_ = TRUE;
	} else {
		UnityFilter* _tmp9_;
		gboolean _tmp10_;
		gboolean _tmp11_;
		_tmp9_ = filter;
		_tmp10_ = unity_filter_get_filtering (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp7_ = !_tmp11_;
	}
	_tmp12_ = _tmp7_;
	if (_tmp12_) {
		gint _tmp13_;
		_vala_min_year = 0;
		_tmp13_ = G_MAXINT;
		_vala_max_year = _tmp13_;
		_g_object_unref0 (filter);
		if (min_year) {
			*min_year = _vala_min_year;
		}
		if (max_year) {
			*max_year = _vala_max_year;
		}
		return;
	}
	_tmp14_ = filter;
	_tmp15_ = _g_object_ref0 (UNITY_IS_MULTI_RANGE_FILTER (_tmp14_) ? ((UnityMultiRangeFilter*) _tmp14_) : NULL);
	mrf = _tmp15_;
	_tmp16_ = mrf;
	_tmp17_ = unity_multi_range_filter_get_first_active (_tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = unity_filter_option_get_id (_tmp18_);
	_tmp20_ = _tmp19_;
	_tmp21_ = atoi (_tmp20_);
	_vala_min_year = _tmp21_;
	_g_object_unref0 (_tmp18_);
	_tmp22_ = mrf;
	_tmp23_ = unity_multi_range_filter_get_last_active (_tmp22_);
	_tmp24_ = _tmp23_;
	_tmp25_ = unity_filter_option_get_id (_tmp24_);
	_tmp26_ = _tmp25_;
	_tmp27_ = atoi (_tmp26_);
	_vala_max_year = _tmp27_ + 9;
	_g_object_unref0 (_tmp24_);
	_g_object_unref0 (mrf);
	_g_object_unref0 (filter);
	if (min_year) {
		*min_year = _vala_min_year;
	}
	if (max_year) {
		*max_year = _vala_max_year;
	}
}


static GeeSet* unity_music_lens_rhythmbox_collection_get_genre_filter (UnityMusicLensRhythmboxCollection* self, GList* filters) {
	GeeSet* result = NULL;
	UnityFilter* filter;
	GList* _tmp0_;
	gboolean _tmp7_ = FALSE;
	UnityFilter* _tmp8_;
	gboolean _tmp12_;
	GeeHashSet* _tmp13_;
	GeeHashSet* active_genres;
	UnityFilter* _tmp14_;
	UnityCheckOptionFilterCompact* _tmp15_;
	UnityCheckOptionFilterCompact* all_genres;
	UnityCheckOptionFilterCompact* _tmp16_;
	GList* _tmp17_;
	g_return_val_if_fail (self != NULL, NULL);
	filter = NULL;
	_tmp0_ = filters;
	{
		GList* parser_collection = NULL;
		GList* parser_it = NULL;
		parser_collection = _tmp0_;
		for (parser_it = parser_collection; parser_it != NULL; parser_it = parser_it->next) {
			UnityMusicLensFilterParser* _tmp1_;
			UnityMusicLensFilterParser* parser = NULL;
			_tmp1_ = _g_object_ref0 ((UnityMusicLensFilterParser*) parser_it->data);
			parser = _tmp1_;
			{
				UnityMusicLensFilterParser* _tmp2_;
				_tmp2_ = parser;
				if (UNITY_MUSIC_LENS_IS_GENRE_FILTER_PARSER (_tmp2_)) {
					UnityMusicLensFilterParser* _tmp3_;
					UnityFilter* _tmp4_;
					UnityFilter* _tmp5_;
					UnityFilter* _tmp6_;
					_tmp3_ = parser;
					_tmp4_ = unity_music_lens_filter_parser_get_filter (_tmp3_);
					_tmp5_ = _tmp4_;
					_tmp6_ = _g_object_ref0 (_tmp5_);
					_g_object_unref0 (filter);
					filter = _tmp6_;
				}
				_g_object_unref0 (parser);
			}
		}
	}
	_tmp8_ = filter;
	if (_tmp8_ == NULL) {
		_tmp7_ = TRUE;
	} else {
		UnityFilter* _tmp9_;
		gboolean _tmp10_;
		gboolean _tmp11_;
		_tmp9_ = filter;
		_tmp10_ = unity_filter_get_filtering (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp7_ = !_tmp11_;
	}
	_tmp12_ = _tmp7_;
	if (_tmp12_) {
		result = NULL;
		_g_object_unref0 (filter);
		return result;
	}
	_tmp13_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL);
	active_genres = _tmp13_;
	_tmp14_ = filter;
	_tmp15_ = _g_object_ref0 (UNITY_IS_CHECK_OPTION_FILTER_COMPACT (_tmp14_) ? ((UnityCheckOptionFilterCompact*) _tmp14_) : NULL);
	all_genres = _tmp15_;
	_tmp16_ = all_genres;
	_tmp17_ = ((UnityOptionsFilter*) _tmp16_)->options;
	{
		GList* option_collection = NULL;
		GList* option_it = NULL;
		option_collection = _tmp17_;
		for (option_it = option_collection; option_it != NULL; option_it = option_it->next) {
			UnityFilterOption* _tmp18_;
			UnityFilterOption* option = NULL;
			_tmp18_ = _g_object_ref0 ((UnityFilterOption*) option_it->data);
			option = _tmp18_;
			{
				gboolean _tmp19_ = FALSE;
				UnityFilterOption* _tmp20_;
				const gchar* _tmp21_;
				const gchar* _tmp22_;
				gboolean _tmp26_;
				GeeHashSet* _tmp27_;
				UnityFilterOption* _tmp28_;
				const gchar* _tmp29_;
				const gchar* _tmp30_;
				_tmp20_ = option;
				_tmp21_ = unity_filter_option_get_id (_tmp20_);
				_tmp22_ = _tmp21_;
				if (_tmp22_ == NULL) {
					_tmp19_ = TRUE;
				} else {
					UnityFilterOption* _tmp23_;
					gboolean _tmp24_;
					gboolean _tmp25_;
					_tmp23_ = option;
					_tmp24_ = unity_filter_option_get_active (_tmp23_);
					_tmp25_ = _tmp24_;
					_tmp19_ = !_tmp25_;
				}
				_tmp26_ = _tmp19_;
				if (_tmp26_) {
					_g_object_unref0 (option);
					continue;
				}
				_tmp27_ = active_genres;
				_tmp28_ = option;
				_tmp29_ = unity_filter_option_get_id (_tmp28_);
				_tmp30_ = _tmp29_;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp27_, _tmp30_);
				_g_object_unref0 (option);
			}
		}
	}
	result = (GeeSet*) active_genres;
	_g_object_unref0 (all_genres);
	_g_object_unref0 (filter);
	return result;
}


UnityMusicLensRhythmboxCollection* unity_music_lens_rhythmbox_collection_construct (GType object_type) {
	UnityMusicLensRhythmboxCollection * self = NULL;
	self = (UnityMusicLensRhythmboxCollection*) g_object_new (object_type, NULL);
	return self;
}


UnityMusicLensRhythmboxCollection* unity_music_lens_rhythmbox_collection_new (void) {
	return unity_music_lens_rhythmbox_collection_construct (UNITY_MUSIC_LENS_TYPE_RHYTHMBOX_COLLECTION);
}


static void _g_variant_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_variant_unref (var), NULL));
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_ptr_array_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL));
}


static gint _unity_music_lens_rhythmbox_collection___lambda9_ (UnityMusicLensRhythmboxCollection* self, GVariant** row1, int row1_length1, GVariant** row2, int row2_length1) {
	gint result = 0;
	GVariant** _tmp0_;
	gint _tmp0__length1;
	GVariant* _tmp1_;
	gint32 _tmp2_ = 0;
	gint a;
	GVariant** _tmp3_;
	gint _tmp3__length1;
	GVariant* _tmp4_;
	gint32 _tmp5_ = 0;
	gint b;
	gint _tmp6_;
	gint _tmp7_;
	_tmp0_ = row1;
	_tmp0__length1 = row1_length1;
	_tmp1_ = _tmp0_[UNITY_MUSIC_LENS_COLUMNS_PLAY_COUNT];
	_tmp2_ = g_variant_get_int32 (_tmp1_);
	a = (gint) _tmp2_;
	_tmp3_ = row2;
	_tmp3__length1 = row2_length1;
	_tmp4_ = _tmp3_[UNITY_MUSIC_LENS_COLUMNS_PLAY_COUNT];
	_tmp5_ = g_variant_get_int32 (_tmp4_);
	b = (gint) _tmp5_;
	_tmp6_ = b;
	_tmp7_ = a;
	result = _tmp6_ - _tmp7_;
	return result;
}


static gint __unity_music_lens_rhythmbox_collection___lambda9__dee_compare_row_func (GVariant** row1, GVariant** row2, gpointer self) {
	gint result;
	result = _unity_music_lens_rhythmbox_collection___lambda9_ (self, row1, -1, row2, -1);
	return result;
}


static void _unity_music_lens_rhythmbox_collection___lambda10_ (UnityMusicLensRhythmboxCollection* self, DeeTermList* terms_in, DeeTermList* terms_out) {
	g_return_if_fail (terms_in != NULL);
	g_return_if_fail (terms_out != NULL);
	{
		DeeTermList* _tmp0_;
		DeeTermList* _tmp1_;
		DeeTermList* _term_list;
		DeeTermList* _tmp2_;
		guint _tmp3_;
		guint _tmp4_;
		guint _term_size;
		gint _term_index;
		_tmp0_ = terms_in;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_term_list = _tmp1_;
		_tmp2_ = _term_list;
		_tmp3_ = dee_term_list_num_terms (_tmp2_);
		_tmp4_ = _tmp3_;
		_term_size = _tmp4_;
		_term_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			guint _tmp7_;
			DeeTermList* _tmp8_;
			gint _tmp9_;
			const gchar* _tmp10_ = NULL;
			const gchar* term;
			DeeICUTermFilter* _tmp11_;
			const gchar* _tmp12_;
			gchar* _tmp13_ = NULL;
			gchar* folded;
			DeeTermList* _tmp14_;
			const gchar* _tmp15_;
			const gchar* _tmp16_;
			const gchar* _tmp17_;
			_tmp5_ = _term_index;
			_term_index = _tmp5_ + 1;
			_tmp6_ = _term_index;
			_tmp7_ = _term_size;
			if (!(((guint) _tmp6_) < _tmp7_)) {
				break;
			}
			_tmp8_ = _term_list;
			_tmp9_ = _term_index;
			_tmp10_ = dee_term_list_get_term (_tmp8_, (guint) _tmp9_);
			term = _tmp10_;
			_tmp11_ = self->priv->ascii_filter;
			_tmp12_ = term;
			_tmp13_ = dee_icu_term_filter_apply (_tmp11_, _tmp12_);
			folded = _tmp13_;
			_tmp14_ = terms_out;
			_tmp15_ = term;
			dee_term_list_add_term (_tmp14_, _tmp15_);
			_tmp16_ = folded;
			_tmp17_ = term;
			if (g_strcmp0 (_tmp16_, _tmp17_) != 0) {
				DeeTermList* _tmp18_;
				const gchar* _tmp19_;
				_tmp18_ = terms_out;
				_tmp19_ = folded;
				dee_term_list_add_term (_tmp18_, _tmp19_);
			}
			_g_free0 (folded);
		}
		_g_object_unref0 (_term_list);
	}
}


static void __unity_music_lens_rhythmbox_collection___lambda10__dee_term_filter_func (DeeTermList* terms_in, DeeTermList* terms_out, gpointer self) {
	_unity_music_lens_rhythmbox_collection___lambda10_ (self, terms_in, terms_out);
}


static GObject * unity_music_lens_rhythmbox_collection_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	UnityMusicLensRhythmboxCollection * self;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	GHashFunc _tmp2_;
	GEqualFunc _tmp3_;
	GHashTable* _tmp4_;
	GHashFunc _tmp5_;
	GEqualFunc _tmp6_;
	GHashTable* _tmp7_;
	DeeSequenceModel* _tmp8_;
	DeeSequenceModel* _tmp9_;
	DeeSequenceModel* _tmp10_;
	guint _tmp11_;
	gchar** _tmp12_ = NULL;
	DeeSequenceModel* _tmp13_;
	DeeModelTag* _tmp14_;
	GHashFunc _tmp15_;
	GEqualFunc _tmp16_;
	GHashTable* _tmp17_;
	DeeFilter _tmp18_ = {0};
	DeeFilter filter;
	DeeSequenceModel* _tmp19_;
	DeeFilter _tmp20_;
	DeeFilterModel* _tmp21_;
	DeeICUTermFilter* _tmp22_;
	DeeTextAnalyzer* _tmp23_;
	DeeAnalyzer* _tmp24_;
	parent_class = G_OBJECT_CLASS (unity_music_lens_rhythmbox_collection_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = UNITY_MUSIC_LENS_RHYTHMBOX_COLLECTION (obj);
	G_STATIC_ASSERT (11 == ((gint) UNITY_MUSIC_LENS_COLUMNS_N_COLUMNS));
	_tmp0_ = g_get_user_cache_dir ();
	_tmp1_ = g_build_filename (_tmp0_, "media-art", NULL);
	_g_free0 (self->priv->media_art_dir);
	self->priv->media_art_dir = _tmp1_;
	_tmp2_ = g_str_hash;
	_tmp3_ = g_str_equal;
	_tmp4_ = g_hash_table_new_full (_tmp2_, _tmp3_, NULL, _g_variant_unref0_);
	_g_hash_table_unref0 (self->priv->variant_store);
	self->priv->variant_store = _tmp4_;
	_tmp5_ = g_direct_hash;
	_tmp6_ = g_direct_equal;
	_tmp7_ = g_hash_table_new_full (_tmp5_, _tmp6_, NULL, _g_variant_unref0_);
	_g_hash_table_unref0 (self->priv->int_variant_store);
	self->priv->int_variant_store = _tmp7_;
	_tmp8_ = (DeeSequenceModel*) dee_sequence_model_new ();
	_g_object_unref0 (self->priv->all_tracks);
	self->priv->all_tracks = _tmp8_;
	_tmp9_ = self->priv->all_tracks;
	dee_model_set_schema ((DeeModel*) _tmp9_, "s", "s", "s", "s", "s", "s", "s", "s", "i", "i", "i", NULL);
	_tmp10_ = self->priv->all_tracks;
	_tmp12_ = dee_model_get_schema ((DeeModel*) _tmp10_, &_tmp11_);
	g_assert (_tmp11_ == ((gint) UNITY_MUSIC_LENS_COLUMNS_N_COLUMNS));
	_tmp13_ = self->priv->all_tracks;
	_tmp14_ = dee_model_register_tag ((DeeModel*) _tmp13_, NULL);
	self->priv->album_art_tag = _tmp14_;
	_tmp15_ = g_str_hash;
	_tmp16_ = g_str_equal;
	_tmp17_ = g_hash_table_new_full (_tmp15_, _tmp16_, _g_free0_, _g_ptr_array_unref0_);
	_g_hash_table_unref0 (self->priv->album_to_tracks_map);
	self->priv->album_to_tracks_map = _tmp17_;
	dee_filter_new_sort (__unity_music_lens_rhythmbox_collection___lambda9__dee_compare_row_func, g_object_ref (self), g_object_unref, &_tmp18_);
	filter = _tmp18_;
	_tmp19_ = self->priv->all_tracks;
	_tmp20_ = filter;
	_tmp21_ = (DeeFilterModel*) dee_filter_model_new ((DeeModel*) _tmp19_, &_tmp20_);
	_g_object_unref0 (self->priv->tracks_by_play_count);
	self->priv->tracks_by_play_count = _tmp21_;
	_tmp22_ = dee_icu_term_filter_new_ascii_folder ();
	_dee_icu_term_filter_destroy0 (self->priv->ascii_filter);
	self->priv->ascii_filter = _tmp22_;
	_tmp23_ = dee_text_analyzer_new ();
	_g_object_unref0 (self->priv->analyzer);
	self->priv->analyzer = (DeeAnalyzer*) _tmp23_;
	_tmp24_ = self->priv->analyzer;
	dee_analyzer_add_term_filter (_tmp24_, __unity_music_lens_rhythmbox_collection___lambda10__dee_term_filter_func, g_object_ref (self), g_object_unref);
	unity_music_lens_rhythmbox_collection_initialize_index (self);
	return obj;
}


static void _unity_music_lens_rhythmbox_collection_xml_parser_start_tag_gmarkup_parser_start_element_func (GMarkupParseContext* context, const gchar* element_name, gchar** attribute_names, gchar** attribute_values, gpointer self, GError** error) {
	unity_music_lens_rhythmbox_collection_xml_parser_start_tag (self, context, element_name, attribute_names, attribute_values, error);
}


static void _unity_music_lens_rhythmbox_collection_xml_parser_end_tag_gmarkup_parser_end_element_func (GMarkupParseContext* context, const gchar* element_name, gpointer self, GError** error) {
	unity_music_lens_rhythmbox_collection_xml_parser_end_tag (self, context, element_name, error);
}


static void _unity_music_lens_rhythmbox_collection_xml_parser_process_text_gmarkup_parser_text_func (GMarkupParseContext* context, const gchar* text, gsize text_len, gpointer self, GError** error) {
	unity_music_lens_rhythmbox_collection_xml_parser_process_text (self, context, text, text_len, error);
}


static gboolean unity_music_lens_rhythmbox_collection_xml_parser_parse (UnityMusicLensRhythmboxCollectionXmlParser* self, const gchar* content, gsize len, GError** error) {
	gboolean result = FALSE;
	GMarkupParseContext* _tmp0_;
	const gchar* _tmp1_;
	gsize _tmp2_;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (content != NULL, FALSE);
	_tmp0_ = self->priv->context;
	_tmp1_ = content;
	_tmp2_ = len;
	_tmp3_ = g_markup_parse_context_parse (_tmp0_, _tmp1_, (gssize) _tmp2_, &_inner_error_);
	_tmp4_ = _tmp3_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_MARKUP_ERROR) {
			g_propagate_error (error, _inner_error_);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = _tmp4_;
	return result;
}


static void unity_music_lens_rhythmbox_collection_xml_parser_start_tag (UnityMusicLensRhythmboxCollectionXmlParser* self, GMarkupParseContext* context, const gchar* name, gchar** attr_names, gchar** attr_values, GError** error) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = self->priv->processing_song;
	if (!_tmp0_) {
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		GQuark _tmp4_ = 0U;
		static GQuark _tmp3_label0 = 0;
		static GQuark _tmp3_label1 = 0;
		_tmp1_ = name;
		_tmp2_ = _tmp1_;
		_tmp4_ = (NULL == _tmp2_) ? 0 : g_quark_from_string (_tmp2_);
		if (_tmp4_ == ((0 != _tmp3_label0) ? _tmp3_label0 : (_tmp3_label0 = g_quark_from_static_string ("rhythmdb")))) {
			switch (0) {
				default:
				{
					self->priv->is_rhythmdb_xml = TRUE;
					break;
				}
			}
		} else if (_tmp4_ == ((0 != _tmp3_label1) ? _tmp3_label1 : (_tmp3_label1 = g_quark_from_static_string ("entry")))) {
			switch (0) {
				default:
				{
					gboolean is_song;
					gboolean _tmp19_;
					UnityMusicLensTrack* _tmp20_;
					is_song = FALSE;
					{
						gint i;
						i = 0;
						{
							gboolean _tmp5_;
							_tmp5_ = TRUE;
							while (TRUE) {
								gboolean _tmp6_;
								gchar** _tmp8_;
								gint _tmp8__length1;
								gint _tmp9_;
								const gchar* _tmp10_;
								gboolean _tmp11_ = FALSE;
								gchar** _tmp12_;
								gint _tmp12__length1;
								gint _tmp13_;
								const gchar* _tmp14_;
								gboolean _tmp18_;
								_tmp6_ = _tmp5_;
								if (!_tmp6_) {
									gint _tmp7_;
									_tmp7_ = i;
									i = _tmp7_ + 1;
								}
								_tmp5_ = FALSE;
								_tmp8_ = attr_names;
								_tmp8__length1 = _vala_array_length (attr_names);
								_tmp9_ = i;
								_tmp10_ = _tmp8_[_tmp9_];
								if (!(_tmp10_ != NULL)) {
									break;
								}
								_tmp12_ = attr_names;
								_tmp12__length1 = _vala_array_length (attr_names);
								_tmp13_ = i;
								_tmp14_ = _tmp12_[_tmp13_];
								if (g_strcmp0 (_tmp14_, "type") == 0) {
									gchar** _tmp15_;
									gint _tmp15__length1;
									gint _tmp16_;
									const gchar* _tmp17_;
									_tmp15_ = attr_values;
									_tmp15__length1 = _vala_array_length (attr_values);
									_tmp16_ = i;
									_tmp17_ = _tmp15_[_tmp16_];
									_tmp11_ = g_strcmp0 (_tmp17_, "song") == 0;
								} else {
									_tmp11_ = FALSE;
								}
								_tmp18_ = _tmp11_;
								if (_tmp18_) {
									is_song = TRUE;
								}
							}
						}
					}
					_tmp19_ = is_song;
					if (!_tmp19_) {
						return;
					}
					self->priv->processing_song = TRUE;
					_tmp20_ = unity_music_lens_track_new ();
					_g_object_unref0 (self->priv->current_track);
					self->priv->current_track = _tmp20_;
					break;
				}
			}
		}
	} else {
		const gchar* _tmp21_;
		const gchar* _tmp22_;
		GQuark _tmp24_ = 0U;
		static GQuark _tmp23_label0 = 0;
		static GQuark _tmp23_label1 = 0;
		static GQuark _tmp23_label2 = 0;
		static GQuark _tmp23_label3 = 0;
		static GQuark _tmp23_label4 = 0;
		static GQuark _tmp23_label5 = 0;
		static GQuark _tmp23_label6 = 0;
		static GQuark _tmp23_label7 = 0;
		static GQuark _tmp23_label8 = 0;
		static GQuark _tmp23_label9 = 0;
		_tmp21_ = name;
		_tmp22_ = _tmp21_;
		_tmp24_ = (NULL == _tmp22_) ? 0 : g_quark_from_string (_tmp22_);
		if (_tmp24_ == ((0 != _tmp23_label0) ? _tmp23_label0 : (_tmp23_label0 = g_quark_from_static_string ("location")))) {
			switch (0) {
				default:
				{
					self->priv->current_data = (gint) UNITY_MUSIC_LENS_COLUMNS_URI;
					break;
				}
			}
		} else if (_tmp24_ == ((0 != _tmp23_label1) ? _tmp23_label1 : (_tmp23_label1 = g_quark_from_static_string ("title")))) {
			switch (0) {
				default:
				{
					self->priv->current_data = (gint) UNITY_MUSIC_LENS_COLUMNS_TITLE;
					break;
				}
			}
		} else if (_tmp24_ == ((0 != _tmp23_label2) ? _tmp23_label2 : (_tmp23_label2 = g_quark_from_static_string ("artist")))) {
			switch (0) {
				default:
				{
					self->priv->current_data = (gint) UNITY_MUSIC_LENS_COLUMNS_ARTIST;
					break;
				}
			}
		} else if (_tmp24_ == ((0 != _tmp23_label3) ? _tmp23_label3 : (_tmp23_label3 = g_quark_from_static_string ("album")))) {
			switch (0) {
				default:
				{
					self->priv->current_data = (gint) UNITY_MUSIC_LENS_COLUMNS_ALBUM;
					break;
				}
			}
		} else if (_tmp24_ == ((0 != _tmp23_label4) ? _tmp23_label4 : (_tmp23_label4 = g_quark_from_static_string ("genre")))) {
			switch (0) {
				default:
				{
					self->priv->current_data = (gint) UNITY_MUSIC_LENS_COLUMNS_GENRE;
					break;
				}
			}
		} else if (_tmp24_ == ((0 != _tmp23_label5) ? _tmp23_label5 : (_tmp23_label5 = g_quark_from_static_string ("track-number")))) {
			switch (0) {
				default:
				{
					self->priv->current_data = (gint) UNITY_MUSIC_LENS_COLUMNS_TRACK_NUMBER;
					break;
				}
			}
		} else if (_tmp24_ == ((0 != _tmp23_label6) ? _tmp23_label6 : (_tmp23_label6 = g_quark_from_static_string ("play-count")))) {
			switch (0) {
				default:
				{
					self->priv->current_data = (gint) UNITY_MUSIC_LENS_COLUMNS_PLAY_COUNT;
					break;
				}
			}
		} else if (_tmp24_ == ((0 != _tmp23_label7) ? _tmp23_label7 : (_tmp23_label7 = g_quark_from_static_string ("date")))) {
			switch (0) {
				default:
				{
					self->priv->current_data = (gint) UNITY_MUSIC_LENS_COLUMNS_YEAR;
					break;
				}
			}
		} else if (_tmp24_ == ((0 != _tmp23_label8) ? _tmp23_label8 : (_tmp23_label8 = g_quark_from_static_string ("media-type")))) {
			switch (0) {
				default:
				{
					self->priv->current_data = (gint) UNITY_MUSIC_LENS_COLUMNS_MIMETYPE;
					break;
				}
			}
		} else if (_tmp24_ == ((0 != _tmp23_label9) ? _tmp23_label9 : (_tmp23_label9 = g_quark_from_static_string ("album-artist")))) {
			switch (0) {
				default:
				{
					self->priv->current_data = (gint) UNITY_MUSIC_LENS_COLUMNS_ALBUM_ARTIST;
					break;
				}
			}
		} else {
			switch (0) {
				default:
				{
					self->priv->current_data = -1;
					break;
				}
			}
		}
	}
}


static void unity_music_lens_rhythmbox_collection_xml_parser_end_tag (UnityMusicLensRhythmboxCollectionXmlParser* self, GMarkupParseContext* content, const gchar* name, GError** error) {
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GQuark _tmp3_ = 0U;
	static GQuark _tmp2_label0 = 0;
	static GQuark _tmp2_label1 = 0;
	static GQuark _tmp2_label2 = 0;
	static GQuark _tmp2_label3 = 0;
	static GQuark _tmp2_label4 = 0;
	static GQuark _tmp2_label5 = 0;
	static GQuark _tmp2_label6 = 0;
	static GQuark _tmp2_label7 = 0;
	static GQuark _tmp2_label8 = 0;
	static GQuark _tmp2_label9 = 0;
	static GQuark _tmp2_label10 = 0;
	static GQuark _tmp2_label11 = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (content != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = name;
	_tmp1_ = _tmp0_;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	if ((((((((((_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("location")))) || (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("title"))))) || (_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("artist"))))) || (_tmp3_ == ((0 != _tmp2_label3) ? _tmp2_label3 : (_tmp2_label3 = g_quark_from_static_string ("album"))))) || (_tmp3_ == ((0 != _tmp2_label4) ? _tmp2_label4 : (_tmp2_label4 = g_quark_from_static_string ("genre"))))) || (_tmp3_ == ((0 != _tmp2_label5) ? _tmp2_label5 : (_tmp2_label5 = g_quark_from_static_string ("track-number"))))) || (_tmp3_ == ((0 != _tmp2_label6) ? _tmp2_label6 : (_tmp2_label6 = g_quark_from_static_string ("play-count"))))) || (_tmp3_ == ((0 != _tmp2_label7) ? _tmp2_label7 : (_tmp2_label7 = g_quark_from_static_string ("date"))))) || (_tmp3_ == ((0 != _tmp2_label8) ? _tmp2_label8 : (_tmp2_label8 = g_quark_from_static_string ("media-type"))))) || (_tmp3_ == ((0 != _tmp2_label9) ? _tmp2_label9 : (_tmp2_label9 = g_quark_from_static_string ("album-artist"))))) {
		switch (0) {
			default:
			{
				gint _tmp4_;
				_tmp4_ = self->priv->current_data;
				if (_tmp4_ >= 0) {
					self->priv->current_data = -1;
				}
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label10) ? _tmp2_label10 : (_tmp2_label10 = g_quark_from_static_string ("hidden")))) {
		switch (0) {
			default:
			{
				gboolean _tmp5_;
				_tmp5_ = self->priv->processing_song;
				if (_tmp5_) {
					self->priv->processing_song = FALSE;
				}
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label11) ? _tmp2_label11 : (_tmp2_label11 = g_quark_from_static_string ("entry")))) {
		switch (0) {
			default:
			{
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_;
				gboolean _tmp9_;
				_tmp7_ = self->priv->processing_song;
				if (_tmp7_) {
					UnityMusicLensTrack* _tmp8_;
					_tmp8_ = self->priv->current_track;
					_tmp6_ = _tmp8_ != NULL;
				} else {
					_tmp6_ = FALSE;
				}
				_tmp9_ = _tmp6_;
				if (_tmp9_) {
					UnityMusicLensTrack* _tmp10_;
					_tmp10_ = self->priv->current_track;
					g_signal_emit_by_name (self, "track-info-ready", _tmp10_);
				}
				self->priv->processing_song = FALSE;
				break;
			}
		}
	}
}


static void unity_music_lens_rhythmbox_collection_xml_parser_process_text (UnityMusicLensRhythmboxCollectionXmlParser* self, GMarkupParseContext* context, const gchar* text, gsize text_len, GError** error) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean _tmp3_;
	gint _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	g_return_if_fail (text != NULL);
	_tmp1_ = self->priv->processing_song;
	if (!_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gint _tmp2_;
		_tmp2_ = self->priv->current_data;
		_tmp0_ = _tmp2_ < 0;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		return;
	}
	_tmp4_ = self->priv->current_data;
	switch (_tmp4_) {
		case UNITY_MUSIC_LENS_COLUMNS_URI:
		{
			UnityMusicLensTrack* _tmp5_;
			const gchar* _tmp6_;
			_tmp5_ = self->priv->current_track;
			_tmp6_ = text;
			unity_music_lens_track_set_uri (_tmp5_, _tmp6_);
			break;
		}
		case UNITY_MUSIC_LENS_COLUMNS_TITLE:
		{
			UnityMusicLensTrack* _tmp7_;
			const gchar* _tmp8_;
			_tmp7_ = self->priv->current_track;
			_tmp8_ = text;
			unity_music_lens_track_set_title (_tmp7_, _tmp8_);
			break;
		}
		case UNITY_MUSIC_LENS_COLUMNS_ARTIST:
		{
			UnityMusicLensTrack* _tmp9_;
			const gchar* _tmp10_;
			_tmp9_ = self->priv->current_track;
			_tmp10_ = text;
			unity_music_lens_track_set_artist (_tmp9_, _tmp10_);
			break;
		}
		case UNITY_MUSIC_LENS_COLUMNS_ALBUM:
		{
			UnityMusicLensTrack* _tmp11_;
			const gchar* _tmp12_;
			_tmp11_ = self->priv->current_track;
			_tmp12_ = text;
			unity_music_lens_track_set_album (_tmp11_, _tmp12_);
			break;
		}
		case UNITY_MUSIC_LENS_COLUMNS_ALBUM_ARTIST:
		{
			UnityMusicLensTrack* _tmp13_;
			const gchar* _tmp14_;
			_tmp13_ = self->priv->current_track;
			_tmp14_ = text;
			unity_music_lens_track_set_album_artist (_tmp13_, _tmp14_);
			break;
		}
		case UNITY_MUSIC_LENS_COLUMNS_GENRE:
		{
			UnityMusicLensTrack* _tmp15_;
			UnityMusicLensGenre* _tmp16_;
			const gchar* _tmp17_;
			gchar* _tmp18_ = NULL;
			gchar* _tmp19_;
			gchar* _tmp20_ = NULL;
			gchar* _tmp21_;
			_tmp15_ = self->priv->current_track;
			_tmp16_ = self->priv->genre;
			_tmp17_ = text;
			_tmp18_ = g_utf8_strdown (_tmp17_, (gssize) (-1));
			_tmp19_ = _tmp18_;
			_tmp20_ = unity_music_lens_genre_get_id_for_genre (_tmp16_, _tmp19_);
			_tmp21_ = _tmp20_;
			unity_music_lens_track_set_genre (_tmp15_, _tmp21_);
			_g_free0 (_tmp21_);
			_g_free0 (_tmp19_);
			break;
		}
		case UNITY_MUSIC_LENS_COLUMNS_MIMETYPE:
		{
			UnityMusicLensTrack* _tmp22_;
			const gchar* _tmp23_;
			_tmp22_ = self->priv->current_track;
			_tmp23_ = text;
			unity_music_lens_track_set_mime_type (_tmp22_, _tmp23_);
			break;
		}
		case UNITY_MUSIC_LENS_COLUMNS_YEAR:
		{
			UnityMusicLensTrack* _tmp24_;
			const gchar* _tmp25_;
			gint _tmp26_ = 0;
			_tmp24_ = self->priv->current_track;
			_tmp25_ = text;
			_tmp26_ = atoi (_tmp25_);
			unity_music_lens_track_set_year (_tmp24_, _tmp26_ / 365);
			break;
		}
		case UNITY_MUSIC_LENS_COLUMNS_PLAY_COUNT:
		{
			UnityMusicLensTrack* _tmp27_;
			const gchar* _tmp28_;
			gint _tmp29_ = 0;
			_tmp27_ = self->priv->current_track;
			_tmp28_ = text;
			_tmp29_ = atoi (_tmp28_);
			unity_music_lens_track_set_play_count (_tmp27_, _tmp29_);
			break;
		}
		case UNITY_MUSIC_LENS_COLUMNS_TRACK_NUMBER:
		{
			UnityMusicLensTrack* _tmp30_;
			const gchar* _tmp31_;
			gint _tmp32_ = 0;
			_tmp30_ = self->priv->current_track;
			_tmp31_ = text;
			_tmp32_ = atoi (_tmp31_);
			unity_music_lens_track_set_track_number (_tmp30_, _tmp32_);
			break;
		}
		default:
		break;
	}
}


static UnityMusicLensRhythmboxCollectionXmlParser* unity_music_lens_rhythmbox_collection_xml_parser_construct (GType object_type) {
	UnityMusicLensRhythmboxCollectionXmlParser * self = NULL;
	self = (UnityMusicLensRhythmboxCollectionXmlParser*) g_object_new (object_type, NULL);
	return self;
}


static UnityMusicLensRhythmboxCollectionXmlParser* unity_music_lens_rhythmbox_collection_xml_parser_new (void) {
	return unity_music_lens_rhythmbox_collection_xml_parser_construct (UNITY_MUSIC_LENS_RHYTHMBOX_COLLECTION_TYPE_XML_PARSER);
}


static GObject * unity_music_lens_rhythmbox_collection_xml_parser_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	UnityMusicLensRhythmboxCollectionXmlParser * self;
	GMarkupParseContext* _tmp0_;
	parent_class = G_OBJECT_CLASS (unity_music_lens_rhythmbox_collection_xml_parser_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = UNITY_MUSIC_LENS_RHYTHMBOX_COLLECTION_XML_PARSER (obj);
	_tmp0_ = g_markup_parse_context_new (&UNITY_MUSIC_LENS_RHYTHMBOX_COLLECTION_XML_PARSER_parser, 0, self, NULL);
	_g_markup_parse_context_free0 (self->priv->context);
	self->priv->context = _tmp0_;
	return obj;
}


static void unity_music_lens_rhythmbox_collection_xml_parser_class_init (UnityMusicLensRhythmboxCollectionXmlParserClass * klass) {
	unity_music_lens_rhythmbox_collection_xml_parser_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UnityMusicLensRhythmboxCollectionXmlParserPrivate));
	G_OBJECT_CLASS (klass)->constructor = unity_music_lens_rhythmbox_collection_xml_parser_constructor;
	G_OBJECT_CLASS (klass)->finalize = unity_music_lens_rhythmbox_collection_xml_parser_finalize;
	g_signal_new ("track_info_ready", UNITY_MUSIC_LENS_RHYTHMBOX_COLLECTION_TYPE_XML_PARSER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, UNITY_MUSIC_LENS_TYPE_TRACK);
}


static void unity_music_lens_rhythmbox_collection_xml_parser_instance_init (UnityMusicLensRhythmboxCollectionXmlParser * self) {
	UnityMusicLensGenre* _tmp0_;
	self->priv = UNITY_MUSIC_LENS_RHYTHMBOX_COLLECTION_XML_PARSER_GET_PRIVATE (self);
	_tmp0_ = unity_music_lens_genre_new ();
	self->priv->genre = _tmp0_;
	self->priv->is_rhythmdb_xml = FALSE;
	self->priv->current_data = -1;
}


static void unity_music_lens_rhythmbox_collection_xml_parser_finalize (GObject* obj) {
	UnityMusicLensRhythmboxCollectionXmlParser * self;
	self = UNITY_MUSIC_LENS_RHYTHMBOX_COLLECTION_XML_PARSER (obj);
	_g_object_unref0 (self->priv->genre);
	_g_markup_parse_context_free0 (self->priv->context);
	_g_object_unref0 (self->priv->current_track);
	G_OBJECT_CLASS (unity_music_lens_rhythmbox_collection_xml_parser_parent_class)->finalize (obj);
}


static GType unity_music_lens_rhythmbox_collection_xml_parser_get_type (void) {
	static volatile gsize unity_music_lens_rhythmbox_collection_xml_parser_type_id__volatile = 0;
	if (g_once_init_enter (&unity_music_lens_rhythmbox_collection_xml_parser_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnityMusicLensRhythmboxCollectionXmlParserClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_music_lens_rhythmbox_collection_xml_parser_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityMusicLensRhythmboxCollectionXmlParser), 0, (GInstanceInitFunc) unity_music_lens_rhythmbox_collection_xml_parser_instance_init, NULL };
		GType unity_music_lens_rhythmbox_collection_xml_parser_type_id;
		unity_music_lens_rhythmbox_collection_xml_parser_type_id = g_type_register_static (G_TYPE_OBJECT, "UnityMusicLensRhythmboxCollectionXmlParser", &g_define_type_info, 0);
		g_once_init_leave (&unity_music_lens_rhythmbox_collection_xml_parser_type_id__volatile, unity_music_lens_rhythmbox_collection_xml_parser_type_id);
	}
	return unity_music_lens_rhythmbox_collection_xml_parser_type_id__volatile;
}


static void unity_music_lens_rhythmbox_collection_class_init (UnityMusicLensRhythmboxCollectionClass * klass) {
	unity_music_lens_rhythmbox_collection_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UnityMusicLensRhythmboxCollectionPrivate));
	G_OBJECT_CLASS (klass)->constructor = unity_music_lens_rhythmbox_collection_constructor;
	G_OBJECT_CLASS (klass)->finalize = unity_music_lens_rhythmbox_collection_finalize;
}


static void unity_music_lens_rhythmbox_collection_instance_init (UnityMusicLensRhythmboxCollection * self) {
	self->priv = UNITY_MUSIC_LENS_RHYTHMBOX_COLLECTION_GET_PRIVATE (self);
}


static void unity_music_lens_rhythmbox_collection_finalize (GObject* obj) {
	UnityMusicLensRhythmboxCollection * self;
	self = UNITY_MUSIC_LENS_RHYTHMBOX_COLLECTION (obj);
	_g_object_unref0 (self->priv->all_tracks);
	_g_object_unref0 (self->priv->tracks_by_play_count);
	_g_hash_table_unref0 (self->priv->album_to_tracks_map);
	_tdb_close0 (self->priv->album_art_tdb);
	_g_object_unref0 (self->priv->tdb_monitor);
	_g_hash_table_unref0 (self->priv->variant_store);
	_g_hash_table_unref0 (self->priv->int_variant_store);
	_vala_array_destroy (self->priv->row_buffer, 11, (GDestroyNotify) g_variant_unref);
	_g_object_unref0 (self->priv->analyzer);
	_g_object_unref0 (self->priv->index);
	_dee_icu_term_filter_destroy0 (self->priv->ascii_filter);
	_g_free0 (self->priv->media_art_dir);
	G_OBJECT_CLASS (unity_music_lens_rhythmbox_collection_parent_class)->finalize (obj);
}


GType unity_music_lens_rhythmbox_collection_get_type (void) {
	static volatile gsize unity_music_lens_rhythmbox_collection_type_id__volatile = 0;
	if (g_once_init_enter (&unity_music_lens_rhythmbox_collection_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnityMusicLensRhythmboxCollectionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_music_lens_rhythmbox_collection_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityMusicLensRhythmboxCollection), 0, (GInstanceInitFunc) unity_music_lens_rhythmbox_collection_instance_init, NULL };
		GType unity_music_lens_rhythmbox_collection_type_id;
		unity_music_lens_rhythmbox_collection_type_id = g_type_register_static (G_TYPE_OBJECT, "UnityMusicLensRhythmboxCollection", &g_define_type_info, 0);
		g_once_init_leave (&unity_music_lens_rhythmbox_collection_type_id__volatile, unity_music_lens_rhythmbox_collection_type_id);
	}
	return unity_music_lens_rhythmbox_collection_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



