import Qt 4.7
import UnityApplications 1.0
import Unity2d 1.0 /* required for drag’n’drop handling */

DropItem {
    id: launcher

    GnomeBackground {
        anchors.fill: parent
        overlay_color: "black"
        overlay_alpha: 0.71
        opacity: (screen.isCompositingManagerRunning) ? 0.0 : 1.0
    }
    
    Rectangle {
        anchors.fill: parent
        color: "black"
        opacity: (screen.isCompositingManagerRunning) ? 0.5 : 0.0
    }

    onDragEnter: launcherView.onDragEnter(event)
    onDrop: launcherView.onDrop(event)

    LauncherList {
        id: main
        anchors.top: parent.top
        anchors.bottom: parent.bottom
        width: parent.width
        z: 1 /* for dnd to remain on top of looseItems */
	/* Ensure all delegates are cached in order to improve smoothness of
	   scrolling on very low end platforms */
	cacheBuffer: 10000

        autoScrollSize: tileSize / 2
        autoScrollVelocity: 200
        reorderable: true

        model: ListAggregatorModel {
            id: items
        }
    }

    LauncherApplicationsList {
        id: applications
    }

    LauncherPlacesList {
        id: places
    }

    LauncherDevicesList {
        id: devices
    }

    Trashes {
        id: trashes
    }

    Component.onCompleted: {
        items.appendModel(applications);
        items.appendModel(places);
        items.appendModel(devices);
        items.appendModel(trashes);
    }

    Connections {
        target: launcherView
        onDesktopFileDropped: applications.insertFavoriteApplication(path)
        onWebpageUrlDropped: applications.insertWebFavorite(url)
        onAddWebFavoriteRequested: applications.insertWebFavorite(url)
        onSuperKeyHeldChanged: {
            if (superKeyHeld) visibilityController.beginForceVisible()
            else visibilityController.endForceVisible()
        }
    }
}
