# -*- coding: utf-8 -*-
#
# Copyright 2011 Canonical Ltd.
#
# This program is free software: you can redistribute it and/or modify it
# under the terms of the GNU General Public License version 3, as published
# by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranties of
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
# PURPOSE.  See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program.  If not, see <http://www.gnu.org/licenses/>.

"""The signin page."""

from ubuntu_sso.utils.ui import (
    EXISTING_ACCOUNT_CHOICE_BUTTON,
    SET_UP_ACCOUNT_CHOICE_BUTTON,
)
from ubuntuone.controlpanel.gui import WELCOME_LABEL
from ubuntuone.controlpanel.gui.qt.ubuntuonebin import UbuntuOneBin
from ubuntuone.controlpanel.gui.qt.ui import signin_ui

WELCOME_MARKUP = u'<span style="font-size:xx-large;">{0}</span>'


class SignInPanel(UbuntuOneBin):
    """The widget for signing in."""

    ui_class = signin_ui

    def _setup(self):
        """Do some extra setupping for the UI."""
        super(SignInPanel, self)._setup()
        self.ui.welcome_label.setText(WELCOME_MARKUP.format(WELCOME_LABEL))
        self.ui.login_button.setText(EXISTING_ACCOUNT_CHOICE_BUTTON)
        self.ui.register_button.setText(SET_UP_ACCOUNT_CHOICE_BUTTON)
