/*
 * Syncdaemon API
 *
 * Authors: Rodrigo Moya <rodrigo.moya@canonical.com>
 *
 * Copyright 2010-2012 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 3, as published
 * by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In addition, as a special exception, the copyright holders give
 * permission to link the code of portions of this program with the
 * OpenSSL library under certain conditions as described in each
 * individual source file, and distribute linked combinations
 * including the two.
 * You must obey the GNU General Public License in all respects
 * for all of the code used other than OpenSSL.  If you modify
 * file(s) with this exception, you may extend this exception to your
 * version of the file(s), but you are not obligated to do so.  If you
 * do not wish to do so, delete this exception statement from your
 * version.  If you delete this exception statement from all source
 * files in the program, then also delete it here.
 *
 */

#ifndef __SYNCDAEMON_PUBLICFILES_INTERFACE_H__
#define __SYNCDAEMON_PUBLICFILES_INTERFACE_H__

#include "syncdaemon-daemon.h"
#include "syncdaemon-interface.h"

G_BEGIN_DECLS

#define SYNCDAEMON_TYPE_PUBLICFILES_INTERFACE                (syncdaemon_publicfiles_interface_get_type ())
#define SYNCDAEMON_PUBLICFILES_INTERFACE(obj)                (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNCDAEMON_TYPE_PUBLICFILES_INTERFACE, SyncdaemonPublicfilesInterface))
#define SYNCDAEMON_IS_PUBLICFILES_INTERFACE(obj)             (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNCDAEMON_TYPE_PUBLICFILES_INTERFACE))
#define SYNCDAEMON_PUBLICFILES_INTERFACE_CLASS(klass)        (G_TYPE_CHECK_CLASS_CAST ((klass), SYNCDAEMON_TYPE_PUBLICFILES_INTERFACE, SyncdaemonPublicfilesInterfaceClass))
#define SYNCDAEMON_IS_PUBLICFILES_INTERFACE_CLASS(klass)     (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNCDAEMON_TYPE_PUBLICFILES_INTERFACE))
#define SYNCDAEMON_PUBLICFILES_INTERFACE_GET_CLASS(obj)      (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNCDAEMON_TYPE_PUBLICFILES_INTERFACE, SyncdaemonPublicfilesInterfaceClass))

typedef struct _SyncdaemonPublicfilesInterfacePrivate SyncdaemonPublicfilesInterfacePrivate;

typedef struct {
	SyncdaemonInterface parent;
	SyncdaemonPublicfilesInterfacePrivate *priv;
} SyncdaemonPublicfilesInterface;

typedef struct {
	SyncdaemonInterfaceClass parent_class;
} SyncdaemonPublicfilesInterfaceClass;

GType                           syncdaemon_publicfiles_interface_get_type (void);

SyncdaemonPublicfilesInterface *syncdaemon_publicfiles_interface_new (SyncdaemonDaemon *daemon);

void                            syncdaemon_publicfiles_interface_change_public_access (SyncdaemonPublicfilesInterface *interface,
										       const gchar *share_id,
										       const gchar *node_id,
										       gboolean is_public);
GSList                         *syncdaemon_publicfiles_interface_get_public_files (SyncdaemonPublicfilesInterface *interface);

G_END_DECLS

#endif
