from urecovery import DataObj

class Partition(DataObj):
    """Partition Data Object"""
    #{{{attrdefs
    attrdefs = {'primary':True,
                'formate':True,
                'bootable':False,
                'pirority':-1,
                'min':0,
                'max':0,
                'fstype':None,
                'mountpoint':None}
    #}}}

    #{{{def check(self):
    def check(self):
        excepted_fstype = ['ext2', 'ext3', 'ext4', 'fat16', 'fat32', 'ntfs', 'swap']
        if self.fstype != 'swap':
            assert type(self.min) is int and type(self.max) is int
            assert (self.min >= 0 and self.max >= 0) and self.max >= self.min
        assert self.fstype in excepted_fstype, "excepted filesystem type is \
one of %s, but fstype is %s" % (','.join(excepted_fstype), self.fstype)
    #}}}

class Recipe(object):
    """Partman-auto Recepe Data Object """
    partitions = []

    #{{{def __init__(self, name):
    def __init__(self, name):
        self.name = name
        self.header =  "%s :: " % self.name
    #}}}

    #{{{def addPartition(self, partition):
    def addPartition(self, partition):
        partition.check()
        self.partitions.append(partition)
    #}}}

    #{{{def __repr__(self):
    def __repr__(self):
        return self.genStr()
    #}}}

    #{{{def genStr(self):
    def genStr(self):
        _str = [self.header]
        for p in self.partitions:
            _str.append(self.genPartitionEntry(p))
        return ' '.join(_str)
    #}}}

    #{{{def genPartitionEntry(self, p):
    def genPartitionEntry(self, p):
        if p.fstype == 'swap':
            _fstype = 'linux-' + p.fstype
        else:
            _fstype = p.fstype

        arr = ["%s %s %s %s" % (p.min, p.max, p.pirority, _fstype)]
        if p.primary:
            arr.append("$primary{ }")
        if p.bootable:
            arr.append("$bootable{ }")
        if p.formate:
            arr.append("method{ format } format{ }")
        arr.append("use_filesystem{ } filesystem{ %s }" % p.fstype)
        if p.mountpoint:
            arr.append("mountpoint{ %s }" % p.mountpoint)
        # endpoint
        arr.append('.')
        return ' '.join(arr)
    #}}}

    #{{{def saveTo(self, filename):
    def saveTo(self, filename):
        """save recipe

        @param str filename recipe file path
        """
        with open(filename, 'w') as f:
            f.write(self.genStr())
    #}}}
pass
