/*
 * Decompiled with CFR 0.152.
 */
package javax.servlet.jsp.jstl.tlv;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.jsp.tagext.PageData;
import javax.servlet.jsp.tagext.TagLibraryValidator;
import javax.servlet.jsp.tagext.ValidationMessage;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class PermittedTaglibsTLV
extends TagLibraryValidator {
    private final String PERMITTED_TAGLIBS_PARAM = "permittedTaglibs";
    private final String JSP_ROOT_URI = "http://java.sun.com/JSP/Page";
    private final String JSP_ROOT_NAME = "root";
    private final String JSP_ROOT_QN = "jsp:root";
    private Set permittedTaglibs;
    private boolean failed;
    private String uri;

    public PermittedTaglibsTLV() {
        this.init();
    }

    private void init() {
        this.permittedTaglibs = null;
    }

    public void release() {
        super.release();
        this.init();
    }

    public synchronized ValidationMessage[] validate(String string, String string2, PageData pageData) {
        try {
            this.uri = string2;
            this.permittedTaglibs = this.readConfiguration();
            PermittedTaglibsHandler permittedTaglibsHandler = new PermittedTaglibsHandler();
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setValidating(true);
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            sAXParser.parse(pageData.getInputStream(), (DefaultHandler)permittedTaglibsHandler);
            if (this.failed) {
                return this.vmFromString("taglib " + string + " (" + string2 + ") allows only the " + "following taglibs to be imported: " + this.permittedTaglibs);
            }
            return null;
        }
        catch (SAXException sAXException) {
            return this.vmFromString(sAXException.toString());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            return this.vmFromString(parserConfigurationException.toString());
        }
        catch (IOException iOException) {
            return this.vmFromString(iOException.toString());
        }
    }

    private Set readConfiguration() {
        HashSet<String> hashSet = new HashSet<String>();
        String string = (String)this.getInitParameters().get("permittedTaglibs");
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            hashSet.add(stringTokenizer.nextToken());
        }
        return hashSet;
    }

    private ValidationMessage[] vmFromString(String string) {
        return new ValidationMessage[]{new ValidationMessage(null, string)};
    }

    private class PermittedTaglibsHandler
    extends DefaultHandler {
        private PermittedTaglibsHandler() {
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) {
            if (!(string3.equals("jsp:root") || string.equals("http://java.sun.com/JSP/Page") && string2.equals("root"))) {
                return;
            }
            for (int i = 0; i < attributes.getLength(); ++i) {
                String string4;
                String string5 = attributes.getQName(i);
                if (!string5.startsWith("xmlns:") || string5.equals("xmlns:jsp") || (string4 = attributes.getValue(i)).equals(PermittedTaglibsTLV.this.uri) || PermittedTaglibsTLV.this.permittedTaglibs.contains(string4)) continue;
                PermittedTaglibsTLV.this.failed = true;
            }
        }
    }
}

