#ifdef NETIF_F_TSO
#define TG3_TSO_SUPPORT	1
#else
#define TG3_TSO_SUPPORT	0
#endif

#ifndef BCM_HAS_REQUEST_FIRMWARE

struct tg3_firmware {
	size_t size;
	const u8 *data;
};

#ifndef MODULE_FIRMWARE
#define MODULE_FIRMWARE(x)
#endif

#define TG3_FW_RELEASE_MAJOR	0x0
#define TG3_FW_RELASE_MINOR	0x0
#define TG3_FW_RELEASE_FIX	0x0
#define TG3_FW_START_ADDR	0x08000000
#define TG3_FW_TEXT_ADDR	0x08000000
#define TG3_FW_TEXT_LEN		0x9c0
#define TG3_FW_RODATA_ADDR	0x080009c0
#define TG3_FW_RODATA_LEN	0x60
#define TG3_FW_DATA_ADDR	0x08000a40
#define TG3_FW_DATA_LEN		0x20
#define TG3_FW_SBSS_ADDR	0x08000a60
#define TG3_FW_SBSS_LEN		0xc
#define TG3_FW_BSS_ADDR		0x08000a70
#define TG3_FW_BSS_LEN		0x10

#define TG3_5701_RLS_FW_LEN (TG3_FW_TEXT_LEN + TG3_FW_RODATA_LEN)

static const u32 tg3FwText[] = {
0x00000000, (u32)TG3_FW_TEXT_ADDR, (u32)TG3_5701_RLS_FW_LEN,
0x00000000, 0x10000003, 0x00000000, 0x0000000d,
0x0000000d, 0x3c1d0800, 0x37bd3ffc, 0x03a0f021,
0x3c100800, 0x26100000, 0x0e000018, 0x00000000,
0x0000000d, 0x3c1d0800, 0x37bd3ffc, 0x03a0f021,
0x3c100800, 0x26100034, 0x0e00021c, 0x00000000,
0x0000000d, 0x00000000, 0x00000000, 0x00000000,
0x27bdffe0, 0x3c1cc000, 0xafbf0018, 0xaf80680c,
0x0e00004c, 0x241b2105, 0x97850000, 0x97870002,
0x9782002c, 0x9783002e, 0x3c040800, 0x248409c0,
0xafa00014, 0x00021400, 0x00621825, 0x00052c00,
0xafa30010, 0x8f860010, 0x00e52825, 0x0e000060,
0x24070102, 0x3c02ac00, 0x34420100, 0x3c03ac01,
0x34630100, 0xaf820490, 0x3c02ffff, 0xaf820494,
0xaf830498, 0xaf82049c, 0x24020001, 0xaf825ce0,
0x0e00003f, 0xaf825d00, 0x0e000140, 0x00000000,
0x8fbf0018, 0x03e00008, 0x27bd0020, 0x2402ffff,
0xaf825404, 0x8f835400, 0x34630400, 0xaf835400,
0xaf825404, 0x3c020800, 0x24420034, 0xaf82541c,
0x03e00008, 0xaf805400, 0x00000000, 0x00000000,
0x3c020800, 0x34423000, 0x3c030800, 0x34633000,
0x3c040800, 0x348437ff, 0x3c010800, 0xac220a64,
0x24020040, 0x3c010800, 0xac220a68, 0x3c010800,
0xac200a60, 0xac600000, 0x24630004, 0x0083102b,
0x5040fffd, 0xac600000, 0x03e00008, 0x00000000,
0x00804821, 0x8faa0010, 0x3c020800, 0x8c420a60,
0x3c040800, 0x8c840a68, 0x8fab0014, 0x24430001,
0x0044102b, 0x3c010800, 0xac230a60, 0x14400003,
0x00004021, 0x3c010800, 0xac200a60, 0x3c020800,
0x8c420a60, 0x3c030800, 0x8c630a64, 0x91240000,
0x00021140, 0x00431021, 0x00481021, 0x25080001,
0xa0440000, 0x29020008, 0x1440fff4, 0x25290001,
0x3c020800, 0x8c420a60, 0x3c030800, 0x8c630a64,
0x8f84680c, 0x00021140, 0x00431021, 0xac440008,
0xac45000c, 0xac460010, 0xac470014, 0xac4a0018,
0x03e00008, 0xac4b001c, 0x00000000, 0x00000000,
0x00000000, 0x00000000, 0x00000000, 0x00000000,
0x00000000, 0x00000000, 0x00000000, 0x00000000,
0x00000000, 0x00000000, 0x00000000, 0x00000000,
0x00000000, 0x00000000, 0x00000000, 0x00000000,
0x00000000, 0x00000000, 0x00000000, 0x00000000,
0x00000000, 0x00000000, 0x00000000, 0x00000000,
0x00000000, 0x00000000, 0x00000000, 0x00000000,
0x00000000, 0x00000000, 0x00000000, 0x00000000,
0x00000000, 0x00000000, 0x00000000, 0x00000000,
0x00000000, 0x00000000, 0x00000000, 0x00000000,
0x00000000, 0x00000000, 0x00000000, 0x00000000,
0x00000000, 0x00000000, 0x00000000, 0x00000000,
0x00000000, 0x00000000, 0x00000000, 0x00000000,
0x02000008, 0x00000000, 0x0a0001e3, 0x3c0a0001,
0x0a0001e3, 0x3c0a0002, 0x0a0001e3, 0x00000000,
0x0a0001e3, 0x00000000, 0x0a0001e3, 0x00000000,
0x0a0001e3, 0x00000000, 0x0a0001e3, 0x00000000,
0x0a0001e3, 0x00000000, 0x0a0001e3, 0x00000000,
0x0a0001e3, 0x00000000, 0x0a0001e3, 0x00000000,
0x0a0001e3, 0x3c0a0007, 0x0a0001e3, 0x3c0a0008,
0x0a0001e3, 0x3c0a0009, 0x0a0001e3, 0x00000000,
0x0a0001e3, 0x00000000, 0x0a0001e3, 0x3c0a000b,
0x0a0001e3, 0x3c0a000c, 0x0a0001e3, 0x3c0a000d,
0x0a0001e3, 0x00000000, 0x0a0001e3, 0x00000000,
0x0a0001e3, 0x3c0a000e, 0x0a0001e3, 0x00000000,
0x0a0001e3, 0x00000000, 0x0a0001e3, 0x00000000,
0x0a0001e3, 0x00000000, 0x0a0001e3, 0x00000000,
0x0a0001e3, 0x00000000, 0x0a0001e3, 0x00000000,
0x0a0001e3, 0x00000000, 0x0a0001e3, 0x3c0a0013,
0x0a0001e3, 0x3c0a0014, 0x00000000, 0x00000000,
0x00000000, 0x00000000, 0x00000000, 0x00000000,
0x00000000, 0x00000000, 0x00000000, 0x00000000,
0x00000000, 0x00000000, 0x00000000, 0x00000000,
0x00000000, 0x00000000, 0x00000000, 0x00000000,
0x00000000, 0x00000000, 0x00000000, 0x00000000,
0x00000000, 0x00000000, 0x00000000, 0x00000000,
0x00000000, 0x00000000, 0x00000000, 0x00000000,
0x00000000, 0x00000000, 0x00000000, 0x00000000,
0x00000000, 0x00000000, 0x00000000, 0x00000000,
0x00000000, 0x00000000, 0x00000000, 0x00000000,
0x00000000, 0x00000000, 0x00000000, 0x00000000,
0x00000000, 0x00000000, 0x00000000, 0x00000000,
0x00000000, 0x00000000, 0x00000000, 0x00000000,
0x00000000, 0x00000000, 0x00000000, 0x00000000,
0x00000000, 0x00000000, 0x00000000, 0x00000000,
0x27bdffe0, 0x00001821, 0x00001021, 0xafbf0018,
0xafb10014, 0xafb00010, 0x3c010800, 0x00220821,
0xac200a70, 0x3c010800, 0x00220821, 0xac200a74,
0x3c010800, 0x00220821, 0xac200a78, 0x24630001,
0x1860fff5, 0x2442000c, 0x24110001, 0x8f906810,
0x32020004, 0x14400005, 0x24040001, 0x3c020800,
0x8c420a78, 0x18400003, 0x00002021, 0x0e000182,
0x00000000, 0x32020001, 0x10400003, 0x00000000,
0x0e000169, 0x00000000, 0x0a000153, 0xaf915028,
0x8fbf0018, 0x8fb10014, 0x8fb00010, 0x03e00008,
0x27bd0020, 0x3c050800, 0x8ca50a70, 0x3c060800,
0x8cc60a80, 0x3c070800, 0x8ce70a78, 0x27bdffe0,
0x3c040800, 0x248409d0, 0xafbf0018, 0xafa00010,
0x0e000060, 0xafa00014, 0x0e00017b, 0x00002021,
0x8fbf0018, 0x03e00008, 0x27bd0020, 0x24020001,
0x8f836810, 0x00821004, 0x00021027, 0x00621824,
0x03e00008, 0xaf836810, 0x27bdffd8, 0xafbf0024,
0x1080002e, 0xafb00020, 0x8f825cec, 0xafa20018,
0x8f825cec, 0x3c100800, 0x26100a78, 0xafa2001c,
0x34028000, 0xaf825cec, 0x8e020000, 0x18400016,
0x00000000, 0x3c020800, 0x94420a74, 0x8fa3001c,
0x000221c0, 0xac830004, 0x8fa2001c, 0x3c010800,
0x0e000201, 0xac220a74, 0x10400005, 0x00000000,
0x8e020000, 0x24420001, 0x0a0001df, 0xae020000,
0x3c020800, 0x8c420a70, 0x00021c02, 0x000321c0,
0x0a0001c5, 0xafa2001c, 0x0e000201, 0x00000000,
0x1040001f, 0x00000000, 0x8e020000, 0x8fa3001c,
0x24420001, 0x3c010800, 0xac230a70, 0x3c010800,
0xac230a74, 0x0a0001df, 0xae020000, 0x3c100800,
0x26100a78, 0x8e020000, 0x18400028, 0x00000000,
0x0e000201, 0x00000000, 0x14400024, 0x00000000,
0x8e020000, 0x3c030800, 0x8c630a70, 0x2442ffff,
0xafa3001c, 0x18400006, 0xae020000, 0x00031402,
0x000221c0, 0x8c820004, 0x3c010800, 0xac220a70,
0x97a2001e, 0x2442ff00, 0x2c420300, 0x1440000b,
0x24024000, 0x3c040800, 0x248409dc, 0xafa00010,
0xafa00014, 0x8fa6001c, 0x24050008, 0x0e000060,
0x00003821, 0x0a0001df, 0x00000000, 0xaf825cf8,
0x3c020800, 0x8c420a40, 0x8fa3001c, 0x24420001,
0xaf835cf8, 0x3c010800, 0xac220a40, 0x8fbf0024,
0x8fb00020, 0x03e00008, 0x27bd0028, 0x27bdffe0,
0x3c040800, 0x248409e8, 0x00002821, 0x00003021,
0x00003821, 0xafbf0018, 0xafa00010, 0x0e000060,
0xafa00014, 0x8fbf0018, 0x03e00008, 0x27bd0020,
0x8f82680c, 0x8f85680c, 0x00021827, 0x0003182b,
0x00031823, 0x00431024, 0x00441021, 0x00a2282b,
0x10a00006, 0x00000000, 0x00401821, 0x8f82680c,
0x0043102b, 0x1440fffd, 0x00000000, 0x03e00008,
0x00000000, 0x3c040800, 0x8c840000, 0x3c030800,
0x8c630a40, 0x0064102b, 0x54400002, 0x00831023,
0x00641023, 0x2c420008, 0x03e00008, 0x38420001,
0x27bdffe0, 0x00802821, 0x3c040800, 0x24840a00,
0x00003021, 0x00003821, 0xafbf0018, 0xafa00010,
0x0e000060, 0xafa00014, 0x0a000216, 0x00000000,
0x8fbf0018, 0x03e00008, 0x27bd0020, 0x00000000,
0x27bdffe0, 0x3c1cc000, 0xafbf0018, 0x0e00004c,
0xaf80680c, 0x3c040800, 0x24840a10, 0x03802821,
0x00003021, 0x00003821, 0xafa00010, 0x0e000060,
0xafa00014, 0x2402ffff, 0xaf825404, 0x3c0200aa,
0x0e000234, 0xaf825434, 0x8fbf0018, 0x03e00008,
0x27bd0020, 0x00000000, 0x00000000, 0x00000000,
0x27bdffe8, 0xafb00010, 0x24100001, 0xafbf0014,
0x3c01c003, 0xac200000, 0x8f826810, 0x30422000,
0x10400003, 0x00000000, 0x0e000246, 0x00000000,
0x0a00023a, 0xaf905428, 0x8fbf0014, 0x8fb00010,
0x03e00008, 0x27bd0018, 0x27bdfff8, 0x8f845d0c,
0x3c0200ff, 0x3c030800, 0x8c630a50, 0x3442fff8,
0x00821024, 0x1043001e, 0x3c0500ff, 0x34a5fff8,
0x3c06c003, 0x3c074000, 0x00851824, 0x8c620010,
0x3c010800, 0xac230a50, 0x30420008, 0x10400005,
0x00871025, 0x8cc20000, 0x24420001, 0xacc20000,
0x00871025, 0xaf825d0c, 0x8fa20000, 0x24420001,
0xafa20000, 0x8fa20000, 0x8fa20000, 0x24420001,
0xafa20000, 0x8fa20000, 0x8f845d0c, 0x3c030800,
0x8c630a50, 0x00851024, 0x1443ffe8, 0x00851824,
0x27bd0008, 0x03e00008, 0x00000000, 0x00000000,
0x35373031, 0x726c7341, 0x00000000, 0x00000000,
0x53774576, 0x656e7430, 0x00000000, 0x726c7045,
0x76656e74, 0x31000000, 0x556e6b6e, 0x45766e74,
0x00000000, 0x00000000, 0x00000000, 0x00000000,
0x66617461, 0x6c457272, 0x00000000, 0x00000000,
0x4d61696e, 0x43707542, 0x00000000, 0x00000000,
};

static const struct tg3_firmware tg3_5701_fw = {
	.size = TG3_5701_RLS_FW_LEN,
	.data = (u8 *)&tg3FwText[0],
};


#if TG3_TSO_SUPPORT != 0

#define TG3_TSO_FW_RELEASE_MAJOR	0x1
#define TG3_TSO_FW_RELASE_MINOR		0x6
#define TG3_TSO_FW_RELEASE_FIX		0x0
#define TG3_TSO_FW_START_ADDR		0x08000000
#define TG3_TSO_FW_TEXT_ADDR		0x08000000
#define TG3_TSO_FW_TEXT_LEN		0x1aa0
#define TG3_TSO_FW_RODATA_ADDR		0x08001aa0
#define TG3_TSO_FW_RODATA_LEN		0x60
#define TG3_TSO_FW_DATA_ADDR		0x08001b20
#define TG3_TSO_FW_DATA_LEN		0x30
#define TG3_TSO_FW_SBSS_ADDR		0x08001b50
#define TG3_TSO_FW_SBSS_LEN		0x2c
#define TG3_TSO_FW_BSS_ADDR		0x08001b80
#define TG3_TSO_FW_BSS_LEN		0x894

#define TG3_LGCY_TSO_FW_LEN \
        (TG3_TSO_FW_TEXT_LEN   + \
         TG3_TSO_FW_RODATA_LEN + \
         0x20                  + \
         TG3_TSO_FW_DATA_LEN)

static const u32 tg3TsoFwText[] = {
0x00010600, (u32)TG3_TSO_FW_TEXT_ADDR, (u32)TG3_LGCY_TSO_FW_LEN,
0x0e000003, 0x00000000, 0x08001b24, 0x00000000,
0x10000003, 0x00000000, 0x0000000d, 0x0000000d,
0x3c1d0800, 0x37bd4000, 0x03a0f021, 0x3c100800,
0x26100000, 0x0e000010, 0x00000000, 0x0000000d,
0x27bdffe0, 0x3c04fefe, 0xafbf0018, 0x0e0005d8,
0x34840002, 0x0e000668, 0x00000000, 0x3c030800,
0x90631b68, 0x24020002, 0x3c040800, 0x24841aac,
0x14620003, 0x24050001, 0x3c040800, 0x24841aa0,
0x24060006, 0x00003821, 0xafa00010, 0x0e00067c,
0xafa00014, 0x8f625c50, 0x34420001, 0xaf625c50,
0x8f625c90, 0x34420001, 0xaf625c90, 0x2402ffff,
0x0e000034, 0xaf625404, 0x8fbf0018, 0x03e00008,
0x27bd0020, 0x00000000, 0x00000000, 0x00000000,
0x27bdffe0, 0xafbf001c, 0xafb20018, 0xafb10014,
0x0e00005b, 0xafb00010, 0x24120002, 0x24110001,
0x8f706820, 0x32020100, 0x10400003, 0x00000000,
0x0e0000bb, 0x00000000, 0x8f706820, 0x32022000,
0x10400004, 0x32020001, 0x0e0001f0, 0x24040001,
0x32020001, 0x10400003, 0x00000000, 0x0e0000a3,
0x00000000, 0x3c020800, 0x90421b98, 0x14520003,
0x00000000, 0x0e0004c0, 0x00000000, 0x0a00003c,
0xaf715028, 0x8fbf001c, 0x8fb20018, 0x8fb10014,
0x8fb00010, 0x03e00008, 0x27bd0020, 0x27bdffe0,
0x3c040800, 0x24841ac0, 0x00002821, 0x00003021,
0x00003821, 0xafbf0018, 0xafa00010, 0x0e00067c,
0xafa00014, 0x3c040800, 0x248423d8, 0xa4800000,
0x3c010800, 0xa0201b98, 0x3c010800, 0xac201b9c,
0x3c010800, 0xac201ba0, 0x3c010800, 0xac201ba4,
0x3c010800, 0xac201bac, 0x3c010800, 0xac201bb8,
0x3c010800, 0xac201bbc, 0x8f624434, 0x3c010800,
0xac221b88, 0x8f624438, 0x3c010800, 0xac221b8c,
0x8f624410, 0xac80f7a8, 0x3c010800, 0xac201b84,
0x3c010800, 0xac2023e0, 0x3c010800, 0xac2023c8,
0x3c010800, 0xac2023cc, 0x3c010800, 0xac202400,
0x3c010800, 0xac221b90, 0x8f620068, 0x24030007,
0x00021702, 0x10430005, 0x00000000, 0x8f620068,
0x00021702, 0x14400004, 0x24020001, 0x3c010800,
0x0a000097, 0xac20240c, 0xac820034, 0x3c040800,
0x24841acc, 0x3c050800, 0x8ca5240c, 0x00003021,
0x00003821, 0xafa00010, 0x0e00067c, 0xafa00014,
0x8fbf0018, 0x03e00008, 0x27bd0020, 0x27bdffe0,
0x3c040800, 0x24841ad8, 0x00002821, 0x00003021,
0x00003821, 0xafbf0018, 0xafa00010, 0x0e00067c,
0xafa00014, 0x0e00005b, 0x00000000, 0x0e0000b4,
0x00002021, 0x8fbf0018, 0x03e00008, 0x27bd0020,
0x24020001, 0x8f636820, 0x00821004, 0x00021027,
0x00621824, 0x03e00008, 0xaf636820, 0x27bdffd0,
0xafbf002c, 0xafb60028, 0xafb50024, 0xafb40020,
0xafb3001c, 0xafb20018, 0xafb10014, 0xafb00010,
0x8f675c5c, 0x3c030800, 0x24631bbc, 0x8c620000,
0x14470005, 0x3c0200ff, 0x3c020800, 0x90421b98,
0x14400119, 0x3c0200ff, 0x3442fff8, 0x00e28824,
0xac670000, 0x00111902, 0x306300ff, 0x30e20003,
0x000211c0, 0x00622825, 0x00a04021, 0x00071602,
0x3c030800, 0x90631b98, 0x3044000f, 0x14600036,
0x00804821, 0x24020001, 0x3c010800, 0xa0221b98,
0x00051100, 0x00821025, 0x3c010800, 0xac201b9c,
0x3c010800, 0xac201ba0, 0x3c010800, 0xac201ba4,
0x3c010800, 0xac201bac, 0x3c010800, 0xac201bb8,
0x3c010800, 0xac201bb0, 0x3c010800, 0xac201bb4,
0x3c010800, 0xa42223d8, 0x9622000c, 0x30437fff,
0x3c010800, 0xa4222410, 0x30428000, 0x3c010800,
0xa4231bc6, 0x10400005, 0x24020001, 0x3c010800,
0xac2223f4, 0x0a000102, 0x2406003e, 0x24060036,
0x3c010800, 0xac2023f4, 0x9622000a, 0x3c030800,
0x94631bc6, 0x3c010800, 0xac2023f0, 0x3c010800,
0xac2023f8, 0x00021302, 0x00021080, 0x00c21021,
0x00621821, 0x3c010800, 0xa42223d0, 0x3c010800,
0x0a000115, 0xa4231b96, 0x9622000c, 0x3c010800,
0xa42223ec, 0x3c040800, 0x24841b9c, 0x8c820000,
0x00021100, 0x3c010800, 0x00220821, 0xac311bc8,
0x8c820000, 0x00021100, 0x3c010800, 0x00220821,
0xac271bcc, 0x8c820000, 0x25030001, 0x306601ff,
0x00021100, 0x3c010800, 0x00220821, 0xac261bd0,
0x8c820000, 0x00021100, 0x3c010800, 0x00220821,
0xac291bd4, 0x96230008, 0x3c020800, 0x8c421bac,
0x00432821, 0x3c010800, 0xac251bac, 0x9622000a,
0x30420004, 0x14400018, 0x00061100, 0x8f630c14,
0x3063000f, 0x2c620002, 0x1440000b, 0x3c02c000,
0x8f630c14, 0x3c020800, 0x8c421b40, 0x3063000f,
0x24420001, 0x3c010800, 0xac221b40, 0x2c620002,
0x1040fff7, 0x3c02c000, 0x00e21825, 0xaf635c5c,
0x8f625c50, 0x30420002, 0x10400014, 0x00000000,
0x0a000147, 0x00000000, 0x3c030800, 0x8c631b80,
0x3c040800, 0x94841b94, 0x01221025, 0x3c010800,
0xa42223da, 0x24020001, 0x3c010800, 0xac221bb8,
0x24630001, 0x0085202a, 0x3c010800, 0x10800003,
0xac231b80, 0x3c010800, 0xa4251b94, 0x3c060800,
0x24c61b9c, 0x8cc20000, 0x24420001, 0xacc20000,
0x28420080, 0x14400005, 0x00000000, 0x0e000656,
0x24040002, 0x0a0001e6, 0x00000000, 0x3c020800,
0x8c421bb8, 0x10400078, 0x24020001, 0x3c050800,
0x90a51b98, 0x14a20072, 0x00000000, 0x3c150800,
0x96b51b96, 0x3c040800, 0x8c841bac, 0x32a3ffff,
0x0083102a, 0x1440006c, 0x00000000, 0x14830003,
0x00000000, 0x3c010800, 0xac2523f0, 0x1060005c,
0x00009021, 0x24d60004, 0x0060a021, 0x24d30014,
0x8ec20000, 0x00028100, 0x3c110800, 0x02308821,
0x0e000625, 0x8e311bc8, 0x00402821, 0x10a00054,
0x00000000, 0x9628000a, 0x31020040, 0x10400005,
0x2407180c, 0x8e22000c, 0x2407188c, 0x00021400,
0xaca20018, 0x3c030800, 0x00701821, 0x8c631bd0,
0x3c020800, 0x00501021, 0x8c421bd4, 0x00031d00,
0x00021400, 0x00621825, 0xaca30014, 0x8ec30004,
0x96220008, 0x00432023, 0x3242ffff, 0x3083ffff,
0x00431021, 0x0282102a, 0x14400002, 0x02b23023,
0x00803021, 0x8e620000, 0x30c4ffff, 0x00441021,
0xae620000, 0x8e220000, 0xaca20000, 0x8e220004,
0x8e63fff4, 0x00431021, 0xaca20004, 0xa4a6000e,
0x8e62fff4, 0x00441021, 0xae62fff4, 0x96230008,
0x0043102a, 0x14400005, 0x02469021, 0x8e62fff0,
0xae60fff4, 0x24420001, 0xae62fff0, 0xaca00008,
0x3242ffff, 0x14540008, 0x24020305, 0x31020080,
0x54400001, 0x34e70010, 0x24020905, 0xa4a2000c,
0x0a0001cb, 0x34e70020, 0xa4a2000c, 0x3c020800,
0x8c4223f0, 0x10400003, 0x3c024b65, 0x0a0001d3,
0x34427654, 0x3c02b49a, 0x344289ab, 0xaca2001c,
0x30e2ffff, 0xaca20010, 0x0e0005a2, 0x00a02021,
0x3242ffff, 0x0054102b, 0x1440ffa9, 0x00000000,
0x24020002, 0x3c010800, 0x0a0001e6, 0xa0221b98,
0x8ec2083c, 0x24420001, 0x0a0001e6, 0xaec2083c,
0x0e0004c0, 0x00000000, 0x8fbf002c, 0x8fb60028,
0x8fb50024, 0x8fb40020, 0x8fb3001c, 0x8fb20018,
0x8fb10014, 0x8fb00010, 0x03e00008, 0x27bd0030,
0x27bdffd0, 0xafbf0028, 0xafb30024, 0xafb20020,
0xafb1001c, 0xafb00018, 0x8f725c9c, 0x3c0200ff,
0x3442fff8, 0x3c070800, 0x24e71bb4, 0x02428824,
0x9623000e, 0x8ce20000, 0x00431021, 0xace20000,
0x8e220010, 0x30420020, 0x14400011, 0x00809821,
0x0e00063b, 0x02202021, 0x3c02c000, 0x02421825,
0xaf635c9c, 0x8f625c90, 0x30420002, 0x1040011e,
0x00000000, 0xaf635c9c, 0x8f625c90, 0x30420002,
0x10400119, 0x00000000, 0x0a00020d, 0x00000000,
0x8e240008, 0x8e230014, 0x00041402, 0x000231c0,
0x00031502, 0x304201ff, 0x2442ffff, 0x3042007f,
0x00031942, 0x30637800, 0x00021100, 0x24424000,
0x00624821, 0x9522000a, 0x3084ffff, 0x30420008,
0x104000b0, 0x000429c0, 0x3c020800, 0x8c422400,
0x14400024, 0x24c50008, 0x94c20014, 0x3c010800,
0xa42223d0, 0x8cc40010, 0x00041402, 0x3c010800,
0xa42223d2, 0x3c010800, 0xa42423d4, 0x94c2000e,
0x3083ffff, 0x00431023, 0x3c010800, 0xac222408,
0x94c2001a, 0x3c010800, 0xac262400, 0x3c010800,
0xac322404, 0x3c010800, 0xac2223fc, 0x3c02c000,
0x02421825, 0xaf635c9c, 0x8f625c90, 0x30420002,
0x104000e5, 0x00000000, 0xaf635c9c, 0x8f625c90,
0x30420002, 0x104000e0, 0x00000000, 0x0a000246,
0x00000000, 0x94c2000e, 0x3c030800, 0x946323d4,
0x00434023, 0x3103ffff, 0x2c620008, 0x1040001c,
0x00000000, 0x94c20014, 0x24420028, 0x00a22821,
0x00031042, 0x1840000b, 0x00002021, 0x24e60848,
0x00403821, 0x94a30000, 0x8cc20000, 0x24840001,
0x00431021, 0xacc20000, 0x0087102a, 0x1440fff9,
0x24a50002, 0x31020001, 0x1040001f, 0x3c024000,
0x3c040800, 0x248423fc, 0xa0a00001, 0x94a30000,
0x8c820000, 0x00431021, 0x0a000285, 0xac820000,
0x8f626800, 0x3c030010, 0x00431024, 0x10400009,
0x00000000, 0x94c2001a, 0x3c030800, 0x8c6323fc,
0x00431021, 0x3c010800, 0xac2223fc, 0x0a000286,
0x3c024000, 0x94c2001a, 0x94c4001c, 0x3c030800,
0x8c6323fc, 0x00441023, 0x00621821, 0x3c010800,
0xac2323fc, 0x3c024000, 0x02421825, 0xaf635c9c,
0x8f625c90, 0x30420002, 0x1440fffc, 0x00000000,
0x9522000a, 0x30420010, 0x1040009b, 0x00000000,
0x3c030800, 0x946323d4, 0x3c070800, 0x24e72400,
0x8ce40000, 0x8f626800, 0x24630030, 0x00832821,
0x3c030010, 0x00431024, 0x1440000a, 0x00000000,
0x94a20004, 0x3c040800, 0x8c842408, 0x3c030800,
0x8c6323fc, 0x00441023, 0x00621821, 0x3c010800,
0xac2323fc, 0x3c040800, 0x8c8423fc, 0x00041c02,
0x3082ffff, 0x00622021, 0x00041402, 0x00822021,
0x00041027, 0xa4a20006, 0x3c030800, 0x8c632404,
0x3c0200ff, 0x3442fff8, 0x00628824, 0x96220008,
0x24050001, 0x24034000, 0x000231c0, 0x00801021,
0xa4c2001a, 0xa4c0001c, 0xace00000, 0x3c010800,
0xac251b60, 0xaf635cb8, 0x8f625cb0, 0x30420002,
0x10400003, 0x00000000, 0x3c010800, 0xac201b60,
0x8e220008, 0xaf625cb8, 0x8f625cb0, 0x30420002,
0x10400003, 0x00000000, 0x3c010800, 0xac201b60,
0x3c020800, 0x8c421b60, 0x1040ffec, 0x00000000,
0x3c040800, 0x0e00063b, 0x8c842404, 0x0a00032a,
0x00000000, 0x3c030800, 0x90631b98, 0x24020002,
0x14620003, 0x3c034b65, 0x0a0002e1, 0x00008021,
0x8e22001c, 0x34637654, 0x10430002, 0x24100002,
0x24100001, 0x00c02021, 0x0e000350, 0x02003021,
0x24020003, 0x3c010800, 0xa0221b98, 0x24020002,
0x1202000a, 0x24020001, 0x3c030800, 0x8c6323f0,
0x10620006, 0x00000000, 0x3c020800, 0x944223d8,
0x00021400, 0x0a00031f, 0xae220014, 0x3c040800,
0x248423da, 0x94820000, 0x00021400, 0xae220014,
0x3c020800, 0x8c421bbc, 0x3c03c000, 0x3c010800,
0xa0201b98, 0x00431025, 0xaf625c5c, 0x8f625c50,
0x30420002, 0x10400009, 0x00000000, 0x2484f7e2,
0x8c820000, 0x00431025, 0xaf625c5c, 0x8f625c50,
0x30420002, 0x1440fffa, 0x00000000, 0x3c020800,
0x24421b84, 0x8c430000, 0x24630001, 0xac430000,
0x8f630c14, 0x3063000f, 0x2c620002, 0x1440000c,
0x3c024000, 0x8f630c14, 0x3c020800, 0x8c421b40,
0x3063000f, 0x24420001, 0x3c010800, 0xac221b40,
0x2c620002, 0x1040fff7, 0x00000000, 0x3c024000,
0x02421825, 0xaf635c9c, 0x8f625c90, 0x30420002,
0x1440fffc, 0x00000000, 0x12600003, 0x00000000,
0x0e0004c0, 0x00000000, 0x8fbf0028, 0x8fb30024,
0x8fb20020, 0x8fb1001c, 0x8fb00018, 0x03e00008,
0x27bd0030, 0x8f634450, 0x3c040800, 0x24841b88,
0x8c820000, 0x00031c02, 0x0043102b, 0x14400007,
0x3c038000, 0x8c840004, 0x8f624450, 0x00021c02,
0x0083102b, 0x1040fffc, 0x3c038000, 0xaf634444,
0x8f624444, 0x00431024, 0x1440fffd, 0x00000000,
0x8f624448, 0x03e00008, 0x3042ffff, 0x3c024000,
0x00822025, 0xaf645c38, 0x8f625c30, 0x30420002,
0x1440fffc, 0x00000000, 0x03e00008, 0x00000000,
0x27bdffe0, 0x00805821, 0x14c00011, 0x256e0008,
0x3c020800, 0x8c4223f4, 0x10400007, 0x24020016,
0x3c010800, 0xa42223d2, 0x2402002a, 0x3c010800,
0x0a000364, 0xa42223d4, 0x8d670010, 0x00071402,
0x3c010800, 0xa42223d2, 0x3c010800, 0xa42723d4,
0x3c040800, 0x948423d4, 0x3c030800, 0x946323d2,
0x95cf0006, 0x3c020800, 0x944223d0, 0x00832023,
0x01e2c023, 0x3065ffff, 0x24a20028, 0x01c24821,
0x3082ffff, 0x14c0001a, 0x01226021, 0x9582000c,
0x3042003f, 0x3c010800, 0xa42223d6, 0x95820004,
0x95830006, 0x3c010800, 0xac2023e4, 0x3c010800,
0xac2023e8, 0x00021400, 0x00431025, 0x3c010800,
0xac221bc0, 0x95220004, 0x3c010800, 0xa4221bc4,
0x95230002, 0x01e51023, 0x0043102a, 0x10400010,
0x24020001, 0x3c010800, 0x0a000398, 0xac2223f8,
0x3c030800, 0x8c6323e8, 0x3c020800, 0x94421bc4,
0x00431021, 0xa5220004, 0x3c020800, 0x94421bc0,
0xa5820004, 0x3c020800, 0x8c421bc0, 0xa5820006,
0x3c020800, 0x8c4223f0, 0x3c0d0800, 0x8dad23e4,
0x3c0a0800, 0x144000e5, 0x8d4a23e8, 0x3c020800,
0x94421bc4, 0x004a1821, 0x3063ffff, 0x0062182b,
0x24020002, 0x10c2000d, 0x01435023, 0x3c020800,
0x944223d6, 0x30420009, 0x10400008, 0x00000000,
0x9582000c, 0x3042fff6, 0xa582000c, 0x3c020800,
0x944223d6, 0x30420009, 0x01a26823, 0x3c020800,
0x8c4223f8, 0x1040004a, 0x01203821, 0x3c020800,
0x944223d2, 0x00004021, 0xa520000a, 0x01e21023,
0xa5220002, 0x3082ffff, 0x00021042, 0x18400008,
0x00003021, 0x00401821, 0x94e20000, 0x25080001,
0x00c23021, 0x0103102a, 0x1440fffb, 0x24e70002,
0x00061c02, 0x30c2ffff, 0x00623021, 0x00061402,
0x00c23021, 0x00c02821, 0x00061027, 0xa522000a,
0x00003021, 0x2527000c, 0x00004021, 0x94e20000,
0x25080001, 0x00c23021, 0x2d020004, 0x1440fffb,
0x24e70002, 0x95220002, 0x00004021, 0x91230009,
0x00442023, 0x01803821, 0x3082ffff, 0xa4e00010,
0x00621821, 0x00021042, 0x18400010, 0x00c33021,
0x00404821, 0x94e20000, 0x24e70002, 0x00c23021,
0x30e2007f, 0x14400006, 0x25080001, 0x8d630000,
0x3c02007f, 0x3442ff80, 0x00625824, 0x25670008,
0x0109102a, 0x1440fff3, 0x00000000, 0x30820001,
0x10400005, 0x00061c02, 0xa0e00001, 0x94e20000,
0x00c23021, 0x00061c02, 0x30c2ffff, 0x00623021,
0x00061402, 0x00c23021, 0x0a00047d, 0x30c6ffff,
0x24020002, 0x14c20081, 0x00000000, 0x3c020800,
0x8c42240c, 0x14400007, 0x00000000, 0x3c020800,
0x944223d2, 0x95230002, 0x01e21023, 0x10620077,
0x00000000, 0x3c020800, 0x944223d2, 0x01e21023,
0xa5220002, 0x3c020800, 0x8c42240c, 0x1040001a,
0x31e3ffff, 0x8dc70010, 0x3c020800, 0x94421b96,
0x00e04021, 0x00072c02, 0x00aa2021, 0x00431023,
0x00823823, 0x00072402, 0x30e2ffff, 0x00823821,
0x00071027, 0xa522000a, 0x3102ffff, 0x3c040800,
0x948423d4, 0x00453023, 0x00e02821, 0x00641823,
0x006d1821, 0x00c33021, 0x00061c02, 0x30c2ffff,
0x0a00047d, 0x00623021, 0x01203821, 0x00004021,
0x3082ffff, 0x00021042, 0x18400008, 0x00003021,
0x00401821, 0x94e20000, 0x25080001, 0x00c23021,
0x0103102a, 0x1440fffb, 0x24e70002, 0x00061c02,
0x30c2ffff, 0x00623021, 0x00061402, 0x00c23021,
0x00c02821, 0x00061027, 0xa522000a, 0x00003021,
0x2527000c, 0x00004021, 0x94e20000, 0x25080001,
0x00c23021, 0x2d020004, 0x1440fffb, 0x24e70002,
0x95220002, 0x00004021, 0x91230009, 0x00442023,
0x01803821, 0x3082ffff, 0xa4e00010, 0x3c040800,
0x948423d4, 0x00621821, 0x00c33021, 0x00061c02,
0x30c2ffff, 0x00623021, 0x00061c02, 0x3c020800,
0x944223d0, 0x00c34821, 0x00441023, 0x00021fc2,
0x00431021, 0x00021043, 0x18400010, 0x00003021,
0x00402021, 0x94e20000, 0x24e70002, 0x00c23021,
0x30e2007f, 0x14400006, 0x25080001, 0x8d630000,
0x3c02007f, 0x3442ff80, 0x00625824, 0x25670008,
0x0104102a, 0x1440fff3, 0x00000000, 0x3c020800,
0x944223ec, 0x00c23021, 0x3122ffff, 0x00c23021,
0x00061c02, 0x30c2ffff, 0x00623021, 0x00061402,
0x00c23021, 0x00c04021, 0x00061027, 0xa5820010,
0xadc00014, 0x0a00049d, 0xadc00000, 0x8dc70010,
0x00e04021, 0x11400007, 0x00072c02, 0x00aa3021,
0x00061402, 0x30c3ffff, 0x00433021, 0x00061402,
0x00c22821, 0x00051027, 0xa522000a, 0x3c030800,
0x946323d4, 0x3102ffff, 0x01e21021, 0x00433023,
0x00cd3021, 0x00061c02, 0x30c2ffff, 0x00623021,
0x00061402, 0x00c23021, 0x00c04021, 0x00061027,
0xa5820010, 0x3102ffff, 0x00051c00, 0x00431025,
0xadc20010, 0x3c020800, 0x8c4223f4, 0x10400005,
0x2de205eb, 0x14400002, 0x25e2fff2, 0x34028870,
0xa5c20034, 0x3c030800, 0x246323e8, 0x8c620000,
0x24420001, 0xac620000, 0x3c040800, 0x8c8423e4,
0x3c020800, 0x8c421bc0, 0x3303ffff, 0x00832021,
0x00431821, 0x0062102b, 0x3c010800, 0xac2423e4,
0x10400003, 0x2482ffff, 0x3c010800, 0xac2223e4,
0x3c010800, 0xac231bc0, 0x03e00008, 0x27bd0020,
0x27bdffb8, 0x3c050800, 0x24a51b96, 0xafbf0044,
0xafbe0040, 0xafb7003c, 0xafb60038, 0xafb50034,
0xafb40030, 0xafb3002c, 0xafb20028, 0xafb10024,
0xafb00020, 0x94a90000, 0x3c020800, 0x944223d0,
0x3c030800, 0x8c631bb0, 0x3c040800, 0x8c841bac,
0x01221023, 0x0064182a, 0xa7a9001e, 0x106000be,
0xa7a20016, 0x24be0022, 0x97b6001e, 0x24b3001a,
0x24b70016, 0x8fc20000, 0x14400008, 0x00000000,
0x8fc2fff8, 0x97a30016, 0x8fc4fff4, 0x00431021,
0x0082202a, 0x148000b0, 0x00000000, 0x97d50818,
0x32a2ffff, 0x104000a3, 0x00009021, 0x0040a021,
0x00008821, 0x0e000625, 0x00000000, 0x00403021,
0x14c00007, 0x00000000, 0x3c020800, 0x8c4223dc,
0x24420001, 0x3c010800, 0x0a000596, 0xac2223dc,
0x3c100800, 0x02118021, 0x8e101bc8, 0x9608000a,
0x31020040, 0x10400005, 0x2407180c, 0x8e02000c,
0x2407188c, 0x00021400, 0xacc20018, 0x31020080,
0x54400001, 0x34e70010, 0x3c020800, 0x00511021,
0x8c421bd0, 0x3c030800, 0x00711821, 0x8c631bd4,
0x00021500, 0x00031c00, 0x00431025, 0xacc20014,
0x96040008, 0x3242ffff, 0x00821021, 0x0282102a,
0x14400002, 0x02b22823, 0x00802821, 0x8e020000,
0x02459021, 0xacc20000, 0x8e020004, 0x00c02021,
0x26310010, 0xac820004, 0x30e2ffff, 0xac800008,
0xa485000e, 0xac820010, 0x24020305, 0x0e0005a2,
0xa482000c, 0x3242ffff, 0x0054102b, 0x1440ffc5,
0x3242ffff, 0x0a00058e, 0x00000000, 0x8e620000,
0x8e63fffc, 0x0043102a, 0x10400067, 0x00000000,
0x8e62fff0, 0x00028900, 0x3c100800, 0x02118021,
0x0e000625, 0x8e101bc8, 0x00403021, 0x14c00005,
0x00000000, 0x8e62082c, 0x24420001, 0x0a000596,
0xae62082c, 0x9608000a, 0x31020040, 0x10400005,
0x2407180c, 0x8e02000c, 0x2407188c, 0x00021400,
0xacc20018, 0x3c020800, 0x00511021, 0x8c421bd0,
0x3c030800, 0x00711821, 0x8c631bd4, 0x00021500,
0x00031c00, 0x00431025, 0xacc20014, 0x8e63fff4,
0x96020008, 0x00432023, 0x3242ffff, 0x3083ffff,
0x00431021, 0x02c2102a, 0x10400003, 0x00802821,
0x97a9001e, 0x01322823, 0x8e620000, 0x30a4ffff,
0x00441021, 0xae620000, 0xa4c5000e, 0x8e020000,
0xacc20000, 0x8e020004, 0x8e63fff4, 0x00431021,
0xacc20004, 0x8e63fff4, 0x96020008, 0x00641821,
0x0062102a, 0x14400006, 0x02459021, 0x8e62fff0,
0xae60fff4, 0x24420001, 0x0a000571, 0xae62fff0,
0xae63fff4, 0xacc00008, 0x3242ffff, 0x10560003,
0x31020004, 0x10400006, 0x24020305, 0x31020080,
0x54400001, 0x34e70010, 0x34e70020, 0x24020905,
0xa4c2000c, 0x8ee30000, 0x8ee20004, 0x14620007,
0x3c02b49a, 0x8ee20860, 0x54400001, 0x34e70400,
0x3c024b65, 0x0a000588, 0x34427654, 0x344289ab,
0xacc2001c, 0x30e2ffff, 0xacc20010, 0x0e0005a2,
0x00c02021, 0x3242ffff, 0x0056102b, 0x1440ff9b,
0x00000000, 0x8e620000, 0x8e63fffc, 0x0043102a,
0x1440ff48, 0x00000000, 0x8fbf0044, 0x8fbe0040,
0x8fb7003c, 0x8fb60038, 0x8fb50034, 0x8fb40030,
0x8fb3002c, 0x8fb20028, 0x8fb10024, 0x8fb00020,
0x03e00008, 0x27bd0048, 0x27bdffe8, 0xafbf0014,
0xafb00010, 0x8f624450, 0x8f634410, 0x0a0005b1,
0x00808021, 0x8f626820, 0x30422000, 0x10400003,
0x00000000, 0x0e0001f0, 0x00002021, 0x8f624450,
0x8f634410, 0x3042ffff, 0x0043102b, 0x1440fff5,
0x00000000, 0x8f630c14, 0x3063000f, 0x2c620002,
0x1440000b, 0x00000000, 0x8f630c14, 0x3c020800,
0x8c421b40, 0x3063000f, 0x24420001, 0x3c010800,
0xac221b40, 0x2c620002, 0x1040fff7, 0x00000000,
0xaf705c18, 0x8f625c10, 0x30420002, 0x10400009,
0x00000000, 0x8f626820, 0x30422000, 0x1040fff8,
0x00000000, 0x0e0001f0, 0x00002021, 0x0a0005c4,
0x00000000, 0x8fbf0014, 0x8fb00010, 0x03e00008,
0x27bd0018, 0x00000000, 0x00000000, 0x00000000,
0x27bdffe8, 0x3c1bc000, 0xafbf0014, 0xafb00010,
0xaf60680c, 0x8f626804, 0x34420082, 0xaf626804,
0x8f634000, 0x24020b50, 0x3c010800, 0xac221b54,
0x24020b78, 0x3c010800, 0xac221b64, 0x34630002,
0xaf634000, 0x0e000605, 0x00808021, 0x3c010800,
0xa0221b68, 0x304200ff, 0x24030002, 0x14430005,
0x00000000, 0x3c020800, 0x8c421b54, 0x0a0005f8,
0xac5000c0, 0x3c020800, 0x8c421b54, 0xac5000bc,
0x8f624434, 0x8f634438, 0x8f644410, 0x3c010800,
0xac221b5c, 0x3c010800, 0xac231b6c, 0x3c010800,
0xac241b58, 0x8fbf0014, 0x8fb00010, 0x03e00008,
0x27bd0018, 0x3c040800, 0x8c870000, 0x3c03aa55,
0x3463aa55, 0x3c06c003, 0xac830000, 0x8cc20000,
0x14430007, 0x24050002, 0x3c0355aa, 0x346355aa,
0xac830000, 0x8cc20000, 0x50430001, 0x24050001,
0x3c020800, 0xac470000, 0x03e00008, 0x00a01021,
0x27bdfff8, 0x18800009, 0x00002821, 0x8f63680c,
0x8f62680c, 0x1043fffe, 0x00000000, 0x24a50001,
0x00a4102a, 0x1440fff9, 0x00000000, 0x03e00008,
0x27bd0008, 0x8f634450, 0x3c020800, 0x8c421b5c,
0x00031c02, 0x0043102b, 0x14400008, 0x3c038000,
0x3c040800, 0x8c841b6c, 0x8f624450, 0x00021c02,
0x0083102b, 0x1040fffc, 0x3c038000, 0xaf634444,
0x8f624444, 0x00431024, 0x1440fffd, 0x00000000,
0x8f624448, 0x03e00008, 0x3042ffff, 0x3082ffff,
0x2442e000, 0x2c422001, 0x14400003, 0x3c024000,
0x0a000648, 0x2402ffff, 0x00822025, 0xaf645c38,
0x8f625c30, 0x30420002, 0x1440fffc, 0x00001021,
0x03e00008, 0x00000000, 0x8f624450, 0x3c030800,
0x8c631b58, 0x0a000651, 0x3042ffff, 0x8f624450,
0x3042ffff, 0x0043102b, 0x1440fffc, 0x00000000,
0x03e00008, 0x00000000, 0x27bdffe0, 0x00802821,
0x3c040800, 0x24841af0, 0x00003021, 0x00003821,
0xafbf0018, 0xafa00010, 0x0e00067c, 0xafa00014,
0x0a000660, 0x00000000, 0x8fbf0018, 0x03e00008,
0x27bd0020, 0x00000000, 0x00000000, 0x00000000,
0x3c020800, 0x34423000, 0x3c030800, 0x34633000,
0x3c040800, 0x348437ff, 0x3c010800, 0xac221b74,
0x24020040, 0x3c010800, 0xac221b78, 0x3c010800,
0xac201b70, 0xac600000, 0x24630004, 0x0083102b,
0x5040fffd, 0xac600000, 0x03e00008, 0x00000000,
0x00804821, 0x8faa0010, 0x3c020800, 0x8c421b70,
0x3c040800, 0x8c841b78, 0x8fab0014, 0x24430001,
0x0044102b, 0x3c010800, 0xac231b70, 0x14400003,
0x00004021, 0x3c010800, 0xac201b70, 0x3c020800,
0x8c421b70, 0x3c030800, 0x8c631b74, 0x91240000,
0x00021140, 0x00431021, 0x00481021, 0x25080001,
0xa0440000, 0x29020008, 0x1440fff4, 0x25290001,
0x3c020800, 0x8c421b70, 0x3c030800, 0x8c631b74,
0x8f64680c, 0x00021140, 0x00431021, 0xac440008,
0xac45000c, 0xac460010, 0xac470014, 0xac4a0018,
0x03e00008, 0xac4b001c, 0x00000000, 0x00000000,
0x4d61696e, 0x43707542, 0x00000000, 0x4d61696e,
0x43707541, 0x00000000, 0x00000000, 0x00000000,
0x73746b6f, 0x66666c64, 0x496e0000, 0x73746b6f,
0x66662a2a, 0x00000000, 0x53774576, 0x656e7430,
0x00000000, 0x00000000, 0x00000000, 0x00000000,
0x66617461, 0x6c457272, 0x00000000, 0x00000000,
0x00000000, 0x00000000, 0x00000000, 0x00000000,
0x00000000, 0x00000000, 0x00000000, 0x00000000,
0x00000000, 0x73746b6f, 0x66666c64, 0x5f76312e,
0x362e3000, 0x00000000, 0x00000000, 0x00000000,
0x00000000, 0x00000000, 0x00000000, 0x00000000,
};

static const struct tg3_firmware tg3_lgcy_tso_fw = {
	.size = TG3_LGCY_TSO_FW_LEN,
	.data = (u8 *)&tg3TsoFwText[0],
};

/* 5705 needs a special version of the TSO firmware.  */
#define TG3_TSO5_FW_RELEASE_MAJOR	0x1
#define TG3_TSO5_FW_RELASE_MINOR	0x2
#define TG3_TSO5_FW_RELEASE_FIX		0x0
#define TG3_TSO5_FW_START_ADDR		0x00010000
#define TG3_TSO5_FW_TEXT_ADDR		0x00010000
#define TG3_TSO5_FW_TEXT_LEN		0xe90
#define TG3_TSO5_FW_RODATA_ADDR		0x00010e90
#define TG3_TSO5_FW_RODATA_LEN		0x50
#define TG3_TSO5_FW_DATA_ADDR		0x00010f00
#define TG3_TSO5_FW_DATA_LEN		0x20
#define TG3_TSO5_FW_SBSS_ADDR		0x00010f20
#define TG3_TSO5_FW_SBSS_LEN		0x28
#define TG3_TSO5_FW_BSS_ADDR		0x00010f50
#define TG3_TSO5_FW_BSS_LEN		0x88

#define TG3_5705_TSO_FW_LEN \
        (TG3_TSO5_FW_TEXT_LEN   + \
         TG3_TSO5_FW_RODATA_LEN + \
         0x20                  + \
         TG3_TSO5_FW_DATA_LEN)

static const u32 tg3Tso5FwText[] = {
0x00010200, (u32)TG3_TSO5_FW_TEXT_ADDR, (u32)TG3_5705_TSO_FW_LEN,
0x0c004003, 0x00000000, 0x00010f04, 0x00000000,
0x10000003, 0x00000000, 0x0000000d, 0x0000000d,
0x3c1d0001, 0x37bde000, 0x03a0f021, 0x3c100001,
0x26100000, 0x0c004010, 0x00000000, 0x0000000d,
0x27bdffe0, 0x3c04fefe, 0xafbf0018, 0x0c0042e8,
0x34840002, 0x0c004364, 0x00000000, 0x3c030001,
0x90630f34, 0x24020002, 0x3c040001, 0x24840e9c,
0x14620003, 0x24050001, 0x3c040001, 0x24840e90,
0x24060002, 0x00003821, 0xafa00010, 0x0c004378,
0xafa00014, 0x0c00402c, 0x00000000, 0x8fbf0018,
0x03e00008, 0x27bd0020, 0x00000000, 0x00000000,
0x27bdffe0, 0xafbf001c, 0xafb20018, 0xafb10014,
0x0c0042d4, 0xafb00010, 0x3c128000, 0x24110001,
0x8f706810, 0x32020400, 0x10400007, 0x00000000,
0x8f641008, 0x00921024, 0x14400003, 0x00000000,
0x0c004064, 0x00000000, 0x3c020001, 0x90420f56,
0x10510003, 0x32020200, 0x1040fff1, 0x00000000,
0x0c0041b4, 0x00000000, 0x08004034, 0x00000000,
0x8fbf001c, 0x8fb20018, 0x8fb10014, 0x8fb00010,
0x03e00008, 0x27bd0020, 0x27bdffe0, 0x3c040001,
0x24840eb0, 0x00002821, 0x00003021, 0x00003821,
0xafbf0018, 0xafa00010, 0x0c004378, 0xafa00014,
0x0000d021, 0x24020130, 0xaf625000, 0x3c010001,
0xa4200f50, 0x3c010001, 0xa0200f57, 0x8fbf0018,
0x03e00008, 0x27bd0020, 0x00000000, 0x00000000,
0x3c030001, 0x24630f60, 0x90620000, 0x27bdfff0,
0x14400003, 0x0080c021, 0x08004073, 0x00004821,
0x3c022000, 0x03021024, 0x10400003, 0x24090002,
0x08004073, 0xa0600000, 0x24090001, 0x00181040,
0x30431f80, 0x346f8008, 0x1520004b, 0x25eb0028,
0x3c040001, 0x00832021, 0x8c848010, 0x3c050001,
0x24a50f7a, 0x00041402, 0xa0a20000, 0x3c010001,
0xa0240f7b, 0x3c020001, 0x00431021, 0x94428014,
0x3c010001, 0xa0220f7c, 0x3c0c0001, 0x01836021,
0x8d8c8018, 0x304200ff, 0x24420008, 0x000220c3,
0x24020001, 0x3c010001, 0xa0220f60, 0x0124102b,
0x1040000c, 0x00003821, 0x24a6000e, 0x01602821,
0x8ca20000, 0x8ca30004, 0x24a50008, 0x24e70001,
0xacc20000, 0xacc30004, 0x00e4102b, 0x1440fff8,
0x24c60008, 0x00003821, 0x3c080001, 0x25080f7b,
0x91060000, 0x3c020001, 0x90420f7c, 0x2503000d,
0x00c32821, 0x00461023, 0x00021fc2, 0x00431021,
0x00021043, 0x1840000c, 0x00002021, 0x91020001,
0x00461023, 0x00021fc2, 0x00431021, 0x00021843,
0x94a20000, 0x24e70001, 0x00822021, 0x00e3102a,
0x1440fffb, 0x24a50002, 0x00041c02, 0x3082ffff,
0x00622021, 0x00041402, 0x00822021, 0x3c02ffff,
0x01821024, 0x3083ffff, 0x00431025, 0x3c010001,
0x080040fa, 0xac220f80, 0x3c050001, 0x24a50f7c,
0x90a20000, 0x3c0c0001, 0x01836021, 0x8d8c8018,
0x000220c2, 0x1080000e, 0x00003821, 0x01603021,
0x24a5000c, 0x8ca20000, 0x8ca30004, 0x24a50008,
0x24e70001, 0xacc20000, 0xacc30004, 0x00e4102b,
0x1440fff8, 0x24c60008, 0x3c050001, 0x24a50f7c,
0x90a20000, 0x30430007, 0x24020004, 0x10620011,
0x28620005, 0x10400005, 0x24020002, 0x10620008,
0x000710c0, 0x080040fa, 0x00000000, 0x24020006,
0x1062000e, 0x000710c0, 0x080040fa, 0x00000000,
0x00a21821, 0x9463000c, 0x004b1021, 0x080040fa,
0xa4430000, 0x000710c0, 0x00a21821, 0x8c63000c,
0x004b1021, 0x080040fa, 0xac430000, 0x00a21821,
0x8c63000c, 0x004b2021, 0x00a21021, 0xac830000,
0x94420010, 0xa4820004, 0x95e70006, 0x3c020001,
0x90420f7c, 0x3c030001, 0x90630f7a, 0x00e2c823,
0x3c020001, 0x90420f7b, 0x24630028, 0x01e34021,
0x24420028, 0x15200012, 0x01e23021, 0x94c2000c,
0x3c010001, 0xa4220f78, 0x94c20004, 0x94c30006,
0x3c010001, 0xa4200f76, 0x3c010001, 0xa4200f72,
0x00021400, 0x00431025, 0x3c010001, 0xac220f6c,
0x95020004, 0x3c010001, 0x08004124, 0xa4220f70,
0x3c020001, 0x94420f70, 0x3c030001, 0x94630f72,
0x00431021, 0xa5020004, 0x3c020001, 0x94420f6c,
0xa4c20004, 0x3c020001, 0x8c420f6c, 0xa4c20006,
0x3c040001, 0x94840f72, 0x3c020001, 0x94420f70,
0x3c0a0001, 0x954a0f76, 0x00441821, 0x3063ffff,
0x0062182a, 0x24020002, 0x1122000b, 0x00832023,
0x3c030001, 0x94630f78, 0x30620009, 0x10400006,
0x3062fff6, 0xa4c2000c, 0x3c020001, 0x94420f78,
0x30420009, 0x01425023, 0x24020001, 0x1122001b,
0x29220002, 0x50400005, 0x24020002, 0x11200007,
0x31a2ffff, 0x08004197, 0x00000000, 0x1122001d,
0x24020016, 0x08004197, 0x31a2ffff, 0x3c0e0001,
0x95ce0f80, 0x10800005, 0x01806821, 0x01c42021,
0x00041c02, 0x3082ffff, 0x00627021, 0x000e1027,
0xa502000a, 0x3c030001, 0x90630f7b, 0x31a2ffff,
0x00e21021, 0x0800418d, 0x00432023, 0x3c020001,
0x94420f80, 0x00442021, 0x00041c02, 0x3082ffff,
0x00622021, 0x00807021, 0x00041027, 0x08004185,
0xa502000a, 0x3c050001, 0x24a50f7a, 0x90a30000,
0x14620002, 0x24e2fff2, 0xa5e20034, 0x90a20000,
0x00e21023, 0xa5020002, 0x3c030001, 0x94630f80,
0x3c020001, 0x94420f5a, 0x30e5ffff, 0x00641821,
0x00451023, 0x00622023, 0x00041c02, 0x3082ffff,
0x00622021, 0x00041027, 0xa502000a, 0x3c030001,
0x90630f7c, 0x24620001, 0x14a20005, 0x00807021,
0x01631021, 0x90420000, 0x08004185, 0x00026200,
0x24620002, 0x14a20003, 0x306200fe, 0x004b1021,
0x944c0000, 0x3c020001, 0x94420f82, 0x3183ffff,
0x3c040001, 0x90840f7b, 0x00431021, 0x00e21021,
0x00442023, 0x008a2021, 0x00041c02, 0x3082ffff,
0x00622021, 0x00041402, 0x00822021, 0x00806821,
0x00041027, 0xa4c20010, 0x31a2ffff, 0x000e1c00,
0x00431025, 0x3c040001, 0x24840f72, 0xade20010,
0x94820000, 0x3c050001, 0x94a50f76, 0x3c030001,
0x8c630f6c, 0x24420001, 0x00b92821, 0xa4820000,
0x3322ffff, 0x00622021, 0x0083182b, 0x3c010001,
0xa4250f76, 0x10600003, 0x24a2ffff, 0x3c010001,
0xa4220f76, 0x3c024000, 0x03021025, 0x3c010001,
0xac240f6c, 0xaf621008, 0x03e00008, 0x27bd0010,
0x3c030001, 0x90630f56, 0x27bdffe8, 0x24020001,
0xafbf0014, 0x10620026, 0xafb00010, 0x8f620cf4,
0x2442ffff, 0x3042007f, 0x00021100, 0x8c434000,
0x3c010001, 0xac230f64, 0x8c434008, 0x24444000,
0x8c5c4004, 0x30620040, 0x14400002, 0x24020088,
0x24020008, 0x3c010001, 0xa4220f68, 0x30620004,
0x10400005, 0x24020001, 0x3c010001, 0xa0220f57,
0x080041d5, 0x00031402, 0x3c010001, 0xa0200f57,
0x00031402, 0x3c010001, 0xa4220f54, 0x9483000c,
0x24020001, 0x3c010001, 0xa4200f50, 0x3c010001,
0xa0220f56, 0x3c010001, 0xa4230f62, 0x24020001,
0x1342001e, 0x00000000, 0x13400005, 0x24020003,
0x13420067, 0x00000000, 0x080042cf, 0x00000000,
0x3c020001, 0x94420f62, 0x241a0001, 0x3c010001,
0xa4200f5e, 0x3c010001, 0xa4200f52, 0x304407ff,
0x00021bc2, 0x00031823, 0x3063003e, 0x34630036,
0x00021242, 0x3042003c, 0x00621821, 0x3c010001,
0xa4240f58, 0x00832021, 0x24630030, 0x3c010001,
0xa4240f5a, 0x3c010001, 0xa4230f5c, 0x3c060001,
0x24c60f52, 0x94c50000, 0x94c30002, 0x3c040001,
0x94840f5a, 0x00651021, 0x0044102a, 0x10400013,
0x3c108000, 0x00a31021, 0xa4c20000, 0x3c02a000,
0xaf620cf4, 0x3c010001, 0xa0200f56, 0x8f641008,
0x00901024, 0x14400003, 0x00000000, 0x0c004064,
0x00000000, 0x8f620cf4, 0x00501024, 0x104000b7,
0x00000000, 0x0800420f, 0x00000000, 0x3c030001,
0x94630f50, 0x00851023, 0xa4c40000, 0x00621821,
0x3042ffff, 0x3c010001, 0xa4230f50, 0xaf620ce8,
0x3c020001, 0x94420f68, 0x34420024, 0xaf620cec,
0x94c30002, 0x3c020001, 0x94420f50, 0x14620012,
0x3c028000, 0x3c108000, 0x3c02a000, 0xaf620cf4,
0x3c010001, 0xa0200f56, 0x8f641008, 0x00901024,
0x14400003, 0x00000000, 0x0c004064, 0x00000000,
0x8f620cf4, 0x00501024, 0x1440fff7, 0x00000000,
0x080042cf, 0x241a0003, 0xaf620cf4, 0x3c108000,
0x8f641008, 0x00901024, 0x14400003, 0x00000000,
0x0c004064, 0x00000000, 0x8f620cf4, 0x00501024,
0x1440fff7, 0x00000000, 0x080042cf, 0x241a0003,
0x3c070001, 0x24e70f50, 0x94e20000, 0x03821021,
0xaf620ce0, 0x3c020001, 0x8c420f64, 0xaf620ce4,
0x3c050001, 0x94a50f54, 0x94e30000, 0x3c040001,
0x94840f58, 0x3c020001, 0x94420f5e, 0x00a32823,
0x00822023, 0x30a6ffff, 0x3083ffff, 0x00c3102b,
0x14400043, 0x00000000, 0x3c020001, 0x94420f5c,
0x00021400, 0x00621025, 0xaf620ce8, 0x94e20000,
0x3c030001, 0x94630f54, 0x00441021, 0xa4e20000,
0x3042ffff, 0x14430021, 0x3c020008, 0x3c020001,
0x90420f57, 0x10400006, 0x3c03000c, 0x3c020001,
0x94420f68, 0x34630624, 0x0800427c, 0x0000d021,
0x3c020001, 0x94420f68, 0x3c030008, 0x34630624,
0x00431025, 0xaf620cec, 0x3c108000, 0x3c02a000,
0xaf620cf4, 0x3c010001, 0xa0200f56, 0x8f641008,
0x00901024, 0x14400003, 0x00000000, 0x0c004064,
0x00000000, 0x8f620cf4, 0x00501024, 0x10400015,
0x00000000, 0x08004283, 0x00000000, 0x3c030001,
0x94630f68, 0x34420624, 0x3c108000, 0x00621825,
0x3c028000, 0xaf630cec, 0xaf620cf4, 0x8f641008,
0x00901024, 0x14400003, 0x00000000, 0x0c004064,
0x00000000, 0x8f620cf4, 0x00501024, 0x1440fff7,
0x00000000, 0x3c010001, 0x080042cf, 0xa4200f5e,
0x3c020001, 0x94420f5c, 0x00021400, 0x00c21025,
0xaf620ce8, 0x3c020001, 0x90420f57, 0x10400009,
0x3c03000c, 0x3c020001, 0x94420f68, 0x34630624,
0x0000d021, 0x00431025, 0xaf620cec, 0x080042c1,
0x3c108000, 0x3c020001, 0x94420f68, 0x3c030008,
0x34630604, 0x00431025, 0xaf620cec, 0x3c020001,
0x94420f5e, 0x00451021, 0x3c010001, 0xa4220f5e,
0x3c108000, 0x3c02a000, 0xaf620cf4, 0x3c010001,
0xa0200f56, 0x8f641008, 0x00901024, 0x14400003,
0x00000000, 0x0c004064, 0x00000000, 0x8f620cf4,
0x00501024, 0x1440fff7, 0x00000000, 0x8fbf0014,
0x8fb00010, 0x03e00008, 0x27bd0018, 0x00000000,
0x27bdffe0, 0x3c040001, 0x24840ec0, 0x00002821,
0x00003021, 0x00003821, 0xafbf0018, 0xafa00010,
0x0c004378, 0xafa00014, 0x0000d021, 0x24020130,
0xaf625000, 0x3c010001, 0xa4200f50, 0x3c010001,
0xa0200f57, 0x8fbf0018, 0x03e00008, 0x27bd0020,
0x27bdffe8, 0x3c1bc000, 0xafbf0014, 0xafb00010,
0xaf60680c, 0x8f626804, 0x34420082, 0xaf626804,
0x8f634000, 0x24020b50, 0x3c010001, 0xac220f20,
0x24020b78, 0x3c010001, 0xac220f30, 0x34630002,
0xaf634000, 0x0c004315, 0x00808021, 0x3c010001,
0xa0220f34, 0x304200ff, 0x24030002, 0x14430005,
0x00000000, 0x3c020001, 0x8c420f20, 0x08004308,
0xac5000c0, 0x3c020001, 0x8c420f20, 0xac5000bc,
0x8f624434, 0x8f634438, 0x8f644410, 0x3c010001,
0xac220f28, 0x3c010001, 0xac230f38, 0x3c010001,
0xac240f24, 0x8fbf0014, 0x8fb00010, 0x03e00008,
0x27bd0018, 0x03e00008, 0x24020001, 0x27bdfff8,
0x18800009, 0x00002821, 0x8f63680c, 0x8f62680c,
0x1043fffe, 0x00000000, 0x24a50001, 0x00a4102a,
0x1440fff9, 0x00000000, 0x03e00008, 0x27bd0008,
0x8f634450, 0x3c020001, 0x8c420f28, 0x00031c02,
0x0043102b, 0x14400008, 0x3c038000, 0x3c040001,
0x8c840f38, 0x8f624450, 0x00021c02, 0x0083102b,
0x1040fffc, 0x3c038000, 0xaf634444, 0x8f624444,
0x00431024, 0x1440fffd, 0x00000000, 0x8f624448,
0x03e00008, 0x3042ffff, 0x3082ffff, 0x2442e000,
0x2c422001, 0x14400003, 0x3c024000, 0x08004347,
0x2402ffff, 0x00822025, 0xaf645c38, 0x8f625c30,
0x30420002, 0x1440fffc, 0x00001021, 0x03e00008,
0x00000000, 0x8f624450, 0x3c030001, 0x8c630f24,
0x08004350, 0x3042ffff, 0x8f624450, 0x3042ffff,
0x0043102b, 0x1440fffc, 0x00000000, 0x03e00008,
0x00000000, 0x27bdffe0, 0x00802821, 0x3c040001,
0x24840ed0, 0x00003021, 0x00003821, 0xafbf0018,
0xafa00010, 0x0c004378, 0xafa00014, 0x0800435f,
0x00000000, 0x8fbf0018, 0x03e00008, 0x27bd0020,
0x3c020001, 0x3442d600, 0x3c030001, 0x3463d600,
0x3c040001, 0x3484ddff, 0x3c010001, 0xac220f40,
0x24020040, 0x3c010001, 0xac220f44, 0x3c010001,
0xac200f3c, 0xac600000, 0x24630004, 0x0083102b,
0x5040fffd, 0xac600000, 0x03e00008, 0x00000000,
0x00804821, 0x8faa0010, 0x3c020001, 0x8c420f3c,
0x3c040001, 0x8c840f44, 0x8fab0014, 0x24430001,
0x0044102b, 0x3c010001, 0xac230f3c, 0x14400003,
0x00004021, 0x3c010001, 0xac200f3c, 0x3c020001,
0x8c420f3c, 0x3c030001, 0x8c630f40, 0x91240000,
0x00021140, 0x00431021, 0x00481021, 0x25080001,
0xa0440000, 0x29020008, 0x1440fff4, 0x25290001,
0x3c020001, 0x8c420f3c, 0x3c030001, 0x8c630f40,
0x8f64680c, 0x00021140, 0x00431021, 0xac440008,
0xac45000c, 0xac460010, 0xac470014, 0xac4a0018,
0x03e00008, 0xac4b001c, 0x00000000, 0x00000000,
0x4d61696e, 0x43707542, 0x00000000, 0x4d61696e,
0x43707541, 0x00000000, 0x00000000, 0x00000000,
0x73746b6f, 0x66666c64, 0x00000000, 0x00000000,
0x73746b6f, 0x66666c64, 0x00000000, 0x00000000,
0x66617461, 0x6c457272, 0x00000000, 0x00000000,
0x00000000, 0x00000000, 0x00000000, 0x00000000,
0x00000000, 0x00000000, 0x00000000, 0x00000000,
0x00000000, 0x73746b6f, 0x66666c64, 0x5f76312e,
0x322e3000, 0x00000000, 0x00000000, 0x00000000,
};

static const struct tg3_firmware tg3_5705_tso_fw = {
	.size = TG3_5705_TSO_FW_LEN,
	.data = (u8 *)&tg3Tso5FwText[0],
};

#endif /* TG3_TSO_SUPPORT != 0 */

static int tg3_hidden_request_firmware(const struct tg3_firmware **fw,
				       const char *name)
{
	*fw = 0;

	if (strcmp(name, "tigon/tg3.bin") == 0)
		*fw = &tg3_5701_fw;
#if TG3_TSO_SUPPORT != 0
	else if (strcmp(name, "tigon/tg3_tso.bin") == 0)
		*fw = &tg3_lgcy_tso_fw;
	else if (strcmp(name, "tigon/tg3_tso5.bin") == 0)
		*fw = &tg3_5705_tso_fw;
#endif

	return *fw ? 0 : -EINVAL;
}

#define tg3_priv_request_firmware(x, y, z) tg3_hidden_request_firmware((x), (y))

#define tg3_priv_release_firmware(x)

#endif /* BCM_HAS_REQUEST_FIRMWARE */
