/*
 * Copyright (C) 2012 Canonical Ltd.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * Authors: Renato Araujo Oliveira Filho <renato.filho@canonical.com>
 */

#ifndef __TPL_LOG_STORE_UFA_H__
#define __TPL_LOG_STORE_UFA_H__

#include <glib.h>
#include <glib-object.h>

G_BEGIN_DECLS

#define TPL_TYPE_LOG_STORE_UFA (tpl_log_store_ufa_get_type ())
#define TPL_LOG_STORE_UFA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TPL_TYPE_LOG_STORE_UFA, TplLogStoreUfa))
#define TPL_LOG_STORE_UFA_CLASS(vtable) (G_TYPE_CHECK_CLASS_CAST ((vtable), TPL_TYPE_LOG_STORE_UFA, TplLogStoreUfaClass))
#define TPL_IS_LOG_STORE_UFA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TPL_TYPE_LOG_STORE_UFA))
#define TPL_IS_LOG_STORE_UFA_CLASS(vtable) (G_TYPE_CHECK_CLASS_TYPE ((vtable), TPL_TYPE_LOG_STORE_UFA))
#define TPL_LOG_STORE_UFA_GET_CLASS(inst) (G_TYPE_INSTANCE_GET_CLASS ((inst), TPL_TYPE_LOG_STORE_UFA, TplLogStoreUfaClass))

typedef struct _TplLogStoreUfaPriv TplLogStoreUfaPriv;

typedef struct
{
  GObject parent;
  TplLogStoreUfaPriv *priv;
} TplLogStoreUfa;

typedef struct
{
  GObjectClass parent;
} TplLogStoreUfaClass;

GType tpl_log_store_ufa_get_type (void);

G_END_DECLS

#endif /* __TPL_LOG_STORE_UFA_H__ */
