/*
 * <insert one-line description of what the program does>
 * Copyright (c) <2008-2009>, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 2.1, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>
#include "GUI/FormTCAgent.h"
#include "eggtrayicon.h"
#include "eggnotificationbubble.h"
#include "GUI/tray.h"
#include "GUI/resmgmt.h"
#include "Engine/TCEngine.h"
#include "InfoMgmt/InfoMgmt.h"

//define error codes
#define GUI_ERR_SUCCESS               0
#define GUI_ERR_INVALID_PARAMETER     1
#define GUI_ERR_CONSTRUCT_ENGINE      2
#define GUI_ERR_CONSTRUCT_DEVICE_INFO 3
#define GUI_ERR_GET_EXPIRATION_INFO   4
#define GUI_ERR_CREATE_PIXBUF         5


#define LEFT_BUTTON        1
#define MIDDLE_BUTTON      2
#define	RIGHT_BUTTON       3
#define TIMEOUT            5000  // 5 seconds

//global variables
extern GtkWidget *AgentWindow;
extern GtkWidget *WarningWindow;
extern GtkWidget *RebootWindow;
extern GtkWidget *ProgressWindow;
extern GtkWidget *AboutWindow;
extern GtkWidget *BubbleWindow1;

extern gboolean m_bFormProgressHave;
extern gboolean m_bRebootForm;
extern gboolean m_bFormWarningShow;
extern RESOURCE_MANAGER g_resManager; 
//enumerate  menu items
typedef enum MENU_ITEM_ID{
	MENU_ID_ABOUT = 0,
	MENU_ID_LOGIN,
	MENU_ID_SETTINGS,
	MENU_ID_HELP,
	MAXIMUM_MENU_ITEMS
}MENU_ITEM_ID;

static gboolean FirstStart = TRUE;
static gboolean NoChangeDesktop = TRUE;
static	EggTrayIcon *tray_icon = NULL;
//double click and single click divition
static gboolean m_bSingleClick = FALSE;
static gboolean m_bFirstClick = TRUE;
static gint m_ClickTimer;
static guint32 m_ClickInterval = 250;// 1/4 second
static EggNotificationBubble* m_notification_bubble;

static	GtkWidget *m_event_box = NULL;
static	GtkTooltips *m_tooltips = NULL;

//record gui status
static /*volatile*/ gint m_TDStatus = STATUS_NORMAL;

static GdkPixbuf *m_icon_pixbuf_normal = NULL;
static GdkPixbuf *m_icon_pixbuf_warning = NULL;
static GdkPixbuf *m_icon_pixbuf_no_connection = NULL;
static GdkPixbuf *m_icon_pixbuf_no_connection_disable = NULL;
static GdkPixbuf *m_icon_pixbuf_not_approved = NULL;
static GdkPixbuf *m_icon_pixbuf_logo32 = NULL;

static const gchar *m_icon_normal = "normal.png";
static const gchar *m_icon_warning = "warning.png";
static const gchar *m_icon_not_approved = "not_approved.png";
static const gchar *m_icon_no_connection = "no_connection.png";
static const gchar *m_icon_no_connection_disable = "no_connection_disable.png";
static const gchar *m_icon_logo32 = "logo32.png";

#define MAX_HARDWAREID_LEN 64
typedef struct HARDWARE_INFO{
	gchar id[MAX_HARDWAREID_LEN];
	gint remain_boot_count;
        gint boot_tick;          //add by xu jun
	struct EXPIRATION_DATE{
		gint year;
		gint month;
		gint day;
	} expiration_date;
}HARDWARE_INFO, *PHARDWARE_INFO;


//Respond to menu item click event.
//When you click the tray icon, the menu will show, when you click 
//the menu item, the code below will be executed.
static void 
menu_item_event_handler(MENU_ITEM_ID menu_id)
{
	int error=0;
	DeviceInfo deviceInfo;
	ServerInfo serverInfo;
	if(menu_id < 0 || menu_id >= MAXIMUM_MENU_ITEMS)
	{
		WritestrLog(MODULE_GUI, "menu_item_event_handler : Invalid menu item id." );
		return;
	}
	GtkWidget *window = NULL;
	char HelpURL[TEMP_MAX_LEN] = "firefox file://";
        char configpath[FILEPATH_MAX_LEN ];
        getrespath(THEFTCONTROL_CONFIG, configpath);

	
	switch(menu_id)
	{
	case MENU_ID_ABOUT:
		//show about window
		window = AboutWindow;	
		break;
	case MENU_ID_HELP:
		strcat(HelpURL,configpath);
		strcat(HelpURL,"/welcome.htm &");
//		printf("%s", HelpURL);
		system(HelpURL);
		break;
	case MENU_ID_SETTINGS:
		//show settings window.
		window = AgentWindow;
	break;
	case MENU_ID_LOGIN:
		

		error = DeviceInfo_Construct(&deviceInfo);
	//	if (error) return error;

		error = ServerInfo_Construct(&serverInfo);
	//	if (error) return error;
		
		char ServerURL[TEMP_MAX_LEN] = "firefox https://";
		strcat(ServerURL,serverInfo.ServerAddress);
		strcat(ServerURL, "/tdserver/student/check_psw.jsp?HWID=" );
		strcat(ServerURL,deviceInfo.HardwareID);
		strcat(ServerURL, " &");
	//	system("firefox http://www.intel.com");
		system (ServerURL);
		break;
	default:
		//As it has been designed, the code won't reach here. 
		//Just a habit...
		break;
	}
		
	if(window != NULL)
	{
		gtk_window_set_position(GTK_WINDOW (window),GTK_WIN_POS_CENTER);
		gtk_window_set_keep_above (GTK_WINDOW (window), TRUE);  
		gtk_window_set_modal (GTK_WINDOW (window), TRUE);
		gtk_widget_show(window);
		gtk_widget_show_all(window);
	}
}

//timer call back function to judge the single click
static void 
timer_handler(GtkWidget* menu)
{
	m_bSingleClick=TRUE;
	m_bFirstClick=TRUE;
	// single click will popup the menu
	//g_print("alarm for single click\n");
	gtk_menu_popup (GTK_MENU(menu), NULL, NULL, NULL, NULL,
					LEFT_BUTTON, gtk_get_current_event_time());
	gtk_timeout_remove(m_ClickTimer);
}

//tray icon click callback function
static gboolean
tray_button_press_event_handler (GtkWidget * button, GdkEventButton * event, GtkWidget* menu)
{
	switch (event->button)
	{
	case MIDDLE_BUTTON:
		break;
	case LEFT_BUTTON:
		
	/*	if(GDK_BUTTON_PRESS == event->type)
		{
			if(TRUE==m_bFirstClick)
			{
				m_bFirstClick=FALSE;
				m_bSingleClick=FALSE;
				//start a timer 
				m_ClickTimer=gtk_timeout_add(m_ClickInterval,(GtkFunction)timer_handler,menu);
			}
			else
			{
				m_bSingleClick=FALSE;
				m_bFirstClick=TRUE;
				//	disable the timer
				gtk_timeout_remove(m_ClickTimer);
				g_print("alarm for double click\n");
				gtk_window_deiconify((GtkWindow*)AgentWindow);
				gtk_widget_show_all (AgentWindow);						
			}
		}
		break;*/
          if(GDK_2BUTTON_PRESS == event->type)
	      {
 		 gtk_widget_show_all (AgentWindow);
	      }
	     break;
	
	case RIGHT_BUTTON:
		if(GDK_BUTTON_PRESS == event->type)
		{
			gtk_menu_popup (GTK_MENU(menu), NULL, NULL, NULL, NULL,
					event->button, event->time);
		}
		break;
	default:
		return FALSE;
	}
	return TRUE;
}

//start  add by Roc Zhang 20070-9-27
void click_bubble_handler( GtkWidget *widget,
            gpointer   data )
{
  	egg_notification_bubble_hide (m_notification_bubble);
}
// end add

void 
create_tray_bubble(gchar* header,gchar* body,guint timeout)
{
	m_notification_bubble=egg_notification_bubble_new();
	egg_notification_bubble_attach(m_notification_bubble,GTK_WIDGET(tray_icon));

	//start  add by Roc Zhang 20070-9-27
	g_signal_connect (G_OBJECT (m_notification_bubble), "clicked", G_CALLBACK (click_bubble_handler), NULL);
	// end add
	 
	//The following codes may be called in another place 
	//to set the bubble text and show it
	//egg_notification_bubble_set(m_notification_bubble,header,NULL,body);
	//egg_notification_bubble_show(m_notification_bubble,timeout);
}


//create and show tray icon.
void
create_tray (const GdkPixbuf *icon_pixbuf, GtkWidget * window)
{
	static	GtkWidget *image = NULL;
	static	GdkPixbuf *pixbuf = NULL;
	GtkWidget* PopupMenu;
	GtkWidget* LogOntoServer;
	GtkWidget* Settings;
	GtkWidget* separator;
	GtkWidget* Help;
	GtkWidget* About;
	
	//create menu
	PopupMenu=gtk_menu_new();
	 gtk_widget_set_size_request(GTK_WIDGET(LogOntoServer),-1,100);
	LogOntoServer=gtk_menu_item_new_with_label(g_resManager.G_strMenuItemLogin);
 	gtk_widget_set_size_request(GTK_WIDGET(LogOntoServer),-1,40);
	Settings=gtk_menu_item_new_with_label(g_resManager.G_strMenuItemSettings);
      gtk_widget_set_size_request(GTK_WIDGET(Settings),-1,40);
	separator=gtk_separator_menu_item_new();
	Help=gtk_menu_item_new_with_label(g_resManager.G_strMenuItemHelp);
      gtk_widget_set_size_request(GTK_WIDGET(Help),-1,40);
	About=gtk_menu_item_new_with_label(g_resManager.G_strMenuItemAbout);
	gtk_widget_set_size_request(GTK_WIDGET(About),-1,40);
	gtk_menu_shell_append(GTK_MENU_SHELL(PopupMenu),LogOntoServer);
	gtk_menu_shell_append(GTK_MENU_SHELL(PopupMenu),Settings);
	gtk_menu_shell_append(GTK_MENU_SHELL(PopupMenu),separator);
	gtk_menu_shell_append(GTK_MENU_SHELL(PopupMenu),Help);
	gtk_menu_shell_append(GTK_MENU_SHELL(PopupMenu),About);

	g_signal_connect_swapped(G_OBJECT(LogOntoServer),"activate",\
			G_CALLBACK(menu_item_event_handler),(gpointer)MENU_ID_LOGIN);
	g_signal_connect_swapped(G_OBJECT(Settings),"activate",\
			G_CALLBACK(menu_item_event_handler),(gpointer)MENU_ID_SETTINGS);
	g_signal_connect_swapped(G_OBJECT(Help),"activate",\
			G_CALLBACK(menu_item_event_handler),(gpointer)MENU_ID_HELP);
	g_signal_connect_swapped(G_OBJECT(About),"activate",\
			G_CALLBACK(menu_item_event_handler),(gpointer)MENU_ID_ABOUT);
	
	gtk_widget_show(LogOntoServer);
	gtk_widget_show(Settings);
	gtk_widget_show(separator);
	gtk_widget_show(Help);
	gtk_widget_show(About);

	//initialization
	if (m_tooltips == NULL)
	{
		m_tooltips = gtk_tooltips_new ();
	}
	if (tray_icon == NULL)
	{
		tray_icon = egg_tray_icon_new (g_resManager.T_strTCAgentTitle);
	}
	if (m_event_box == NULL)	
	{
		m_event_box = gtk_event_box_new ();
		gtk_container_add (GTK_CONTAINER (tray_icon), m_event_box);
		g_signal_connect (G_OBJECT (m_event_box), "button-press-event",
			  G_CALLBACK (tray_button_press_event_handler),PopupMenu);
		g_signal_connect(G_OBJECT(m_event_box),"destroy",G_CALLBACK(Create_TrayIcon_Again),NULL);
	}
	if (image != NULL)
	{
		gtk_container_remove (GTK_CONTAINER (m_event_box), image);
	}

	image = (GtkWidget *)gtk_image_new_from_pixbuf ((GdkPixbuf *)icon_pixbuf);	
	
	gtk_container_add (GTK_CONTAINER (m_event_box), image);
		
		
	//new tooltip for cmpc 1.5(lsx)
	//gchar tmp[TEMP_MAX_LEN];
	//gint error;
	//error = UpdateTrayTooltipInfo(tmp);
	//gtk_tooltips_set_tip (GTK_TOOLTIPS(m_tooltips), m_event_box,tmp, NULL);	
	gtk_widget_show_all (GTK_WIDGET (tray_icon));
	//create tray bubble ( and show it in othe part of the code)
	create_tray_bubble("","",TIMEOUT);
//	gtk_widget_show_all (window);
	return;
}

// set the variable m_TDStatus = status
//gui status include following
//STATUS_NORMAL          0x00
//STATUS_DISABLE         0x01
//STATUS_NOT_APPROVED    0x02
//STATUS_WARNING         0x04
//STATUS_NO_CONNECTION   0x08
//STATUS_PERMANENT       0x20
//Be aware that the sataus may be combined status 
gint GUI_SetStatus(gint status)
{
	//may be sync control needed later...
	gint old_status;
	old_status = m_TDStatus;
	m_TDStatus = status;
	
	return old_status;
}

//Get gui status code
gint GUI_GetStatus(gint *status)
{
	*status = m_TDStatus;
	return *status;
}


//Create pixbufs for usage of other part of the code.
static gboolean GUI_CreatePixbuf()
{
	gchar pixmappath[FILEPATH_MAX_LEN];
	gboolean breturn;
	
	getrespath(THEFTCONTROL_PIXMAPS,pixmappath);
	add_pixmap_directory (pixmappath);

//define following macro for clarity	
#define CREATE_PIXBUF(filename, pixbuf) \
	if(pixbuf == NULL) { pixbuf = (GdkPixbuf *)create_pixbuf (filename);}
	
	CREATE_PIXBUF(m_icon_normal,m_icon_pixbuf_normal);
	CREATE_PIXBUF(m_icon_warning,m_icon_pixbuf_warning);
	CREATE_PIXBUF(m_icon_no_connection,m_icon_pixbuf_no_connection);
	CREATE_PIXBUF(m_icon_no_connection_disable,m_icon_pixbuf_no_connection_disable);
	CREATE_PIXBUF(m_icon_not_approved,m_icon_pixbuf_not_approved);
	CREATE_PIXBUF(m_icon_logo32,m_icon_pixbuf_logo32);
		
	breturn = (m_icon_pixbuf_normal != NULL && 
			m_icon_pixbuf_warning != NULL && 
			m_icon_pixbuf_no_connection != NULL &&
			m_icon_pixbuf_no_connection_disable != NULL &&
			m_icon_pixbuf_not_approved != NULL &&
			m_icon_pixbuf_logo32 != NULL);
	
	return breturn;
}

//get hardware info include harware id, expiration date, left boot counts
static gint get_hardware_info(PHARDWARE_INFO phardware_info)
{
	gint ret = 0;
	gint error = 0;

	TCEngine tcEngine;
	DeviceInfo deviceInfo;
	DateTime dateExpiration;
	
	if(NULL == phardware_info)
	{
		WritestrLog(MODULE_GUI, "get_hardware_info: Invalid parameter");
		return GUI_ERR_INVALID_PARAMETER;
	}
	ret = TCEngine_Construct(&tcEngine);
	if (ret)
	{
		WritestrLog(MODULE_GUI, "tcengine initialization fail" );
		return GUI_ERR_CONSTRUCT_ENGINE;
	}
			error = DeviceInfo_Construct(&deviceInfo);
			/*if (error)
			{
				strcpy(phardware_info->id,"");
				//g_print("error %s(%d)\n", __FILE__, __LINE__);
				ret=GUI_ERR_CONSTRUCT_DEVICE_INFO;
			}
			else*/
			//{
				strcpy(phardware_info->id,deviceInfo.HardwareID);
			//}
                                phardware_info->boot_tick = deviceInfo.BootTick;   //add by xu jun
                               // printf("xxx %d xxx\n", deviceInfo.BootTick);
			//Expiration Date & Boot Count
			//Get expireation info form tcEngine
			error = TCEngine_GetExpirationInfo(&tcEngine, &dateExpiration, &(phardware_info->remain_boot_count));
			/*if (error) 
			{
				memset(&phardware_info->expiration_date, 0, sizeof(struct EXPIRATION_DATE));
				ret=GUI_ERR_GET_EXPIRATION_INFO;
			}
			else*/
			//{
				phardware_info->expiration_date.year = dateExpiration.Year;
				phardware_info->expiration_date.month = dateExpiration.Month;
				phardware_info->expiration_date.day = dateExpiration.Day;
				
			//}

			return ret;
}

//format tooltip information from input parameters: hardware id, expiration date, left boot counts
static gint tooltip_info_from_status(gchar *tootiptext, PHARDWARE_INFO phardware_info)
{
	gint current_status;
	if(tootiptext == NULL)
	{//error
		WritestrLog(MODULE_GUI, "TooltipInfoFromStatus: Invalid parameter.\n" );
		return GUI_ERR_INVALID_PARAMETER;
	}
	
	GUI_GetStatus(&current_status);
	
	if((current_status & STATUS_NOT_APPROVED) && 
			(current_status & STATUS_NO_CONNECTION))
	{
		strcpy(tootiptext,g_resManager.G_strDisableNoConnection);
	}
		else if((current_status & STATUS_WARNING) && 
				(current_status & STATUS_NOT_APPROVED))
		{
			sprintf(tootiptext,g_resManager.G_strTooltipText,
					g_resManager.G_strStatusNotApproved,//(Not activited)
					phardware_info->id, 
					phardware_info->expiration_date.month, 
					phardware_info->expiration_date.day,
					phardware_info->expiration_date.year,
					phardware_info->remain_boot_count,
                                        phardware_info->boot_tick               //add by xu jun
					);
		}
		else if((current_status & STATUS_WARNING) && 
				(current_status & STATUS_NO_CONNECTION))
		{
			sprintf(tootiptext, g_resManager.G_strTooltipText,
					g_resManager.G_strStatusWarning,//"(Warning)",
					phardware_info->id, 
					phardware_info->expiration_date.month,
					phardware_info->expiration_date.day,
					phardware_info->expiration_date.year,
					phardware_info->remain_boot_count,
					phardware_info->boot_tick               //add by xu jun
					);
		}		
		else if(current_status & STATUS_WARNING) //h
		{
			sprintf(tootiptext, g_resManager.G_strTooltipText,
					g_resManager.G_strStatusWarning,//"(Warning)",
					phardware_info->id,
					phardware_info->expiration_date.month, 
					phardware_info->expiration_date.day,
					phardware_info->expiration_date.year,
					phardware_info->remain_boot_count,
					phardware_info->boot_tick               //add by xu jun
					);
		}
		else if(current_status & STATUS_NO_CONNECTION)
		{
			strcpy(tootiptext, g_resManager.G_strNoConnection);
		}
		else if(current_status & STATUS_NOT_APPROVED)
		{
			strcpy(tootiptext, g_resManager.G_strNotApproved);
		}
		else if(current_status & STATUS_PERMANENT)
		{
			sprintf(tootiptext, 
					g_resManager.G_strPermanentCertificate, 
					phardware_info->id);
		}
		else//normal
		{
		 	 if(phardware_info->expiration_date.year>2038 && phardware_info->remain_boot_count>365000)
			{
				sprintf(tootiptext, g_resManager.G_strPermanentCertificate, phardware_info->id);
				return GUI_ERR_SUCCESS;	
			}
			sprintf(tootiptext, g_resManager.G_strTooltipText,
					g_resManager.G_strStatusNormal,//,"(Normal)"
					phardware_info->id, 
					phardware_info->expiration_date.month, 
					phardware_info->expiration_date.day,
					phardware_info->expiration_date.year,
					phardware_info->remain_boot_count,
					phardware_info->boot_tick              //add by xu jun
					);	
		}
	return GUI_ERR_SUCCESS;	
}
/// <summary>
/// Update expiry infomation for tray icon m_tooltips
/// form tcEngine's expiration info .
/// </summary>
gint UpdateTrayTooltipInfo(gchar* tooltip_text )
{
	gint ret = 0;
	gint error=0;
	HARDWARE_INFO HardwareInfo;
	
	if(GUI_ERR_SUCCESS != (get_hardware_info(&HardwareInfo)))
	{
		WritestrLog(MODULE_GUI, "UpdateTrayTooltipInfo: call get_hardware_info error.\n" );		
	}
	tooltip_text[0] = '\0';
	ret = tooltip_info_from_status(tooltip_text, &HardwareInfo);
	return ret;	
}

//format balloon text information from input parameters: hardware id, expiration date, left boot counts
static gint balloon_info_from_status(gchar *balloon_text, PHARDWARE_INFO phardware_info)
{
	if(balloon_text == NULL || phardware_info == NULL)
	{
		WritestrLog(MODULE_GUI, "balloon_info_from_status: Invalid parameter.\n" );
		return GUI_ERR_INVALID_PARAMETER;
	}
	
	struct tm *pTmNow;
	struct tm tmExpiry;
	time_t timeNow;
	time_t timeExpiry;
	gint ispandays;
	char spandays[20];
	gint current_status;
	
	time(&timeNow);
	pTmNow = localtime(&timeNow);
	timeNow = mktime(pTmNow);
	tmExpiry.tm_sec = tmExpiry.tm_min = 59;
	tmExpiry.tm_hour = 23;
	tmExpiry.tm_mday = phardware_info->expiration_date.day;
	tmExpiry.tm_mon = phardware_info->expiration_date.month - 1;
	tmExpiry.tm_year = phardware_info->expiration_date.year - 1900;
	tmExpiry.tm_wday = tmExpiry.tm_yday = 0;
	tmExpiry.tm_isdst = 0;
	timeExpiry = mktime(&tmExpiry);
	if (phardware_info->expiration_date.year >=PERMANENT_YEAR)//(- 1900)
		{
		strcpy(spandays,"unlimited");
		}
	else{
		ispandays = (gint)difftime(timeExpiry, timeNow) / SECONDS_FOR_ONE_DAY;
		sprintf(spandays,"%d", ispandays);
	}	
	GUI_GetStatus(&current_status);
	
	if((current_status & STATUS_WARNING) && 
				(current_status & STATUS_NOT_APPROVED) && 
				(current_status & STATUS_NO_CONNECTION))
		{
		sprintf(balloon_text, g_resManager.G_strBalloonText, spandays, phardware_info->remain_boot_count);				
		}
		else if((current_status & STATUS_WARNING) && 
				(current_status & STATUS_NOT_APPROVED))
		{
			sprintf(balloon_text, g_resManager.G_strBalloonText, spandays, phardware_info->remain_boot_count);
		}
		else if((current_status & STATUS_WARNING) && 
				(current_status & STATUS_NO_CONNECTION))
		{
			sprintf(balloon_text, g_resManager.G_strBalloonText, spandays, phardware_info->remain_boot_count);			
		}
		else if((current_status & STATUS_NOT_APPROVED) && 
				(current_status & STATUS_NO_CONNECTION))
		{
			strcpy(balloon_text, g_resManager.G_strNoConnection2);			
		}
		else if(current_status & STATUS_WARNING)
		{
			sprintf(balloon_text, g_resManager.G_strBalloonText, spandays, phardware_info->remain_boot_count);
		}
		else if(current_status & STATUS_NO_CONNECTION)
		{
			strcpy(balloon_text, g_resManager.G_strNoConnection2);			
		}
		//else if(current_status & STATUS_NOT_APPROVED)	{}
		//else if(current_status & STATUS_PERMANENT){}
	    //else//normal{}
	return GUI_ERR_SUCCESS;	
}

static gint UpdateTrayBalloonInfo(gchar* balloon_text)
{
	    gint ret; 	
		HARDWARE_INFO HardwareInfo;
		
		ret = get_hardware_info(&HardwareInfo);
		if(ret != GUI_ERR_SUCCESS)
		{//error
			WritestrLog(MODULE_GUI,"UpdateTrayBalloonInfo: call get_hardware_info error.");
			//g_print("%s(%d): Error code=%d\n", __FILE__, __LINE__, ret);
		}
		balloon_text[0] = '\0';
		ret = balloon_info_from_status(balloon_text, &HardwareInfo);	
		return ret;	
}

static gint gui_update_ui(gchar *tooltip_text, gchar *balloon_text)
{
	gint current_status;
	int firsttime=1;
	//const gchar *bubble_header = "Theft Deterrent Agent";
	GdkPixbuf *icon_pixbuf;
		
	if(!GUI_CreatePixbuf())
	{//error create pixbuf
		WritestrLog(MODULE_GUI," GUI_Update: Create pixbuf error \n");
		return GUI_ERR_CREATE_PIXBUF;
	}
	
	GUI_GetStatus(&current_status);
	
	if((current_status & STATUS_WARNING) && 
			(current_status & STATUS_NOT_APPROVED) && 
			(current_status & STATUS_NO_CONNECTION))
	{
		icon_pixbuf = m_icon_pixbuf_warning;				
	}
	else if((current_status & STATUS_WARNING) && 
			(current_status & STATUS_NOT_APPROVED))
	{
		icon_pixbuf=m_icon_pixbuf_warning;			
	}
	else if((current_status & STATUS_WARNING) && 
			(current_status & STATUS_NO_CONNECTION))
	{
		icon_pixbuf=m_icon_pixbuf_no_connection;				
	}
	else if((current_status & STATUS_NOT_APPROVED) && 
			(current_status & STATUS_NO_CONNECTION))
	{
		icon_pixbuf=m_icon_pixbuf_no_connection_disable;	
	}
	else if(current_status & STATUS_WARNING)
	{
		icon_pixbuf=m_icon_pixbuf_warning;		
	}
	else if(current_status & STATUS_NO_CONNECTION)
	{
		icon_pixbuf=m_icon_pixbuf_no_connection;			
	}
	else if(current_status & STATUS_NOT_APPROVED)
	{
		icon_pixbuf=m_icon_pixbuf_not_approved;	
	}
	else if(current_status & STATUS_PERMANENT)
	{
		icon_pixbuf=m_icon_pixbuf_normal;			
	}
	else//normal
	{
		icon_pixbuf=m_icon_pixbuf_normal;
	}
	
	//create tray icon
	gtk_window_set_icon (GTK_WINDOW (AgentWindow), m_icon_pixbuf_logo32);
	gtk_window_set_icon (GTK_WINDOW (RebootWindow), m_icon_pixbuf_logo32);

	create_tray(icon_pixbuf,AgentWindow);

	int provisioned=0;
	OtherInfo_Provisioned(&provisioned, "GET");
	//if (provisioned==0)
		//return GUI_ERR_SUCCESS;//if not provisioned, no need to show tooltip and balloon text

	//set tooltip text
	
	if(FirstStart)
	{
		FirstStart = FALSE;
	}
	else
	{
	if(tooltip_text != NULL && 0 < strlen(tooltip_text))
	{
		gtk_tooltips_set_tip (GTK_TOOLTIPS(m_tooltips), m_event_box,tooltip_text, NULL);
	}
	if (firsttime&&NoChangeDesktop){//only show once
	//set and show balloon text
		if(balloon_text != NULL &&  0 < strlen(balloon_text) && strcmp(balloon_text,"")!=0)
		{
			egg_notification_bubble_set(m_notification_bubble,g_resManager.G_strBubbleHeader,NULL, balloon_text);
			egg_notification_bubble_show(m_notification_bubble,TIMEOUT);	
		}
		firsttime=0;
		NoChangeDesktop = TRUE;
	}
	}
	return GUI_ERR_SUCCESS;
}

gint GUI_UpdateUIByStatus(gint status)
{
	GUI_SetStatus(status);
	gchar tooltip_text[TEMP_MAX_LEN];
	gchar balloon_text[TEMP_MAX_LEN*2];	
	gint ret = UpdateTrayBalloonInfo(balloon_text);
	if (ret)
		WritestrLog(MODULE_GUI, "UpdateTrayBalloonInfo fail");
	UpdateTrayTooltipInfo(tooltip_text);
	if (ret)
		WritestrLog(MODULE_GUI, "UpdateTrayTooltipInfo fail");
	
	ret = gui_update_ui(tooltip_text, balloon_text);
	if (ret) WritestrLog(MODULE_GUI, "gui_update_ui fail");
	return ret;
}
void Create_TrayIcon_Again(GtkObject *object,gpointer user_data)
{
	m_tooltips  = NULL;
	tray_icon = NULL;
	m_event_box = NULL;
	NoChangeDesktop = FALSE;
	UpdateUIbyStatus();
	
}

