 /* soapServer.c
   Generated by gSOAP 2.7.8c from AgentDevice.h
   Copyright (C) 2000-2006, Robert van Engelen, Genivia Inc. All Rights Reserved.
   This part of the software is released under one of the following licenses:
   GPL, the gSOAP public license, or Genivia's license for commercial use.
*/
#include "soapH.h"
#ifdef __cplusplus
extern "C" {
#endif

SOAP_SOURCE_STAMP("@(#) soapServer.c ver 2.7.8c 2007-12-19 20:19:45 GMT")


SOAP_FMAC5 int SOAP_FMAC6 soap_serve(struct soap *soap)
{
#ifndef WITH_FASTCGI
	unsigned int k = soap->max_keep_alive;
#endif

	do
	{
#ifdef WITH_FASTCGI
		if (FCGI_Accept() < 0)
		{
			soap->error = SOAP_EOF;
			return soap_send_fault(soap);
		}
#endif

		soap_begin(soap);

#ifndef WITH_FASTCGI
		if (soap->max_keep_alive > 0 && !--k)
			soap->keep_alive = 0;
#endif

		if (soap_begin_recv(soap))
		{	if (soap->error < SOAP_STOP)
			{
#ifdef WITH_FASTCGI
				soap_send_fault(soap);
#else 
				return soap_send_fault(soap);
#endif
			}
			soap_closesock(soap);

			continue;
		}

		if (soap_envelope_begin_in(soap)
		 || soap_recv_header(soap)
		 || soap_body_begin_in(soap)
		 || soap_serve_request(soap)
		 || (soap->fserveloop && soap->fserveloop(soap)))
		{
#ifdef WITH_FASTCGI
			soap_send_fault(soap);
#else
			return soap_send_fault(soap);
#endif
		}

#ifdef WITH_FASTCGI
	} while (1);
#else
	} while (soap->keep_alive);
#endif
	return SOAP_OK;
}

#ifndef WITH_NOSERVEREQUEST
SOAP_FMAC5 int SOAP_FMAC6 soap_serve_request(struct soap *soap)
{
	soap_peek_element(soap);
	if (!soap_match_tag(soap, soap->tag, "ns1:exchangeData"))
		return soap_serve_ns1__exchangeData(soap);
	if (!soap_match_tag(soap, soap->tag, "ns1:exchangeDataHttp"))
		return soap_serve_ns1__exchangeDataHttp(soap);
	if (!soap_match_tag(soap, soap->tag, "ns1:exchangeDataEx"))
		return soap_serve_ns1__exchangeDataEx(soap);
	if (!soap_match_tag(soap, soap->tag, "ns1:UpdateResult"))
		return soap_serve_ns1__UpdateResult(soap);
	return soap->error = SOAP_NO_METHOD;
}
#endif

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_ns1__exchangeData(struct soap *soap)
{	struct ns1__exchangeData soap_tmp_ns1__exchangeData;
	struct ns1__exchangeDataResponse soap_tmp_ns1__exchangeDataResponse;
	struct xsd__base64Binary soap_tmp_xsd__base64Binary;
	soap_default_ns1__exchangeDataResponse(soap, &soap_tmp_ns1__exchangeDataResponse);
	soap_default_xsd__base64Binary(soap, &soap_tmp_xsd__base64Binary);
	soap_tmp_ns1__exchangeDataResponse._exchangeDataReturn = &soap_tmp_xsd__base64Binary;
	soap_default_ns1__exchangeData(soap, &soap_tmp_ns1__exchangeData);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_ns1__exchangeData(soap, &soap_tmp_ns1__exchangeData, "ns1:exchangeData", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = ns1__exchangeData(soap, soap_tmp_ns1__exchangeData._HWID, soap_tmp_ns1__exchangeData._Boot_USCOREtick, soap_tmp_ns1__exchangeData._certKind, soap_tmp_ns1__exchangeData._ip, soap_tmp_ns1__exchangeData._dns, soap_tmp_ns1__exchangeData._wins, soap_tmp_ns1__exchangeData._gateway, soap_tmp_ns1__exchangeData._proxy, soap_tmp_ns1__exchangeData._localTime, &soap_tmp_xsd__base64Binary);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_ns1__exchangeDataResponse(soap, &soap_tmp_ns1__exchangeDataResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_ns1__exchangeDataResponse(soap, &soap_tmp_ns1__exchangeDataResponse, "ns1:exchangeDataResponse", "")
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_ns1__exchangeDataResponse(soap, &soap_tmp_ns1__exchangeDataResponse, "ns1:exchangeDataResponse", "")
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_ns1__exchangeDataHttp(struct soap *soap)
{	struct ns1__exchangeDataHttp soap_tmp_ns1__exchangeDataHttp;
	struct ns1__exchangeDataHttpResponse soap_tmp_ns1__exchangeDataHttpResponse;
	struct xsd__base64Binary soap_tmp_xsd__base64Binary;
	soap_default_ns1__exchangeDataHttpResponse(soap, &soap_tmp_ns1__exchangeDataHttpResponse);
	soap_default_xsd__base64Binary(soap, &soap_tmp_xsd__base64Binary);
	soap_tmp_ns1__exchangeDataHttpResponse._exchangeDataHttpReturn = &soap_tmp_xsd__base64Binary;
	soap_default_ns1__exchangeDataHttp(soap, &soap_tmp_ns1__exchangeDataHttp);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_ns1__exchangeDataHttp(soap, &soap_tmp_ns1__exchangeDataHttp, "ns1:exchangeDataHttp", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = ns1__exchangeDataHttp(soap, soap_tmp_ns1__exchangeDataHttp._HWID, soap_tmp_ns1__exchangeDataHttp._agentBT, soap_tmp_ns1__exchangeDataHttp._packageTpye, soap_tmp_ns1__exchangeDataHttp._ip, soap_tmp_ns1__exchangeDataHttp._dns, soap_tmp_ns1__exchangeDataHttp._wins, soap_tmp_ns1__exchangeDataHttp._gateway, soap_tmp_ns1__exchangeDataHttp._proxy, soap_tmp_ns1__exchangeDataHttp._localTime, soap_tmp_ns1__exchangeDataHttp._deviceID, &soap_tmp_xsd__base64Binary);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_ns1__exchangeDataHttpResponse(soap, &soap_tmp_ns1__exchangeDataHttpResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_ns1__exchangeDataHttpResponse(soap, &soap_tmp_ns1__exchangeDataHttpResponse, "ns1:exchangeDataHttpResponse", "")
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_ns1__exchangeDataHttpResponse(soap, &soap_tmp_ns1__exchangeDataHttpResponse, "ns1:exchangeDataHttpResponse", "")
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_ns1__exchangeDataEx(struct soap *soap)
{	struct ns1__exchangeDataEx soap_tmp_ns1__exchangeDataEx;
	struct ns1__exchangeDataExResponse soap_tmp_ns1__exchangeDataExResponse;
	struct xsd__base64Binary soap_tmp_xsd__base64Binary;
	soap_default_ns1__exchangeDataExResponse(soap, &soap_tmp_ns1__exchangeDataExResponse);
	soap_default_xsd__base64Binary(soap, &soap_tmp_xsd__base64Binary);
	soap_tmp_ns1__exchangeDataExResponse._exchangeDataExReturn = &soap_tmp_xsd__base64Binary;
	soap_default_ns1__exchangeDataEx(soap, &soap_tmp_ns1__exchangeDataEx);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_ns1__exchangeDataEx(soap, &soap_tmp_ns1__exchangeDataEx, "ns1:exchangeDataEx", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = ns1__exchangeDataEx(soap, soap_tmp_ns1__exchangeDataEx._HWID, soap_tmp_ns1__exchangeDataEx._Boot_USCOREtick, soap_tmp_ns1__exchangeDataEx._certKind, soap_tmp_ns1__exchangeDataEx._ip, soap_tmp_ns1__exchangeDataEx._dns, soap_tmp_ns1__exchangeDataEx._wins, soap_tmp_ns1__exchangeDataEx._gateway, soap_tmp_ns1__exchangeDataEx._proxy, soap_tmp_ns1__exchangeDataEx._localTime, soap_tmp_ns1__exchangeDataEx._deviceID, &soap_tmp_xsd__base64Binary);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_ns1__exchangeDataExResponse(soap, &soap_tmp_ns1__exchangeDataExResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_ns1__exchangeDataExResponse(soap, &soap_tmp_ns1__exchangeDataExResponse, "ns1:exchangeDataExResponse", "")
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_ns1__exchangeDataExResponse(soap, &soap_tmp_ns1__exchangeDataExResponse, "ns1:exchangeDataExResponse", "")
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_ns1__UpdateResult(struct soap *soap)
{	struct ns1__UpdateResult soap_tmp_ns1__UpdateResult;
	struct ns1__UpdateResultResponse _param_1;
	soap_default_ns1__UpdateResultResponse(soap, &_param_1);
	soap_default_ns1__UpdateResult(soap, &soap_tmp_ns1__UpdateResult);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_ns1__UpdateResult(soap, &soap_tmp_ns1__UpdateResult, "ns1:UpdateResult", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = ns1__UpdateResult(soap, soap_tmp_ns1__UpdateResult._HWID, soap_tmp_ns1__UpdateResult._state, &_param_1);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_ns1__UpdateResultResponse(soap, &_param_1);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_ns1__UpdateResultResponse(soap, &_param_1, "ns1:UpdateResultResponse", "")
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_ns1__UpdateResultResponse(soap, &_param_1, "ns1:UpdateResultResponse", "")
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

#ifdef __cplusplus
}
#endif

/* End of soapServer.c */
