#!/bin/bash
# internal-master-hook.sh
#
# Used for QA and RD to add hook when install the image,
# Some of them make use ubiquity's hook
# 
# Bin Li (bin.li@canonical.com)
# ------------------------------- NOTE ----------------------------------------
# 1) Phase1's hook
# For phase1(from U-disk/DVD to recovery partition)'s hooks
# You need set the hook in preseed/project.cfg like below
#
# ubiquity ubuntu-recovery/pre_phase1_command string /bin/pre_phase1_hook
# ubiquity ubuntu-recovery/post_phase1_command string /bin/post_phase1_hook
#
# Next we need install scripts as:
#
# /bin/post_phase1_hook and /bin/pre_phase1_hook
# -----------------------------------------------------------------------------
# 2) Phase2's hook
# For phase2(from recovery partition to Hard-disk)'s hooks
# Ubiquity can't recognize the phase1 with phase2, so I call it
# pre_ubiquity_hook, so it will called in phase1 too.
# We make use the ubiquity's dm-scripts, just install script as:
#
# /usr/lib/ubiquity/dm-scripts/install/pre_ubiquity_hook
#
# And for post hook we make use ubiquity's SCRIPTS.
# And for the post hook phase2, we make use of the post-fail-general.sh and
# post-success-general.sh which are called by SUCCESS-SCRIPT/FAIL-SCRIPT in
# /usr/share/ubuntu/scripts/.
# 
# So we need install scripts as:
#
# /usr/share/ubuntu/scripts/post-success-general.sh
# /usr/share/ubuntu/scripts/post-fail-general.sh
# -----------------------------------------------------------------------------
# 3) oem-config's hook
# We make use the ubiquity's dm-scripts, just install script as:
#
# /usr/lib/ubiquity/dm-scripts/oem/pre_oem_config_hook
# -----------------------------------------------------------------------------

# By default the hook is do nothing, please set DO_NOTHING as 0.
# And rebuild, make a directory called debs/ on your live media and put
# the modified debian packages inside it.
DO_NOTHING=1

DIALOG=/usr/bin/dialog
PLYMOUTH=/bin/plymouth
ZENITY=/usr/bin/zenity
LOG=/tmp/ubiquity_hook_log

if [ $DO_NOTHING -ne 0 ]; then
	rm -f /usr/share/ubuntu/scripts/internal-master-hook.sh
	exit 0
fi

# you can install this scripts as hooiks
if [ x$1 = "xinstall" ] ; then
	echo "install hook script"
	ln -sf $0 /bin/pre_phase1_hook
	ln -sf $0 /bin/post_phase1_hook
	ln -sf $0 /usr/lib/ubiquity/dm-scripts/install/pre_ubiquity_hook
	ln -sf $0 /usr/lib/ubiquity/dm-scripts/oem/pre_oem_config_hook
	ln -sf $0 /usr/share/ubuntu/scripts/post-success-general.sh
	ln -sf $0 /usr/share/ubuntu/scripts/post-fail-general.sh
	exit 0
fi
# you can uninstall this scripts as hooiks
if [ x$1 = "xuninstall" ] ; then
	echo "uninstall hook script"
	rm -f /bin/pre_phase1_hook
	rm -f /bin/post_phase1_hook
	rm -f /usr/lib/ubiquity/dm-scripts/install/pre_ubiquity_hook
	rm -f /usr/lib/ubiquity/dm-scripts/oem/pre_oem_config_hook
	rm -f /usr/share/ubuntu/scripts/post-success-general.sh
	rm -f /usr/share/ubuntu/scripts/post-fail-general.sh
	exit 0
fi
# Cause the X already started, so we use zenity in high priority.
if [ -e $ZENITY ] ; then
	$ZENITY --info --timeout=10 --text "$0 waiting for input on /tmp/pause..." &
elif [ -e $PLYMOUTH ] ; then
	$PLYMOUTH --ping
	if [ $? -eq 0 ]; then
		plymouth message --text="$0 waiting for input on /tmp/pause..."
	fi
elif [ -e $DIALOG ] ; then
	$DIALOG --infobox "$0 waiting for input on /tmp/pause..." 5 80
fi

# Now we just create a pipe to let the process stop and wait input from user.
# You can run you own scrip here
sudo mkfifo -m 666 /tmp/pause; sudo cat /tmp/pause >> $LOG; sudo rm /tmp/pause; echo "$0 $@" >> $LOG ;

