// Global vars
var gPref = Components.classes["@mozilla.org/preferences-service;1"]
               .getService(Components.interfaces.nsIPrefService)
               .QueryInterface(Components.interfaces.nsIPrefBranch2);
var targetDial = -1;
var retVals = null;

var PLUGIN_GADGET = 0;
var PLUGIN_CUSTOM = 1;

function Startup() {
  // Set variables
  targetDial = window.arguments[0];
  //retVals = window.arguments[1];

  var speedDialBundle = document.getElementById("bundle_speeddial");

  var defaultTab = PLUGIN_GADGET;
  
  if (gPref.prefHasUserValue("extensions.speeddial.thumbnail-" + targetDial + "-url")) {
    var targetURL = gPref.getCharPref("extensions.speeddial.thumbnail-" + targetDial + "-url");
    if (SpeedDialUtils.stringStartsWith(targetURL, "plugin:")) {
      defaultTab = PLUGIN_CUSTOM;
      document.getElementById("url").value = targetURL.substr("plugin:".length);
    }
    if (SpeedDialUtils.stringStartsWith(targetURL, "plugin:http://www.gmodules.com/ig/ifr")) {
      defaultTab = PLUGIN_GADGET;
      document.getElementById("currentGadget").value = targetURL.substr("plugin:".length);
    }
  }
  
  document.getElementById("pluginTypes").selectedIndex = defaultTab;
}

function onOK(event) {
  var speedDialBundle = document.getElementById("bundle_speeddial");
  
  var currentTab = document.getElementById("pluginTypes").selectedIndex;
  
  if (currentTab == PLUGIN_GADGET) {
    var newGadget = document.getElementById("newGadget").value;
    var reScript = new RegExp("<script src=\"(.*)\"></script>");
    var resultsScript = reScript.exec(newGadget);
    if ((resultsScript) && (resultsScript[1]) && (resultsScript[1] != '')) {
      SpeedDialUtils.deassignThumbnail(targetDial);
      var gadgetURL = resultsScript[1].replace(/&amp;/g, "&");
      gadgetURL = gadgetURL.replace("&output=js", "&output=html");
      gPref.setCharPref("extensions.speeddial.thumbnail-" + targetDial + "-url", "plugin:" + gadgetURL);
      var reTitle = new RegExp("&title=(.*)&");
      var resultsTitle = reTitle.exec(gadgetURL);
      if ((resultsTitle) && (resultsTitle[1]) && (resultsTitle[1] != '')) {
        var str = Components.classes["@mozilla.org/supports-string;1"].createInstance(Components.interfaces.nsISupportsString);
        str.data = resultsTitle[1];
        gPref.setComplexValue("extensions.speeddial.thumbnail-" + targetDial + "-label", Components.interfaces.nsISupportsString, str);
      } else {
        gPref.setBoolPref("extensions.speeddial.thumbnail-" + targetDial + "-dynamictitle", true);
        var str = Components.classes["@mozilla.org/supports-string;1"].createInstance(Components.interfaces.nsISupportsString);
        str.data = "";
        gPref.setComplexValue("extensions.speeddial.thumbnail-" + targetDial + "-label", Components.interfaces.nsISupportsString, str);
      }
      if (SpeedDialUtils.isFirefox3()) {
        gPref.setCharPref("extensions.speeddial.thumbnail-" + targetDial + "-icon", "data:");
      }
    } else {
      var promptService = Components.classes['@mozilla.org/embedcomp/prompt-service;1'].getService(Components.interfaces.nsIPromptService);
      promptService.alert(window, 
        speedDialBundle.getString("gadget.badformattitle"), 
        speedDialBundle.getString("gadget.badformat"));
      return false;
    }

  } else if (currentTab == PLUGIN_CUSTOM) {
    SpeedDialUtils.deassignThumbnail(targetDial);
    gPref.setCharPref("extensions.speeddial.thumbnail-" + targetDial + "-url", "plugin:" + document.getElementById("url").value);
    gPref.setBoolPref("extensions.speeddial.thumbnail-" + targetDial + "-dynamictitle", true);
    var str = Components.classes["@mozilla.org/supports-string;1"].createInstance(Components.interfaces.nsISupportsString);
    str.data = "";
    gPref.setComplexValue("extensions.speeddial.thumbnail-" + targetDial + "-label", Components.interfaces.nsISupportsString, str);
    if (SpeedDialUtils.isFirefox3()) {
      gPref.setCharPref("extensions.speeddial.thumbnail-" + targetDial + "-icon", "data:");
    }
  }
  
  
  return true;
}

function onCancel(event) {
  if (retVals != null) {
    retVals.canceled = true;
  }
  return true;
}

function openFullEdit() {
  window.opener.openDialog("chrome://speeddial/content/editDial.xul", "",
             "centerscreen,chrome,dialog,resizable,dependent",
             targetDial);
  window.close();
}

function openURL(aURL)
{
   if (aURL == null) aURL = "about:blank";
   
   var windowManager = Components.classes["@mozilla.org/appshell/window-mediator;1"]
           .getService(Components.interfaces.nsIWindowMediator);

   // check for an existing window and focus it; it's not application modal
   var anyWindow = windowManager.getMostRecentWindow("navigator:browser");

   if (!anyWindow) {
     var hiddenWin = Components.classes[ "@mozilla.org/appshell/appShellService;1" ].
		getService(Components.interfaces.nsIAppShellService).
		hiddenDOMWindow;
     hiddenWin.open(aURL, "_blank");
   } else {
     anyWindow.open(aURL, "_blank");
   }
}
