/* blink
 *
 * flash a keyboard leds for a short time
 * 
 * (C) 2004 by Michal Kwiatkowski <ruby@joker.linuxstuff.pl>
 */

/*
 * COMPILE
 * $ cc blink.c -o blink
 * 
 * USAGE
 * $ blink x
 *    where x is a number from 1 to 7, representing
 *    leds state you want to have
 */


#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <linux/kd.h>


#define DELAY 50000 /* you won't need to touch that mostly */

static int blink(int mask);


int main(int argc, char *argv[])
{
	int ledstate;

	if (argc != 2)
		return 1;

	ledstate = atoi(argv[1]);

	if (ledstate > 0 && ledstate < 8)
		blink(ledstate);

	return 0;
}

static int blink(int mask)
{
	int fd;
	long int led = 0;

	if ((fd = open("/dev/console", O_NOCTTY)) == -1)
		return 1;

	if (ioctl(fd, KDGETLED, &led) == -1)
		return 1;

	if (ioctl(fd, KDSETLED, led^mask) == -1)
		return 1;

	usleep(DELAY);

	ioctl(fd, KDSETLED, 8|led);

	return 0;
}

