/*
 * This file is part of signon-plugin-google
 *
 * Copyright (C) 2011 Canonical Ltd.
 *
 * Contact: Alberto Mardegan <alberto.mardegan@canonical.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 */

#ifndef SIGNON_GOOGLE_PLUGIN_TEST_H
#define SIGNON_GOOGLE_PLUGIN_TEST_H

#include "plugin.h"

#include <QEventLoop>
#include <QNetworkReply>
#include <SignOn/AuthPluginInterface>

class GooglePluginTest: public QObject
{
    Q_OBJECT

public slots:
    void result(const SignOn::SessionData &data);
    void pluginError(const SignOn::Error &err);
    void uiRequest(const SignOn::UiSessionData &data);
    void store(const SignOn::SessionData &data);
    void aborted(QNetworkReply *reply);

private slots:
    void initTestCase();
    void cleanupTestCase();
    void init();
    void cleanup();

    //test cases
    void testPlugin();
    void testPluginType();
    void testMechanisms();
    void testCancel();
    void testProcessValidate();
    void testProcess();

private:
    GooglePlugin::Plugin *m_testPlugin;
    bool m_errorEmitted;
    SignOn::Error m_error;
    bool m_responseEmitted;
    SignOn::SessionData m_response;
    bool m_userActionRequiredEmitted;
    SignOn::UiSessionData m_uiRequest;
    SignOn::SessionData m_stored;
    QEventLoop m_loop;
};

#endif // SIGNON_GOOGLE_PLUGIN_TEST_H
