/*
 * DeployLockShceduleRequ.cpp
 *
 *  Created on: 2008-12-10
 *      Author: root
 */

/*
 * SearchPRGMRequ.cpp
 *
 *  Created on: 2008-9-16
 *      Author: stanley
 */

#ifdef _DEBUG
#include <list>
#include <string>
#endif

#include "libsesdata.h"
#include "SESOperator.h"
#include "StudentMgr.h"
#include "TeacherPolicySettingData.h"
#include "CSESLog.h"
using namespace std;
using namespace LibSESData;
CDeployLockShceduleRequ::CDeployLockShceduleRequ()
{
}

CDeployLockShceduleRequ::~CDeployLockShceduleRequ()
{
	CSESLog::WriteLine(CSESLogData::LOG_TEACHER_PROGRAMSEARCH, "CSearchPRGMRequ::~CSearchPRGMRequ -- All finished!");
}

bool CDeployLockShceduleRequ::SendRequ(CIntfData& myData)
{
	CSESLog::WriteLine(CSESLogData::LOG_TEACHER_DEPLOYSCHDULE, "CDeployLockShceduleRequ::SendRequ >>Start!");

	std::list<std::string> studentList;
	myData.ParaXmlDoc.getListPara(studentList);
	std::string schedulePolicyXML;
	myData.ParaXmlDoc.getString("schedulePolicyXML", schedulePolicyXML);

	if ( ( 0 == studentList.size() ) || (true == schedulePolicyXML.empty() ) )
	{
		Disconnect("");
		return false;
	}

	myData.GetOperationID(OperationID);

	string teacherpolicyupdatedatapath = CONFIG_FILE_DIR + TEACHERPOLICYSETTING ;
	CTeacherPolicySettingData teacherpolicyupdatedata;
	teacherpolicyupdatedata.LoadFromFile(teacherpolicyupdatedatapath);

	string teacherInfoFile = CONFIG_FILE_DIR + TEACHER_INFO;
	string ControllerName;
	LibSESData::CTeacherInfoData* pTeacher = new LibSESData::CTeacherInfoData();
	if (0 == pTeacher->LoadFromFile(teacherInfoFile))
	{
		ControllerName = pTeacher->GetTeacherName();
		delete pTeacher;
	}else
	{
		delete pTeacher;
		return false;
	}
	CIntfData cIntfData;
	cIntfData.SetOperationID(OperationID);
	cIntfData.SetMessage(TEACHER_DEPLOYSCHEDULEPOLICY);
	cIntfData.ParaXmlDoc.setString("schedulePolicyXML",
			schedulePolicyXML);
	list<std::string>::iterator ir;
	list<std::string>::iterator para_begin = studentList.begin();
	list<std::string>::iterator para_end = studentList.end();
	for (ir = para_begin; ir != para_end; ir++)
	{
		cIntfData.SetStudentID((*ir));
		m_StudentIDList.push_back((*ir));
		pStudentMgr->Send(cIntfData);
		teacherpolicyupdatedata.UpdateInfo(*ir, ControllerName);
	}

	teacherpolicyupdatedata.Save2File(teacherpolicyupdatedatapath);

	CSESLog::WriteLine(CSESLogData::LOG_TEACHER_DEPLOYSCHDULE, "CDeployLockShceduleRequ::SendRequ >>End!");
	return true;
}

bool CDeployLockShceduleRequ::RecvResp(CIntfData& myData)
{
	std::string studentID;
	myData.GetStudentID(studentID);
	return filter(studentID);
}

int CDeployLockShceduleRequ::GetOperationID()
{
	return OperationID;

}
bool CDeployLockShceduleRequ::filter(std::string studentID)
{
	CSESLog::WriteLine(CSESLogData::LOG_TEACHER_DEPLOYSCHDULE, "CDeployLockShceduleRequ::filter--Get Reply from network, StudentID = "+ studentID);
	if(true == studentID.empty())
	{
		return false;
	}
	list<std::string>::iterator ir;
	list<std::string>::iterator para_begin = m_StudentIDList.begin();
	list<std::string>::iterator para_end = m_StudentIDList.end();

	for (ir = para_begin; ir != para_end; ir++)
	{
		if(0 == (*ir).compare(studentID))
		{
			m_StudentIDList.erase(ir);
			break;
		}
	}
	return m_StudentIDList.empty();
}
bool CDeployLockShceduleRequ::Disconnect(std::string studentID)
{
	CIntfData* myData = new CIntfData();
	myData->SetMessage(TEACHER_DEPLOYSCHEDULEPOLICYCALLBACK);
	myData->SetStudentID(studentID);
	myData->SetResult(SES_API_SUCCESS);
	myData->ParaXmlDoc.setString("bSuccess", METHOD_FALSE);
	CSESLog::WriteLine(CSESLogData::LOG_TEACHER_PROGRAMSEARCH, "Disconnect IPCTeacherDaemonAPI::SendMsg --Send Msg to Dbus >>Start!");
	TeacherDaemonAPI->SendMsg(myData);
	CSESLog::WriteLine(CSESLogData::LOG_TEACHER_PROGRAMSEARCH, "Disconnect IPCTeacherDaemonAPI::SendMsg --Send Msg to Dbus >>End!");
	delete myData;
	return filter(studentID);
}

bool CDeployLockShceduleRequ::CancelOperation(int OID)
{
	//not need notify student because too later

//	for(list<string>::iterator iter = m_StudentIDList.begin();
//	iter!= m_StudentIDList.end();iter++)
//	{
//		string strStuID = *iter;
//		CIntfData data;
//		data.SetStudentID(strStuID);
//		data.SetOperationID(this->OperationID);
//		data.SetMessage(TEACHER_CANCELOPERATION);
//		this->pStudentMgr->Send(data);
//	}

	CIntfData* myData = new CIntfData();
	myData->SetMessage(TEACHER_DEPLOYSCHEDULEPOLICYCALLBACK);
	myData->SetStudentID("");
	myData->ParaXmlDoc.setString("bSuccess", METHOD_FALSE);
	myData->SetResult(SES_API_FAILURE);
	CSESLog::WriteLine(CSESLogData::LOG_TEACHER_PROGRAMSEARCH, "CancelOperation IPCTeacherDaemonAPI::SendMsg --Send Msg to Dbus >>Start!");
	TeacherDaemonAPI->SendMsg(myData);
	CSESLog::WriteLine(CSESLogData::LOG_TEACHER_PROGRAMSEARCH, "CancelOperation IPCTeacherDaemonAPI::SendMsg --Send Msg to Dbus >>End!");
	delete myData;

	return true;
}
