#ifndef REGMGR_H_
#define REGMGR_H_
#include "libsesdata.h"
#include <vector>
#include "ace/Singleton.h"
#include "ace/Synch_Traits.h"
#include <ace/Thread_Manager.h>
#include <IntfData.h>
#include "TSDCommon.h"
#include <ace/Recursive_Thread_Mutex.h>
#include <ace/SSL/SSL_Context.h>

#include <ace/Event_Handler.h>
class CACE_SSL_Context;
class CStudentMgr;
class Student;
class CNetSSLClientWrapper;
class COperationManager;
#include  "NetSSLServerWrapper.h"
using namespace IPCAPI;
class RegMgr
{
public:
	RegMgr();
	virtual ~RegMgr();

	static RegMgr *instance(void);

public:
	int iThread;
	//When accept a  new student  mp_AcceptCallBack()
	int Accept(int iPort = 8888, int iDownloadPort = 8889);

	bool StopAccept();

	bool RegisterCOperationManager(COperationManager* cOperationManager);

	bool UpdateStudent(std::string& studentID, StudentInfo_t& studentInfo_t,
			bool bAllow);

	//bool ControlNewStudent(std::string& studentID, bool bAllow,CIntfData& cIntfData);


public:

	//These methods will not be used.

	//for stumgr
	bool AddNewStudent(Student* student, const std::string& studentId);

	//not use any more
	void Setmp_AcceptCallBack(void(*p)(CIntfData& intfData));

	void setPassword(const std::string& password)
	{
		m_Password = password;
	}
	std::string GetPassword() const
	{

		return m_Password;
	}

	ACE_SSL_Context* GetContext()
	{
		return m_pContext;
	}
	void AddStudent(std::string &stuId,
			CNetSSLClientWrapper* cNetSSLClientWrapper);

	static void* RegMgrThread(void *arg);
	bool IsPort(int iport)
	{
		return (m_iPort == iport);
	}
private:

	//void RegMgrCallback(CIntfData& intfData);
	void RegMgrCallback();

	void StartOpen();

	//	bool SetStudentInfo(std::string &strIntfData,Student* student);

	int SendCARoot();

private:
	int m_iPort;
	//void (*mp_AcceptCallBack)(CIntfData& intfData);

	CNetSSLServerWrapper m_cNetSSLServerWrapper;

	CNetSSLServerWrapper m_cNetSSLServerWrapper2;

	ACE_SSL_Context *m_pContext;
	int m_Errno;

	bool bStart;

	bool m_bFirst;
	std::vector<Student*> m_StuVector;

	//for RegMgr::Accept


	COperationManager* mp_COperationManager;

	ACE_Recursive_Thread_Mutex m_ErrnoLock;
	ACE_Reactor* mp_ACE_Reactor;
	std::string m_Password;
	ACE_thread_mutex_t mc_mgr_lock;
};

#endif /*REGMGR_H_*/
