/******************************************************************************
 * File Name    : SelectClassWindow.cpp
 * Created      : 2008/9/10
 * Author       : lfeng@neusoft.com
 * Model        :
 * Description  :
 ******************************************************************************/
#include "SelectClassWindow.h"
#include "ShellControllerWindow.h"
#include "libsesdata.h"
#include <glib/gi18n.h>
#include "libsesgui.h"


using namespace LibSESData;
using namespace std;
using namespace IPCAPI;
using namespace LibSESGUI;

namespace ShellController
{

enum
{
	COLUMN_ITEM_PIXBUF,
	COLUMN_ITEM_CLASSNAME,
	COLUMN_ITEM_CLASS,
	NUM_ITEM_COLUMNS
};
/******************************************************************************
 * Function Name: SelectClassWindow
 * Description  : Constructor of SelectClassWindow
 * Date         : 2008/9/10
 * Parameter    : pTeacherApiRef	IPCTeacherAPI
 * 				  pClassGroup		CClassGroupData
 * 				  pSelectedClass	CClassDef
 * Return Code  :
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
#if 0
SelectClassWindow::SelectClassWindow(IPCTeacherAPI* pTeacherApiRef,	CClassGroupData* pClassGroup, CClassDef* pSelectedClass)
{
	CSESLog::WriteLine("SelectClassWindow::SelectClassWindow<<Start");

	m_gWindow = NULL;
	m_gGtkTreeview = NULL;
	m_gEditBtn = NULL;
	m_gAddBtn = NULL;
	m_gDeleteBtn = NULL;
	m_pSelectClassPic = NULL;

	//m_pClassGroup = pClassGroup;
	m_pSelectedClass = pSelectedClass;

	m_pEditGroupWindow = NULL;

	m_IsOpenForAll = -1;
	m_iResult = 0;
	m_iInitail = 0;
	//m_isSelection = isFileSelection;

	m_pShellControllerWindow = NULL;

	CSESLog::WriteLine("SelectClassWindow::SelectClassWindow>>End");
}

#endif

SelectClassWindow::SelectClassWindow(std::string selectedClass)
{
	CSESLog::WriteLine("SelectClassWindow::SelectClassWindow<<Start");

	m_SelectClass = selectedClass;

	m_gWindow = NULL;
	m_gGtkTreeview = NULL;
	m_gEditBtn = NULL;
	m_gAddBtn = NULL;
	m_gDeleteBtn = NULL;
	m_pSelectClassPic = NULL;

	//m_pClassGroup = NULL;
	//m_pSelectedClass = NULL;

	m_pEditGroupWindow = NULL;

	m_IsOpenForAll = -1;
	m_iResult = 0;
	m_iInitail = 0;
	//m_isSelection = isFileSelection;

	m_pShellControllerWindow = NULL;

	CSESLog::WriteLine("SelectClassWindow::SelectClassWindow<<Start");
}

/******************************************************************************
 * Function Name: ~SelectClassWindow
 * Description  : Destructor of SelectClassWindow
 * Date         : 2008/9/10
 * Parameter    : pTeacherApiRef
 * Return Code  :
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
SelectClassWindow::~SelectClassWindow()
{
	CSESLog::WriteLine("SelectClassWindow::~SelectClassWindow<<Start");

	if (NULL != m_pEditGroupWindow)
	{
		delete m_pEditGroupWindow;
		m_pEditGroupWindow = NULL;
	}

	g_object_unref(m_pSelectClassPic);

	ReleasePixbuf();

	CSESLog::WriteLine("SelectClassWindow::~SelectClassWindow>>End");
}
/******************************************************************************
 * Function Name: CreateTreeView
 * Description  : Create treeview
 * Date         : 2008/9/10
 * Parameter    : parent 	parent GtkWidget
 * Return Code  : GtkWidget
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
GtkWidget* SelectClassWindow::CreateTreeView(GtkWidget* parent)
{
	CSESLog::WriteLine("SelectClassWindow::CreateTreeView<<Start");
	GtkWidget* treeview = NULL;
	GtkCellRenderer* renderer = NULL;
	GtkTreeViewColumn* column = NULL;

	GtkListStore* store = gtk_list_store_new(NUM_ITEM_COLUMNS, GDK_TYPE_PIXBUF, G_TYPE_STRING, G_TYPE_INT);
	//g_signal_connect(G_OBJECT(store), "row-changed", G_CALLBACK (SelectionChanged), this);
	//list<CClassDef*>* classgroup_list = m_pClassGroup->GetPClassInfoList();
	list<CClassDef*>* classgroup_list = m_ClassGroup.GetPClassInfoList();
	list<CClassDef*>::iterator class_list_iter;
	list<CStudentInfoData*>::iterator student_info_iter;
	GtkTreeIter iter;
	for (class_list_iter = classgroup_list->begin(); class_list_iter != classgroup_list->end(); ++class_list_iter)
	{
		CClassDef* pClassDef = *class_list_iter;
		gtk_list_store_append(store, &iter);
		gtk_list_store_set(store, &iter, COLUMN_ITEM_PIXBUF, m_pSelectClassPic, COLUMN_ITEM_CLASSNAME, pClassDef->GetName().c_str(), COLUMN_ITEM_CLASS, pClassDef, -1);
	}
	gtk_list_store_append(store, &iter);
	gtk_list_store_set(store, &iter, COLUMN_ITEM_PIXBUF, m_pSelectClassPic, COLUMN_ITEM_CLASSNAME, _(OPEN_FOR_ALL_STUDENT.c_str()), COLUMN_ITEM_CLASS, NULL, -1);
	treeview = gtk_tree_view_new_with_model(GTK_TREE_MODEL(store));
	g_signal_connect (G_OBJECT (treeview), "cursor-changed", G_CALLBACK (SelectionChanged), this);
	gtk_tree_view_columns_autosize(GTK_TREE_VIEW(treeview));

	gtk_tree_view_set_rules_hint(GTK_TREE_VIEW (treeview), TRUE);
	gtk_widget_set_size_request(treeview, 300, 190);
	gtk_container_add(GTK_CONTAINER (parent), treeview);
	gtk_tree_view_set_headers_visible(GTK_TREE_VIEW(treeview), FALSE);
	//gtk_tree_view_set_reorderable(GTK_TREE_VIEW(treeview), FALSE);
	gtk_tree_view_set_enable_search(GTK_TREE_VIEW(treeview), FALSE);

	//gtk_tree_selection_set_mode(gtk_tree_view_get_selection(GTK_TREE_VIEW(treeview)), GTK_SELECTION_SINGLE);

	renderer = gtk_cell_renderer_pixbuf_new();
	column = gtk_tree_view_column_new_with_attributes("", renderer, "pixbuf", 0, NULL);
	gtk_tree_view_append_column(GTK_TREE_VIEW (treeview), column);

	renderer = gtk_cell_renderer_text_new();
	//g_object_set(renderer, "ellipsize", PANGO_ELLIPSIZE_END, NULL);
	column = gtk_tree_view_column_new_with_attributes("", renderer, "text", 1, NULL);
	gtk_tree_view_append_column(GTK_TREE_VIEW(treeview), column);
	gtk_tree_view_column_set_resizable (GTK_TREE_VIEW_COLUMN (column), true);
	gtk_tree_view_column_set_min_width(GTK_TREE_VIEW_COLUMN (column), 80);

	gtk_widget_show(treeview);
	CSESLog::WriteLine("SelectClassWindow::CreateTreeView>>End");
	return treeview;
}
/******************************************************************************
 * Function Name: InitButtons
 * Description  : Init buttons
 * Date         : 2008/9/10
 * Parameter    : parent 	parent GtkWidget
 * Return Code  : OK		return 0;
 * 				  FAILURE	return -1;
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
int SelectClassWindow::InitRightButtons(GtkWidget* parent)
{
	CSESLog::WriteLine("SelectClassWindow::InitButtons<<Start");
	//GtkWidget* button = NULL;
//	GtkWidget* hbox = NULL;
//	hbox = gtk_hbox_new(FALSE, 0);
//	gtk_box_pack_start(GTK_BOX (parent), hbox, FALSE, FALSE, 10);
//	gtk_widget_show(hbox);

	m_gAddBtn = gtk_button_new_with_label(_("Add..."));
	g_signal_connect (G_OBJECT (m_gAddBtn), "clicked", SES_G_CALLBACK(AddGroup), this);
	gtk_widget_set_tooltip_text (m_gAddBtn, _("Add..."));
	gtk_widget_set_size_request(m_gAddBtn, 80, 30);
	gtk_box_pack_start(GTK_BOX (parent), m_gAddBtn, FALSE, FALSE, 20);
	//gtk_widget_show(m_gAddBtn);

	m_gEditBtn = gtk_button_new_with_label(_("Edit..."));
	g_signal_connect (G_OBJECT (m_gEditBtn), "clicked", SES_G_CALLBACK(EditGroup), this);
	gtk_widget_set_tooltip_text (m_gEditBtn, _("Edit..."));
	gtk_widget_set_sensitive(m_gEditBtn, FALSE);
	gtk_widget_set_size_request(m_gEditBtn, 80, 30);
	gtk_box_pack_start(GTK_BOX (parent), m_gEditBtn, FALSE, FALSE, 20);
	//gtk_widget_show(m_gEditBtn);

	m_gDeleteBtn = gtk_button_new_with_label(_("Delete"));
	g_signal_connect (G_OBJECT (m_gDeleteBtn), "clicked", SES_G_CALLBACK(RemoveGroup), this);
	gtk_widget_set_tooltip_text (m_gDeleteBtn, _("Delete"));
	gtk_widget_set_sensitive(m_gDeleteBtn, FALSE);
	gtk_widget_set_size_request(m_gDeleteBtn, 80, 30);
	gtk_box_pack_start(GTK_BOX (parent), m_gDeleteBtn, FALSE, FALSE, 20);
	//gtk_widget_show(m_gDeleteBtn);

//	hbox = gtk_hbox_new(FALSE, 0);
//	gtk_box_pack_start(GTK_BOX (parent), hbox, FALSE, FALSE, 0);
//	gtk_widget_show(hbox);
//
//	button = gtk_button_new_with_label(_("OK"));
//	gtk_signal_connect (GTK_OBJECT(button), "clicked", SES_G_CALLBACK(SelectClassWindow::OKGroup), this);
//	gtk_widget_set_tooltip_text (button, _("OK"));
//	gtk_widget_set_size_request(button, 80, 30);
//	gtk_box_pack_end(GTK_BOX (hbox), button, FALSE, FALSE, 10);
//	gtk_widget_show(button);
//
//	button = gtk_button_new_with_label(_("Cancel"));
//	gtk_signal_connect (GTK_OBJECT(button), "clicked", SES_G_CALLBACK(CancelGroup), this);
//	gtk_widget_set_tooltip_text (button, _("Cancel"));
//	gtk_widget_set_size_request(button, 80, 30);
//	gtk_box_pack_end(GTK_BOX (hbox), button, FALSE, FALSE, 0);
//	gtk_widget_show(button);


	CSESLog::WriteLine("SelectClassWindow::InitButtons>>End");
	return 0;
}

int SelectClassWindow::InitBottomButtons(GtkWidget* parent)
{
    GtkWidget* button = gtk_button_new_with_label(_("OK"));
    gtk_signal_connect (GTK_OBJECT(button), "clicked", SES_G_CALLBACK(SelectClassWindow::OKGroup), this);
    gtk_widget_set_tooltip_text (button, _("OK"));
    gtk_widget_set_size_request(button, 80, 30);
    gtk_box_pack_end(GTK_BOX (parent), button, FALSE, FALSE, 80);
    //gtk_widget_show(button);

    button = gtk_button_new_with_label(_("Cancel"));
    gtk_signal_connect (GTK_OBJECT(button), "clicked", SES_G_CALLBACK(CancelGroup), this);
    gtk_widget_set_tooltip_text (button, _("Cancel"));
    gtk_widget_set_size_request(button, 80, 30);
    gtk_box_pack_start(GTK_BOX (parent), button, FALSE, FALSE, 80);
    //gtk_widget_show(button);
    return 0;
}

/******************************************************************************
 * Function Name: InitWindow
 * Description  : Init main window
 * Date         : 2008/9/10
 * Parameter    : VOID
 * Return Code  : OK		return 0;
 * 				  FAILURE	return -1;
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
int SelectClassWindow::InitWindow()
{
	CSESLog::WriteLine("SelectClassWindow::InitWindow<<Start");
	GtkWidget* pMainVbox = NULL;
	GtkWidget* scrolled_window = NULL;
	string selectClassPicPath = SES_TEACHER_ICON;
	m_pSelectClassPic = gdk_pixbuf_new_from_file_at_size (selectClassPicPath.c_str(), 24, 24, NULL);

	m_gWindow = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	g_signal_connect (G_OBJECT(m_gWindow), "delete_event", G_CALLBACK(OnWindowClosing), this);
	//g_signal_connect (G_OBJECT (m_gWindow), "show", G_CALLBACK (WindowShow), this);
	gtk_window_set_title(GTK_WINDOW (m_gWindow), _("Select Class"));
	// added by dengjing
	gtk_window_set_wmclass (GTK_WINDOW(m_gWindow), _("Select Class"), "SES");
	gtk_container_set_border_width(GTK_CONTAINER (m_gWindow), 0);
	gtk_window_set_type_hint(GTK_WINDOW (m_gWindow), GDK_WINDOW_TYPE_HINT_DIALOG);
	gtk_widget_set_has_tooltip(m_gWindow, FALSE);
	gtk_window_set_position(GTK_WINDOW (m_gWindow), GTK_WIN_POS_CENTER_ON_PARENT);
	gtk_widget_set_size_request(m_gWindow, 400, 265);
	gtk_window_set_resizable(GTK_WINDOW(m_gWindow), FALSE);
	gtk_window_set_skip_taskbar_hint(GTK_WINDOW(m_gWindow), TRUE);

	string iconPath("");
    iconPath.append(SES_RESOURCE_IMAGE_PATH);
    iconPath.append("shellcontroller_main.png");

    GError** error = NULL;
    gtk_window_set_icon_from_file(GTK_WINDOW(m_gWindow), SES_SHELL_CONTROLLER_ICON.c_str(), error);

	pMainVbox = gtk_vbox_new(FALSE, 0);
	gtk_container_add(GTK_CONTAINER (m_gWindow), pMainVbox);
	//gtk_widget_show(pMainVbox);

	GtkWidget* pHbox = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(pMainVbox), pHbox, FALSE, FALSE, 0);

	GtkWidget* pVbox = gtk_vbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(pHbox), pVbox, FALSE, FALSE, 0);

	scrolled_window = gtk_scrolled_window_new(NULL, NULL);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW(scrolled_window), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
	gtk_box_pack_start(GTK_BOX(pVbox), scrolled_window, FALSE, FALSE, 0);
	gtk_widget_set_size_request(scrolled_window, 315, 190);
	//gtk_widget_show(scrolled_window);
	m_gGtkTreeview = CreateTreeView(scrolled_window);

	pVbox = gtk_vbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(pHbox), pVbox, FALSE, FALSE, 4);

	InitRightButtons(pVbox);

//	pHbox = gtk_hbox_new(FALSE, 0);
//	gtk_box_pack_start(GTK_BOX(pMainVbox), pHbox, FALSE, FALSE, 0);

	GtkWidget* pSeparator = gtk_hseparator_new();
	//gtk_widget_set_size_request(pSeparator, 20, 1);
	gtk_box_pack_start(GTK_BOX(pMainVbox), pSeparator, false, false, 0);

	pHbox = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_end(GTK_BOX(pMainVbox), pHbox, FALSE, FALSE, 10);

	InitBottomButtons(pHbox);

	CSESLog::WriteLine("SelectClassWindow::InitWindow>>End");

	return 0;
}

int SelectClassWindow::InitClassGroup()
{
	int ret = 0;

	ret = m_ClassGroup.LoadFromFile(LibSESData::CONFIG_FILE_DIR + LibSESData::CLASS_GROUP);

	return ret;
}


/******************************************************************************
 * Function Name: Init
 * Description  : Init function
 * Date         : 2008/9/10
 * Parameter    : VOID
 * Return Code  : OK		return 0;
 * 				  FAILURE	return -1;
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
int SelectClassWindow::Init()
{
	CSESLog::WriteLine("SelectClassWindow::Init<<Start");

	InitClassGroup();

	InitWindow();


	CSESLog::WriteLine("SelectClassWindow::Init>>End");
	return 0;
}
/******************************************************************************
 * Function Name: ShowModal
 * Description  : Make SelectClassWindow in modal style
 * Date         : 2008/9/10
 * Parameter    : parent		parent GtkWidget
 * 				  cb			callback function
 * 				  data			user data
 * Return Code  : OK		return 0;
 * 				  FAILURE	return -1;
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
int SelectClassWindow::ShowModal(GtkWidget* parentWindow, GCallback cb, gpointer data)
{
	CSESLog::WriteLine("SelectClassWindow::ShowModal<<Start");
	gtk_window_set_transient_for(GTK_WINDOW(m_gWindow), GTK_WINDOW(parentWindow));
	gtk_window_set_modal(GTK_WINDOW(m_gWindow), true);

	m_pShellControllerWindow = (ShellControllerWindow*)data;

	if (NULL != cb)
	{
		g_signal_connect (G_OBJECT(m_gWindow), "destroy", G_CALLBACK (cb), data);
	}
	gtk_widget_show_all(m_gWindow);
	CSESLog::WriteLine("SelectClassWindow::ShowModal>>End");
	return 0;
}
/******************************************************************************
 * Function Name: EditGroup
 * Description  : Edit Group
 * Date         : 2008/9/10
 * Parameter    : gtkwidget		GtkWidget which triggers the event
 * 				  data			user data
 * Return Code  : VOID
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
void SelectClassWindow::EditGroup(GtkWidget* gtkwidget, gpointer data)
{
	CSESLog::WriteLine("SelectClassWindow::EditGroup<<Start");
	GtkTreeModel* model = NULL;
	GtkTreeIter iter;
	GtkTreeSelection* selection = NULL;
	selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(m_gGtkTreeview));
	model = gtk_tree_view_get_model(GTK_TREE_VIEW(m_gGtkTreeview));
	if (gtk_tree_selection_get_selected(selection, NULL, &iter))
	{
		CClassDef* pClass = NULL;
		gtk_tree_model_get (model, &iter, COLUMN_ITEM_CLASS, &pClass, -1);

		if(NULL != pClass)
		{
			if (NULL != m_pEditGroupWindow)
			{
				delete m_pEditGroupWindow;
				m_pEditGroupWindow = NULL;
			}

			m_pEditGroupWindow = new EditGroupWindow(0, pClass, &m_ClassGroup);
			m_pEditGroupWindow->Init();
			m_pEditGroupWindow->ShowModal(m_gWindow, SES_G_CALLBACK(AddEditGroupClosed), (SelectClassWindow*)data);
		}
	}
	CSESLog::WriteLine("SelectClassWindow::EditGroup>>End");
}
/******************************************************************************
 * Function Name: AddGroup
 * Description  : Add Group
 * Date         : 2008/9/10
 * Parameter    : gtkwidget		GtkWidget which triggers the event
 * 				  data			user data
 * Return Code  : VOID
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
void SelectClassWindow::AddGroup(GtkWidget* gtkwidget, gpointer data)
{
	CSESLog::WriteLine("SelectClassWindow::AddGroup<<Start");

	if (NULL != m_pEditGroupWindow)
	{
		delete m_pEditGroupWindow;
		m_pEditGroupWindow = NULL;
	}

	m_pEditGroupWindow = new EditGroupWindow(1, NULL, &m_ClassGroup);
	m_pEditGroupWindow->Init();
	m_pEditGroupWindow->ShowModal(m_gWindow, SES_G_CALLBACK(AddEditGroupClosed), this);
	CSESLog::WriteLine("SelectClassWindow::AddGroup<<End");
}
/******************************************************************************
 * Function Name: RemoveGroup
 * Description  : Remove Group
 * Date         : 2008/9/10
 * Parameter    : gtkwidget		GtkWidget which triggers the event
 * 				  data			user data
 * Return Code  : VOID
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
void SelectClassWindow::RemoveGroup(GtkWidget* gtkwidget, gpointer data)
{
	CSESLog::WriteLine("SelectClassWindow::RemoveGroup >>Start");

	GtkTreeModel* model = NULL;
	GtkTreeIter iter;
	GtkTreeSelection* selection = NULL;

	model = gtk_tree_view_get_model(GTK_TREE_VIEW(m_gGtkTreeview));
	selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(m_gGtkTreeview));

	if (gtk_tree_selection_get_selected(selection, &model, &iter))
	{
		CClassDef* pClass = NULL;
		gtk_tree_model_get(model, &iter, COLUMN_ITEM_CLASS, &pClass, -1);
		if (NULL != pClass)
		{
//			GtkWidget* dialog = gtk_message_dialog_new (GTK_WINDOW (m_gWindow),
//									   GTK_DIALOG_MODAL,
//									   GTK_MESSAGE_QUESTION,
//									   GTK_BUTTONS_YES_NO,
//									   _("Do you want to delete the class?"));
		    string message(_("Do you want to delete the class?"));
		    int result = CMessageBox::Show(message, m_gWindow, GTK_MESSAGE_QUESTION, GTK_BUTTONS_YES_NO);
//			if( NULL != dialog )
//			{
//				gtk_window_set_title(GTK_WINDOW(dialog), _("Information"));
				if ( GTK_RESPONSE_YES == result )
				{
					gtk_list_store_remove(GTK_LIST_STORE (model), &iter);
					//				list<CClassDef*>::iterator classIter;
					//				for(classIter == m_pClassGroup->GetPClassInfoList()->begin(); classIter != m_pClassGroup->GetPClassInfoList()->end(); ++classIter)
					//				{
					//					if((*classIter)->GetName() == pClass->GetName())
					//					{
					//
					//					}
					//				}

					//TODO Added by hm for work around
#if 0
                    if(m_pSelectedClass)
                    {
                        string selectedClassName = m_pSelectedClass->GetName();
                        if(selectedClassName == pClass->GetName())
                        {
                            m_pShellControllerWindow->NotifyClassIsDeleted(pClass->GetName());
                            m_pSelectedClass = NULL;
                        }
                    }
#endif

                    //if (m_SelectClass.size() > 0 && m_SelectClass == pClass->GetName())
                    //{
                    //	m_pShellControllerWindow->NotifyClassIsDeleted(pClass->GetName());
                    //}

                    // Notify main window this class has been deleted.
                    m_pShellControllerWindow->NotifyClassIsDeleted(pClass->GetName());

					m_ClassGroup.GetPClassInfoList()->remove(pClass);

					if(NULL != pClass)
					{
						delete pClass;
						pClass = NULL;
					}

					gtk_widget_set_sensitive(m_gEditBtn, false);
					gtk_widget_set_sensitive(m_gDeleteBtn, false);

					// Update Class File.
					SaveClassInfo();

				}
				//gtk_widget_destroy(dialog);
			//}
		}
	}
	CSESLog::WriteLine("SelectClassWindow::RemoveGroup <<End");
}

/******************************************************************************
 * Function Name: OnWindowClosing
 * Description  : Closing the main window
 * Date         : 2008/9/10
 * Parameter    : gtkwidget		GtkWidget which triggers the event
 * 				  event			The event
 * 				  data			user data
 * Return Code  : VOID
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
bool SelectClassWindow::OnWindowClosing(GtkWidget* gtkwidget, GdkEvent* event, gpointer data)
{
	CSESLog::WriteLine("SelectClassWindow::OnWindowClosing<<Start");
	SelectClassWindow* ptr = (SelectClassWindow*)data;
//	GtkWidget* dialog = NULL;
//	dialog = gtk_message_dialog_new (GTK_WINDOW (ptr->m_gWindow),
//					   GTK_DIALOG_MODAL,
//					   GTK_MESSAGE_INFO,
//					   GTK_BUTTONS_YES_NO,
//					   "Save your changes?");

//	if(GTK_RESPONSE_YES == gtk_dialog_run (GTK_DIALOG (dialog)))
//	{
		ptr->m_iResult = BUTTON_CLICK_IS_CANCEL;
		ptr->m_IsOpenForAll = -1;
		//ptr->m_pSelectedClass = NULL;
//		GtkTreeIter iter;
//		GtkTreeModel* model = gtk_tree_view_get_model(GTK_TREE_VIEW(ptr->m_gGtkTreeview));
//		GtkTreeSelection* selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(ptr->m_gGtkTreeview));
//		if (gtk_tree_selection_get_selected(selection, &model, &iter))
//		{
//			CClassDef* pClass = NULL;
//			gtk_tree_model_get(model, &iter, COLUMN_ITEM_CLASS, &pClass, -1);
//			if (NULL == pClass)
//			{
//				ptr->m_IsSelectAll = 1;
//				ptr->m_pSelectedClass = NULL;
//			}
//			else
//			{
//				ptr->m_IsSelectAll = 0;
//				ptr->m_pSelectedClass = pClass;
//			}
//		}
//	}
//	else
//	{
//		ptr->m_iResult = BUTTON_CLICK_IS_CANCEL;
//	}
	//gtk_widget_destroy(dialog);
	CSESLog::WriteLine("SelectClassWindow::OnWindowClosing>>End");
	return false;
}

EditGroupWindow* SelectClassWindow::GetEditGroupWindow()
{
	return this->m_pEditGroupWindow;
}

/******************************************************************************
 * Function Name: OKGroup
 * Description  : If click Ok button
 * Date         : 2008/9/10
 * Parameter    : gtkwidget		GtkWidget which triggers the event
 * 				  data			user data
 * Return Code  : VOID
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
void SelectClassWindow::OKGroup(GtkWidget* gtkwidget, gpointer data)
{
	CSESLog::WriteLine("SelectClassWindow::OKGroup<<Start");

	m_iResult = BUTTON_CLICK_IS_OK;

	GtkTreeIter iter;
	GtkTreeModel* model = gtk_tree_view_get_model(GTK_TREE_VIEW(m_gGtkTreeview));
	GtkTreeSelection*  selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(m_gGtkTreeview));
	if( TRUE == gtk_tree_selection_get_selected(selection, &model, &iter))
	{
		CClassDef* pClass = NULL;
		gtk_tree_model_get (model, &iter, COLUMN_ITEM_CLASS, &pClass, -1);
		if(NULL == pClass)
		{
			// Open For All Student is selected.
			m_IsOpenForAll = 1;
			//m_pSelectedClass = NULL;

			m_SelectClass = "";
			m_eClassSelectStatus = OpenForAll;
		}
		else
		{
			// Some Class is Selected.
			m_IsOpenForAll = 0;
			//m_pSelectedClass = pClass;

			m_SelectClass = pClass->GetName();
			m_eClassSelectStatus = SomeClass;
		}
	}
	else
	{
		// No class is selected.
		m_IsOpenForAll = 0;
		//m_pSelectedClass = NULL;

		m_SelectClass = "";
		m_eClassSelectStatus = NoClass;
	}

	gtk_widget_destroy(m_gWindow);
	CSESLog::WriteLine("SelectClassWindow::OKGroup>>End");
}

/******************************************************************************
 * Function Name: CancelGroup
 * Description  : Cancel Group
 * Date         : 2008/9/10
 * Parameter    : gtkwidget		GtkWidget which triggers the event
 * 				  data			user data
 * Return Code  : VOID
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
void SelectClassWindow::CancelGroup(GtkWidget* gtkwidget, gpointer data)
{
	CSESLog::WriteLine("SelectClassWindow::CancelGroup<<Start");
//	GtkWidget* dialog = NULL;
//	dialog = gtk_message_dialog_new (GTK_WINDOW (m_gWindow),
//					   GTK_DIALOG_MODAL,
//					   GTK_MESSAGE_INFO,
//					   GTK_BUTTONS_YES_NO,
//					   "Save your changes?");

//	if(GTK_RESPONSE_YES == gtk_dialog_run (GTK_DIALOG (dialog)))
//	{
		m_iResult = BUTTON_CLICK_IS_CANCEL;
//		m_IsOpenForAll = -1;
//		GtkTreeIter iter;
//		GtkTreeModel* model = gtk_tree_view_get_model(GTK_TREE_VIEW(m_gGtkTreeview));
//		GtkTreeSelection* selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(m_gGtkTreeview));
//		if (gtk_tree_selection_get_selected(selection, &model, &iter))
//		{
//			CClassDef* pClass = NULL;
//			gtk_tree_model_get(model, &iter, COLUMN_ITEM_CLASS, &pClass, -1);
//			if (NULL == pClass)
//			{
//				m_IsSelectAll = 1;
//				m_pSelectedClass = NULL;
//			}
//			else
//			{
//				m_IsSelectAll = 0;
//				m_pSelectedClass = pClass;
//			}
//		}
//		else
//		{
//			m_IsSelectAll = -1;
//		}
//	}
//	else
//	{
//		m_iResult = BUTTON_CLICK_IS_CANCEL;
//	}
	//gtk_widget_destroy(dialog);
	gtk_widget_destroy(m_gWindow);
	CSESLog::WriteLine("SelectClassWindow::CancelGroup>>End");

}

/******************************************************************************
 * Function Name: AddEditGroupClosed
 * Description  : Add or edit group complete
 * Date         : 2008/9/10
 * Parameter    : gtkwidget		GtkWidget which triggers the event
 * 				  data			user data
 * Return Code  : VOID
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
void SelectClassWindow::AddEditGroupClosed(GtkWidget* gtkwidget, gpointer data)
{
	CSESLog::WriteLine("SelectClassWindow::AddEditGroupClosed<<Start");

	//TODO Criticalsection with new student notification
	//	int result = 1;

	if(m_pEditGroupWindow->GetResult() == BUTTON_CLICK_IS_OK)
	{
		GtkTreeIter iter;
		GtkTreeModel* model = gtk_tree_view_get_model(GTK_TREE_VIEW(m_gGtkTreeview));

		if ( m_pEditGroupWindow->IsAddGroup() )
		{
			// add new class
			CClassDef* pAddEditClassDef = m_pEditGroupWindow->GetSelectedClass();

			CClassDef* pClass = pAddEditClassDef->Clone();

			//m_pClassGroup->GetPClassInfoList()->push_front(pClass);

			//m_pClassGroup->AddNewClass(0, pClass);
			//m_ClassGroup.AddNewClass(0, pClass);
			m_ClassGroup.GetPClassInfoList()->push_front(pClass);

			gtk_list_store_prepend(GTK_LIST_STORE (model), &iter);
			gtk_list_store_set(GTK_LIST_STORE(model), &iter,
					COLUMN_ITEM_PIXBUF, m_pSelectClassPic,
					COLUMN_ITEM_CLASSNAME,	pClass->GetName().c_str(),
					COLUMN_ITEM_CLASS,	pClass,
					-1);

			// Save to file
			//m_pClassGroup->Save2File(LibSESData::CONFIG_FILE_DIR + LibSESData::CLASS_GROUP);
			m_ClassGroup.Save2File(LibSESData::CONFIG_FILE_DIR + LibSESData::CLASS_GROUP);
		}
		else
		{
			// Udpate & Save to File.
			string previousClassName = m_pEditGroupWindow->GetPreviousClassName();

			CClassDef* pAddEditClassDef = m_pEditGroupWindow->GetSelectedClass();
			CClassDef* pClass = pAddEditClassDef->Clone();

			m_ClassGroup.UpdateExistedClass(previousClassName, pClass);

			m_ClassGroup.Save2File(LibSESData::CONFIG_FILE_DIR + LibSESData::CLASS_GROUP);

			// Update GUI if class name has been changed.
			GtkTreeSelection* selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(m_gGtkTreeview));
			if (gtk_tree_selection_get_selected(selection, &model, &iter))
			{
				gtk_list_store_set(GTK_LIST_STORE(model), &iter,
						COLUMN_ITEM_CLASSNAME,
						pClass->GetName().c_str(),
						COLUMN_ITEM_CLASS, pClass,
						-1);
			}

			// notify main windows.
			m_pShellControllerWindow->NotifyClassInfoChanged(previousClassName, pClass->GetName());

#if 0

			// edit existed class
			CClassDef* pAddEditClassDef = m_pEditGroupWindow->GetSelectedClass();
			CClassDef* pAddEditClassDefOri = m_pEditGroupWindow->GetSelectedOriRefClass();

			string orgClassName = pAddEditClassDefOri->GetName();
			string newClassName	= pAddEditClassDef->GetName();

			list<CStudentInfoData*>* pStudentList = new list<CStudentInfoData*> ();
			list<CStudentInfoData*>* pEditStudentList =	pAddEditClassDef->GetPStudentsInfoList();
			list<CStudentInfoData*>::iterator studentIter;
			for (studentIter = pEditStudentList->begin(); studentIter!= pEditStudentList->end(); studentIter++)
			{
				CStudentInfoData* pSrcStudentInfo = *studentIter;
				CStudentInfoData* pStudentInfo = new CStudentInfoData();
				pStudentInfo->SetStudentID(pSrcStudentInfo->GetStudentID());
				pStudentInfo->SetStudentName(pSrcStudentInfo->GetStudentName());
				pStudentList->push_back(pStudentInfo);
			}
//			CClassDef* pClassOriRef = m_pEditGroupWindow->GetSelectedOriRefClass();

			pAddEditClassDefOri->SetName(pAddEditClassDef->GetName());
			pAddEditClassDefOri->SetPStudentsInfoList(pStudentList);

			GtkTreeSelection* selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(m_gGtkTreeview));
			if (gtk_tree_selection_get_selected(selection, &model, &iter))
			{
				gtk_list_store_set(GTK_LIST_STORE(model), &iter,
								   COLUMN_ITEM_CLASSNAME,
								   pAddEditClassDefOri->GetName().c_str(),
								   -1);
			}

			//TODO: jinxin review find class dirty.

			// Save to file
			m_pClassGroup->Save2File(LibSESData::CONFIG_FILE_DIR + LibSESData::CLASS_GROUP);

			// notify main window to sync
			//TODO Added by hm for work around
			if(m_pSelectedClass)
			{
			    string selectedClassName = m_pSelectedClass->GetName();
			    if(selectedClassName == orgClassName)
			    {
			        m_pShellControllerWindow->NotifyClassInfoChanged(orgClassName, newClassName);
			        //ReInitialTreeView
			        CClassDef* tmpClass = NULL;
			        m_pClassGroup->GetClassInfo(newClassName, &tmpClass);

			        if(tmpClass)
			        {
			            m_pSelectedClass = tmpClass->Clone();
			        }

			        GtkWidget* parentContainer = gtk_widget_get_parent(m_gGtkTreeview);
			        if(parentContainer)
			        {
			            gtk_container_remove(GTK_CONTAINER(parentContainer), m_gGtkTreeview);
			            m_gGtkTreeview = CreateTreeView(parentContainer);
			            gtk_widget_set_sensitive(m_gEditBtn, FALSE);
			            gtk_widget_set_sensitive(m_gDeleteBtn, FALSE);
			        }
			    }
			}

#endif

		}



#if 0
		if (0 != pAddEditClassDef->GetName().size())
		{
			CClassDef* pAddEditClassDefOri = m_pEditGroupWindow->GetSelectedOriRefClass();
			list<CClassDef*>::iterator classIter;

			for (classIter = m_pClassGroup->GetPClassInfoList()->begin();
				 classIter != m_pClassGroup->GetPClassInfoList()->end();
				 ++classIter)
			{
				if ((*classIter)->GetName() == pAddEditClassDef->GetName())
				{
					if(pAddEditClassDefOri == NULL || pAddEditClassDefOri != *classIter)
					{
						result = 0;
						break;
					}
				}
			}

			if (1 == result)
			{
				if (NULL != pAddEditClassDef)
				{
					if (m_pEditGroupWindow->IsAddGroup())
					{
						CClassDef* pClass = pAddEditClassDef->Clone();
						m_pClassGroup->GetPClassInfoList()->push_front(pClass);
						//m_pSelectedClass = pClass;
						gtk_list_store_move_before(GTK_LIST_STORE(model), &iter, NULL);//TODO: jinxin review where is this iter come from.
						gtk_list_store_prepend(GTK_LIST_STORE (model), &iter);
						gtk_list_store_set(GTK_LIST_STORE(model), &iter,
								COLUMN_ITEM_PIXBUF, m_pSelectClassPic,
								COLUMN_ITEM_CLASSNAME,
								pClass->GetName().c_str(), COLUMN_ITEM_CLASS,
								pClass, -1);
					}
					else
					{
						list<CStudentInfoData*>* pStudentList = new list<CStudentInfoData*> ();
						list<CStudentInfoData*>* pEditStudentList =	pAddEditClassDef->GetPStudentsInfoList();
						list<CStudentInfoData*>::iterator studentIter;
						for (studentIter = pEditStudentList->begin(); studentIter
								!= pEditStudentList->end(); studentIter++)
						{
							CStudentInfoData* pSrcStudentInfo = *studentIter;
							CStudentInfoData* pStudentInfo = new CStudentInfoData();
							pStudentInfo->SetStudentID(pSrcStudentInfo->GetStudentID());
							pStudentInfo->SetStudentName(pSrcStudentInfo->GetStudentName());
							pStudentList->push_back(pStudentInfo);
						}
						CClassDef* pClassOriRef = m_pEditGroupWindow->GetSelectedOriRefClass();
						pClassOriRef->SetName(pAddEditClassDef->GetName());
						pClassOriRef->SetPStudentsInfoList(pStudentList);

						GtkTreeSelection* selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(m_gGtkTreeview));
						if (gtk_tree_selection_get_selected(selection, &model, &iter))
						{
							gtk_list_store_set((GtkListStore*) model, &iter, COLUMN_ITEM_CLASSNAME,
									pClassOriRef->GetName().c_str(), -1);
						}
					}
				}
			}
		}
#endif
	}
	else
	{
		CSESLog::WriteLine("Teacher choose cancel when edit or add class.");
	}

//	delete m_pEditGroupWindow;
//	m_pEditGroupWindow = NULL;
	CSESLog::WriteLine("SelectClassWindow::AddEditGroupClosed>>End");
}
/******************************************************************************
 * Function Name: IsSelectAll
 * Description  : Whether select all students or not
 * Date         : 2008/9/10
 * Parameter    : VOID
 * Return Code  : Select all		return 1;
 * 				  Select not all	return 0;
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
int SelectClassWindow::IsOpenForAll()
{
	return m_IsOpenForAll;
}
/******************************************************************************
 * Function Name: GetResult
 * Description  : Justify if click OK button or Cancel button
 * Date         : 2008/9/10
 * Parameter    : VOID
 * Return Code  : OK button			return 1;
 * 				  Cancel button		return 0;
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
int SelectClassWindow::GetResult()
{
	return m_iResult;
}
/******************************************************************************
 * Function Name: IsInitial
 * Description  : Justify whether the window is initial or not
 * Date         : 2008/9/10
 * Parameter    : VOID
 * Return Code  : YES			return 1;
 * 				  NOT			return 0;
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
int SelectClassWindow::IsInitial()
{
	return m_iInitail;
}
/******************************************************************************
 * Function Name: GetSelectedClass
 * Description  : Get selected class
 * Date         : 2008/9/10
 * Parameter    : VOID
 * Return Code  : CClassDef
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
//CClassDef* SelectClassWindow::GetSelectedClass()
//{
//	return m_pSelectedClass;
//}
/******************************************************************************
 * Function Name: SelectionChanged//TODO delete this function
 * Description  :
 * Date         : 2008/9/10
 * Parameter    : VOID
 * Return Code  : CClassDef
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
void SelectClassWindow::SelectionChanged(GtkTreeView* treeview,  gpointer data)
{
	SelectClassWindow* ptr= (SelectClassWindow*)data;
	GtkTreeIter iter;
	GtkTreeModel *model = gtk_tree_view_get_model(GTK_TREE_VIEW(ptr->m_gGtkTreeview));




	GtkTreePath *pPath = NULL;
	GtkTreeViewColumn *pFocusColumn = NULL;



	GtkTreeSelection *select = gtk_tree_view_get_selection(GTK_TREE_VIEW(ptr->m_gGtkTreeview));
	gtk_tree_view_get_cursor(treeview, &pPath, &pFocusColumn);
	if ( (NULL != pPath) && (TRUE == gtk_tree_model_get_iter(model, &iter, pPath)) )

	{
		gtk_tree_selection_select_iter(select, &iter);
		CClassDef* pClass = NULL;
		gtk_tree_model_get (model, &iter, COLUMN_ITEM_CLASS, &pClass, -1);
		if(NULL != pClass)
		{
			gtk_widget_set_sensitive(ptr->m_gEditBtn, TRUE);
			gtk_widget_set_sensitive(ptr->m_gDeleteBtn, TRUE);
		}
		else
		{
			gtk_widget_set_sensitive(ptr->m_gEditBtn, FALSE);
			gtk_widget_set_sensitive(ptr->m_gDeleteBtn, FALSE);
		}
	}



}

/******************************************************************************
 * Function Name: SaveClassInfo//TODO delete this function
 * Description  : Save class information
 * Date         : 2008/11/10
 * Parameter    : VOID
 * Return Code  : Ok		0
 *     			  Error		-1
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
// class info
// Dump the latest class info into local file.
int SelectClassWindow::SaveClassInfo()
{
	int ret = 0;
//	if (NULL != m_pClassGroup)
//	{
		//if ( LIBSESDATA_SUCCESS == m_pClassGroup->Save2File(CONFIG_FILE_DIR + CLASS_GROUP) )
		if ( LIBSESDATA_SUCCESS == m_ClassGroup.Save2File(CONFIG_FILE_DIR + CLASS_GROUP) )
		{
			ret = 1;
		}
		else
		{
//			GtkWidget* dialog = NULL;
//			dialog = gtk_message_dialog_new(GTK_WINDOW(m_gWindow),
//					GTK_DIALOG_DESTROY_WITH_PARENT,
//					GTK_MESSAGE_ERROR,
//					GTK_BUTTONS_OK,
//					_("Fail to save class information!"));

			string message(_("Fail to save class information!"));
		    CMessageBox::Show(message, m_gWindow, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK);

//            gtk_window_set_title(GTK_WINDOW(dialog), "Error");
//            gtk_dialog_run(GTK_DIALOG(dialog));
//            gtk_widget_destroy(dialog);

		}
//	}
	return ret;
}

void SelectClassWindow::ReleasePixbuf()
{
    g_object_unref(m_pSelectClassPic);
}

}
