/******************************************************************************
 * File Name    : EditGroupWindow.h
 * Created      : 2008/9/10
 * Author       : lfeng@neusoft.com
 * Model        :
 * Description  : The header file of EditGroupWindow
 ******************************************************************************/
#ifndef EDITGROUPWINDOW_H_
#define EDITGROUPWINDOW_H_
#include <gtk/gtk.h>
#include "seslib.h"
#include "ClassGroupData.h"
#include "libsesdata.h"
#include "SESCommonDef.h"
#include "IPCTeacherAPI.h"


class EditGroupWindow : public IPCAPI::CTeacherAPICallbackBase
{
public:
	EditGroupWindow(int IsAdd,
					LibSESData::CClassDef* pClass,
					//IPCAPI::IPCTeacherAPI* pTeacherApiRef,
					LibSESData::CClassGroupData* pClassGroup);

	~EditGroupWindow();

public:
	int Init();
	int ShowModal(GtkWidget* parentWindow, GCallback cb, gpointer data);
	void SetEntry(gchar*);

	static void Move2Left(GtkTreeView*, gchar*, GtkTreeViewColumn*, gpointer);
	static void Move2Right(GtkTreeView*, gchar*, GtkTreeViewColumn*, gpointer);
	static void MoveLeft(GtkWidget*, gpointer);
	static void MoveRight(GtkWidget*, gpointer);
	static void OnOK(GtkWidget*, gpointer data);
	static void OnCancel(GtkWidget*, gpointer data);
	static bool OnWindowClosing(GtkWidget*, GdkEvent*, gpointer);
	static void LeftCursorChanged(GtkTreeView* leftTreeView, gpointer);
	static void RightCursorChanged(GtkTreeView* rightTreeView, gpointer);
	static void NameEntryChanged(GtkEntry* entry, gpointer);
	GtkWidget* Get_Window();
	int EditWindow();
	int AddWindow();

public:

	void NewStudentMessage(int MessageID, IPCAPI::tagStudent_t* student, LibSESData::CClassDef* selectedClass);

	void UpdateStudentListOfCurrentClass(int MessageID, std::string ClassName, const IPCAPI::StudentInfo_t* pStudent);

	void UpdateStudentListInCandidateList(int MessageID, std::string ClassName, const IPCAPI::StudentInfo_t* pStudent);

	void UpdateStudentInfo(std::string ClassName, const IPCAPI::StudentInfo_t* pStudent);

	std::string GetPreviousClassName() { return m_previousClassName; };

public:
	int IsAddGroup();
	int GetResult();

	LibSESData::CClassDef* GetSelectedClass();
	LibSESData::CClassDef* GetSelectedOriRefClass();


private:

	int InitWindow();

	int InitListViews();

	int InitMiddleButtons(GtkWidget* parent);
	int InitBottomButtons(GtkWidget* parent);
	void CreateLeftTreeView(GtkWidget* parent);
	void CreateRightTreeView(GtkWidget* parent);
	bool IsTreeViewNull(GtkWidget* treeview);
	bool IsButtonSensitive(GtkWidget*);
//	void TrimString(std::string&);
//	void SESShowDialog(std::string);

	void LoadOnlineStudent();

	void ReLoadCandidateList();

	int IsStudentInList(std::string studentID, const std::list<IPCAPI::tagStudent_t*>* pStudentList);

	void RefreshCandidateList();

	void MakeStudentNameUnique();

	void FilterStudentInClass();

	void ReDrawTreeView();

	void DrawCandidateStudentListView();

	void DrawClassStudentListView();

	int RemoveCandidateStudent(std::string studentID);

	int RemoveClassStudent(std::string studentID);

	void ReleaseStudentList();

	void ReleaseCandidateStudentList();

	void ReleaseClassStudentList();

	int ConvertStudentInfo2CStudentInfoData(std::list<IPCAPI::StudentInfo_t*>* pStudent, std::list<LibSESData::CStudentInfoData*>* pCStudentInfoData);

	int IsDataDirty();

	int DumpGUIClassInfo();

	int MoveTreeItems(GtkTreeView *srcTreeView, std::list<IPCAPI::tagStudent_t*>* pSrcTagStudentList, GtkTreeView *destTreeView, std::list<IPCAPI::tagStudent_t*>* pDestTagStudentList);

	int UpdateStudentInfoInList(std::list<IPCAPI::StudentInfo_t*>* pStudentList, const IPCAPI::StudentInfo_t* pStudent);

private:
	GtkWidget* m_gWindow;
	GtkWidget* m_gEntry;
	GtkWidget* m_gLeftBtn;
	GtkWidget* m_gRightBtn;
	GtkWidget* m_pLeftTreeView;
	GtkWidget* m_pRightTreeView;
	GtkListStore* m_pLeftStore;
	GtkListStore* m_pRightStore;
	GdkPixbuf* m_pEditClassPic;

private:

	std::string m_previousClassName;

	LibSESData::CClassDef* m_pClass;
	LibSESData::CClassDef* m_pClassOrg;

	//LibSESData::CClassDef* m_pClassOriRef;

	//LibSESData::CClassGroupData* m_pClassGroup;
	//IPCAPI::IPCTeacherAPI* m_pTeacherApiRef;

	std::list<IPCAPI::tagStudent_t*> m_tagStudentList;

	std::list<IPCAPI::StudentInfo_t*> m_StudentListInClass;

	//std::list<IPCAPI::StudentInfo_t> m_StudentList;

	LibSESData::CClassGroupData m_ClassGroup;

	int m_iResult;
	int m_iIsAdd;
	//int m_isDataChanged;
	int m_isInitial;

	bool m_IsLeftTreeViewSelected;

	bool m_IsRightTreeViewSelected;

};
#endif /*EDITGROUPWINDOW_H_*/
