/****************************************************************************

Copyright (c) 2009 Intel Corporation.  All rights reserved. 



DISCLAIMER OF WARRANTY

NEITHER INTEL NOR ITS SUPPLIERS MAKE ANY REPRESENTATION OR WARRANTY OR

CONDITION OF ANY KIND WHETHER EXPRESS OR IMPLIED (EITHER IN FACT OR BY

OPERATION OF LAW) WITH RESPECT TO THE SOURCE CODE.  INTEL AND ITS SUPPLIERS

EXPRESSLY DISCLAIM ALL WARRANTIES OR CONDITIONS OF MERCHANTABILITY OR

FITNESS FOR A PARTICULAR PURPOSE.  INTEL AND ITS SUPPLIERS DO NOT WARRANT

THAT THE SOURCE CODE IS ERROR-FREE OR THAT OPERATION OF THE SOURCE CODE WILL

BE SECURE OR UNINTERRUPTED AND HEREBY DISCLAIM ANY AND ALL LIABILITY ON

ACCOUNT THEREOF.  THERE IS ALSO NO IMPLIED WARRANTY OF NON-INFRINGEMENT.

SOURCE CODE IS LICENSED TO LICENSEE ON AN "AS IS" BASIS AND NEITHER INTEL

NOR ITS SUPPLIERS WILL PROVIDE ANY SUPPORT, ASSISTANCE, INSTALLATION,

TRAINING OR OTHER SERVICES.  INTEL AND ITS SUPPLIERS WILL NOT PROVIDE ANY

UPDATES, ENHANCEMENTS OR EXTENSIONS. 


File Name:          SearchResultData.h

Description:

    This file defines class SearchResultData.

Environment (opt):
    OS: Ubuntu
    SE: Eclipse

Notes (opt):

  =====================================================================

  Revision   Revision History               Author     Date

  =====================================================================

  0.1        Create                        Huang Miao  2008/9/16

  =====================================================================

****************************************************************************/

#ifndef __SEARCHRESULTDATA_H__
#define __SEARCHRESULTDATA_H__

#include "SESDataProvider.h"
#include "ApplicationInfo.h"

#include <string>
#include <list>
#include <set>

namespace LibSESData
{

class CSearchResultData: public LibSESData::CSESDataProvider
{
public:
	CSearchResultData();
	virtual ~CSearchResultData();

protected:
	int DOM2Member();
	int Member2DOM();

public:
	//
	std::list<CApplicationInfo*> *GetPApplicationInfoList() const;
	//
	void SetPApplicationInfoList(std::list<CApplicationInfo*> *pApplicationInfoList);
	//
	int AddApplications(const std::string& strXML);
	//
	int Clear();

private:
	int	CheckApplicationDuplicate(const std::string& strAppName);

private:
	std::list<CApplicationInfo*>* 	m_pApplicationInfoList;
	std::set<std::string>			m_AppNameSet;
};

}

#endif /* __SEARCHRESULTDATA_H__ */
