/****************************************************************************

Copyright (c) 2009 Intel Corporation.  All rights reserved. 



DISCLAIMER OF WARRANTY

NEITHER INTEL NOR ITS SUPPLIERS MAKE ANY REPRESENTATION OR WARRANTY OR

CONDITION OF ANY KIND WHETHER EXPRESS OR IMPLIED (EITHER IN FACT OR BY

OPERATION OF LAW) WITH RESPECT TO THE SOURCE CODE.  INTEL AND ITS SUPPLIERS

EXPRESSLY DISCLAIM ALL WARRANTIES OR CONDITIONS OF MERCHANTABILITY OR

FITNESS FOR A PARTICULAR PURPOSE.  INTEL AND ITS SUPPLIERS DO NOT WARRANT

THAT THE SOURCE CODE IS ERROR-FREE OR THAT OPERATION OF THE SOURCE CODE WILL

BE SECURE OR UNINTERRUPTED AND HEREBY DISCLAIM ANY AND ALL LIABILITY ON

ACCOUNT THEREOF.  THERE IS ALSO NO IMPLIED WARRANTY OF NON-INFRINGEMENT.

SOURCE CODE IS LICENSED TO LICENSEE ON AN "AS IS" BASIS AND NEITHER INTEL

NOR ITS SUPPLIERS WILL PROVIDE ANY SUPPORT, ASSISTANCE, INSTALLATION,

TRAINING OR OTHER SERVICES.  INTEL AND ITS SUPPLIERS WILL NOT PROVIDE ANY

UPDATES, ENHANCEMENTS OR EXTENSIONS. 


File Name:          SESDataProvider.h

Description:

    This file defines class SESDataProvider.

Environment (opt):
    OS: Ubuntu
    SE: Eclipse

Notes (opt):

  =====================================================================

  Revision   Revision History               Author     Date

  =====================================================================

  0.1        Create                        Jin Xin   2008/9/12

  =====================================================================

****************************************************************************/

#ifndef __SESDATAPROVIDER_H__
#define __SESDATAPROVIDER_H__

#include <string>
#include <sstream>
#include <iostream>
#include <fstream>
#include <istream>


using namespace std;

class TiXmlDocument; // Careful: this forward declaration is global.

namespace LibSESData
{
class CSESDataProvider
{
public:
	CSESDataProvider();
	virtual ~CSESDataProvider();

private:
	CSESDataProvider(const CSESDataProvider&);
	CSESDataProvider& operator =(const CSESDataProvider&);

protected:
	virtual int DOM2Member();
	virtual int Member2DOM();

public:
	virtual int LoadFromFile(const std::string& strFilePath);
	virtual int LoadFromString(const std::string& strXML);

	virtual int Save2File(const std::string& strFilePath);
	virtual int Save2String(std::string& strXML);


	virtual int Enciphering(std::string& strFile);
	virtual int Deciphering(std::string& strFile);
	virtual int Enciphering(std::string& strFile, const string& filePath);
	virtual int Deciphering(std::string& strFile, const string& filePath);
protected:
	TiXmlDocument* m_pTiDoc;
	std::string m_strOrgFilePath;
	std::string m_strXML;

protected:
	bool ConvertString2Int(std::string &strT, int &iValue);
	bool ConvertInt2String(int iTemp, std::string &str);
	pthread_mutex_t m_pFileLock;
};

}

#endif /* __SESDATAPROVIDER_H__ */
