/****************************************************************************

Copyright (c) 2009 Intel Corporation.  All rights reserved. 



DISCLAIMER OF WARRANTY

NEITHER INTEL NOR ITS SUPPLIERS MAKE ANY REPRESENTATION OR WARRANTY OR

CONDITION OF ANY KIND WHETHER EXPRESS OR IMPLIED (EITHER IN FACT OR BY

OPERATION OF LAW) WITH RESPECT TO THE SOURCE CODE.  INTEL AND ITS SUPPLIERS

EXPRESSLY DISCLAIM ALL WARRANTIES OR CONDITIONS OF MERCHANTABILITY OR

FITNESS FOR A PARTICULAR PURPOSE.  INTEL AND ITS SUPPLIERS DO NOT WARRANT

THAT THE SOURCE CODE IS ERROR-FREE OR THAT OPERATION OF THE SOURCE CODE WILL

BE SECURE OR UNINTERRUPTED AND HEREBY DISCLAIM ANY AND ALL LIABILITY ON

ACCOUNT THEREOF.  THERE IS ALSO NO IMPLIED WARRANTY OF NON-INFRINGEMENT.

SOURCE CODE IS LICENSED TO LICENSEE ON AN "AS IS" BASIS AND NEITHER INTEL

NOR ITS SUPPLIERS WILL PROVIDE ANY SUPPORT, ASSISTANCE, INSTALLATION,

TRAINING OR OTHER SERVICES.  INTEL AND ITS SUPPLIERS WILL NOT PROVIDE ANY

UPDATES, ENHANCEMENTS OR EXTENSIONS. 


File Name:          CPolicySettingData.h

Description:

    This file defines class CPolicySettingData.

Environment (opt):
    OS: Ubuntu
    SE: Eclipse

Notes (opt):

  =====================================================================

  Revision   Revision History               Author     Date

  =====================================================================

  0.1        Create                        Huang Miao  2008/11/27

  =====================================================================

****************************************************************************/

#ifndef CPOLICYSETTINGDATA_H_
#define CPOLICYSETTINGDATA_H_

#include <string.h>
#include "SESDataProvider.h"

namespace LibSESData
{

#define LOCALADMIN "local admin"

class CPolicySettingData: public LibSESData::CSESDataProvider
{
private:
	std::string m_DeployerName;
	long int m_UpdateTime;
public:
	CPolicySettingData();
	virtual ~CPolicySettingData();

	long int GetTimeOriginal();
	std::string GetTime();
	void SetTime(std::string time);
	void SetTime(long int  time);
	std::string GetDeployerName();
	void SetDeployerName(std::string DeployerName);

protected:
		virtual int DOM2Member();
		virtual int Member2DOM();
};

}
#endif /* CPOLICYSETTINGDATA_H_ */
