/****************************************************************************

Copyright (c) 2009 Intel Corporation.  All rights reserved. 



DISCLAIMER OF WARRANTY

NEITHER INTEL NOR ITS SUPPLIERS MAKE ANY REPRESENTATION OR WARRANTY OR

CONDITION OF ANY KIND WHETHER EXPRESS OR IMPLIED (EITHER IN FACT OR BY

OPERATION OF LAW) WITH RESPECT TO THE SOURCE CODE.  INTEL AND ITS SUPPLIERS

EXPRESSLY DISCLAIM ALL WARRANTIES OR CONDITIONS OF MERCHANTABILITY OR

FITNESS FOR A PARTICULAR PURPOSE.  INTEL AND ITS SUPPLIERS DO NOT WARRANT

THAT THE SOURCE CODE IS ERROR-FREE OR THAT OPERATION OF THE SOURCE CODE WILL

BE SECURE OR UNINTERRUPTED AND HEREBY DISCLAIM ANY AND ALL LIABILITY ON

ACCOUNT THEREOF.  THERE IS ALSO NO IMPLIED WARRANTY OF NON-INFRINGEMENT.

SOURCE CODE IS LICENSED TO LICENSEE ON AN "AS IS" BASIS AND NEITHER INTEL

NOR ITS SUPPLIERS WILL PROVIDE ANY SUPPORT, ASSISTANCE, INSTALLATION,

TRAINING OR OTHER SERVICES.  INTEL AND ITS SUPPLIERS WILL NOT PROVIDE ANY

UPDATES, ENHANCEMENTS OR EXTENSIONS. 


File Name:          TeacherMessageNotify.h

Description:

    This file defines class TeacherMessageNotify.

Environment (opt):
    OS: Ubuntu
    SE: Eclipse

Notes (opt):

  =====================================================================

  Revision   Revision History               Author     Date

  =====================================================================

  0.1        Create                        Sheng Lijie 2008/9/16

  =====================================================================

****************************************************************************/

#ifndef TEACHERMESSAGENOTIFY_H_
#define TEACHERMESSAGENOTIFY_H_

#include <pthread.h>
#include "IntfData.h"

namespace IPCAPI {

	class TeacherMessageNotify
	{
	private:
		IIPCTeacherAPICallback* m_objCallBack;
		pthread_mutex_t m_CallBackLock;
	public:
		TeacherMessageNotify();
		virtual ~TeacherMessageNotify();

	public:
		APIResult DoAction(std::string strName, std::string inArgs, std::string& outArgs);
		void SetCallBack(IIPCTeacherAPICallback* objCallBack);

	private:
		APIResult SearchProgramCallBack(std::string inArgs, std::string& outArgs);
		APIResult ManualLockRemotStudentCallBack(std::string inArgs, std::string& outArgs);
		APIResult ManualUnLockRemotStudentCallBack(std::string inArgs, std::string& outArgs);
		APIResult KickOffStudentCallBack(std::string inArgs, std::string& outArgs);
		APIResult NotifyStudentStatusChanged(std::string inArgs, std::string& outArgs);
		APIResult DeployTabNavPolicyCallBack(std::string inArgs, std::string& outArgs);
		APIResult DeploySchedulePolicyCallBack(std::string inArgs, std::string& outArgs);
		APIResult NewStudentCallBack(std::string inArgs, std::string& outArgs);
		APIResult OnMessage(std::string inArgs, std::string& outArgs);
		APIResult NotifyStudentInfoChanged(std::string inArgs, std::string& outArgs);
	};
}
#endif /* TEACHERMESSAGENOTIFY_H_ */
