/****************************************************************************

Copyright (c) 2009 Intel Corporation.  All rights reserved. 



DISCLAIMER OF WARRANTY

NEITHER INTEL NOR ITS SUPPLIERS MAKE ANY REPRESENTATION OR WARRANTY OR

CONDITION OF ANY KIND WHETHER EXPRESS OR IMPLIED (EITHER IN FACT OR BY

OPERATION OF LAW) WITH RESPECT TO THE SOURCE CODE.  INTEL AND ITS SUPPLIERS

EXPRESSLY DISCLAIM ALL WARRANTIES OR CONDITIONS OF MERCHANTABILITY OR

FITNESS FOR A PARTICULAR PURPOSE.  INTEL AND ITS SUPPLIERS DO NOT WARRANT

THAT THE SOURCE CODE IS ERROR-FREE OR THAT OPERATION OF THE SOURCE CODE WILL

BE SECURE OR UNINTERRUPTED AND HEREBY DISCLAIM ANY AND ALL LIABILITY ON

ACCOUNT THEREOF.  THERE IS ALSO NO IMPLIED WARRANTY OF NON-INFRINGEMENT.

SOURCE CODE IS LICENSED TO LICENSEE ON AN "AS IS" BASIS AND NEITHER INTEL

NOR ITS SUPPLIERS WILL PROVIDE ANY SUPPORT, ASSISTANCE, INSTALLATION,

TRAINING OR OTHER SERVICES.  INTEL AND ITS SUPPLIERS WILL NOT PROVIDE ANY

UPDATES, ENHANCEMENTS OR EXTENSIONS. 


File Name:          IPCTeacherDaemonAPI.h

Description:

    This file defines class IPCTeacherDaemonAPI.

Environment (opt):
    OS: Ubuntu
    SE: Eclipse

Notes (opt):

  =====================================================================

  Revision   Revision History               Author     Date

  =====================================================================

  0.1        Create                        Sheng Lijie 2008/9/16

  =====================================================================

****************************************************************************/

#ifndef IPCTEACHERDAEMONAPI_H_
#define IPCTEACHERDAEMONAPI_H_

#include "IPCCommon.h"
#include "IPCAPIBase.h"
#include "IntfData.h"

namespace IPCAPI
{
	class IPCTeacherDaemonAPI : public IPCAPIBase
	{
	private:
		DBusMessage* m_objCurmsg;
		int m_iMsgType;
	private:
		APIResult Initialize();
		APIResult UnInitialize();

		APIResult ReceiveMsg(int& iOPID, std::string& strOPName, std::string& outArgs);
		APIResult SendMsg(int& iOPID, std::string strOPName, std::string inArgs);
		APIResult ReplyMsg(std::string inArgs);
	public:
		IPCTeacherDaemonAPI();
		virtual ~IPCTeacherDaemonAPI();

		APIResult ReceiveMsg(CIntfData& InfoData);
		APIResult ReplyMsg(CIntfData* InfoData);
		APIResult SendMsg(CIntfData* InfoData);

		bool IsBlock();

		APIResult SearchProgramCallBack(std::string studentID, std::string programsXML, int iResult) ;
		APIResult NotifyStudentStatusChanged(std::string studentID, int iStatus) ;
		APIResult DeployTabNavPolicyCallBack(std::string studentID, bool bSuccess) ;
		APIResult NewStudentCallBack(StudentInfo_t& studentInfo) ;
		APIResult NotifyStudentInfoChanged(std::string OldStudentID, std::string NewStudentID, std::string NewStudentName, bool bNeedDelete);

//		APIResult ManualLockRemotStudentCallBack(std::string studentID, int iReturn) ;
//		APIResult ManualUnLockRemotStudentCallBack(std::string studentID, int iReturn) ;
//		APIResult KickOffStudentCallBack(std::string studentID, int iReturn) ;
//		APIResult DeploySchedulePolicyCallBack(std::string studentID, bool bSuccess) ;

	};

}



#endif /*IPCTEACHERAPI_H_*/
