/****************************************************************************

Copyright (c) 2009 Intel Corporation.  All rights reserved. 



DISCLAIMER OF WARRANTY

NEITHER INTEL NOR ITS SUPPLIERS MAKE ANY REPRESENTATION OR WARRANTY OR

CONDITION OF ANY KIND WHETHER EXPRESS OR IMPLIED (EITHER IN FACT OR BY

OPERATION OF LAW) WITH RESPECT TO THE SOURCE CODE.  INTEL AND ITS SUPPLIERS

EXPRESSLY DISCLAIM ALL WARRANTIES OR CONDITIONS OF MERCHANTABILITY OR

FITNESS FOR A PARTICULAR PURPOSE.  INTEL AND ITS SUPPLIERS DO NOT WARRANT

THAT THE SOURCE CODE IS ERROR-FREE OR THAT OPERATION OF THE SOURCE CODE WILL

BE SECURE OR UNINTERRUPTED AND HEREBY DISCLAIM ANY AND ALL LIABILITY ON

ACCOUNT THEREOF.  THERE IS ALSO NO IMPLIED WARRANTY OF NON-INFRINGEMENT.

SOURCE CODE IS LICENSED TO LICENSEE ON AN "AS IS" BASIS AND NEITHER INTEL

NOR ITS SUPPLIERS WILL PROVIDE ANY SUPPORT, ASSISTANCE, INSTALLATION,

TRAINING OR OTHER SERVICES.  INTEL AND ITS SUPPLIERS WILL NOT PROVIDE ANY

UPDATES, ENHANCEMENTS OR EXTENSIONS. 


File Name:          IPCTeacherAPICallback.h

Description:

    This file defines class IPCTeacherAPICallback.

Environment (opt):
    OS: Ubuntu
    SE: Eclipse

Notes (opt):

  =====================================================================

  Revision   Revision History               Author     Date

  =====================================================================

  0.1        Create                        Sheng Lijie 2008/9/16

  =====================================================================

****************************************************************************/

#ifndef IPCTEACHERAPICALLBACK_H_
#define IPCTEACHERAPICALLBACK_H_

#include <string>
#include <CommonMessage.h>
#include "IntfData.h"
namespace IPCAPI
{
	class IIPCTeacherAPICallback
	{
	public:
		virtual void SearchProgramCallBack(std::string studentID, std::string programsXML) = 0;
		virtual void ManualLockRemotStudentCallBack(std::string studentID, int iReturn) = 0;
		virtual void ManualUnLockRemotStudentCallBack(std::string studentID, int iReturn) = 0;
		virtual void KickOffStudentCallBack(std::string studentID, int iReturn) = 0;
		virtual void NotifyStudentStatusChanged(std::string studentID, int iStatus) = 0;
		virtual void DeployTabNavPolicyCallBack(std::string studentID, bool bSuccess) = 0;
		virtual void DeploySchedulePolicyCallBack(std::string studentID, bool bSuccess) = 0;
		virtual void NewStudentCallBack(const StudentInfo_t& studentInfo) = 0;
		virtual void OnMessage(int /*MessageID*/, std::string /*Message*/) {};
		virtual void NotifyStudentInfoChanged(std::string& /*OldStudentID*/, std::string& /*NewStudentID*/, std::string& /*NewStudentName*/, bool /*bNeedDelete*/){};
	};
}



#endif /*IPCTEACHERAPICALLBACK_H_*/
