/*
 * Copyright (c) 2015 Intel Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef _PSH_PRIVATE_DATA_H_
#define _PSH_PRIVATE_DATA_H_

#define SNR_NAME_MAX_LEN 5
typedef struct {
        unsigned char id;
        bool support_calibration;
        char name[SNR_NAME_MAX_LEN + 1];
} psh_private_data_t;

#define CMD_PARAM_MAX_SIZE ((unsigned short)128)
struct psh_cmd {
        unsigned char tran_id;
        unsigned char cmd_id;
        unsigned char sensor_id;
        unsigned char reserved;
        char param[0];
} __attribute__ ((packed));

#define RESP_CMD_ACK        0
#define RESP_GET_TIME       1
#define RESP_GET_SINGLE     2
#define RESP_STREAMING      3
#define RESP_DEBUG_MSG      4
#define RESP_DEBUG_GET_MASK 5
#define RESP_CAL_RESULT     6
#define RESP_BIST_RESULT    7
#define RESP_ADD_EVENT      8
#define RESP_CLEAR_EVENT    9
#define RESP_EVENT          10
#define RESP_GET_STATUS     11
#define RESP_PSH_EVT        16

struct psh_cmd_resp {
        unsigned char tran_id;
        unsigned char type;
        unsigned char sensor_id;
        unsigned char reserved;
        unsigned int data_len;
        char buf[0];
} __attribute__ ((packed));

struct psh_cmd_resp_ack {
        unsigned char cmd_id;
        unsigned char reserved;
        int16_t ret;
        char extra[0];
} __attribute__ ((packed));

#endif
