/*
 * Copyright (c) 2015 Intel Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "PSHTypeMap.h"

PSHTypeMap::PSHTypeMap()
        :noSensorFound("")
{
        PSHTypeTable[SENSOR_TYPE_ACCELEROMETER] = "ACCEL";
        PSHTypeTable[SENSOR_TYPE_MAGNETIC_FIELD] = "COMPS";
        PSHTypeTable[SENSOR_TYPE_ORIENTATION] = "ORIEN";
        PSHTypeTable[SENSOR_TYPE_GYROSCOPE] = "GYRO";
        PSHTypeTable[SENSOR_TYPE_LIGHT] = "ALS_P";
        PSHTypeTable[SENSOR_TYPE_PRESSURE] = "BARO";
        PSHTypeTable[SENSOR_TYPE_TEMPERATURE] = "";
        PSHTypeTable[SENSOR_TYPE_PROXIMITY] = "PS_P";
        PSHTypeTable[SENSOR_TYPE_GRAVITY] = "GRAVI";
        PSHTypeTable[SENSOR_TYPE_LINEAR_ACCELERATION] = "LACCL";
        PSHTypeTable[SENSOR_TYPE_ROTATION_VECTOR] = "RVECT";
        PSHTypeTable[SENSOR_TYPE_RELATIVE_HUMIDITY] = "";
        PSHTypeTable[SENSOR_TYPE_AMBIENT_TEMPERATURE] = "";
        PSHTypeTable[SENSOR_TYPE_MAGNETIC_FIELD_UNCALIBRATED] = "";
        PSHTypeTable[SENSOR_TYPE_GAME_ROTATION_VECTOR] = "6AGRV";
        PSHTypeTable[SENSOR_TYPE_GYROSCOPE_UNCALIBRATED] = "";
        PSHTypeTable[SENSOR_TYPE_SIGNIFICANT_MOTION] = "SIGMT";
        PSHTypeTable[SENSOR_TYPE_STEP_DETECTOR] = "SDET";
        PSHTypeTable[SENSOR_TYPE_STEP_COUNTER] = "SCOUN";
        PSHTypeTable[SENSOR_TYPE_GEOMAGNETIC_ROTATION_VECTOR] = "6AMRV";
        PSHTypeTable[SENSOR_TYPE_HEART_RATE] = "";
        PSHTypeTable[SENSOR_TYPE_TILT_DETECTOR] = "TILTD";
        PSHTypeTable[SENSOR_TYPE_WAKE_GESTURE] = "STAP";
        PSHTypeTable[SENSOR_TYPE_GLANCE_GESTURE] = "SHAKI";
        PSHTypeTable[SENSOR_TYPE_PICK_UP_GESTURE] = "PICUP";

        // Todo: complete Android sensors definition and add aware OEM sensors.
}

std::string &PSHTypeMap::getPSHTypeName(int sensorType)
{
        if (PSHTypeTable.count(sensorType))
                return PSHTypeTable[sensorType];

        return noSensorFound;
}
