/*
 * Copyright (c) 2015 Intel Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef _PSH_SERVICE_H_
#define _PSH_SERVICE_H_

#include "PlatformService.h"
#include "Session.h"
#include "psh_private_data.h"
#include "sensorhubd.h"
#include "PSHTypeMap.h"
#include <map>
#include <string>
#include <pthread.h>

#define CMD_GET_SINGLE 2
#define CMD_START_STREAMING 3
#define CMD_STOP_STREAMING 4
#define CMD_ADD_EVENT 5
#define CMD_CLEAR_EVENT 6
#define CMD_SET_CALIBRATION 9
#define CMD_GET_CALIBRATION 9
#define CMD_SET_PROPERTY 12
#define CMD_FLUSH_STREAMING 15
#define CMD_GET_PROPERTY 17

typedef struct {
        unsigned char id;
        bool support_calibration;
        short freq_max;        // -1, means no fixed data rate
} psh_sensor_information_t;

class PSHService : public PlatformService {
        bool initializeInterfaces();
        bool getStatus();
        bool initializePrivateData(xmlNodePtr node, psh_private_data_t &data, struct sensor_device_t &device);
        Sensor * constructSensorByType(const struct sensor_device_t &device, const sensor_additional_information_t &information, const psh_private_data_t &data);
        PSHTypeMap typeTable;
        int ctrlFd;
        int dataFd;
        int dataSizeFd;
        char *dataBuf;
        unsigned char *respBuf;
        std::map<std::string, psh_sensor_information_t> sensorsInfo;
        std::map<unsigned char, Sensor *> sensorsTable;
        sensors_meta_data_event_t metaEvent;
        struct flushParams {
                int handle;
                Session *session;
        };
        std::queue<struct flushParams> flushQueue;
        mutable pthread_mutex_t mFlushQueueLock;
public:
        PSHService();
        ~PSHService();
        void getDataFds(std::queue<int> &dataFdQueue);
        dataSelectMode getDataSelectMode() { return SELECT_MODE_EXCEPTION; }
        bool handleEvents(int fd);
        bool sendControlCommand(const void *buf, size_t count, void **resp_buf, size_t *resp_size);
        int enumerateSensors(SensorEnumerator * enumerator, const xmlNodePtr ishRoot, std::vector<Sensor *> &sensors);
        void addToFlushQueue(int handle, Session *session);
        void removeFromFlushQueue();
        void lockFlushQueue();
        void unlockFlushQueue();
        int getNotifyFd() { return -1; }
        void handleNotify(int notification) {}
};

#endif
