/*
 * Copyright (c) 2015 Intel Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "PSHProximity.h"
#include "Log.h"

struct ps_phy_data {
        int64_t ts;
        unsigned short near;
        unsigned char reserved[2];
} __attribute__ ((packed));

PSHProximity::PSHProximity(const struct sensor_device_t &device, const sensor_additional_information_t &information, const psh_private_data_t &data, PSHService *service)
 :PSHSensor(device, information, data, service)
{
        if (information.scale_android.size() == 1) {
                scaleX = information.scale_android[0];
                ALOGV_IF(VERBOSE, "%s line: %d %f", __FUNCTION__, __LINE__, scaleX);
        } else {
                ALOGW("%s line: %d invalid scale information: size: %d", __FUNCTION__, __LINE__, information.scale_android.size());
                scaleX = 1.0;
        }
}

PSHProximity::~PSHProximity()
{

}

size_t PSHProximity::convertToEvent(const char * buf, size_t bufSize)
{
        size_t count = bufSize / sizeof(struct ps_phy_data);

        if (bufSize % sizeof(struct ps_phy_data) != 0) {
                ALOGE("%s line: %d Invalid size: %d unit size is: %d",
                      __FUNCTION__, __LINE__, bufSize, sizeof(struct ps_phy_data));
                return 0;
        }

        reallocEventsBuffer(count);

        const struct ps_phy_data *proximity = reinterpret_cast<const struct ps_phy_data *>(buf);
        for (int i = 0; i < count; i++) {
                mEvents[i].timestamp = proximity[i].ts;
                mEvents[i].distance = (proximity[i].near == 0 ? 1 : 0) * scaleX;
        }
        return count;
}
