#include "ISHTemperature.h"
#include "Log.h"

struct _temperature_data_t {
	int64_t timestamp;
	int64_t timestamp0; // new added, will replace the first one later
	int32_t temperature;
} __attribute__ ((packed));

ISHTemperature::ISHTemperature(const struct sensor_device_t &device, const sensor_additional_information_t &information, const ish_private_data_t &data)
        :ISHSensor(device, information, data)
{
        initialize();
}

ISHTemperature::ISHTemperature(const Sensor * refSensor, const uint32_t serial_number)
        :ISHSensor(refSensor, serial_number)
{
        initialize();
}

ISHTemperature::~ISHTemperature()
{

}

void ISHTemperature::initialize()
{
        if (information.scale_android.size() == 1) {
                scale = information.scale_android[0];
                ALOGV_IF(VERBOSE, "%s line: %d %f", __FUNCTION__, __LINE__, scale);
        } else {
                ALOGW("%s line: %d invalid scale information: size: %d", __FUNCTION__, __LINE__, information.scale_android.size());
                scale = 0.01; // defalut scale 10^-2
        }
}

size_t ISHTemperature::convertToEvent(const char * buf, size_t bufSize)
{
        size_t count = bufSize / sizeof(struct _temperature_data_t);

        if (bufSize % sizeof(struct _temperature_data_t) != 0) {
                ALOGE("%s line: %d Invalid size: %d unit size is: %d",
                      __FUNCTION__, __LINE__, bufSize, sizeof(struct _temperature_data_t));
                return 0;
        }

        reallocEventsBuffer(count);

        const struct _temperature_data_t *temperature = reinterpret_cast<const struct _temperature_data_t *>(buf);
        for (int i = 0; i < count; i++) {
                mEvents[i].timestamp = temperature[i].timestamp * US_TO_NS;
                mEvents[i].temperature = temperature[i].temperature * scale;
        }

        return count;
}
